// Copyright 2025 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Armscii8_general_ci_RuneWeight returns the weight of a given rune based on its relational sort order from
// the `armscii8_general_ci` collation.
func Armscii8_general_ci_RuneWeight(r rune) int32 {
	weight, ok := armscii8_general_ci_Weights[r]
	if ok {
		return weight
	} else {
		return 2147483647
	}
}

// armscii8_general_ci_Weights contain a map from rune to weight for the `armscii8_general_ci` collation. The
// map primarily contains mappings that have a random order. Mappings that fit into a sequential range (and are long
// enough) are defined in the calling function to save space.
var armscii8_general_ci_Weights = map[rune]int32{
	0:     0,
	1:     1,
	2:     2,
	3:     3,
	4:     4,
	5:     5,
	6:     6,
	7:     7,
	8:     8,
	9:     9,
	10:    10,
	11:    11,
	12:    12,
	13:    13,
	14:    14,
	15:    15,
	16:    16,
	17:    17,
	18:    18,
	19:    19,
	20:    20,
	21:    21,
	22:    22,
	23:    23,
	24:    24,
	25:    25,
	26:    26,
	27:    27,
	28:    28,
	29:    29,
	30:    30,
	31:    31,
	32:    32,
	33:    33,
	34:    34,
	35:    35,
	36:    36,
	37:    37,
	38:    38,
	39:    39,
	40:    40,
	41:    41,
	42:    42,
	43:    43,
	44:    44,
	45:    45,
	46:    46,
	47:    47,
	48:    48,
	49:    49,
	50:    50,
	51:    51,
	52:    52,
	53:    53,
	54:    54,
	55:    55,
	56:    56,
	57:    57,
	58:    58,
	59:    59,
	60:    60,
	61:    61,
	62:    62,
	63:    63,
	64:    64,
	65:    65,
	97:    65,
	66:    66,
	98:    66,
	67:    67,
	99:    67,
	68:    68,
	100:   68,
	69:    69,
	101:   69,
	70:    70,
	102:   70,
	71:    71,
	103:   71,
	72:    72,
	104:   72,
	73:    73,
	105:   73,
	74:    74,
	106:   74,
	75:    75,
	107:   75,
	76:    76,
	108:   76,
	77:    77,
	109:   77,
	78:    78,
	110:   78,
	79:    79,
	111:   79,
	80:    80,
	112:   80,
	81:    81,
	113:   81,
	82:    82,
	114:   82,
	83:    83,
	115:   83,
	84:    84,
	116:   84,
	85:    85,
	117:   85,
	86:    86,
	118:   86,
	87:    87,
	119:   87,
	88:    88,
	120:   88,
	89:    89,
	121:   89,
	90:    90,
	122:   90,
	91:    91,
	92:    92,
	93:    93,
	94:    94,
	95:    95,
	96:    96,
	123:   97,
	124:   98,
	125:   99,
	126:   100,
	127:   101,
	128:   102,
	129:   103,
	130:   104,
	131:   105,
	132:   106,
	133:   107,
	134:   108,
	135:   109,
	136:   110,
	137:   111,
	138:   112,
	139:   113,
	140:   114,
	141:   115,
	142:   116,
	143:   117,
	144:   118,
	145:   119,
	146:   120,
	147:   121,
	148:   122,
	149:   123,
	150:   124,
	151:   125,
	152:   126,
	153:   127,
	154:   128,
	155:   129,
	156:   130,
	157:   131,
	158:   132,
	159:   133,
	160:   134,
	10049: 135,
	167:   136,
	1417:  137,
	187:   138,
	171:   139,
	8212:  140,
	1373:  141,
	1375:  142,
	8230:  143,
	1372:  144,
	1371:  145,
	1374:  146,
	1329:  147,
	1377:  148,
	1330:  149,
	1378:  150,
	1331:  151,
	1379:  152,
	1332:  153,
	1380:  154,
	1333:  155,
	1381:  156,
	1334:  157,
	1382:  158,
	1335:  159,
	1383:  160,
	1336:  161,
	1384:  162,
	1337:  163,
	1385:  164,
	1338:  165,
	1386:  166,
	1339:  167,
	1387:  168,
	1340:  169,
	1388:  170,
	1341:  171,
	1389:  172,
	1342:  173,
	1390:  174,
	1343:  175,
	1391:  176,
	1344:  177,
	1392:  178,
	1345:  179,
	1393:  180,
	1346:  181,
	1394:  182,
	1347:  183,
	1395:  184,
	1348:  185,
	1396:  186,
	1349:  187,
	1397:  188,
	1350:  189,
	1398:  190,
	1351:  191,
	1399:  192,
	1352:  193,
	1400:  194,
	1353:  195,
	1401:  196,
	1354:  197,
	1402:  198,
	1355:  199,
	1403:  200,
	1356:  201,
	1404:  202,
	1357:  203,
	1405:  204,
	1358:  205,
	1406:  206,
	1359:  207,
	1407:  208,
	1360:  209,
	1408:  210,
	1361:  211,
	1409:  212,
	1362:  213,
	1410:  214,
	1363:  215,
	1411:  216,
	1364:  217,
	1412:  218,
	1365:  219,
	1413:  220,
	1366:  221,
	1414:  222,
	8217:  223,
}
