package fpconv

var (
	npowers    int64 = 87
	steppowers int64 = 8
	firstpower int64 = -348 /* 10 ^ -348 */

	expmax = -32
	expmin = -60

	powers_ten = []Fp{
		{18054884314459144840, -1220}, {13451937075301367670, -1193},
		{10022474136428063862, -1166}, {14934650266808366570, -1140},
		{11127181549972568877, -1113}, {16580792590934885855, -1087},
		{12353653155963782858, -1060}, {18408377700990114895, -1034},
		{13715310171984221708, -1007}, {10218702384817765436, -980},
		{15227053142812498563, -954}, {11345038669416679861, -927},
		{16905424996341287883, -901}, {12595523146049147757, -874},
		{9384396036005875287, -847}, {13983839803942852151, -821},
		{10418772551374772303, -794}, {15525180923007089351, -768},
		{11567161174868858868, -741}, {17236413322193710309, -715},
		{12842128665889583758, -688}, {9568131466127621947, -661},
		{14257626930069360058, -635}, {10622759856335341974, -608},
		{15829145694278690180, -582}, {11793632577567316726, -555},
		{17573882009934360870, -529}, {13093562431584567480, -502},
		{9755464219737475723, -475}, {14536774485912137811, -449},
		{10830740992659433045, -422}, {16139061738043178685, -396},
		{12024538023802026127, -369}, {17917957937422433684, -343},
		{13349918974505688015, -316}, {9946464728195732843, -289},
		{14821387422376473014, -263}, {11042794154864902060, -236},
		{16455045573212060422, -210}, {12259964326927110867, -183},
		{18268770466636286478, -157}, {13611294676837538539, -130},
		{10141204801825835212, -103}, {15111572745182864684, -77},
		{11258999068426240000, -50}, {16777216000000000000, -24},
		{12500000000000000000, 3}, {9313225746154785156, 30},
		{13877787807814456755, 56}, {10339757656912845936, 83},
		{15407439555097886824, 109}, {11479437019748901445, 136},
		{17105694144590052135, 162}, {12744735289059618216, 189},
		{9495567745759798747, 216}, {14149498560666738074, 242},
		{10542197943230523224, 269}, {15709099088952724970, 295},
		{11704190886730495818, 322}, {17440603504673385349, 348},
		{12994262207056124023, 375}, {9681479787123295682, 402},
		{14426529090290212157, 428}, {10748601772107342003, 455},
		{16016664761464807395, 481}, {11933345169920330789, 508},
		{17782069995880619868, 534}, {13248674568444952270, 561},
		{9871031767461413346, 588}, {14708983551653345445, 614},
		{10959046745042015199, 641}, {16330252207878254650, 667},
		{12166986024289022870, 694}, {18130221999122236476, 720},
		{13508068024458167312, 747}, {10064294952495520794, 774},
		{14996968138956309548, 800}, {11173611982879273257, 827},
		{16649979327439178909, 853}, {12405201291620119593, 880},
		{9242595204427927429, 907}, {13772540099066387757, 933},
		{10261342003245940623, 960}, {15290591125556738113, 986},
		{11392378155556871081, 1013}, {16975966327722178521, 1039},
		{12648080533535911531, 1066},
	}
)

func find_cachedpow10(exp int64, k *int64) Fp {
	one_log_ten := 0.30102999566398114

	approx := int64(float64(-(exp + npowers)) * one_log_ten)
	idx := int((approx - firstpower) / steppowers)

	for {
		current := int(exp + powers_ten[idx].exp + 64)

		if current < expmin {
			idx++
			continue
		}

		if current > expmax {
			idx--
			continue
		}

		*k = (firstpower + int64(idx)*steppowers)

		return powers_ten[idx]
	}
}
