// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/retail/v2alpha/user_event_service.proto

package retailpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	httpbody "google.golang.org/genproto/googleapis/api/httpbody"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The scope of user events to be rejoined with the latest product catalog.
// If the rejoining aims at reducing number of unjoined events, set
// `UserEventRejoinScope` to `UNJOINED_EVENTS`.
// If the rejoining aims at correcting product catalog information in joined
// events, set `UserEventRejoinScope` to `JOINED_EVENTS`.
// If all events needs to be rejoined, set `UserEventRejoinScope` to
// `USER_EVENT_REJOIN_SCOPE_UNSPECIFIED`.
type RejoinUserEventsRequest_UserEventRejoinScope int32

const (
	// Rejoin all events with the latest product catalog, including both joined
	// events and unjoined events.
	RejoinUserEventsRequest_USER_EVENT_REJOIN_SCOPE_UNSPECIFIED RejoinUserEventsRequest_UserEventRejoinScope = 0
	// Only rejoin joined events with the latest product catalog.
	RejoinUserEventsRequest_JOINED_EVENTS RejoinUserEventsRequest_UserEventRejoinScope = 1
	// Only rejoin unjoined events with the latest product catalog.
	RejoinUserEventsRequest_UNJOINED_EVENTS RejoinUserEventsRequest_UserEventRejoinScope = 2
)

// Enum value maps for RejoinUserEventsRequest_UserEventRejoinScope.
var (
	RejoinUserEventsRequest_UserEventRejoinScope_name = map[int32]string{
		0: "USER_EVENT_REJOIN_SCOPE_UNSPECIFIED",
		1: "JOINED_EVENTS",
		2: "UNJOINED_EVENTS",
	}
	RejoinUserEventsRequest_UserEventRejoinScope_value = map[string]int32{
		"USER_EVENT_REJOIN_SCOPE_UNSPECIFIED": 0,
		"JOINED_EVENTS":                       1,
		"UNJOINED_EVENTS":                     2,
	}
)

func (x RejoinUserEventsRequest_UserEventRejoinScope) Enum() *RejoinUserEventsRequest_UserEventRejoinScope {
	p := new(RejoinUserEventsRequest_UserEventRejoinScope)
	*p = x
	return p
}

func (x RejoinUserEventsRequest_UserEventRejoinScope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RejoinUserEventsRequest_UserEventRejoinScope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2alpha_user_event_service_proto_enumTypes[0].Descriptor()
}

func (RejoinUserEventsRequest_UserEventRejoinScope) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2alpha_user_event_service_proto_enumTypes[0]
}

func (x RejoinUserEventsRequest_UserEventRejoinScope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RejoinUserEventsRequest_UserEventRejoinScope.Descriptor instead.
func (RejoinUserEventsRequest_UserEventRejoinScope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_user_event_service_proto_rawDescGZIP(), []int{2, 0}
}

// Request message for WriteUserEvent method.
type WriteUserEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent catalog resource name, such as
	// `projects/1234/locations/global/catalogs/default_catalog`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User event to write.
	UserEvent *UserEvent `protobuf:"bytes,2,opt,name=user_event,json=userEvent,proto3" json:"user_event,omitempty"`
	// If set to true, the user event will be written asynchronously after
	// validation, and the API will respond without waiting for the write.
	// Therefore, silent failures can occur even if the API returns success. In
	// case of silent failures, error messages can be found in Stackdriver logs.
	WriteAsync bool `protobuf:"varint,3,opt,name=write_async,json=writeAsync,proto3" json:"write_async,omitempty"`
}

func (x *WriteUserEventRequest) Reset() {
	*x = WriteUserEventRequest{}
	mi := &file_google_cloud_retail_v2alpha_user_event_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WriteUserEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteUserEventRequest) ProtoMessage() {}

func (x *WriteUserEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_user_event_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteUserEventRequest.ProtoReflect.Descriptor instead.
func (*WriteUserEventRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_user_event_service_proto_rawDescGZIP(), []int{0}
}

func (x *WriteUserEventRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *WriteUserEventRequest) GetUserEvent() *UserEvent {
	if x != nil {
		return x.UserEvent
	}
	return nil
}

func (x *WriteUserEventRequest) GetWriteAsync() bool {
	if x != nil {
		return x.WriteAsync
	}
	return false
}

// Request message for CollectUserEvent method.
type CollectUserEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rule that can convert the raw_json to a user event. It is needed
	// only when the raw_json is set.
	//
	// Types that are assignable to ConversionRule:
	//
	//	*CollectUserEventRequest_PrebuiltRule
	ConversionRule isCollectUserEventRequest_ConversionRule `protobuf_oneof:"conversion_rule"`
	// Required. The parent catalog name, such as
	// `projects/1234/locations/global/catalogs/default_catalog`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. URL encoded UserEvent proto with a length limit of 2,000,000
	// characters.
	UserEvent string `protobuf:"bytes,2,opt,name=user_event,json=userEvent,proto3" json:"user_event,omitempty"`
	// The URL including cgi-parameters but excluding the hash fragment with a
	// length limit of 5,000 characters. This is often more useful than the
	// referer URL, because many browsers only send the domain for 3rd party
	// requests.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	// The event timestamp in milliseconds. This prevents browser caching of
	// otherwise identical get requests. The name is abbreviated to reduce the
	// payload bytes.
	Ets int64 `protobuf:"varint,4,opt,name=ets,proto3" json:"ets,omitempty"`
	// An arbitrary serialized JSON string that contains necessary information
	// that can comprise a user event. When this field is specified, the
	// user_event field will be ignored. Note: line-delimited JSON is not
	// supported, a single JSON only.
	RawJson string `protobuf:"bytes,5,opt,name=raw_json,json=rawJson,proto3" json:"raw_json,omitempty"`
}

func (x *CollectUserEventRequest) Reset() {
	*x = CollectUserEventRequest{}
	mi := &file_google_cloud_retail_v2alpha_user_event_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CollectUserEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CollectUserEventRequest) ProtoMessage() {}

func (x *CollectUserEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_user_event_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CollectUserEventRequest.ProtoReflect.Descriptor instead.
func (*CollectUserEventRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_user_event_service_proto_rawDescGZIP(), []int{1}
}

func (m *CollectUserEventRequest) GetConversionRule() isCollectUserEventRequest_ConversionRule {
	if m != nil {
		return m.ConversionRule
	}
	return nil
}

func (x *CollectUserEventRequest) GetPrebuiltRule() string {
	if x, ok := x.GetConversionRule().(*CollectUserEventRequest_PrebuiltRule); ok {
		return x.PrebuiltRule
	}
	return ""
}

func (x *CollectUserEventRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CollectUserEventRequest) GetUserEvent() string {
	if x != nil {
		return x.UserEvent
	}
	return ""
}

func (x *CollectUserEventRequest) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *CollectUserEventRequest) GetEts() int64 {
	if x != nil {
		return x.Ets
	}
	return 0
}

func (x *CollectUserEventRequest) GetRawJson() string {
	if x != nil {
		return x.RawJson
	}
	return ""
}

type isCollectUserEventRequest_ConversionRule interface {
	isCollectUserEventRequest_ConversionRule()
}

type CollectUserEventRequest_PrebuiltRule struct {
	// The prebuilt rule name that can convert a specific type of raw_json.
	// For example: "ga4_bq" rule for the GA4 user event schema.
	PrebuiltRule string `protobuf:"bytes,6,opt,name=prebuilt_rule,json=prebuiltRule,proto3,oneof"`
}

func (*CollectUserEventRequest_PrebuiltRule) isCollectUserEventRequest_ConversionRule() {}

// Request message for RejoinUserEvents method.
type RejoinUserEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent catalog resource name, such as
	// `projects/1234/locations/global/catalogs/default_catalog`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The type of the user event rejoin to define the scope and range of the user
	// events to be rejoined with the latest product catalog. Defaults to
	// `USER_EVENT_REJOIN_SCOPE_UNSPECIFIED` if this field is not set, or set to
	// an invalid integer value.
	UserEventRejoinScope RejoinUserEventsRequest_UserEventRejoinScope `protobuf:"varint,2,opt,name=user_event_rejoin_scope,json=userEventRejoinScope,proto3,enum=google.cloud.retail.v2alpha.RejoinUserEventsRequest_UserEventRejoinScope" json:"user_event_rejoin_scope,omitempty"`
}

func (x *RejoinUserEventsRequest) Reset() {
	*x = RejoinUserEventsRequest{}
	mi := &file_google_cloud_retail_v2alpha_user_event_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RejoinUserEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RejoinUserEventsRequest) ProtoMessage() {}

func (x *RejoinUserEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_user_event_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RejoinUserEventsRequest.ProtoReflect.Descriptor instead.
func (*RejoinUserEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_user_event_service_proto_rawDescGZIP(), []int{2}
}

func (x *RejoinUserEventsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *RejoinUserEventsRequest) GetUserEventRejoinScope() RejoinUserEventsRequest_UserEventRejoinScope {
	if x != nil {
		return x.UserEventRejoinScope
	}
	return RejoinUserEventsRequest_USER_EVENT_REJOIN_SCOPE_UNSPECIFIED
}

// Response message for `RejoinUserEvents` method.
type RejoinUserEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of user events that were joined with latest product catalog.
	RejoinedUserEventsCount int64 `protobuf:"varint,1,opt,name=rejoined_user_events_count,json=rejoinedUserEventsCount,proto3" json:"rejoined_user_events_count,omitempty"`
}

func (x *RejoinUserEventsResponse) Reset() {
	*x = RejoinUserEventsResponse{}
	mi := &file_google_cloud_retail_v2alpha_user_event_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RejoinUserEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RejoinUserEventsResponse) ProtoMessage() {}

func (x *RejoinUserEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_user_event_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RejoinUserEventsResponse.ProtoReflect.Descriptor instead.
func (*RejoinUserEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_user_event_service_proto_rawDescGZIP(), []int{3}
}

func (x *RejoinUserEventsResponse) GetRejoinedUserEventsCount() int64 {
	if x != nil {
		return x.RejoinedUserEventsCount
	}
	return 0
}

// Metadata for `RejoinUserEvents` method.
type RejoinUserEventsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RejoinUserEventsMetadata) Reset() {
	*x = RejoinUserEventsMetadata{}
	mi := &file_google_cloud_retail_v2alpha_user_event_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RejoinUserEventsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RejoinUserEventsMetadata) ProtoMessage() {}

func (x *RejoinUserEventsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_user_event_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RejoinUserEventsMetadata.ProtoReflect.Descriptor instead.
func (*RejoinUserEventsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_user_event_service_proto_rawDescGZIP(), []int{4}
}

var File_google_cloud_retail_v2alpha_user_event_service_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2alpha_user_event_service_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x62, 0x6f, 0x64, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x65,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x70, 0x75, 0x72, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa1, 0x01, 0x0a, 0x15, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a,
	0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x75, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x5f, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x22, 0xd3, 0x01, 0x0a, 0x17, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0d, 0x70, 0x72, 0x65, 0x62, 0x75, 0x69,
	0x6c, 0x74, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x0c, 0x70, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x1b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69,
	0x12, 0x10, 0x0a, 0x03, 0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x65,
	0x74, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x72, 0x61, 0x77, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x72, 0x61, 0x77, 0x4a, 0x73, 0x6f, 0x6e, 0x42, 0x11, 0x0a,
	0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x22, 0xa2, 0x02, 0x0a, 0x17, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x80, 0x01, 0x0a, 0x17, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x5f,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e,
	0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x6a, 0x6f, 0x69,
	0x6e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x52, 0x14, 0x75, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x22, 0x67, 0x0a, 0x14,
	0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x53,
	0x63, 0x6f, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x23, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x45, 0x56, 0x45,
	0x4e, 0x54, 0x5f, 0x52, 0x45, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a,
	0x0d, 0x4a, 0x4f, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x53, 0x10, 0x01,
	0x12, 0x13, 0x0a, 0x0f, 0x55, 0x4e, 0x4a, 0x4f, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x45, 0x56, 0x45,
	0x4e, 0x54, 0x53, 0x10, 0x02, 0x22, 0x57, 0x0a, 0x18, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x55,
	0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x3b, 0x0a, 0x1a, 0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x17, 0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x55,
	0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x1a,
	0x0a, 0x18, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x32, 0xac, 0x0c, 0x0a, 0x10, 0x55,
	0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0xc6, 0x01, 0x0a, 0x0e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x58,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x3a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x22, 0x44, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x3a, 0x77, 0x72, 0x69, 0x74, 0x65, 0x12, 0xae, 0x01, 0x0a, 0x10, 0x43, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x48, 0x74, 0x74, 0x70, 0x42, 0x6f, 0x64, 0x79, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x48, 0x12, 0x46, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x3a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x9a, 0x02, 0x0a, 0x0f, 0x50, 0x75,
	0x72, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x75, 0x72, 0x67,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xb2, 0x01, 0xca, 0x41, 0x60, 0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x3a, 0x01, 0x2a,
	0x22, 0x44, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x3a, 0x70, 0x75, 0x72, 0x67, 0x65, 0x12, 0x9f, 0x02, 0x0a, 0x10, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xb5, 0x01, 0xca, 0x41, 0x62, 0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x01,
	0x2a, 0x22, 0x45, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x9f, 0x02, 0x0a, 0x10, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xb5, 0x01, 0xca, 0x41, 0x62, 0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x55, 0x73, 0x65, 0x72,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a,
	0x3a, 0x01, 0x2a, 0x22, 0x45, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xf1, 0x01, 0x0a, 0x10, 0x52,
	0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65,
	0x6a, 0x6f, 0x69, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01, 0xca, 0x41, 0x34, 0x0a, 0x18, 0x52, 0x65, 0x6a, 0x6f,
	0x69, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x52, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x55, 0x73, 0x65, 0x72,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x01, 0x2a, 0x22, 0x45, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x73, 0x65,
	0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x72, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x1a, 0x49,
	0xca, 0x41, 0x15, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xd9, 0x01, 0x0a, 0x1f, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x15, 0x55,
	0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0xa2,
	0x02, 0x06, 0x52, 0x45, 0x54, 0x41, 0x49, 0x4c, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x56,
	0x32, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5c, 0x56, 0x32, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0xea, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x3a, 0x3a, 0x56, 0x32,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2alpha_user_event_service_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2alpha_user_event_service_proto_rawDescData = file_google_cloud_retail_v2alpha_user_event_service_proto_rawDesc
)

func file_google_cloud_retail_v2alpha_user_event_service_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2alpha_user_event_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2alpha_user_event_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2alpha_user_event_service_proto_rawDescData)
	})
	return file_google_cloud_retail_v2alpha_user_event_service_proto_rawDescData
}

var file_google_cloud_retail_v2alpha_user_event_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_retail_v2alpha_user_event_service_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_retail_v2alpha_user_event_service_proto_goTypes = []any{
	(RejoinUserEventsRequest_UserEventRejoinScope)(0), // 0: google.cloud.retail.v2alpha.RejoinUserEventsRequest.UserEventRejoinScope
	(*WriteUserEventRequest)(nil),                     // 1: google.cloud.retail.v2alpha.WriteUserEventRequest
	(*CollectUserEventRequest)(nil),                   // 2: google.cloud.retail.v2alpha.CollectUserEventRequest
	(*RejoinUserEventsRequest)(nil),                   // 3: google.cloud.retail.v2alpha.RejoinUserEventsRequest
	(*RejoinUserEventsResponse)(nil),                  // 4: google.cloud.retail.v2alpha.RejoinUserEventsResponse
	(*RejoinUserEventsMetadata)(nil),                  // 5: google.cloud.retail.v2alpha.RejoinUserEventsMetadata
	(*UserEvent)(nil),                                 // 6: google.cloud.retail.v2alpha.UserEvent
	(*PurgeUserEventsRequest)(nil),                    // 7: google.cloud.retail.v2alpha.PurgeUserEventsRequest
	(*ImportUserEventsRequest)(nil),                   // 8: google.cloud.retail.v2alpha.ImportUserEventsRequest
	(*ExportUserEventsRequest)(nil),                   // 9: google.cloud.retail.v2alpha.ExportUserEventsRequest
	(*httpbody.HttpBody)(nil),                         // 10: google.api.HttpBody
	(*longrunningpb.Operation)(nil),                   // 11: google.longrunning.Operation
}
var file_google_cloud_retail_v2alpha_user_event_service_proto_depIdxs = []int32{
	6,  // 0: google.cloud.retail.v2alpha.WriteUserEventRequest.user_event:type_name -> google.cloud.retail.v2alpha.UserEvent
	0,  // 1: google.cloud.retail.v2alpha.RejoinUserEventsRequest.user_event_rejoin_scope:type_name -> google.cloud.retail.v2alpha.RejoinUserEventsRequest.UserEventRejoinScope
	1,  // 2: google.cloud.retail.v2alpha.UserEventService.WriteUserEvent:input_type -> google.cloud.retail.v2alpha.WriteUserEventRequest
	2,  // 3: google.cloud.retail.v2alpha.UserEventService.CollectUserEvent:input_type -> google.cloud.retail.v2alpha.CollectUserEventRequest
	7,  // 4: google.cloud.retail.v2alpha.UserEventService.PurgeUserEvents:input_type -> google.cloud.retail.v2alpha.PurgeUserEventsRequest
	8,  // 5: google.cloud.retail.v2alpha.UserEventService.ImportUserEvents:input_type -> google.cloud.retail.v2alpha.ImportUserEventsRequest
	9,  // 6: google.cloud.retail.v2alpha.UserEventService.ExportUserEvents:input_type -> google.cloud.retail.v2alpha.ExportUserEventsRequest
	3,  // 7: google.cloud.retail.v2alpha.UserEventService.RejoinUserEvents:input_type -> google.cloud.retail.v2alpha.RejoinUserEventsRequest
	6,  // 8: google.cloud.retail.v2alpha.UserEventService.WriteUserEvent:output_type -> google.cloud.retail.v2alpha.UserEvent
	10, // 9: google.cloud.retail.v2alpha.UserEventService.CollectUserEvent:output_type -> google.api.HttpBody
	11, // 10: google.cloud.retail.v2alpha.UserEventService.PurgeUserEvents:output_type -> google.longrunning.Operation
	11, // 11: google.cloud.retail.v2alpha.UserEventService.ImportUserEvents:output_type -> google.longrunning.Operation
	11, // 12: google.cloud.retail.v2alpha.UserEventService.ExportUserEvents:output_type -> google.longrunning.Operation
	11, // 13: google.cloud.retail.v2alpha.UserEventService.RejoinUserEvents:output_type -> google.longrunning.Operation
	8,  // [8:14] is the sub-list for method output_type
	2,  // [2:8] is the sub-list for method input_type
	2,  // [2:2] is the sub-list for extension type_name
	2,  // [2:2] is the sub-list for extension extendee
	0,  // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2alpha_user_event_service_proto_init() }
func file_google_cloud_retail_v2alpha_user_event_service_proto_init() {
	if File_google_cloud_retail_v2alpha_user_event_service_proto != nil {
		return
	}
	file_google_cloud_retail_v2alpha_export_config_proto_init()
	file_google_cloud_retail_v2alpha_import_config_proto_init()
	file_google_cloud_retail_v2alpha_purge_config_proto_init()
	file_google_cloud_retail_v2alpha_user_event_proto_init()
	file_google_cloud_retail_v2alpha_user_event_service_proto_msgTypes[1].OneofWrappers = []any{
		(*CollectUserEventRequest_PrebuiltRule)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2alpha_user_event_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_retail_v2alpha_user_event_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2alpha_user_event_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_retail_v2alpha_user_event_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_retail_v2alpha_user_event_service_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2alpha_user_event_service_proto = out.File
	file_google_cloud_retail_v2alpha_user_event_service_proto_rawDesc = nil
	file_google_cloud_retail_v2alpha_user_event_service_proto_goTypes = nil
	file_google_cloud_retail_v2alpha_user_event_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// UserEventServiceClient is the client API for UserEventService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type UserEventServiceClient interface {
	// Writes a single user event.
	WriteUserEvent(ctx context.Context, in *WriteUserEventRequest, opts ...grpc.CallOption) (*UserEvent, error)
	// Writes a single user event from the browser. This uses a GET request to
	// due to browser restriction of POST-ing to a 3rd party domain.
	//
	// This method is used only by the Retail API JavaScript pixel and Google Tag
	// Manager. Users should not call this method directly.
	CollectUserEvent(ctx context.Context, in *CollectUserEventRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error)
	// Deletes permanently all user events specified by the filter provided.
	// Depending on the number of events specified by the filter, this operation
	// could take hours or days to complete. To test a filter, use the list
	// command first.
	PurgeUserEvents(ctx context.Context, in *PurgeUserEventsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Bulk import of User events. Request processing might be
	// synchronous. Events that already exist are skipped.
	// Use this method for backfilling historical user events.
	//
	// `Operation.response` is of type `ImportResponse`. Note that it is
	// possible for a subset of the items to be successfully inserted.
	// `Operation.metadata` is of type `ImportMetadata`.
	ImportUserEvents(ctx context.Context, in *ImportUserEventsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports user events.
	//
	// `Operation.response` is of type `ExportResponse`.
	// `Operation.metadata` is of type `ExportMetadata`.
	ExportUserEvents(ctx context.Context, in *ExportUserEventsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts a user-event rejoin operation with latest product catalog. Events
	// are not annotated with detailed product information for products that are
	// missing from the catalog when the user event is ingested. These
	// events are stored as unjoined events with limited usage on training and
	// serving. You can use this method to start a join operation on specified
	// events with the latest version of product catalog. You can also use this
	// method to correct events joined with the wrong product catalog. A rejoin
	// operation can take hours or days to complete.
	RejoinUserEvents(ctx context.Context, in *RejoinUserEventsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type userEventServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewUserEventServiceClient(cc grpc.ClientConnInterface) UserEventServiceClient {
	return &userEventServiceClient{cc}
}

func (c *userEventServiceClient) WriteUserEvent(ctx context.Context, in *WriteUserEventRequest, opts ...grpc.CallOption) (*UserEvent, error) {
	out := new(UserEvent)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2alpha.UserEventService/WriteUserEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) CollectUserEvent(ctx context.Context, in *CollectUserEventRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error) {
	out := new(httpbody.HttpBody)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2alpha.UserEventService/CollectUserEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) PurgeUserEvents(ctx context.Context, in *PurgeUserEventsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2alpha.UserEventService/PurgeUserEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) ImportUserEvents(ctx context.Context, in *ImportUserEventsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2alpha.UserEventService/ImportUserEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) ExportUserEvents(ctx context.Context, in *ExportUserEventsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2alpha.UserEventService/ExportUserEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) RejoinUserEvents(ctx context.Context, in *RejoinUserEventsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2alpha.UserEventService/RejoinUserEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserEventServiceServer is the server API for UserEventService service.
type UserEventServiceServer interface {
	// Writes a single user event.
	WriteUserEvent(context.Context, *WriteUserEventRequest) (*UserEvent, error)
	// Writes a single user event from the browser. This uses a GET request to
	// due to browser restriction of POST-ing to a 3rd party domain.
	//
	// This method is used only by the Retail API JavaScript pixel and Google Tag
	// Manager. Users should not call this method directly.
	CollectUserEvent(context.Context, *CollectUserEventRequest) (*httpbody.HttpBody, error)
	// Deletes permanently all user events specified by the filter provided.
	// Depending on the number of events specified by the filter, this operation
	// could take hours or days to complete. To test a filter, use the list
	// command first.
	PurgeUserEvents(context.Context, *PurgeUserEventsRequest) (*longrunningpb.Operation, error)
	// Bulk import of User events. Request processing might be
	// synchronous. Events that already exist are skipped.
	// Use this method for backfilling historical user events.
	//
	// `Operation.response` is of type `ImportResponse`. Note that it is
	// possible for a subset of the items to be successfully inserted.
	// `Operation.metadata` is of type `ImportMetadata`.
	ImportUserEvents(context.Context, *ImportUserEventsRequest) (*longrunningpb.Operation, error)
	// Exports user events.
	//
	// `Operation.response` is of type `ExportResponse`.
	// `Operation.metadata` is of type `ExportMetadata`.
	ExportUserEvents(context.Context, *ExportUserEventsRequest) (*longrunningpb.Operation, error)
	// Starts a user-event rejoin operation with latest product catalog. Events
	// are not annotated with detailed product information for products that are
	// missing from the catalog when the user event is ingested. These
	// events are stored as unjoined events with limited usage on training and
	// serving. You can use this method to start a join operation on specified
	// events with the latest version of product catalog. You can also use this
	// method to correct events joined with the wrong product catalog. A rejoin
	// operation can take hours or days to complete.
	RejoinUserEvents(context.Context, *RejoinUserEventsRequest) (*longrunningpb.Operation, error)
}

// UnimplementedUserEventServiceServer can be embedded to have forward compatible implementations.
type UnimplementedUserEventServiceServer struct {
}

func (*UnimplementedUserEventServiceServer) WriteUserEvent(context.Context, *WriteUserEventRequest) (*UserEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteUserEvent not implemented")
}
func (*UnimplementedUserEventServiceServer) CollectUserEvent(context.Context, *CollectUserEventRequest) (*httpbody.HttpBody, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CollectUserEvent not implemented")
}
func (*UnimplementedUserEventServiceServer) PurgeUserEvents(context.Context, *PurgeUserEventsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeUserEvents not implemented")
}
func (*UnimplementedUserEventServiceServer) ImportUserEvents(context.Context, *ImportUserEventsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportUserEvents not implemented")
}
func (*UnimplementedUserEventServiceServer) ExportUserEvents(context.Context, *ExportUserEventsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportUserEvents not implemented")
}
func (*UnimplementedUserEventServiceServer) RejoinUserEvents(context.Context, *RejoinUserEventsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RejoinUserEvents not implemented")
}

func RegisterUserEventServiceServer(s *grpc.Server, srv UserEventServiceServer) {
	s.RegisterService(&_UserEventService_serviceDesc, srv)
}

func _UserEventService_WriteUserEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteUserEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).WriteUserEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2alpha.UserEventService/WriteUserEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).WriteUserEvent(ctx, req.(*WriteUserEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_CollectUserEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CollectUserEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).CollectUserEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2alpha.UserEventService/CollectUserEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).CollectUserEvent(ctx, req.(*CollectUserEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_PurgeUserEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeUserEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).PurgeUserEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2alpha.UserEventService/PurgeUserEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).PurgeUserEvents(ctx, req.(*PurgeUserEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_ImportUserEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportUserEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).ImportUserEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2alpha.UserEventService/ImportUserEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).ImportUserEvents(ctx, req.(*ImportUserEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_ExportUserEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportUserEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).ExportUserEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2alpha.UserEventService/ExportUserEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).ExportUserEvents(ctx, req.(*ExportUserEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_RejoinUserEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RejoinUserEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).RejoinUserEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2alpha.UserEventService/RejoinUserEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).RejoinUserEvents(ctx, req.(*RejoinUserEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _UserEventService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2alpha.UserEventService",
	HandlerType: (*UserEventServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "WriteUserEvent",
			Handler:    _UserEventService_WriteUserEvent_Handler,
		},
		{
			MethodName: "CollectUserEvent",
			Handler:    _UserEventService_CollectUserEvent_Handler,
		},
		{
			MethodName: "PurgeUserEvents",
			Handler:    _UserEventService_PurgeUserEvents_Handler,
		},
		{
			MethodName: "ImportUserEvents",
			Handler:    _UserEventService_ImportUserEvents_Handler,
		},
		{
			MethodName: "ExportUserEvents",
			Handler:    _UserEventService_ExportUserEvents_Handler,
		},
		{
			MethodName: "RejoinUserEvents",
			Handler:    _UserEventService_RejoinUserEvents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/retail/v2alpha/user_event_service.proto",
}
