// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The confidence that Amazon Comprehend accurately detected the source language is low. If a low confidence level is acceptable for your application, you can use the language in the exception to call Amazon Translate again. For more information, see the <a href="https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html">DetectDominantLanguage</a> operation in the <i>Amazon Comprehend Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DetectedLanguageLowConfidenceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: ::std::option::Option<::std::string::String>,
    /// <p>The language code of the auto-detected language from Amazon Comprehend.</p>
    pub detected_language_code: ::std::option::Option<::std::string::String>,
    pub(crate) meta: ::aws_smithy_types::error::ErrorMetadata,
}
impl DetectedLanguageLowConfidenceException {
    /// <p>The language code of the auto-detected language from Amazon Comprehend.</p>
    pub fn detected_language_code(&self) -> ::std::option::Option<&str> {
        self.detected_language_code.as_deref()
    }
}
impl DetectedLanguageLowConfidenceException {
    /// Returns the error message.
    pub fn message(&self) -> ::std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl ::std::fmt::Display for DetectedLanguageLowConfidenceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        ::std::write!(f, "DetectedLanguageLowConfidenceException")?;
        if let ::std::option::Option::Some(inner_1) = &self.message {
            {
                ::std::write!(f, ": {}", inner_1)?;
            }
        }
        Ok(())
    }
}
impl ::std::error::Error for DetectedLanguageLowConfidenceException {}
impl ::aws_types::request_id::RequestId for crate::types::error::DetectedLanguageLowConfidenceException {
    fn request_id(&self) -> Option<&str> {
        use ::aws_smithy_types::error::metadata::ProvideErrorMetadata;
        self.meta().request_id()
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for DetectedLanguageLowConfidenceException {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        &self.meta
    }
}
impl DetectedLanguageLowConfidenceException {
    /// Creates a new builder-style object to manufacture [`DetectedLanguageLowConfidenceException`](crate::types::error::DetectedLanguageLowConfidenceException).
    pub fn builder() -> crate::types::error::builders::DetectedLanguageLowConfidenceExceptionBuilder {
        crate::types::error::builders::DetectedLanguageLowConfidenceExceptionBuilder::default()
    }
}

/// A builder for [`DetectedLanguageLowConfidenceException`](crate::types::error::DetectedLanguageLowConfidenceException).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DetectedLanguageLowConfidenceExceptionBuilder {
    pub(crate) message: ::std::option::Option<::std::string::String>,
    pub(crate) detected_language_code: ::std::option::Option<::std::string::String>,
    meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
}
impl DetectedLanguageLowConfidenceExceptionBuilder {
    #[allow(missing_docs)] // documentation missing in model
    pub fn message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.message = ::std::option::Option::Some(input.into());
        self
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn set_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.message = input;
        self
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn get_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.message
    }
    /// <p>The language code of the auto-detected language from Amazon Comprehend.</p>
    pub fn detected_language_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.detected_language_code = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The language code of the auto-detected language from Amazon Comprehend.</p>
    pub fn set_detected_language_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.detected_language_code = input;
        self
    }
    /// <p>The language code of the auto-detected language from Amazon Comprehend.</p>
    pub fn get_detected_language_code(&self) -> &::std::option::Option<::std::string::String> {
        &self.detected_language_code
    }
    /// Sets error metadata
    pub fn meta(mut self, meta: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        self.meta = Some(meta);
        self
    }

    /// Sets error metadata
    pub fn set_meta(&mut self, meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>) -> &mut Self {
        self.meta = meta;
        self
    }
    /// Consumes the builder and constructs a [`DetectedLanguageLowConfidenceException`](crate::types::error::DetectedLanguageLowConfidenceException).
    pub fn build(self) -> crate::types::error::DetectedLanguageLowConfidenceException {
        crate::types::error::DetectedLanguageLowConfidenceException {
            message: self.message,
            detected_language_code: self.detected_language_code,
            meta: self.meta.unwrap_or_default(),
        }
    }
}
