// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Settings to configure your translation output. You can configure the following options:</p>
/// <ul>
/// <li>
/// <p>Brevity: reduces the length of the translation output for most translations. Available for <code>TranslateText</code> only.</p></li>
/// <li>
/// <p>Formality: sets the formality level of the translation output.</p></li>
/// <li>
/// <p>Profanity: masks profane words and phrases in the translation output.</p></li>
/// </ul>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct TranslationSettings {
    /// <p>You can specify the desired level of formality for translations to supported target languages. The formality setting controls the level of formal language usage (also known as <a href="https://en.wikipedia.org/wiki/Register_(sociolinguistics)">register</a>) in the translation output. You can set the value to informal or formal. If you don't specify a value for formality, or if the target language doesn't support formality, the translation will ignore the formality setting.</p>
    /// <p>If you specify multiple target languages for the job, translate ignores the formality setting for any unsupported target language.</p>
    /// <p>For a list of target languages that support formality, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-formality.html#customizing-translations-formality-languages">Supported languages</a> in the Amazon Translate Developer Guide.</p>
    pub formality: ::std::option::Option<crate::types::Formality>,
    /// <p>You can enable the profanity setting if you want to mask profane words and phrases in your translation output.</p>
    /// <p>To mask profane words and phrases, Amazon Translate replaces them with the grawlix string “?$#@$“. This 5-character sequence is used for each profane word or phrase, regardless of the length or number of words.</p>
    /// <p>Amazon Translate doesn't detect profanity in all of its supported languages. For languages that don't support profanity detection, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-profanity.html#customizing-translations-profanity-languages">Unsupported languages</a> in the Amazon Translate Developer Guide.</p>
    /// <p>If you specify multiple target languages for the job, all the target languages must support profanity masking. If any of the target languages don't support profanity masking, the translation job won't mask profanity for any target language.</p>
    pub profanity: ::std::option::Option<crate::types::Profanity>,
    /// <p>When you turn on brevity, Amazon Translate reduces the length of the translation output for most translations (when compared with the same translation with brevity turned off). By default, brevity is turned off.</p>
    /// <p>If you turn on brevity for a translation request with an unsupported language pair, the translation proceeds with the brevity setting turned off.</p>
    /// <p>For the language pairs that brevity supports, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-brevity">Using brevity</a> in the Amazon Translate Developer Guide.</p>
    pub brevity: ::std::option::Option<crate::types::Brevity>,
}
impl TranslationSettings {
    /// <p>You can specify the desired level of formality for translations to supported target languages. The formality setting controls the level of formal language usage (also known as <a href="https://en.wikipedia.org/wiki/Register_(sociolinguistics)">register</a>) in the translation output. You can set the value to informal or formal. If you don't specify a value for formality, or if the target language doesn't support formality, the translation will ignore the formality setting.</p>
    /// <p>If you specify multiple target languages for the job, translate ignores the formality setting for any unsupported target language.</p>
    /// <p>For a list of target languages that support formality, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-formality.html#customizing-translations-formality-languages">Supported languages</a> in the Amazon Translate Developer Guide.</p>
    pub fn formality(&self) -> ::std::option::Option<&crate::types::Formality> {
        self.formality.as_ref()
    }
    /// <p>You can enable the profanity setting if you want to mask profane words and phrases in your translation output.</p>
    /// <p>To mask profane words and phrases, Amazon Translate replaces them with the grawlix string “?$#@$“. This 5-character sequence is used for each profane word or phrase, regardless of the length or number of words.</p>
    /// <p>Amazon Translate doesn't detect profanity in all of its supported languages. For languages that don't support profanity detection, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-profanity.html#customizing-translations-profanity-languages">Unsupported languages</a> in the Amazon Translate Developer Guide.</p>
    /// <p>If you specify multiple target languages for the job, all the target languages must support profanity masking. If any of the target languages don't support profanity masking, the translation job won't mask profanity for any target language.</p>
    pub fn profanity(&self) -> ::std::option::Option<&crate::types::Profanity> {
        self.profanity.as_ref()
    }
    /// <p>When you turn on brevity, Amazon Translate reduces the length of the translation output for most translations (when compared with the same translation with brevity turned off). By default, brevity is turned off.</p>
    /// <p>If you turn on brevity for a translation request with an unsupported language pair, the translation proceeds with the brevity setting turned off.</p>
    /// <p>For the language pairs that brevity supports, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-brevity">Using brevity</a> in the Amazon Translate Developer Guide.</p>
    pub fn brevity(&self) -> ::std::option::Option<&crate::types::Brevity> {
        self.brevity.as_ref()
    }
}
impl TranslationSettings {
    /// Creates a new builder-style object to manufacture [`TranslationSettings`](crate::types::TranslationSettings).
    pub fn builder() -> crate::types::builders::TranslationSettingsBuilder {
        crate::types::builders::TranslationSettingsBuilder::default()
    }
}

/// A builder for [`TranslationSettings`](crate::types::TranslationSettings).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct TranslationSettingsBuilder {
    pub(crate) formality: ::std::option::Option<crate::types::Formality>,
    pub(crate) profanity: ::std::option::Option<crate::types::Profanity>,
    pub(crate) brevity: ::std::option::Option<crate::types::Brevity>,
}
impl TranslationSettingsBuilder {
    /// <p>You can specify the desired level of formality for translations to supported target languages. The formality setting controls the level of formal language usage (also known as <a href="https://en.wikipedia.org/wiki/Register_(sociolinguistics)">register</a>) in the translation output. You can set the value to informal or formal. If you don't specify a value for formality, or if the target language doesn't support formality, the translation will ignore the formality setting.</p>
    /// <p>If you specify multiple target languages for the job, translate ignores the formality setting for any unsupported target language.</p>
    /// <p>For a list of target languages that support formality, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-formality.html#customizing-translations-formality-languages">Supported languages</a> in the Amazon Translate Developer Guide.</p>
    pub fn formality(mut self, input: crate::types::Formality) -> Self {
        self.formality = ::std::option::Option::Some(input);
        self
    }
    /// <p>You can specify the desired level of formality for translations to supported target languages. The formality setting controls the level of formal language usage (also known as <a href="https://en.wikipedia.org/wiki/Register_(sociolinguistics)">register</a>) in the translation output. You can set the value to informal or formal. If you don't specify a value for formality, or if the target language doesn't support formality, the translation will ignore the formality setting.</p>
    /// <p>If you specify multiple target languages for the job, translate ignores the formality setting for any unsupported target language.</p>
    /// <p>For a list of target languages that support formality, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-formality.html#customizing-translations-formality-languages">Supported languages</a> in the Amazon Translate Developer Guide.</p>
    pub fn set_formality(mut self, input: ::std::option::Option<crate::types::Formality>) -> Self {
        self.formality = input;
        self
    }
    /// <p>You can specify the desired level of formality for translations to supported target languages. The formality setting controls the level of formal language usage (also known as <a href="https://en.wikipedia.org/wiki/Register_(sociolinguistics)">register</a>) in the translation output. You can set the value to informal or formal. If you don't specify a value for formality, or if the target language doesn't support formality, the translation will ignore the formality setting.</p>
    /// <p>If you specify multiple target languages for the job, translate ignores the formality setting for any unsupported target language.</p>
    /// <p>For a list of target languages that support formality, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-formality.html#customizing-translations-formality-languages">Supported languages</a> in the Amazon Translate Developer Guide.</p>
    pub fn get_formality(&self) -> &::std::option::Option<crate::types::Formality> {
        &self.formality
    }
    /// <p>You can enable the profanity setting if you want to mask profane words and phrases in your translation output.</p>
    /// <p>To mask profane words and phrases, Amazon Translate replaces them with the grawlix string “?$#@$“. This 5-character sequence is used for each profane word or phrase, regardless of the length or number of words.</p>
    /// <p>Amazon Translate doesn't detect profanity in all of its supported languages. For languages that don't support profanity detection, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-profanity.html#customizing-translations-profanity-languages">Unsupported languages</a> in the Amazon Translate Developer Guide.</p>
    /// <p>If you specify multiple target languages for the job, all the target languages must support profanity masking. If any of the target languages don't support profanity masking, the translation job won't mask profanity for any target language.</p>
    pub fn profanity(mut self, input: crate::types::Profanity) -> Self {
        self.profanity = ::std::option::Option::Some(input);
        self
    }
    /// <p>You can enable the profanity setting if you want to mask profane words and phrases in your translation output.</p>
    /// <p>To mask profane words and phrases, Amazon Translate replaces them with the grawlix string “?$#@$“. This 5-character sequence is used for each profane word or phrase, regardless of the length or number of words.</p>
    /// <p>Amazon Translate doesn't detect profanity in all of its supported languages. For languages that don't support profanity detection, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-profanity.html#customizing-translations-profanity-languages">Unsupported languages</a> in the Amazon Translate Developer Guide.</p>
    /// <p>If you specify multiple target languages for the job, all the target languages must support profanity masking. If any of the target languages don't support profanity masking, the translation job won't mask profanity for any target language.</p>
    pub fn set_profanity(mut self, input: ::std::option::Option<crate::types::Profanity>) -> Self {
        self.profanity = input;
        self
    }
    /// <p>You can enable the profanity setting if you want to mask profane words and phrases in your translation output.</p>
    /// <p>To mask profane words and phrases, Amazon Translate replaces them with the grawlix string “?$#@$“. This 5-character sequence is used for each profane word or phrase, regardless of the length or number of words.</p>
    /// <p>Amazon Translate doesn't detect profanity in all of its supported languages. For languages that don't support profanity detection, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-profanity.html#customizing-translations-profanity-languages">Unsupported languages</a> in the Amazon Translate Developer Guide.</p>
    /// <p>If you specify multiple target languages for the job, all the target languages must support profanity masking. If any of the target languages don't support profanity masking, the translation job won't mask profanity for any target language.</p>
    pub fn get_profanity(&self) -> &::std::option::Option<crate::types::Profanity> {
        &self.profanity
    }
    /// <p>When you turn on brevity, Amazon Translate reduces the length of the translation output for most translations (when compared with the same translation with brevity turned off). By default, brevity is turned off.</p>
    /// <p>If you turn on brevity for a translation request with an unsupported language pair, the translation proceeds with the brevity setting turned off.</p>
    /// <p>For the language pairs that brevity supports, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-brevity">Using brevity</a> in the Amazon Translate Developer Guide.</p>
    pub fn brevity(mut self, input: crate::types::Brevity) -> Self {
        self.brevity = ::std::option::Option::Some(input);
        self
    }
    /// <p>When you turn on brevity, Amazon Translate reduces the length of the translation output for most translations (when compared with the same translation with brevity turned off). By default, brevity is turned off.</p>
    /// <p>If you turn on brevity for a translation request with an unsupported language pair, the translation proceeds with the brevity setting turned off.</p>
    /// <p>For the language pairs that brevity supports, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-brevity">Using brevity</a> in the Amazon Translate Developer Guide.</p>
    pub fn set_brevity(mut self, input: ::std::option::Option<crate::types::Brevity>) -> Self {
        self.brevity = input;
        self
    }
    /// <p>When you turn on brevity, Amazon Translate reduces the length of the translation output for most translations (when compared with the same translation with brevity turned off). By default, brevity is turned off.</p>
    /// <p>If you turn on brevity for a translation request with an unsupported language pair, the translation proceeds with the brevity setting turned off.</p>
    /// <p>For the language pairs that brevity supports, see <a href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-brevity">Using brevity</a> in the Amazon Translate Developer Guide.</p>
    pub fn get_brevity(&self) -> &::std::option::Option<crate::types::Brevity> {
        &self.brevity
    }
    /// Consumes the builder and constructs a [`TranslationSettings`](crate::types::TranslationSettings).
    pub fn build(self) -> crate::types::TranslationSettings {
        crate::types::TranslationSettings {
            formality: self.formality,
            profanity: self.profanity,
            brevity: self.brevity,
        }
    }
}
