// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A supported language.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Language {
    /// <p>Language name of the supported language.</p>
    pub language_name: ::std::string::String,
    /// <p>Language code for the supported language.</p>
    pub language_code: ::std::string::String,
}
impl Language {
    /// <p>Language name of the supported language.</p>
    pub fn language_name(&self) -> &str {
        use std::ops::Deref;
        self.language_name.deref()
    }
    /// <p>Language code for the supported language.</p>
    pub fn language_code(&self) -> &str {
        use std::ops::Deref;
        self.language_code.deref()
    }
}
impl Language {
    /// Creates a new builder-style object to manufacture [`Language`](crate::types::Language).
    pub fn builder() -> crate::types::builders::LanguageBuilder {
        crate::types::builders::LanguageBuilder::default()
    }
}

/// A builder for [`Language`](crate::types::Language).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct LanguageBuilder {
    pub(crate) language_name: ::std::option::Option<::std::string::String>,
    pub(crate) language_code: ::std::option::Option<::std::string::String>,
}
impl LanguageBuilder {
    /// <p>Language name of the supported language.</p>
    /// This field is required.
    pub fn language_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.language_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Language name of the supported language.</p>
    pub fn set_language_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.language_name = input;
        self
    }
    /// <p>Language name of the supported language.</p>
    pub fn get_language_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.language_name
    }
    /// <p>Language code for the supported language.</p>
    /// This field is required.
    pub fn language_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.language_code = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Language code for the supported language.</p>
    pub fn set_language_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.language_code = input;
        self
    }
    /// <p>Language code for the supported language.</p>
    pub fn get_language_code(&self) -> &::std::option::Option<::std::string::String> {
        &self.language_code
    }
    /// Consumes the builder and constructs a [`Language`](crate::types::Language).
    /// This method will fail if any of the following fields are not set:
    /// - [`language_name`](crate::types::builders::LanguageBuilder::language_name)
    /// - [`language_code`](crate::types::builders::LanguageBuilder::language_code)
    pub fn build(self) -> ::std::result::Result<crate::types::Language, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::Language {
            language_name: self.language_name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "language_name",
                    "language_name was not specified but it is required when building Language",
                )
            })?,
            language_code: self.language_code.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "language_code",
                    "language_code was not specified but it is required when building Language",
                )
            })?,
        })
    }
}
