// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetTerminology`](crate::operation::get_terminology::builders::GetTerminologyFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::operation::get_terminology::builders::GetTerminologyFluentBuilder::name) / [`set_name(Option<String>)`](crate::operation::get_terminology::builders::GetTerminologyFluentBuilder::set_name):<br>required: **true**<br><p>The name of the custom terminology being retrieved.</p><br>
    ///   - [`terminology_data_format(TerminologyDataFormat)`](crate::operation::get_terminology::builders::GetTerminologyFluentBuilder::terminology_data_format) / [`set_terminology_data_format(Option<TerminologyDataFormat>)`](crate::operation::get_terminology::builders::GetTerminologyFluentBuilder::set_terminology_data_format):<br>required: **false**<br><p>The data format of the custom terminology being retrieved.</p> <p>If you don't specify this parameter, Amazon Translate returns a file with the same format as the file that was imported to create the terminology.</p> <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p><br>
    /// - On success, responds with [`GetTerminologyOutput`](crate::operation::get_terminology::GetTerminologyOutput) with field(s):
    ///   - [`terminology_properties(Option<TerminologyProperties>)`](crate::operation::get_terminology::GetTerminologyOutput::terminology_properties): <p>The properties of the custom terminology being retrieved.</p>
    ///   - [`terminology_data_location(Option<TerminologyDataLocation>)`](crate::operation::get_terminology::GetTerminologyOutput::terminology_data_location): <p>The Amazon S3 location of the most recent custom terminology input file that was successfully imported into Amazon Translate. The location is returned as a presigned URL that has a 30-minute expiration.</p><important>  <p>Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.</p>  <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p>  <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p> </important>
    ///   - [`auxiliary_data_location(Option<TerminologyDataLocation>)`](crate::operation::get_terminology::GetTerminologyOutput::auxiliary_data_location): <p>The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file. This file was created when Amazon Translate attempted to create a terminology resource. The location is returned as a presigned URL to that has a 30-minute expiration.</p>
    /// - On failure, responds with [`SdkError<GetTerminologyError>`](crate::operation::get_terminology::GetTerminologyError)
    pub fn get_terminology(&self) -> crate::operation::get_terminology::builders::GetTerminologyFluentBuilder {
        crate::operation::get_terminology::builders::GetTerminologyFluentBuilder::new(self.handle.clone())
    }
}
