
SET(LIBNATPMP_SEARCH_PATHS
    /usr/local/
    /usr
    /opt
)

FIND_PATH(LIBNATPMP_INCLUDE_DIR natpmp.h
    HINTS
    PATH_SUFFIXES include
    PATHS ${LIBNATPMP_SEARCH_PATHS}
)
FIND_LIBRARY(LIBNATPMP_LIBRARY natpmp
    HINTS
    PATH_SUFFIXES lib64 lib bin
    PATHS ${LIBNATPMP_SEARCH_PATHS}
)

include(FindPackageHandleStandardArgs)
# handle the QUIETLY and REQUIRED arguments
FIND_PACKAGE_HANDLE_STANDARD_ARGS(natpmp
    REQUIRED_VARS LIBNATPMP_LIBRARY LIBNATPMP_INCLUDE_DIR
)

mark_as_advanced(LIBNATPMP_INCLUDE_DIR LIBNATPMP_LIBRARY LIBNATPMP_SEARCH_PATHS LIBNATPMP_DEFINITIONS)
