// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1beta1/model_monitoring_stats.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the collection of statistics for a metric.
type ModelMonitoringStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Stats:
	//
	//	*ModelMonitoringStats_TabularStats
	Stats isModelMonitoringStats_Stats `protobuf_oneof:"stats"`
}

func (x *ModelMonitoringStats) Reset() {
	*x = ModelMonitoringStats{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelMonitoringStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringStats) ProtoMessage() {}

func (x *ModelMonitoringStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringStats.ProtoReflect.Descriptor instead.
func (*ModelMonitoringStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDescGZIP(), []int{0}
}

func (m *ModelMonitoringStats) GetStats() isModelMonitoringStats_Stats {
	if m != nil {
		return m.Stats
	}
	return nil
}

func (x *ModelMonitoringStats) GetTabularStats() *ModelMonitoringTabularStats {
	if x, ok := x.GetStats().(*ModelMonitoringStats_TabularStats); ok {
		return x.TabularStats
	}
	return nil
}

type isModelMonitoringStats_Stats interface {
	isModelMonitoringStats_Stats()
}

type ModelMonitoringStats_TabularStats struct {
	// Generated tabular statistics.
	TabularStats *ModelMonitoringTabularStats `protobuf:"bytes,1,opt,name=tabular_stats,json=tabularStats,proto3,oneof"`
}

func (*ModelMonitoringStats_TabularStats) isModelMonitoringStats_Stats() {}

// Represents a single statistics data point.
type ModelMonitoringStatsDataPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Statistics from current dataset.
	CurrentStats *ModelMonitoringStatsDataPoint_TypedValue `protobuf:"bytes,1,opt,name=current_stats,json=currentStats,proto3" json:"current_stats,omitempty"`
	// Statistics from baseline dataset.
	BaselineStats *ModelMonitoringStatsDataPoint_TypedValue `protobuf:"bytes,2,opt,name=baseline_stats,json=baselineStats,proto3" json:"baseline_stats,omitempty"`
	// Threshold value.
	ThresholdValue float64 `protobuf:"fixed64,3,opt,name=threshold_value,json=thresholdValue,proto3" json:"threshold_value,omitempty"`
	// Indicate if the statistics has anomaly.
	HasAnomaly bool `protobuf:"varint,4,opt,name=has_anomaly,json=hasAnomaly,proto3" json:"has_anomaly,omitempty"`
	// Model monitoring job resource name.
	ModelMonitoringJob string `protobuf:"bytes,5,opt,name=model_monitoring_job,json=modelMonitoringJob,proto3" json:"model_monitoring_job,omitempty"`
	// Schedule resource name.
	Schedule string `protobuf:"bytes,6,opt,name=schedule,proto3" json:"schedule,omitempty"`
	// Statistics create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Algorithm used to calculated the metrics, eg: jensen_shannon_divergence,
	// l_infinity.
	Algorithm string `protobuf:"bytes,8,opt,name=algorithm,proto3" json:"algorithm,omitempty"`
}

func (x *ModelMonitoringStatsDataPoint) Reset() {
	*x = ModelMonitoringStatsDataPoint{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelMonitoringStatsDataPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringStatsDataPoint) ProtoMessage() {}

func (x *ModelMonitoringStatsDataPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringStatsDataPoint.ProtoReflect.Descriptor instead.
func (*ModelMonitoringStatsDataPoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDescGZIP(), []int{1}
}

func (x *ModelMonitoringStatsDataPoint) GetCurrentStats() *ModelMonitoringStatsDataPoint_TypedValue {
	if x != nil {
		return x.CurrentStats
	}
	return nil
}

func (x *ModelMonitoringStatsDataPoint) GetBaselineStats() *ModelMonitoringStatsDataPoint_TypedValue {
	if x != nil {
		return x.BaselineStats
	}
	return nil
}

func (x *ModelMonitoringStatsDataPoint) GetThresholdValue() float64 {
	if x != nil {
		return x.ThresholdValue
	}
	return 0
}

func (x *ModelMonitoringStatsDataPoint) GetHasAnomaly() bool {
	if x != nil {
		return x.HasAnomaly
	}
	return false
}

func (x *ModelMonitoringStatsDataPoint) GetModelMonitoringJob() string {
	if x != nil {
		return x.ModelMonitoringJob
	}
	return ""
}

func (x *ModelMonitoringStatsDataPoint) GetSchedule() string {
	if x != nil {
		return x.Schedule
	}
	return ""
}

func (x *ModelMonitoringStatsDataPoint) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ModelMonitoringStatsDataPoint) GetAlgorithm() string {
	if x != nil {
		return x.Algorithm
	}
	return ""
}

// A collection of data points that describes the time-varying values of a
// tabular metric.
type ModelMonitoringTabularStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The stats name.
	StatsName string `protobuf:"bytes,1,opt,name=stats_name,json=statsName,proto3" json:"stats_name,omitempty"`
	// One of the supported monitoring objectives:
	// `raw-feature-drift`
	// `prediction-output-drift`
	// `feature-attribution`
	ObjectiveType string `protobuf:"bytes,2,opt,name=objective_type,json=objectiveType,proto3" json:"objective_type,omitempty"`
	// The data points of this time series. When listing time series, points are
	// returned in reverse time order.
	DataPoints []*ModelMonitoringStatsDataPoint `protobuf:"bytes,3,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
}

func (x *ModelMonitoringTabularStats) Reset() {
	*x = ModelMonitoringTabularStats{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelMonitoringTabularStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringTabularStats) ProtoMessage() {}

func (x *ModelMonitoringTabularStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringTabularStats.ProtoReflect.Descriptor instead.
func (*ModelMonitoringTabularStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDescGZIP(), []int{2}
}

func (x *ModelMonitoringTabularStats) GetStatsName() string {
	if x != nil {
		return x.StatsName
	}
	return ""
}

func (x *ModelMonitoringTabularStats) GetObjectiveType() string {
	if x != nil {
		return x.ObjectiveType
	}
	return ""
}

func (x *ModelMonitoringTabularStats) GetDataPoints() []*ModelMonitoringStatsDataPoint {
	if x != nil {
		return x.DataPoints
	}
	return nil
}

// Filter for searching ModelMonitoringStats.
type SearchModelMonitoringStatsFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Filter:
	//
	//	*SearchModelMonitoringStatsFilter_TabularStatsFilter_
	Filter isSearchModelMonitoringStatsFilter_Filter `protobuf_oneof:"filter"`
}

func (x *SearchModelMonitoringStatsFilter) Reset() {
	*x = SearchModelMonitoringStatsFilter{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchModelMonitoringStatsFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchModelMonitoringStatsFilter) ProtoMessage() {}

func (x *SearchModelMonitoringStatsFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchModelMonitoringStatsFilter.ProtoReflect.Descriptor instead.
func (*SearchModelMonitoringStatsFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDescGZIP(), []int{3}
}

func (m *SearchModelMonitoringStatsFilter) GetFilter() isSearchModelMonitoringStatsFilter_Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (x *SearchModelMonitoringStatsFilter) GetTabularStatsFilter() *SearchModelMonitoringStatsFilter_TabularStatsFilter {
	if x, ok := x.GetFilter().(*SearchModelMonitoringStatsFilter_TabularStatsFilter_); ok {
		return x.TabularStatsFilter
	}
	return nil
}

type isSearchModelMonitoringStatsFilter_Filter interface {
	isSearchModelMonitoringStatsFilter_Filter()
}

type SearchModelMonitoringStatsFilter_TabularStatsFilter_ struct {
	// Tabular statistics filter.
	TabularStatsFilter *SearchModelMonitoringStatsFilter_TabularStatsFilter `protobuf:"bytes,1,opt,name=tabular_stats_filter,json=tabularStatsFilter,proto3,oneof"`
}

func (*SearchModelMonitoringStatsFilter_TabularStatsFilter_) isSearchModelMonitoringStatsFilter_Filter() {
}

// Typed value of the statistics.
type ModelMonitoringStatsDataPoint_TypedValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The typed value.
	//
	// Types that are assignable to Value:
	//
	//	*ModelMonitoringStatsDataPoint_TypedValue_DoubleValue
	//	*ModelMonitoringStatsDataPoint_TypedValue_DistributionValue
	Value isModelMonitoringStatsDataPoint_TypedValue_Value `protobuf_oneof:"value"`
}

func (x *ModelMonitoringStatsDataPoint_TypedValue) Reset() {
	*x = ModelMonitoringStatsDataPoint_TypedValue{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelMonitoringStatsDataPoint_TypedValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringStatsDataPoint_TypedValue) ProtoMessage() {}

func (x *ModelMonitoringStatsDataPoint_TypedValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringStatsDataPoint_TypedValue.ProtoReflect.Descriptor instead.
func (*ModelMonitoringStatsDataPoint_TypedValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDescGZIP(), []int{1, 0}
}

func (m *ModelMonitoringStatsDataPoint_TypedValue) GetValue() isModelMonitoringStatsDataPoint_TypedValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *ModelMonitoringStatsDataPoint_TypedValue) GetDoubleValue() float64 {
	if x, ok := x.GetValue().(*ModelMonitoringStatsDataPoint_TypedValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (x *ModelMonitoringStatsDataPoint_TypedValue) GetDistributionValue() *ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue {
	if x, ok := x.GetValue().(*ModelMonitoringStatsDataPoint_TypedValue_DistributionValue); ok {
		return x.DistributionValue
	}
	return nil
}

type isModelMonitoringStatsDataPoint_TypedValue_Value interface {
	isModelMonitoringStatsDataPoint_TypedValue_Value()
}

type ModelMonitoringStatsDataPoint_TypedValue_DoubleValue struct {
	// Double.
	DoubleValue float64 `protobuf:"fixed64,1,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type ModelMonitoringStatsDataPoint_TypedValue_DistributionValue struct {
	// Distribution.
	DistributionValue *ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue `protobuf:"bytes,2,opt,name=distribution_value,json=distributionValue,proto3,oneof"`
}

func (*ModelMonitoringStatsDataPoint_TypedValue_DoubleValue) isModelMonitoringStatsDataPoint_TypedValue_Value() {
}

func (*ModelMonitoringStatsDataPoint_TypedValue_DistributionValue) isModelMonitoringStatsDataPoint_TypedValue_Value() {
}

// Summary statistics for a population of values.
type ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Predictive monitoring drift distribution in
	// `tensorflow.metadata.v0.DatasetFeatureStatistics` format.
	Distribution *structpb.Value `protobuf:"bytes,1,opt,name=distribution,proto3" json:"distribution,omitempty"`
	// Distribution distance deviation from the current dataset's statistics
	// to baseline dataset's statistics.
	//   - For categorical feature, the distribution distance is calculated
	//     by L-inifinity norm or Jensen–Shannon divergence.
	//   - For numerical feature, the distribution distance is calculated by
	//     Jensen–Shannon divergence.
	DistributionDeviation float64 `protobuf:"fixed64,2,opt,name=distribution_deviation,json=distributionDeviation,proto3" json:"distribution_deviation,omitempty"`
}

func (x *ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue) Reset() {
	*x = ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue) ProtoMessage() {}

func (x *ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue.ProtoReflect.Descriptor instead.
func (*ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue) GetDistribution() *structpb.Value {
	if x != nil {
		return x.Distribution
	}
	return nil
}

func (x *ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue) GetDistributionDeviation() float64 {
	if x != nil {
		return x.DistributionDeviation
	}
	return 0
}

// Tabular statistics filter.
type SearchModelMonitoringStatsFilter_TabularStatsFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If not specified, will return all the stats_names.
	StatsName string `protobuf:"bytes,1,opt,name=stats_name,json=statsName,proto3" json:"stats_name,omitempty"`
	// One of the supported monitoring objectives:
	// `raw-feature-drift`
	// `prediction-output-drift`
	// `feature-attribution`
	ObjectiveType string `protobuf:"bytes,2,opt,name=objective_type,json=objectiveType,proto3" json:"objective_type,omitempty"`
	// From a particular monitoring job.
	ModelMonitoringJob string `protobuf:"bytes,3,opt,name=model_monitoring_job,json=modelMonitoringJob,proto3" json:"model_monitoring_job,omitempty"`
	// From a particular monitoring schedule.
	ModelMonitoringSchedule string `protobuf:"bytes,4,opt,name=model_monitoring_schedule,json=modelMonitoringSchedule,proto3" json:"model_monitoring_schedule,omitempty"`
	// Specify the algorithm type used for distance calculation, eg:
	// jensen_shannon_divergence, l_infinity.
	Algorithm string `protobuf:"bytes,5,opt,name=algorithm,proto3" json:"algorithm,omitempty"`
}

func (x *SearchModelMonitoringStatsFilter_TabularStatsFilter) Reset() {
	*x = SearchModelMonitoringStatsFilter_TabularStatsFilter{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchModelMonitoringStatsFilter_TabularStatsFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchModelMonitoringStatsFilter_TabularStatsFilter) ProtoMessage() {}

func (x *SearchModelMonitoringStatsFilter_TabularStatsFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchModelMonitoringStatsFilter_TabularStatsFilter.ProtoReflect.Descriptor instead.
func (*SearchModelMonitoringStatsFilter_TabularStatsFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDescGZIP(), []int{3, 0}
}

func (x *SearchModelMonitoringStatsFilter_TabularStatsFilter) GetStatsName() string {
	if x != nil {
		return x.StatsName
	}
	return ""
}

func (x *SearchModelMonitoringStatsFilter_TabularStatsFilter) GetObjectiveType() string {
	if x != nil {
		return x.ObjectiveType
	}
	return ""
}

func (x *SearchModelMonitoringStatsFilter_TabularStatsFilter) GetModelMonitoringJob() string {
	if x != nil {
		return x.ModelMonitoringJob
	}
	return ""
}

func (x *SearchModelMonitoringStatsFilter_TabularStatsFilter) GetModelMonitoringSchedule() string {
	if x != nil {
		return x.ModelMonitoringSchedule
	}
	return ""
}

func (x *SearchModelMonitoringStatsFilter_TabularStatsFilter) GetAlgorithm() string {
	if x != nil {
		return x.Algorithm
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x84,
	0x01, 0x0a, 0x14, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x63, 0x0a, 0x0d, 0x74, 0x61, 0x62, 0x75, 0x6c,
	0x61, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x54, 0x61, 0x62, 0x75, 0x6c, 0x61, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x48, 0x00, 0x52, 0x0c,
	0x74, 0x61, 0x62, 0x75, 0x6c, 0x61, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x42, 0x07, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x73, 0x22, 0xd1, 0x06, 0x0a, 0x1d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x6e, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x70, 0x0a, 0x0e, 0x62, 0x61, 0x73, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x61, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x62, 0x61, 0x73, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x74, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x0e, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x68, 0x61, 0x73, 0x5f, 0x61, 0x6e, 0x6f, 0x6d, 0x61, 0x6c,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x68, 0x61, 0x73, 0x41, 0x6e, 0x6f, 0x6d,
	0x61, 0x6c, 0x79, 0x12, 0x30, 0x0a, 0x14, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x12, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1c,
	0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x1a, 0xda, 0x02, 0x0a,
	0x0a, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x64,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x01, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x90, 0x01, 0x0a, 0x12, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x54, 0x79,
	0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00,
	0x52, 0x11, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x1a, 0x8a, 0x01, 0x0a, 0x15, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3a, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x64, 0x69, 0x73,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x16, 0x64, 0x69, 0x73,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x15, 0x64, 0x69, 0x73, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xc4, 0x01, 0x0a, 0x1b, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x62,
	0x75, 0x6c, 0x61, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x74, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x5f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x73, 0x44, 0x61, 0x74, 0x61, 0x50,
	0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73,
	0x22, 0xa0, 0x03, 0x0a, 0x20, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x73, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x88, 0x01, 0x0a, 0x14, 0x74, 0x61, 0x62, 0x75, 0x6c, 0x61,
	0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x54, 0x61, 0x62, 0x75, 0x6c, 0x61, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x12, 0x74, 0x61,
	0x62, 0x75, 0x6c, 0x61, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x1a, 0xe6, 0x01, 0x0a, 0x12, 0x54, 0x61, 0x62, 0x75, 0x6c, 0x61, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x73,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x30, 0x0a,
	0x14, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x12,
	0x3a, 0x0a, 0x19, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x17, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x61,
	0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x42, 0x08, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x42, 0xf0, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x19, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41,
	0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_goTypes = []any{
	(*ModelMonitoringStats)(nil),                                           // 0: google.cloud.aiplatform.v1beta1.ModelMonitoringStats
	(*ModelMonitoringStatsDataPoint)(nil),                                  // 1: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
	(*ModelMonitoringTabularStats)(nil),                                    // 2: google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats
	(*SearchModelMonitoringStatsFilter)(nil),                               // 3: google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter
	(*ModelMonitoringStatsDataPoint_TypedValue)(nil),                       // 4: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
	(*ModelMonitoringStatsDataPoint_TypedValue_DistributionDataValue)(nil), // 5: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue
	(*SearchModelMonitoringStatsFilter_TabularStatsFilter)(nil),            // 6: google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
	(*timestamppb.Timestamp)(nil),                                          // 7: google.protobuf.Timestamp
	(*structpb.Value)(nil),                                                 // 8: google.protobuf.Value
}
var file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_depIdxs = []int32{
	2, // 0: google.cloud.aiplatform.v1beta1.ModelMonitoringStats.tabular_stats:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats
	4, // 1: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.current_stats:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
	4, // 2: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.baseline_stats:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue
	7, // 3: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.create_time:type_name -> google.protobuf.Timestamp
	1, // 4: google.cloud.aiplatform.v1beta1.ModelMonitoringTabularStats.data_points:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint
	6, // 5: google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.tabular_stats_filter:type_name -> google.cloud.aiplatform.v1beta1.SearchModelMonitoringStatsFilter.TabularStatsFilter
	5, // 6: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.distribution_value:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue
	8, // 7: google.cloud.aiplatform.v1beta1.ModelMonitoringStatsDataPoint.TypedValue.DistributionDataValue.distribution:type_name -> google.protobuf.Value
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_init() }
func file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[0].OneofWrappers = []any{
		(*ModelMonitoringStats_TabularStats)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[3].OneofWrappers = []any{
		(*SearchModelMonitoringStatsFilter_TabularStatsFilter_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes[4].OneofWrappers = []any{
		(*ModelMonitoringStatsDataPoint_TypedValue_DoubleValue)(nil),
		(*ModelMonitoringStatsDataPoint_TypedValue_DistributionValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto = out.File
	file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_model_monitoring_stats_proto_depIdxs = nil
}
