// Code generated by sdkgen-v2. DO NOT EDIT.
package oidcsdk

import (
	"context"

	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	oidc "github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1/workload/oidc"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	sdkop "github.com/yandex-cloud/go-sdk/v2/pkg/operation"
	"github.com/yandex-cloud/go-sdk/v2/pkg/transport"
	"google.golang.org/grpc"
	proto "google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/reflect/protoreflect"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// FederationClient provides methods for managing Federation resources of Yandex.Cloud Oidc.
type FederationClient interface {
	Get(context.Context, *oidc.GetFederationRequest, ...grpc.CallOption) (*oidc.Federation, error)
	List(context.Context, *oidc.ListFederationsRequest, ...grpc.CallOption) (*oidc.ListFederationsResponse, error)
	Create(context.Context, *oidc.CreateFederationRequest, ...grpc.CallOption) (*FederationCreateOperation, error)
	Update(context.Context, *oidc.UpdateFederationRequest, ...grpc.CallOption) (*FederationUpdateOperation, error)
	Delete(context.Context, *oidc.DeleteFederationRequest, ...grpc.CallOption) (*FederationDeleteOperation, error)
	ListAccessBindings(context.Context, *access.ListAccessBindingsRequest, ...grpc.CallOption) (*access.ListAccessBindingsResponse, error)
	SetAccessBindings(context.Context, *access.SetAccessBindingsRequest, ...grpc.CallOption) (*FederationSetAccessBindingsOperation, error)
	UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest, ...grpc.CallOption) (*FederationUpdateAccessBindingsOperation, error)
}

var _ FederationClient = federationClient{}

type federationClient struct {
	connector transport.Connector
}

// NewFederationClient returns FederationClient implementation.
func NewFederationClient(connector transport.Connector) FederationClient {
	return federationClient{connector}
}

// Get is an operation of Yandex.Cloud Oidc Federation service.
func (c federationClient) Get(ctx context.Context, in *oidc.GetFederationRequest, opts ...grpc.CallOption) (*oidc.Federation, error) {
	connection, err := c.connector.GetConnection(ctx, FederationGet, opts...)
	if err != nil {
		return nil, err
	}
	return oidc.NewFederationServiceClient(connection).Get(ctx, in, opts...)
}

// List is an operation of Yandex.Cloud Oidc Federation service.
func (c federationClient) List(ctx context.Context, in *oidc.ListFederationsRequest, opts ...grpc.CallOption) (*oidc.ListFederationsResponse, error) {
	connection, err := c.connector.GetConnection(ctx, FederationList, opts...)
	if err != nil {
		return nil, err
	}
	return oidc.NewFederationServiceClient(connection).List(ctx, in, opts...)
}

// FederationCreateOperation is used to monitor the state of Create operations.
type FederationCreateOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *FederationCreateOperation) Metadata() *oidc.CreateFederationMetadata {
	return o.Operation.Metadata().(*oidc.CreateFederationMetadata)
}

// Response retrieves the operation response.
func (o *FederationCreateOperation) Response() *oidc.Federation {
	return o.Operation.Response().(*oidc.Federation)
}

// Wait polls the operation until it's done.
func (o *FederationCreateOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*oidc.Federation, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*oidc.Federation)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *FederationCreateOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*oidc.Federation, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*oidc.Federation)
	return response, err
}

// Create is an operation of Yandex.Cloud Oidc Federation service.
// It returns an object which should be used to monitor the operation state.
func (c federationClient) Create(ctx context.Context, in *oidc.CreateFederationRequest, opts ...grpc.CallOption) (*FederationCreateOperation, error) {
	connection, err := c.connector.GetConnection(ctx, FederationCreate, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := oidc.NewFederationServiceClient(connection).Create(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll: c.pollOperation,
		GetResourceID: func(metadata proto.Message) string {
			return metadata.(*oidc.CreateFederationMetadata).GetFederationId()
		},
		MetadataType: (*oidc.CreateFederationMetadata)(nil),
		ResponseType: (*oidc.Federation)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &FederationCreateOperation{*op}, nil
}

// FederationUpdateOperation is used to monitor the state of Update operations.
type FederationUpdateOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *FederationUpdateOperation) Metadata() *oidc.UpdateFederationMetadata {
	return o.Operation.Metadata().(*oidc.UpdateFederationMetadata)
}

// Response retrieves the operation response.
func (o *FederationUpdateOperation) Response() *oidc.Federation {
	return o.Operation.Response().(*oidc.Federation)
}

// Wait polls the operation until it's done.
func (o *FederationUpdateOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*oidc.Federation, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*oidc.Federation)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *FederationUpdateOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*oidc.Federation, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*oidc.Federation)
	return response, err
}

// Update is an operation of Yandex.Cloud Oidc Federation service.
// It returns an object which should be used to monitor the operation state.
func (c federationClient) Update(ctx context.Context, in *oidc.UpdateFederationRequest, opts ...grpc.CallOption) (*FederationUpdateOperation, error) {
	connection, err := c.connector.GetConnection(ctx, FederationUpdate, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := oidc.NewFederationServiceClient(connection).Update(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll: c.pollOperation,
		GetResourceID: func(metadata proto.Message) string {
			return metadata.(*oidc.UpdateFederationMetadata).GetFederationId()
		},
		MetadataType: (*oidc.UpdateFederationMetadata)(nil),
		ResponseType: (*oidc.Federation)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &FederationUpdateOperation{*op}, nil
}

// FederationDeleteOperation is used to monitor the state of Delete operations.
type FederationDeleteOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *FederationDeleteOperation) Metadata() *oidc.DeleteFederationMetadata {
	return o.Operation.Metadata().(*oidc.DeleteFederationMetadata)
}

// Response retrieves the operation response.
func (o *FederationDeleteOperation) Response() *emptypb.Empty {
	return o.Operation.Response().(*emptypb.Empty)
}

// Wait polls the operation until it's done.
func (o *FederationDeleteOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *FederationDeleteOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// Delete is an operation of Yandex.Cloud Oidc Federation service.
// It returns an object which should be used to monitor the operation state.
func (c federationClient) Delete(ctx context.Context, in *oidc.DeleteFederationRequest, opts ...grpc.CallOption) (*FederationDeleteOperation, error) {
	connection, err := c.connector.GetConnection(ctx, FederationDelete, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := oidc.NewFederationServiceClient(connection).Delete(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll: c.pollOperation,
		GetResourceID: func(metadata proto.Message) string {
			return metadata.(*oidc.DeleteFederationMetadata).GetFederationId()
		},
		MetadataType: (*oidc.DeleteFederationMetadata)(nil),
		ResponseType: (*emptypb.Empty)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &FederationDeleteOperation{*op}, nil
}

// ListAccessBindings is an operation of Yandex.Cloud Oidc Federation service.
func (c federationClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	connection, err := c.connector.GetConnection(ctx, FederationListAccessBindings, opts...)
	if err != nil {
		return nil, err
	}
	return oidc.NewFederationServiceClient(connection).ListAccessBindings(ctx, in, opts...)
}

// FederationSetAccessBindingsOperation is used to monitor the state of SetAccessBindings operations.
type FederationSetAccessBindingsOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *FederationSetAccessBindingsOperation) Metadata() *access.SetAccessBindingsMetadata {
	return o.Operation.Metadata().(*access.SetAccessBindingsMetadata)
}

// Response retrieves the operation response.
func (o *FederationSetAccessBindingsOperation) Response() *access.AccessBindingsOperationResult {
	return o.Operation.Response().(*access.AccessBindingsOperationResult)
}

// Wait polls the operation until it's done.
func (o *FederationSetAccessBindingsOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*access.AccessBindingsOperationResult, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*access.AccessBindingsOperationResult)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *FederationSetAccessBindingsOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*access.AccessBindingsOperationResult, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*access.AccessBindingsOperationResult)
	return response, err
}

// SetAccessBindings is an operation of Yandex.Cloud Oidc Federation service.
// It returns an object which should be used to monitor the operation state.
func (c federationClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*FederationSetAccessBindingsOperation, error) {
	connection, err := c.connector.GetConnection(ctx, FederationSetAccessBindings, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := oidc.NewFederationServiceClient(connection).SetAccessBindings(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll:         c.pollOperation,
		MetadataType: (*access.SetAccessBindingsMetadata)(nil),
		ResponseType: (*access.AccessBindingsOperationResult)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &FederationSetAccessBindingsOperation{*op}, nil
}

// FederationUpdateAccessBindingsOperation is used to monitor the state of UpdateAccessBindings operations.
type FederationUpdateAccessBindingsOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *FederationUpdateAccessBindingsOperation) Metadata() *access.UpdateAccessBindingsMetadata {
	return o.Operation.Metadata().(*access.UpdateAccessBindingsMetadata)
}

// Response retrieves the operation response.
func (o *FederationUpdateAccessBindingsOperation) Response() *access.AccessBindingsOperationResult {
	return o.Operation.Response().(*access.AccessBindingsOperationResult)
}

// Wait polls the operation until it's done.
func (o *FederationUpdateAccessBindingsOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*access.AccessBindingsOperationResult, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*access.AccessBindingsOperationResult)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *FederationUpdateAccessBindingsOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*access.AccessBindingsOperationResult, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*access.AccessBindingsOperationResult)
	return response, err
}

// UpdateAccessBindings is an operation of Yandex.Cloud Oidc Federation service.
// It returns an object which should be used to monitor the operation state.
func (c federationClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*FederationUpdateAccessBindingsOperation, error) {
	connection, err := c.connector.GetConnection(ctx, FederationUpdateAccessBindings, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := oidc.NewFederationServiceClient(connection).UpdateAccessBindings(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll:         c.pollOperation,
		MetadataType: (*access.UpdateAccessBindingsMetadata)(nil),
		ResponseType: (*access.AccessBindingsOperationResult)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &FederationUpdateAccessBindingsOperation{*op}, nil
}

// pollOperation returns the current state of the polled operation.
func (c federationClient) pollOperation(ctx context.Context, operationId string, opts ...grpc.CallOption) (sdkop.YCOperation, error) {
	connection, err := c.connector.GetConnection(ctx, FederationOperationPoller, opts...)
	if err != nil {
		return nil, err
	}
	return operation.NewOperationServiceClient(connection).Get(ctx, &operation.GetOperationRequest{OperationId: operationId}, opts...)
}

var (
	FederationGet                  = protoreflect.FullName("yandex.cloud.iam.v1.workload.oidc.FederationService.Get")
	FederationList                 = protoreflect.FullName("yandex.cloud.iam.v1.workload.oidc.FederationService.List")
	FederationCreate               = protoreflect.FullName("yandex.cloud.iam.v1.workload.oidc.FederationService.Create")
	FederationUpdate               = protoreflect.FullName("yandex.cloud.iam.v1.workload.oidc.FederationService.Update")
	FederationDelete               = protoreflect.FullName("yandex.cloud.iam.v1.workload.oidc.FederationService.Delete")
	FederationListAccessBindings   = protoreflect.FullName("yandex.cloud.iam.v1.workload.oidc.FederationService.ListAccessBindings")
	FederationSetAccessBindings    = protoreflect.FullName("yandex.cloud.iam.v1.workload.oidc.FederationService.SetAccessBindings")
	FederationUpdateAccessBindings = protoreflect.FullName("yandex.cloud.iam.v1.workload.oidc.FederationService.UpdateAccessBindings")
	FederationOperationPoller      = protoreflect.FullName("yandex.cloud.operation.OperationService.Get")
)
