/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.importers;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractTagPaster;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.TextTagParser;

public final class TextTagPaster
extends AbstractTagPaster {
    private static final String HELP = HelpUtil.ht("/Action/PasteTags");

    public TextTagPaster() {
        super(DataFlavor.stringFlavor);
    }

    @Override
    public boolean supports(TransferHandler.TransferSupport support) {
        try {
            return super.supports(support) && this.containsValidTags(support);
        }
        catch (UnsupportedFlavorException | IOException e) {
            Logging.warn(e);
            return false;
        }
    }

    private boolean containsValidTags(TransferHandler.TransferSupport support) throws UnsupportedFlavorException, IOException {
        return !this.getTagsImpl(support).isEmpty();
    }

    @Override
    protected Map<String, String> getTags(TransferHandler.TransferSupport support) throws UnsupportedFlavorException, IOException {
        Map<String, String> tags = this.getTagsImpl(support);
        if (tags.isEmpty()) {
            TextTagPaster.showBadBufferMessage(HELP);
            throw new IOException("Invalid tags to paste.");
        }
        if (!TextTagParser.validateTags(tags, TextTagPaster::warning)) {
            throw new IOException("Tags to paste are not valid.");
        }
        return tags;
    }

    private Map<String, String> getTagsImpl(TransferHandler.TransferSupport support) throws UnsupportedFlavorException, IOException {
        return TextTagParser.readTagsFromText((String)support.getTransferable().getTransferData(this.df));
    }

    public static int warning(String text, String data, String code) {
        ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Do you want to paste these tags?", new Object[0]), I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Clear buffer", new Object[0]), I18n.tr("Ignore warnings", new Object[0]));
        ed.setButtonIcons("ok", "cancel", "dialogs/delete", "pastetags");
        ed.setContent("<html><b>" + text + "</b><br/><br/><div width=\"300px\">" + XmlWriter.encode(data, true) + "</html>");
        ed.setDefaultButton(2);
        ed.setCancelButton(2);
        ed.setIcon(2);
        ed.toggleEnable(code);
        ed.showDialog();
        int r = ed.getValue();
        if (r == 0) {
            r = 2;
        }
        if (r == 3) {
            ClipboardUtils.copyString("");
        }
        return r;
    }

    public static void showBadBufferMessage(String helpTopic) {
        String msg = I18n.tr("<html><p> Sorry, it is impossible to paste tags from buffer. It does not contain any JOSM object or suitable text. </p></html>", new Object[0]);
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(msg), GBC.eop());
        String helpUrl = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(helpTopic, LanguageInfo.LocaleType.DEFAULT));
        if (helpUrl != null) {
            p.add((Component)new UrlLabel(helpUrl), GBC.eop());
        }
        ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Warning", new Object[0]), I18n.tr("Ok", new Object[0]), I18n.tr("Clear buffer", new Object[0])).setButtonIcons("ok", "dialogs/delete").setContent(p).setDefaultButton(1).setCancelButton(1).setIcon(2).toggleEnable("tags.paste.cleanbadbuffer");
        ed.showDialog();
        if (ed.getValue() == 2) {
            ClipboardUtils.copyString("");
        }
    }
}

