#!/bin/sh -e

. /etc/os-release

# workaround for really bare-bones Archlinux containers:
if [ -x "$(command -v pacman)" ]; then
    pacman --noconfirm -Sy
    pacman --noconfirm -S grep gawk sed
fi

if [ ${ID} == "fedora" -a ${VERSION_ID} -gt 41 ]; then
    dnf install -y gawk
fi

os_release_file=
if [ -s "/etc/os-release" ]; then
  os_release_file="/etc/os-release"
elif [ -s "/usr/lib/os-release" ]; then
  os_release_file="/usr/lib/os-release"
else
  echo >&2 "Cannot find an os-release file ..."
  return 1
fi
export distro_id=$(grep '^ID=' $os_release_file|awk -F = '{print $2}'|sed 's/\"//g')
export version_id=$(grep '^VERSION_ID=' $os_release_file|awk -F = '{print $2}'|sed 's/\"//g')
export platform_id=$(grep '^PLATFORM_ID=' /etc/os-release|awk -F = '{print $2}'|sed 's/\"//g'| cut -d":" -f2)
# Fedora dropped PLATFORM_ID: https://fedoraproject.org/wiki/Changes/Drop_PLATFORM_ID?#Drop_PLATFORM_ID
if [ -z $platform_id ]; then export platform_id=$(echo ${distro_id:0:1}${version_id}); fi
