// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package plogotlp

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
)

func TestExportResponse_MoveTo(t *testing.T) {
	ms := generateTestExportResponse()
	dest := NewExportResponse()
	ms.MoveTo(dest)
	assert.Equal(t, NewExportResponse(), ms)
	assert.Equal(t, generateTestExportResponse(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestExportResponse(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newExportResponse(internal.NewOrigExportLogsServiceResponse(), sharedState)) })
	assert.Panics(t, func() { newExportResponse(internal.NewOrigExportLogsServiceResponse(), sharedState).MoveTo(dest) })
}

func TestExportResponse_CopyTo(t *testing.T) {
	ms := NewExportResponse()
	orig := NewExportResponse()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestExportResponse()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newExportResponse(internal.NewOrigExportLogsServiceResponse(), sharedState)) })
}

func TestExportResponse_PartialSuccess(t *testing.T) {
	ms := NewExportResponse()
	assert.Equal(t, NewExportPartialSuccess(), ms.PartialSuccess())
	ms.orig.PartialSuccess = *internal.GenTestOrigExportLogsPartialSuccess()
	assert.Equal(t, generateTestExportPartialSuccess(), ms.PartialSuccess())
}

func generateTestExportResponse() ExportResponse {
	ms := newExportResponse(internal.GenTestOrigExportLogsServiceResponse(), internal.NewState())
	return ms
}
