/*
 * Copyright (C) 2011-2024 by the Widelands Development Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses/>.
 *
 */

#ifndef WL_WUI_CHAT_OVERLAY_H
#define WL_WUI_CHAT_OVERLAY_H

#include <memory>

#include "chat/chat.h"
#include "ui_basic/panel.h"

/**
 * The overlay that displays all new chat messages for some timeout on the main window.
 *
 * \see GameChatPanel, GameChatMenu
 */
struct ChatOverlay : public UI::Panel {
	ChatOverlay(
	   UI::Panel* parent, ChatColorForPlayer fn, int32_t x, int32_t y, int32_t w, int32_t h);
	~ChatOverlay() override = default;

	void set_chat_provider(ChatProvider&);
	void draw(RenderTarget&) override;
	void think() override;

	// Check if position and size is still correct.
	void recompute();

private:
	struct Impl;
	std::unique_ptr<Impl> m;
};

#endif  // end of include guard: WL_WUI_CHAT_OVERLAY_H
