// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::put_lexicon::_put_lexicon_output::PutLexiconOutputBuilder;

pub use crate::operation::put_lexicon::_put_lexicon_input::PutLexiconInputBuilder;

impl crate::operation::put_lexicon::builders::PutLexiconInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::put_lexicon::PutLexiconOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_lexicon::PutLexiconError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.put_lexicon();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `PutLexicon`.
///
/// <p>Stores a pronunciation lexicon in an Amazon Web Services Region. If a lexicon with the same name already exists in the region, it is overwritten by the new lexicon. Lexicon operations have eventual consistency, therefore, it might take some time before the lexicon is available to the SynthesizeSpeech operation.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing Lexicons</a>.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct PutLexiconFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::put_lexicon::builders::PutLexiconInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::put_lexicon::PutLexiconOutput,
        crate::operation::put_lexicon::PutLexiconError,
    > for PutLexiconFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::put_lexicon::PutLexiconOutput,
            crate::operation::put_lexicon::PutLexiconError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl PutLexiconFluentBuilder {
    /// Creates a new `PutLexiconFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the PutLexicon as a reference.
    pub fn as_input(&self) -> &crate::operation::put_lexicon::builders::PutLexiconInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::put_lexicon::PutLexiconOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_lexicon::PutLexiconError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::put_lexicon::PutLexicon::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::put_lexicon::PutLexicon::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::put_lexicon::PutLexiconOutput,
        crate::operation::put_lexicon::PutLexiconError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>Name of the lexicon. The name must follow the regular express format \[0-9A-Za-z\]{1,20}. That is, the name is a case-sensitive alphanumeric string up to 20 characters long.</p>
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.name(input.into());
        self
    }
    /// <p>Name of the lexicon. The name must follow the regular express format \[0-9A-Za-z\]{1,20}. That is, the name is a case-sensitive alphanumeric string up to 20 characters long.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_name(input);
        self
    }
    /// <p>Name of the lexicon. The name must follow the regular express format \[0-9A-Za-z\]{1,20}. That is, the name is a case-sensitive alphanumeric string up to 20 characters long.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_name()
    }
    /// <p>Content of the PLS lexicon as string data.</p>
    pub fn content(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.content(input.into());
        self
    }
    /// <p>Content of the PLS lexicon as string data.</p>
    pub fn set_content(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_content(input);
        self
    }
    /// <p>Content of the PLS lexicon as string data.</p>
    pub fn get_content(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_content()
    }
}
