// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatch

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatch/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpDeleteAlarms struct {
}

func (*validateOpDeleteAlarms) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAlarms) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAlarmsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAlarmsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAnomalyDetector struct {
}

func (*validateOpDeleteAnomalyDetector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAnomalyDetector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAnomalyDetectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAnomalyDetectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDashboards struct {
}

func (*validateOpDeleteDashboards) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDashboards) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDashboardsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDashboardsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteInsightRules struct {
}

func (*validateOpDeleteInsightRules) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteInsightRules) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteInsightRulesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteInsightRulesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteMetricStream struct {
}

func (*validateOpDeleteMetricStream) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteMetricStream) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteMetricStreamInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteMetricStreamInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeAlarmContributors struct {
}

func (*validateOpDescribeAlarmContributors) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeAlarmContributors) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeAlarmContributorsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeAlarmContributorsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeAlarmsForMetric struct {
}

func (*validateOpDescribeAlarmsForMetric) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeAlarmsForMetric) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeAlarmsForMetricInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeAlarmsForMetricInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeAnomalyDetectors struct {
}

func (*validateOpDescribeAnomalyDetectors) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeAnomalyDetectors) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeAnomalyDetectorsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeAnomalyDetectorsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisableAlarmActions struct {
}

func (*validateOpDisableAlarmActions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisableAlarmActions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisableAlarmActionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisableAlarmActionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisableInsightRules struct {
}

func (*validateOpDisableInsightRules) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisableInsightRules) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisableInsightRulesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisableInsightRulesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEnableAlarmActions struct {
}

func (*validateOpEnableAlarmActions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEnableAlarmActions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EnableAlarmActionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEnableAlarmActionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEnableInsightRules struct {
}

func (*validateOpEnableInsightRules) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEnableInsightRules) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EnableInsightRulesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEnableInsightRulesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDashboard struct {
}

func (*validateOpGetDashboard) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDashboard) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDashboardInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDashboardInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetInsightRuleReport struct {
}

func (*validateOpGetInsightRuleReport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetInsightRuleReport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetInsightRuleReportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetInsightRuleReportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetMetricData struct {
}

func (*validateOpGetMetricData) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetMetricData) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetMetricDataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetMetricDataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetMetricStatistics struct {
}

func (*validateOpGetMetricStatistics) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetMetricStatistics) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetMetricStatisticsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetMetricStatisticsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetMetricStream struct {
}

func (*validateOpGetMetricStream) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetMetricStream) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetMetricStreamInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetMetricStreamInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetMetricWidgetImage struct {
}

func (*validateOpGetMetricWidgetImage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetMetricWidgetImage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetMetricWidgetImageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetMetricWidgetImageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListManagedInsightRules struct {
}

func (*validateOpListManagedInsightRules) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListManagedInsightRules) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListManagedInsightRulesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListManagedInsightRulesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListMetrics struct {
}

func (*validateOpListMetrics) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListMetrics) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListMetricsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListMetricsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutAnomalyDetector struct {
}

func (*validateOpPutAnomalyDetector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutAnomalyDetector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutAnomalyDetectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutAnomalyDetectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutCompositeAlarm struct {
}

func (*validateOpPutCompositeAlarm) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutCompositeAlarm) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutCompositeAlarmInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutCompositeAlarmInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutDashboard struct {
}

func (*validateOpPutDashboard) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutDashboard) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutDashboardInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutDashboardInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutInsightRule struct {
}

func (*validateOpPutInsightRule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutInsightRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutInsightRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutInsightRuleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutManagedInsightRules struct {
}

func (*validateOpPutManagedInsightRules) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutManagedInsightRules) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutManagedInsightRulesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutManagedInsightRulesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutMetricAlarm struct {
}

func (*validateOpPutMetricAlarm) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutMetricAlarm) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutMetricAlarmInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutMetricAlarmInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutMetricData struct {
}

func (*validateOpPutMetricData) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutMetricData) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutMetricDataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutMetricDataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutMetricStream struct {
}

func (*validateOpPutMetricStream) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutMetricStream) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutMetricStreamInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutMetricStreamInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSetAlarmState struct {
}

func (*validateOpSetAlarmState) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSetAlarmState) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SetAlarmStateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSetAlarmStateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartMetricStreams struct {
}

func (*validateOpStartMetricStreams) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartMetricStreams) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartMetricStreamsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartMetricStreamsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStopMetricStreams struct {
}

func (*validateOpStopMetricStreams) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStopMetricStreams) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StopMetricStreamsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStopMetricStreamsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpDeleteAlarmsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAlarms{}, middleware.After)
}

func addOpDeleteAnomalyDetectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAnomalyDetector{}, middleware.After)
}

func addOpDeleteDashboardsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDashboards{}, middleware.After)
}

func addOpDeleteInsightRulesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteInsightRules{}, middleware.After)
}

func addOpDeleteMetricStreamValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteMetricStream{}, middleware.After)
}

func addOpDescribeAlarmContributorsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeAlarmContributors{}, middleware.After)
}

func addOpDescribeAlarmsForMetricValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeAlarmsForMetric{}, middleware.After)
}

func addOpDescribeAnomalyDetectorsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeAnomalyDetectors{}, middleware.After)
}

func addOpDisableAlarmActionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisableAlarmActions{}, middleware.After)
}

func addOpDisableInsightRulesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisableInsightRules{}, middleware.After)
}

func addOpEnableAlarmActionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEnableAlarmActions{}, middleware.After)
}

func addOpEnableInsightRulesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEnableInsightRules{}, middleware.After)
}

func addOpGetDashboardValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDashboard{}, middleware.After)
}

func addOpGetInsightRuleReportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetInsightRuleReport{}, middleware.After)
}

func addOpGetMetricDataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetMetricData{}, middleware.After)
}

func addOpGetMetricStatisticsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetMetricStatistics{}, middleware.After)
}

func addOpGetMetricStreamValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetMetricStream{}, middleware.After)
}

func addOpGetMetricWidgetImageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetMetricWidgetImage{}, middleware.After)
}

func addOpListManagedInsightRulesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListManagedInsightRules{}, middleware.After)
}

func addOpListMetricsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListMetrics{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpPutAnomalyDetectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutAnomalyDetector{}, middleware.After)
}

func addOpPutCompositeAlarmValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutCompositeAlarm{}, middleware.After)
}

func addOpPutDashboardValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutDashboard{}, middleware.After)
}

func addOpPutInsightRuleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutInsightRule{}, middleware.After)
}

func addOpPutManagedInsightRulesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutManagedInsightRules{}, middleware.After)
}

func addOpPutMetricAlarmValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutMetricAlarm{}, middleware.After)
}

func addOpPutMetricDataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutMetricData{}, middleware.After)
}

func addOpPutMetricStreamValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutMetricStream{}, middleware.After)
}

func addOpSetAlarmStateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSetAlarmState{}, middleware.After)
}

func addOpStartMetricStreamsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartMetricStreams{}, middleware.After)
}

func addOpStopMetricStreamsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStopMetricStreams{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func validateAnomalyDetectorConfiguration(v *types.AnomalyDetectorConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AnomalyDetectorConfiguration"}
	if v.ExcludedTimeRanges != nil {
		if err := validateAnomalyDetectorExcludedTimeRanges(v.ExcludedTimeRanges); err != nil {
			invalidParams.AddNested("ExcludedTimeRanges", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAnomalyDetectorExcludedTimeRanges(v []types.Range) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AnomalyDetectorExcludedTimeRanges"}
	for i := range v {
		if err := validateRange(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDimension(v *types.Dimension) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Dimension"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDimensionFilter(v *types.DimensionFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DimensionFilter"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDimensionFilters(v []types.DimensionFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DimensionFilters"}
	for i := range v {
		if err := validateDimensionFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDimensions(v []types.Dimension) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Dimensions"}
	for i := range v {
		if err := validateDimension(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEntityMetricData(v *types.EntityMetricData) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EntityMetricData"}
	if v.MetricData != nil {
		if err := validateMetricData(v.MetricData); err != nil {
			invalidParams.AddNested("MetricData", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEntityMetricDataList(v []types.EntityMetricData) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EntityMetricDataList"}
	for i := range v {
		if err := validateEntityMetricData(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateManagedRule(v *types.ManagedRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ManagedRule"}
	if v.TemplateName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TemplateName"))
	}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateManagedRules(v []types.ManagedRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ManagedRules"}
	for i := range v {
		if err := validateManagedRule(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetric(v *types.Metric) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Metric"}
	if v.Dimensions != nil {
		if err := validateDimensions(v.Dimensions); err != nil {
			invalidParams.AddNested("Dimensions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricData(v []types.MetricDatum) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricData"}
	for i := range v {
		if err := validateMetricDatum(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricDataQueries(v []types.MetricDataQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricDataQueries"}
	for i := range v {
		if err := validateMetricDataQuery(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricDataQuery(v *types.MetricDataQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricDataQuery"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.MetricStat != nil {
		if err := validateMetricStat(v.MetricStat); err != nil {
			invalidParams.AddNested("MetricStat", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricDatum(v *types.MetricDatum) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricDatum"}
	if v.MetricName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricName"))
	}
	if v.Dimensions != nil {
		if err := validateDimensions(v.Dimensions); err != nil {
			invalidParams.AddNested("Dimensions", err.(smithy.InvalidParamsError))
		}
	}
	if v.StatisticValues != nil {
		if err := validateStatisticSet(v.StatisticValues); err != nil {
			invalidParams.AddNested("StatisticValues", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricMathAnomalyDetector(v *types.MetricMathAnomalyDetector) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricMathAnomalyDetector"}
	if v.MetricDataQueries != nil {
		if err := validateMetricDataQueries(v.MetricDataQueries); err != nil {
			invalidParams.AddNested("MetricDataQueries", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricStat(v *types.MetricStat) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricStat"}
	if v.Metric == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Metric"))
	} else if v.Metric != nil {
		if err := validateMetric(v.Metric); err != nil {
			invalidParams.AddNested("Metric", err.(smithy.InvalidParamsError))
		}
	}
	if v.Period == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Period"))
	}
	if v.Stat == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Stat"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricStreamStatisticsConfiguration(v *types.MetricStreamStatisticsConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricStreamStatisticsConfiguration"}
	if v.IncludeMetrics == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IncludeMetrics"))
	} else if v.IncludeMetrics != nil {
		if err := validateMetricStreamStatisticsIncludeMetrics(v.IncludeMetrics); err != nil {
			invalidParams.AddNested("IncludeMetrics", err.(smithy.InvalidParamsError))
		}
	}
	if v.AdditionalStatistics == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AdditionalStatistics"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricStreamStatisticsConfigurations(v []types.MetricStreamStatisticsConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricStreamStatisticsConfigurations"}
	for i := range v {
		if err := validateMetricStreamStatisticsConfiguration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricStreamStatisticsIncludeMetrics(v []types.MetricStreamStatisticsMetric) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricStreamStatisticsIncludeMetrics"}
	for i := range v {
		if err := validateMetricStreamStatisticsMetric(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricStreamStatisticsMetric(v *types.MetricStreamStatisticsMetric) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricStreamStatisticsMetric"}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.MetricName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRange(v *types.Range) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Range"}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	}
	if v.EndTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndTime"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSingleMetricAnomalyDetector(v *types.SingleMetricAnomalyDetector) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SingleMetricAnomalyDetector"}
	if v.Dimensions != nil {
		if err := validateDimensions(v.Dimensions); err != nil {
			invalidParams.AddNested("Dimensions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStatisticSet(v *types.StatisticSet) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StatisticSet"}
	if v.SampleCount == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SampleCount"))
	}
	if v.Sum == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Sum"))
	}
	if v.Minimum == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Minimum"))
	}
	if v.Maximum == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Maximum"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagList(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagList"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAlarmsInput(v *DeleteAlarmsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAlarmsInput"}
	if v.AlarmNames == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmNames"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAnomalyDetectorInput(v *DeleteAnomalyDetectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAnomalyDetectorInput"}
	if v.Dimensions != nil {
		if err := validateDimensions(v.Dimensions); err != nil {
			invalidParams.AddNested("Dimensions", err.(smithy.InvalidParamsError))
		}
	}
	if v.SingleMetricAnomalyDetector != nil {
		if err := validateSingleMetricAnomalyDetector(v.SingleMetricAnomalyDetector); err != nil {
			invalidParams.AddNested("SingleMetricAnomalyDetector", err.(smithy.InvalidParamsError))
		}
	}
	if v.MetricMathAnomalyDetector != nil {
		if err := validateMetricMathAnomalyDetector(v.MetricMathAnomalyDetector); err != nil {
			invalidParams.AddNested("MetricMathAnomalyDetector", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDashboardsInput(v *DeleteDashboardsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDashboardsInput"}
	if v.DashboardNames == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DashboardNames"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteInsightRulesInput(v *DeleteInsightRulesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteInsightRulesInput"}
	if v.RuleNames == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleNames"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteMetricStreamInput(v *DeleteMetricStreamInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteMetricStreamInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeAlarmContributorsInput(v *DescribeAlarmContributorsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeAlarmContributorsInput"}
	if v.AlarmName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeAlarmsForMetricInput(v *DescribeAlarmsForMetricInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeAlarmsForMetricInput"}
	if v.MetricName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricName"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Dimensions != nil {
		if err := validateDimensions(v.Dimensions); err != nil {
			invalidParams.AddNested("Dimensions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeAnomalyDetectorsInput(v *DescribeAnomalyDetectorsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeAnomalyDetectorsInput"}
	if v.Dimensions != nil {
		if err := validateDimensions(v.Dimensions); err != nil {
			invalidParams.AddNested("Dimensions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisableAlarmActionsInput(v *DisableAlarmActionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisableAlarmActionsInput"}
	if v.AlarmNames == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmNames"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisableInsightRulesInput(v *DisableInsightRulesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisableInsightRulesInput"}
	if v.RuleNames == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleNames"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEnableAlarmActionsInput(v *EnableAlarmActionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EnableAlarmActionsInput"}
	if v.AlarmNames == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmNames"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEnableInsightRulesInput(v *EnableInsightRulesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EnableInsightRulesInput"}
	if v.RuleNames == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleNames"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDashboardInput(v *GetDashboardInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDashboardInput"}
	if v.DashboardName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DashboardName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetInsightRuleReportInput(v *GetInsightRuleReportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetInsightRuleReportInput"}
	if v.RuleName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleName"))
	}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	}
	if v.EndTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndTime"))
	}
	if v.Period == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Period"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetMetricDataInput(v *GetMetricDataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetMetricDataInput"}
	if v.MetricDataQueries == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricDataQueries"))
	} else if v.MetricDataQueries != nil {
		if err := validateMetricDataQueries(v.MetricDataQueries); err != nil {
			invalidParams.AddNested("MetricDataQueries", err.(smithy.InvalidParamsError))
		}
	}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	}
	if v.EndTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndTime"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetMetricStatisticsInput(v *GetMetricStatisticsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetMetricStatisticsInput"}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.MetricName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricName"))
	}
	if v.Dimensions != nil {
		if err := validateDimensions(v.Dimensions); err != nil {
			invalidParams.AddNested("Dimensions", err.(smithy.InvalidParamsError))
		}
	}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	}
	if v.EndTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndTime"))
	}
	if v.Period == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Period"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetMetricStreamInput(v *GetMetricStreamInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetMetricStreamInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetMetricWidgetImageInput(v *GetMetricWidgetImageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetMetricWidgetImageInput"}
	if v.MetricWidget == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricWidget"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListManagedInsightRulesInput(v *ListManagedInsightRulesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListManagedInsightRulesInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListMetricsInput(v *ListMetricsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListMetricsInput"}
	if v.Dimensions != nil {
		if err := validateDimensionFilters(v.Dimensions); err != nil {
			invalidParams.AddNested("Dimensions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutAnomalyDetectorInput(v *PutAnomalyDetectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutAnomalyDetectorInput"}
	if v.Dimensions != nil {
		if err := validateDimensions(v.Dimensions); err != nil {
			invalidParams.AddNested("Dimensions", err.(smithy.InvalidParamsError))
		}
	}
	if v.Configuration != nil {
		if err := validateAnomalyDetectorConfiguration(v.Configuration); err != nil {
			invalidParams.AddNested("Configuration", err.(smithy.InvalidParamsError))
		}
	}
	if v.SingleMetricAnomalyDetector != nil {
		if err := validateSingleMetricAnomalyDetector(v.SingleMetricAnomalyDetector); err != nil {
			invalidParams.AddNested("SingleMetricAnomalyDetector", err.(smithy.InvalidParamsError))
		}
	}
	if v.MetricMathAnomalyDetector != nil {
		if err := validateMetricMathAnomalyDetector(v.MetricMathAnomalyDetector); err != nil {
			invalidParams.AddNested("MetricMathAnomalyDetector", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutCompositeAlarmInput(v *PutCompositeAlarmInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutCompositeAlarmInput"}
	if v.AlarmName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmName"))
	}
	if v.AlarmRule == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmRule"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutDashboardInput(v *PutDashboardInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutDashboardInput"}
	if v.DashboardName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DashboardName"))
	}
	if v.DashboardBody == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DashboardBody"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutInsightRuleInput(v *PutInsightRuleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutInsightRuleInput"}
	if v.RuleName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleName"))
	}
	if v.RuleDefinition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleDefinition"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutManagedInsightRulesInput(v *PutManagedInsightRulesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutManagedInsightRulesInput"}
	if v.ManagedRules == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ManagedRules"))
	} else if v.ManagedRules != nil {
		if err := validateManagedRules(v.ManagedRules); err != nil {
			invalidParams.AddNested("ManagedRules", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutMetricAlarmInput(v *PutMetricAlarmInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutMetricAlarmInput"}
	if v.AlarmName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmName"))
	}
	if v.Dimensions != nil {
		if err := validateDimensions(v.Dimensions); err != nil {
			invalidParams.AddNested("Dimensions", err.(smithy.InvalidParamsError))
		}
	}
	if v.EvaluationPeriods == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EvaluationPeriods"))
	}
	if len(v.ComparisonOperator) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ComparisonOperator"))
	}
	if v.Metrics != nil {
		if err := validateMetricDataQueries(v.Metrics); err != nil {
			invalidParams.AddNested("Metrics", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutMetricDataInput(v *PutMetricDataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutMetricDataInput"}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.MetricData != nil {
		if err := validateMetricData(v.MetricData); err != nil {
			invalidParams.AddNested("MetricData", err.(smithy.InvalidParamsError))
		}
	}
	if v.EntityMetricData != nil {
		if err := validateEntityMetricDataList(v.EntityMetricData); err != nil {
			invalidParams.AddNested("EntityMetricData", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutMetricStreamInput(v *PutMetricStreamInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutMetricStreamInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.FirehoseArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FirehoseArn"))
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if len(v.OutputFormat) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("OutputFormat"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if v.StatisticsConfigurations != nil {
		if err := validateMetricStreamStatisticsConfigurations(v.StatisticsConfigurations); err != nil {
			invalidParams.AddNested("StatisticsConfigurations", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSetAlarmStateInput(v *SetAlarmStateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SetAlarmStateInput"}
	if v.AlarmName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmName"))
	}
	if len(v.StateValue) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("StateValue"))
	}
	if v.StateReason == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StateReason"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartMetricStreamsInput(v *StartMetricStreamsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartMetricStreamsInput"}
	if v.Names == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Names"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStopMetricStreamsInput(v *StopMetricStreamsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StopMetricStreamsInput"}
	if v.Names == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Names"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
