/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */

import { RestSerializer } from 'miragejs';

const underscore = (str) =>
  str.replace(/([a-z])([A-Z])/g, '$1_$2').toLowerCase();

export default {
  application: RestSerializer.extend({
    keyForAttribute(attr) {
      return underscore(attr);
    },
    keyForModel() {
      return 'data';
    },
  }),
};
