
import Component from '@glimmer/component';
import { eq } from '../../../utils/helpers.js';
import DynamicMultiSelect from './searchable-multi-select.js';
import { HdsFormCheckboxField, HdsFormCheckboxGroup, HdsFormTextInputField, HdsFormRadioGroup } from '@hashicorp/design-system-components/components';
import { precompileTemplate } from '@ember/template-compilation';
import { setComponentTemplate } from '@ember/component';

class FilterControl extends Component {
  isCheckboxChecked = (name, value) => {
    const appliedFilter = this.args.appliedFilters[name];
    const rawValue = appliedFilter?.value?.value;
    if (!rawValue) {
      return false;
    }
    if (Array.isArray(rawValue)) {
      return rawValue.includes(value);
    }
    if (typeof rawValue === 'string') {
      return rawValue === value;
    }
    return false;
  };
  isLookbackChecked = (name, value) => {
    const appliedFilter = this.args.appliedFilters[name];
    if (!appliedFilter) {
      return false;
    } else {
      return appliedFilter.value.value === value;
    }
  };
  getValue = name => {
    return this.args.appliedFilters?.[name]?.value?.value ?? '';
  };
  getOperator = name => {
    return this.args.appliedFilters?.[name]?.operator ?? '';
  };
  static {
    setComponentTemplate(precompileTemplate("\n    <div class=\"filter-control__wrapper\" data-test-vault-reporting-filter-bar-control={{@filter.name}}>\n      {{#if (eq @filter.type \"lookback\")}}\n        <HdsFormRadioGroup @name=\"format\" as |G|>\n          {{#if @filter.label}}\n            <G.Legend class=\"hds-typography-body-100-font-size\">\n              {{@filter.label}}\n            </G.Legend>\n          {{/if}}\n          {{#each @filter.options as |option|}}\n            <G.RadioField name={{@filter.name}} @value={{option.value}} checked={{this.isLookbackChecked @filter.name option.value}} as |F|><F.Label>{{option.name}}</F.Label></G.RadioField>\n          {{/each}}\n        </HdsFormRadioGroup>\n      {{else if (eq @filter.type \"text\")}}\n        <div class=\"filter-bar__filters__text-filter-wrapper\">\n          <HdsFormTextInputField @type=\"text\" name={{@filter.name}} @value={{this.getValue @filter.name}} as |F|>\n            <F.Label>\n              {{@filter.label}}\n            </F.Label>\n          </HdsFormTextInputField>\n        </div>\n      {{else if (eq @filter.type \"single-select\")}}\n        <HdsFormRadioGroup @name=\"format\" as |G|>\n          {{#if @filter.label}}\n            <G.Legend class=\"hds-typography-body-100-font-size\">\n              {{@filter.label}}\n            </G.Legend>\n          {{/if}}\n          {{#each @filter.options as |option|}}\n            <G.RadioField name={{@filter.name}} @value={{option.value}} checked={{eq (this.getValue @filter.name) option.value}} as |F|>\n              <F.Label>{{option.name}}</F.Label>\n            </G.RadioField>\n          {{/each}}\n        </HdsFormRadioGroup>\n      {{else if (eq @filter.type \"multi-select\")}}\n        <HdsFormCheckboxGroup as |G|>\n          {{#if @filter.label}}\n            <G.Legend>{{@filter.label}}</G.Legend>\n          {{/if}}\n          {{#each @filter.options as |option|}}\n            <G.CheckboxField name={{@filter.name}} @value={{option.value}} checked={{this.isCheckboxChecked @filter.name option.value}} as |F|><F.Label>{{option.name}}</F.Label></G.CheckboxField>\n          {{/each}}\n        </HdsFormCheckboxGroup>\n      {{else if (eq @filter.type \"searchable-multi-select\")}}\n        <SearchableMultiSelect @name={{@filter.name}} @appliedFilters={{@appliedFilters}} @onSearch={{@filter.onSearch}} @placeholder={{@filter.placeholder}} />\n      {{else if (eq @filter.type \"boolean\")}}\n        <HdsFormCheckboxField name={{@filter.name}} checked={{this.getValue @filter.name}} as |F|>\n          <F.Label>{{@filter.label}}</F.Label>\n        </HdsFormCheckboxField>\n      {{/if}}\n    </div>\n  ", {
      strictMode: true,
      scope: () => ({
        eq,
        HdsFormRadioGroup,
        HdsFormTextInputField,
        HdsFormCheckboxGroup,
        SearchableMultiSelect: DynamicMultiSelect,
        HdsFormCheckboxField
      })
    }), this);
  }
}

export { FilterControl as default };
//# sourceMappingURL=filter-control.js.map
