
import { getOwner } from '@ember/owner';
import Service from '@ember/service';
import { VaultReportingServiceApi } from '../clients/cloud-vault-reporting/src/apis/VaultReportingServiceApi.js';
import { Configuration, BASE_PATH } from '../clients/cloud-vault-reporting/src/runtime.js';

/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */

class ReportingApiService extends Service {
  /**
   * Attempt to look up the API service from host application if it exists. Using service decorator would error so this allows falling back if it doesn't.
   */
  get api() {
    return getOwner(this)?.lookup('service:api');
  }

  /**
   * Attempt to look up the user context from host application if it exists. Using service decorator would error so this allows falling back if it doesn't.
   */
  get userContext() {
    return getOwner(this)?.lookup('service:user-context');
  }

  /**
   * Attempt to get the organizationId and projectId from user context in host application.
   * Fall back to default values if not available.
   */

  get organizationId() {
    return this.userContext?.organization?.id || '';
  }
  get projectId() {
    return this.userContext?.project?.id || '';
  }

  /**
   * Attempt to get the API configuration from host application. Fall back to default otherwise.
   */
  get config() {
    if (this.api) {
      return new Configuration(this.api.config(BASE_PATH));
    } else {
      return new Configuration({
        basePath: `${new URL(window.location.href).origin}/api`
      });
    }
  }
  reporting = new VaultReportingServiceApi(this.config);
}

export { ReportingApiService as default };
//# sourceMappingURL=reporting-api.js.map
