
import Component from '@glimmer/component';
import { HdsTextBody, HdsLinkStandalone, HdsTextDisplay } from '@hashicorp/design-system-components/components';
import { on } from '@ember/modifier';
import { or } from '../../../utils/helpers.js';
import { service } from '@ember/service';
import { safeRoute } from '../../../utils/safe-route.js';
import { precompileTemplate } from '@ember/template-compilation';
import { setComponentTemplate } from '@ember/component';
import { g, i } from 'decorator-transforms/runtime';

/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
class TitleRow extends Component {
  static {
    g(this.prototype, "reportingAnalytics", [service]);
  }
  #reportingAnalytics = (i(this, "reportingAnalytics"), void 0);
  static {
    g(this.prototype, "router", [service]);
  }
  #router = (i(this, "router"), void 0);
  get hasExternalLink() {
    return this.args.linkUrl;
  }
  get hasInternalLink() {
    return this.args.linkRoute;
  }
  get linkText() {
    return this.args.linkText || 'View all';
  }
  get linkUrl() {
    return this.args.linkUrl || '#';
  }
  get linkRoute() {
    return safeRoute(this.router, this.args.linkRoute);
  }
  get linkIcon() {
    return this.args.linkIcon || 'arrow-right';
  }
  get linkTarget() {
    return this.args.linkTarget || '_self';
  }
  handleLinkClick = () => {
    this.reportingAnalytics.trackEvent(`card_link`, {
      card: this.args.title,
      link: this.linkText,
      target: this.linkTarget
    });
  };
  static {
    setComponentTemplate(precompileTemplate("\n    <div class=\"ssu-title-row\" data-test-vault-reporting-dashboard-card-title-row>\n      <div class=\"ssu-title-row__container\">\n        <HdsTextDisplay data-test-vault-reporting-dashboard-card-title @size=\"300\">\n          {{@title}}\n        </HdsTextDisplay>\n\n        {{#if (or this.hasExternalLink this.hasInternalLink)}}\n          <HdsLinkStandalone data-test-vault-reporting-dashboard-card-title-link class=\"ssu-title-row__container__link\" @text={{this.linkText}} @href={{if this.hasExternalLink this.linkUrl}} @route={{if this.hasInternalLink this.linkRoute}} @icon={{this.linkIcon}} target={{this.linkTarget}} @iconPosition=\"trailing\" {{on \"click\" this.handleLinkClick}} />\n        {{/if}}\n      </div>\n\n      {{#if @description}}\n        <HdsTextBody class=\"ssu-title-row__description\" data-test-vault-reporting-dashboard-card-description>\n          {{@description}}\n        </HdsTextBody>\n      {{/if}}\n    </div>\n  ", {
      strictMode: true,
      scope: () => ({
        HdsTextDisplay,
        or,
        HdsLinkStandalone,
        on,
        HdsTextBody
      })
    }), this);
  }
}

export { TitleRow as default };
//# sourceMappingURL=title-row.js.map
