
import { BaseAPI, RequiredError, JSONApiResponse } from '../runtime.js';
import { VaultReporting20250505FetchDistinctEntityIdsResponseFromJSON } from '../models/VaultReporting20250505FetchDistinctEntityIdsResponse.js';
import { VaultReporting20250505FetchDistinctMountsResponseFromJSON } from '../models/VaultReporting20250505FetchDistinctMountsResponse.js';
import { VaultReporting20250505FetchDistinctNamespacesResponseFromJSON } from '../models/VaultReporting20250505FetchDistinctNamespacesResponse.js';
import { VaultReporting20250505FetchSecretsInventoryCountResponseFromJSON } from '../models/VaultReporting20250505FetchSecretsInventoryCountResponse.js';
import { VaultReporting20250505FetchSecretsInventoryResponseFromJSON } from '../models/VaultReporting20250505FetchSecretsInventoryResponse.js';

/* tslint:disable */
/* eslint-disable */
/**
 * HashiCorp Cloud Platform Vault Reporting
 * API for Vault Reporting
 *
 * The version of the OpenAPI document: 2025-05-05
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/**
 * 
 */
class VaultReportingServiceApi extends BaseAPI {
  /**
   */
  async fetchDistinctEntityIdsRaw(requestParameters, initOverrides) {
    if (requestParameters['organizationId'] == null) {
      throw new RequiredError('organizationId', 'Required parameter "organizationId" was null or undefined when calling fetchDistinctEntityIds().');
    }
    if (requestParameters['projectId'] == null) {
      throw new RequiredError('projectId', 'Required parameter "projectId" was null or undefined when calling fetchDistinctEntityIds().');
    }
    if (requestParameters['clusterId'] == null) {
      throw new RequiredError('clusterId', 'Required parameter "clusterId" was null or undefined when calling fetchDistinctEntityIds().');
    }
    const queryParameters = {};
    if (requestParameters['column'] != null) {
      queryParameters['column'] = requestParameters['column'];
    }
    if (requestParameters['paginationPageSize'] != null) {
      queryParameters['pagination.page_size'] = requestParameters['paginationPageSize'];
    }
    if (requestParameters['paginationNextPageToken'] != null) {
      queryParameters['pagination.next_page_token'] = requestParameters['paginationNextPageToken'];
    }
    if (requestParameters['paginationPreviousPageToken'] != null) {
      queryParameters['pagination.previous_page_token'] = requestParameters['paginationPreviousPageToken'];
    }
    const headerParameters = {};
    if (this.configuration && this.configuration.apiKey) {
      headerParameters["Authorization"] = await this.configuration.apiKey("Authorization"); // bearer authentication
    }
    const response = await this.request({
      path: `/vault-reporting/2025-05-05/organizations/{organization_id}/projects/{project_id}/clusters/{cluster_id}/reports/distinct-entity-ids`.replace(`{${"organization_id"}}`, encodeURIComponent(String(requestParameters['organizationId']))).replace(`{${"project_id"}}`, encodeURIComponent(String(requestParameters['projectId']))).replace(`{${"cluster_id"}}`, encodeURIComponent(String(requestParameters['clusterId']))),
      method: 'GET',
      headers: headerParameters,
      query: queryParameters
    }, initOverrides);
    return new JSONApiResponse(response, jsonValue => VaultReporting20250505FetchDistinctEntityIdsResponseFromJSON(jsonValue));
  }

  /**
   */
  async fetchDistinctEntityIds(requestParameters, initOverrides) {
    const response = await this.fetchDistinctEntityIdsRaw(requestParameters, initOverrides);
    return await response.value();
  }

  /**
   */
  async fetchDistinctMountsRaw(requestParameters, initOverrides) {
    if (requestParameters['organizationId'] == null) {
      throw new RequiredError('organizationId', 'Required parameter "organizationId" was null or undefined when calling fetchDistinctMounts().');
    }
    if (requestParameters['projectId'] == null) {
      throw new RequiredError('projectId', 'Required parameter "projectId" was null or undefined when calling fetchDistinctMounts().');
    }
    if (requestParameters['clusterId'] == null) {
      throw new RequiredError('clusterId', 'Required parameter "clusterId" was null or undefined when calling fetchDistinctMounts().');
    }
    const queryParameters = {};
    if (requestParameters['namespace'] != null) {
      queryParameters['namespace'] = requestParameters['namespace'];
    }
    if (requestParameters['mountPathPrefix'] != null) {
      queryParameters['mount_path_prefix'] = requestParameters['mountPathPrefix'];
    }
    if (requestParameters['paginationPageSize'] != null) {
      queryParameters['pagination.page_size'] = requestParameters['paginationPageSize'];
    }
    if (requestParameters['paginationNextPageToken'] != null) {
      queryParameters['pagination.next_page_token'] = requestParameters['paginationNextPageToken'];
    }
    if (requestParameters['paginationPreviousPageToken'] != null) {
      queryParameters['pagination.previous_page_token'] = requestParameters['paginationPreviousPageToken'];
    }
    const headerParameters = {};
    if (this.configuration && this.configuration.apiKey) {
      headerParameters["Authorization"] = await this.configuration.apiKey("Authorization"); // bearer authentication
    }
    const response = await this.request({
      path: `/vault-reporting/2025-05-05/organizations/{organization_id}/projects/{project_id}/clusters/{cluster_id}/reports/distinct-mounts`.replace(`{${"organization_id"}}`, encodeURIComponent(String(requestParameters['organizationId']))).replace(`{${"project_id"}}`, encodeURIComponent(String(requestParameters['projectId']))).replace(`{${"cluster_id"}}`, encodeURIComponent(String(requestParameters['clusterId']))),
      method: 'GET',
      headers: headerParameters,
      query: queryParameters
    }, initOverrides);
    return new JSONApiResponse(response, jsonValue => VaultReporting20250505FetchDistinctMountsResponseFromJSON(jsonValue));
  }

  /**
   */
  async fetchDistinctMounts(requestParameters, initOverrides) {
    const response = await this.fetchDistinctMountsRaw(requestParameters, initOverrides);
    return await response.value();
  }

  /**
   */
  async fetchDistinctNamespacesRaw(requestParameters, initOverrides) {
    if (requestParameters['organizationId'] == null) {
      throw new RequiredError('organizationId', 'Required parameter "organizationId" was null or undefined when calling fetchDistinctNamespaces().');
    }
    if (requestParameters['projectId'] == null) {
      throw new RequiredError('projectId', 'Required parameter "projectId" was null or undefined when calling fetchDistinctNamespaces().');
    }
    if (requestParameters['clusterId'] == null) {
      throw new RequiredError('clusterId', 'Required parameter "clusterId" was null or undefined when calling fetchDistinctNamespaces().');
    }
    const queryParameters = {};
    if (requestParameters['namespacePathPrefix'] != null) {
      queryParameters['namespace_path_prefix'] = requestParameters['namespacePathPrefix'];
    }
    if (requestParameters['paginationPageSize'] != null) {
      queryParameters['pagination.page_size'] = requestParameters['paginationPageSize'];
    }
    if (requestParameters['paginationNextPageToken'] != null) {
      queryParameters['pagination.next_page_token'] = requestParameters['paginationNextPageToken'];
    }
    if (requestParameters['paginationPreviousPageToken'] != null) {
      queryParameters['pagination.previous_page_token'] = requestParameters['paginationPreviousPageToken'];
    }
    const headerParameters = {};
    if (this.configuration && this.configuration.apiKey) {
      headerParameters["Authorization"] = await this.configuration.apiKey("Authorization"); // bearer authentication
    }
    const response = await this.request({
      path: `/vault-reporting/2025-05-05/organizations/{organization_id}/projects/{project_id}/clusters/{cluster_id}/reports/distinct-namespaces`.replace(`{${"organization_id"}}`, encodeURIComponent(String(requestParameters['organizationId']))).replace(`{${"project_id"}}`, encodeURIComponent(String(requestParameters['projectId']))).replace(`{${"cluster_id"}}`, encodeURIComponent(String(requestParameters['clusterId']))),
      method: 'GET',
      headers: headerParameters,
      query: queryParameters
    }, initOverrides);
    return new JSONApiResponse(response, jsonValue => VaultReporting20250505FetchDistinctNamespacesResponseFromJSON(jsonValue));
  }

  /**
   */
  async fetchDistinctNamespaces(requestParameters, initOverrides) {
    const response = await this.fetchDistinctNamespacesRaw(requestParameters, initOverrides);
    return await response.value();
  }

  /**
   */
  async fetchSecretsInventoryRaw(requestParameters, initOverrides) {
    if (requestParameters['organizationId'] == null) {
      throw new RequiredError('organizationId', 'Required parameter "organizationId" was null or undefined when calling fetchSecretsInventory().');
    }
    if (requestParameters['projectId'] == null) {
      throw new RequiredError('projectId', 'Required parameter "projectId" was null or undefined when calling fetchSecretsInventory().');
    }
    if (requestParameters['clusterId'] == null) {
      throw new RequiredError('clusterId', 'Required parameter "clusterId" was null or undefined when calling fetchSecretsInventory().');
    }
    const queryParameters = {};
    if (requestParameters['filterIncludeDeleted'] != null) {
      queryParameters['filter.include_deleted'] = requestParameters['filterIncludeDeleted'];
    }
    if (requestParameters['filterSecretNames'] != null) {
      queryParameters['filter.secret_names'] = requestParameters['filterSecretNames'];
    }
    if (requestParameters['filterSecretTypes'] != null) {
      queryParameters['filter.secret_types'] = requestParameters['filterSecretTypes'];
    }
    if (requestParameters['filterNamespaces'] != null) {
      queryParameters['filter.namespaces'] = requestParameters['filterNamespaces'];
    }
    if (requestParameters['filterMountPaths'] != null) {
      queryParameters['filter.mount_paths'] = requestParameters['filterMountPaths'];
    }
    if (requestParameters['filterPluginNames'] != null) {
      queryParameters['filter.plugin_names'] = requestParameters['filterPluginNames'];
    }
    if (requestParameters['filterPluginTypes'] != null) {
      queryParameters['filter.plugin_types'] = requestParameters['filterPluginTypes'];
    }
    if (requestParameters['filterCreatedAtOperator'] != null) {
      queryParameters['filter.created_at.operator'] = requestParameters['filterCreatedAtOperator'];
    }
    if (requestParameters['filterCreatedAtAbsolute'] != null) {
      queryParameters['filter.created_at.absolute'] = requestParameters['filterCreatedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterCreatedAtRelativeToNow'] != null) {
      queryParameters['filter.created_at.relative_to_now'] = requestParameters['filterCreatedAtRelativeToNow'];
    }
    if (requestParameters['filterCreatedByIds'] != null) {
      queryParameters['filter.created_by_ids'] = requestParameters['filterCreatedByIds'];
    }
    if (requestParameters['filterConfigLastModifiedAtOperator'] != null) {
      queryParameters['filter.config_last_modified_at.operator'] = requestParameters['filterConfigLastModifiedAtOperator'];
    }
    if (requestParameters['filterConfigLastModifiedAtAbsolute'] != null) {
      queryParameters['filter.config_last_modified_at.absolute'] = requestParameters['filterConfigLastModifiedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterConfigLastModifiedAtRelativeToNow'] != null) {
      queryParameters['filter.config_last_modified_at.relative_to_now'] = requestParameters['filterConfigLastModifiedAtRelativeToNow'];
    }
    if (requestParameters['filterConfigLastModifiedByIds'] != null) {
      queryParameters['filter.config_last_modified_by_ids'] = requestParameters['filterConfigLastModifiedByIds'];
    }
    if (requestParameters['filterConfigLastAccessedAtOperator'] != null) {
      queryParameters['filter.config_last_accessed_at.operator'] = requestParameters['filterConfigLastAccessedAtOperator'];
    }
    if (requestParameters['filterConfigLastAccessedAtAbsolute'] != null) {
      queryParameters['filter.config_last_accessed_at.absolute'] = requestParameters['filterConfigLastAccessedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterConfigLastAccessedAtRelativeToNow'] != null) {
      queryParameters['filter.config_last_accessed_at.relative_to_now'] = requestParameters['filterConfigLastAccessedAtRelativeToNow'];
    }
    if (requestParameters['filterConfigLastAccessedByIds'] != null) {
      queryParameters['filter.config_last_accessed_by_ids'] = requestParameters['filterConfigLastAccessedByIds'];
    }
    if (requestParameters['filterConfigDeletedAtOperator'] != null) {
      queryParameters['filter.config_deleted_at.operator'] = requestParameters['filterConfigDeletedAtOperator'];
    }
    if (requestParameters['filterConfigDeletedAtAbsolute'] != null) {
      queryParameters['filter.config_deleted_at.absolute'] = requestParameters['filterConfigDeletedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterConfigDeletedAtRelativeToNow'] != null) {
      queryParameters['filter.config_deleted_at.relative_to_now'] = requestParameters['filterConfigDeletedAtRelativeToNow'];
    }
    if (requestParameters['filterConfigDeletedByIds'] != null) {
      queryParameters['filter.config_deleted_by_ids'] = requestParameters['filterConfigDeletedByIds'];
    }
    if (requestParameters['filterSecretLastModifiedAtOperator'] != null) {
      queryParameters['filter.secret_last_modified_at.operator'] = requestParameters['filterSecretLastModifiedAtOperator'];
    }
    if (requestParameters['filterSecretLastModifiedAtAbsolute'] != null) {
      queryParameters['filter.secret_last_modified_at.absolute'] = requestParameters['filterSecretLastModifiedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterSecretLastModifiedAtRelativeToNow'] != null) {
      queryParameters['filter.secret_last_modified_at.relative_to_now'] = requestParameters['filterSecretLastModifiedAtRelativeToNow'];
    }
    if (requestParameters['filterSecretLastModifiedByIds'] != null) {
      queryParameters['filter.secret_last_modified_by_ids'] = requestParameters['filterSecretLastModifiedByIds'];
    }
    if (requestParameters['filterSecretLastAccessedAtOperator'] != null) {
      queryParameters['filter.secret_last_accessed_at.operator'] = requestParameters['filterSecretLastAccessedAtOperator'];
    }
    if (requestParameters['filterSecretLastAccessedAtAbsolute'] != null) {
      queryParameters['filter.secret_last_accessed_at.absolute'] = requestParameters['filterSecretLastAccessedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterSecretLastAccessedAtRelativeToNow'] != null) {
      queryParameters['filter.secret_last_accessed_at.relative_to_now'] = requestParameters['filterSecretLastAccessedAtRelativeToNow'];
    }
    if (requestParameters['filterSecretLastAccessedByIds'] != null) {
      queryParameters['filter.secret_last_accessed_by_ids'] = requestParameters['filterSecretLastAccessedByIds'];
    }
    if (requestParameters['filterSecretDeletedAtOperator'] != null) {
      queryParameters['filter.secret_deleted_at.operator'] = requestParameters['filterSecretDeletedAtOperator'];
    }
    if (requestParameters['filterSecretDeletedAtAbsolute'] != null) {
      queryParameters['filter.secret_deleted_at.absolute'] = requestParameters['filterSecretDeletedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterSecretDeletedAtRelativeToNow'] != null) {
      queryParameters['filter.secret_deleted_at.relative_to_now'] = requestParameters['filterSecretDeletedAtRelativeToNow'];
    }
    if (requestParameters['filterSecretDeletedByIds'] != null) {
      queryParameters['filter.secret_deleted_by_ids'] = requestParameters['filterSecretDeletedByIds'];
    }
    if (requestParameters['filterSecretUndeletedAtOperator'] != null) {
      queryParameters['filter.secret_undeleted_at.operator'] = requestParameters['filterSecretUndeletedAtOperator'];
    }
    if (requestParameters['filterSecretUndeletedAtAbsolute'] != null) {
      queryParameters['filter.secret_undeleted_at.absolute'] = requestParameters['filterSecretUndeletedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterSecretUndeletedAtRelativeToNow'] != null) {
      queryParameters['filter.secret_undeleted_at.relative_to_now'] = requestParameters['filterSecretUndeletedAtRelativeToNow'];
    }
    if (requestParameters['filterSecretUndeletedByIds'] != null) {
      queryParameters['filter.secret_undeleted_by_ids'] = requestParameters['filterSecretUndeletedByIds'];
    }
    if (requestParameters['filterSecretDestroyedAtOperator'] != null) {
      queryParameters['filter.secret_destroyed_at.operator'] = requestParameters['filterSecretDestroyedAtOperator'];
    }
    if (requestParameters['filterSecretDestroyedAtAbsolute'] != null) {
      queryParameters['filter.secret_destroyed_at.absolute'] = requestParameters['filterSecretDestroyedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterSecretDestroyedAtRelativeToNow'] != null) {
      queryParameters['filter.secret_destroyed_at.relative_to_now'] = requestParameters['filterSecretDestroyedAtRelativeToNow'];
    }
    if (requestParameters['filterSecretDestroyedByIds'] != null) {
      queryParameters['filter.secret_destroyed_by_ids'] = requestParameters['filterSecretDestroyedByIds'];
    }
    if (requestParameters['filterExpiresOrNextRotationAtOperator'] != null) {
      queryParameters['filter.expires_or_next_rotation_at.operator'] = requestParameters['filterExpiresOrNextRotationAtOperator'];
    }
    if (requestParameters['filterExpiresOrNextRotationAtAbsolute'] != null) {
      queryParameters['filter.expires_or_next_rotation_at.absolute'] = requestParameters['filterExpiresOrNextRotationAtAbsolute'].toISOString();
    }
    if (requestParameters['filterExpiresOrNextRotationAtRelativeToNow'] != null) {
      queryParameters['filter.expires_or_next_rotation_at.relative_to_now'] = requestParameters['filterExpiresOrNextRotationAtRelativeToNow'];
    }
    if (requestParameters['paginationPageSize'] != null) {
      queryParameters['pagination.page_size'] = requestParameters['paginationPageSize'];
    }
    if (requestParameters['paginationNextPageToken'] != null) {
      queryParameters['pagination.next_page_token'] = requestParameters['paginationNextPageToken'];
    }
    if (requestParameters['paginationPreviousPageToken'] != null) {
      queryParameters['pagination.previous_page_token'] = requestParameters['paginationPreviousPageToken'];
    }
    if (requestParameters['sortingOrderBy'] != null) {
      queryParameters['sorting.order_by'] = requestParameters['sortingOrderBy'];
    }
    const headerParameters = {};
    if (this.configuration && this.configuration.apiKey) {
      headerParameters["Authorization"] = await this.configuration.apiKey("Authorization"); // bearer authentication
    }
    const response = await this.request({
      path: `/vault-reporting/2025-05-05/organizations/{organization_id}/projects/{project_id}/clusters/{cluster_id}/reports/secrets-inventory`.replace(`{${"organization_id"}}`, encodeURIComponent(String(requestParameters['organizationId']))).replace(`{${"project_id"}}`, encodeURIComponent(String(requestParameters['projectId']))).replace(`{${"cluster_id"}}`, encodeURIComponent(String(requestParameters['clusterId']))),
      method: 'GET',
      headers: headerParameters,
      query: queryParameters
    }, initOverrides);
    return new JSONApiResponse(response, jsonValue => VaultReporting20250505FetchSecretsInventoryResponseFromJSON(jsonValue));
  }

  /**
   */
  async fetchSecretsInventory(requestParameters, initOverrides) {
    const response = await this.fetchSecretsInventoryRaw(requestParameters, initOverrides);
    return await response.value();
  }

  /**
   */
  async fetchSecretsInventoryCountRaw(requestParameters, initOverrides) {
    if (requestParameters['organizationId'] == null) {
      throw new RequiredError('organizationId', 'Required parameter "organizationId" was null or undefined when calling fetchSecretsInventoryCount().');
    }
    if (requestParameters['projectId'] == null) {
      throw new RequiredError('projectId', 'Required parameter "projectId" was null or undefined when calling fetchSecretsInventoryCount().');
    }
    if (requestParameters['clusterId'] == null) {
      throw new RequiredError('clusterId', 'Required parameter "clusterId" was null or undefined when calling fetchSecretsInventoryCount().');
    }
    const queryParameters = {};
    if (requestParameters['filterIncludeDeleted'] != null) {
      queryParameters['filter.include_deleted'] = requestParameters['filterIncludeDeleted'];
    }
    if (requestParameters['filterSecretNames'] != null) {
      queryParameters['filter.secret_names'] = requestParameters['filterSecretNames'];
    }
    if (requestParameters['filterSecretTypes'] != null) {
      queryParameters['filter.secret_types'] = requestParameters['filterSecretTypes'];
    }
    if (requestParameters['filterNamespaces'] != null) {
      queryParameters['filter.namespaces'] = requestParameters['filterNamespaces'];
    }
    if (requestParameters['filterMountPaths'] != null) {
      queryParameters['filter.mount_paths'] = requestParameters['filterMountPaths'];
    }
    if (requestParameters['filterPluginNames'] != null) {
      queryParameters['filter.plugin_names'] = requestParameters['filterPluginNames'];
    }
    if (requestParameters['filterPluginTypes'] != null) {
      queryParameters['filter.plugin_types'] = requestParameters['filterPluginTypes'];
    }
    if (requestParameters['filterCreatedAtOperator'] != null) {
      queryParameters['filter.created_at.operator'] = requestParameters['filterCreatedAtOperator'];
    }
    if (requestParameters['filterCreatedAtAbsolute'] != null) {
      queryParameters['filter.created_at.absolute'] = requestParameters['filterCreatedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterCreatedAtRelativeToNow'] != null) {
      queryParameters['filter.created_at.relative_to_now'] = requestParameters['filterCreatedAtRelativeToNow'];
    }
    if (requestParameters['filterCreatedByIds'] != null) {
      queryParameters['filter.created_by_ids'] = requestParameters['filterCreatedByIds'];
    }
    if (requestParameters['filterConfigLastModifiedAtOperator'] != null) {
      queryParameters['filter.config_last_modified_at.operator'] = requestParameters['filterConfigLastModifiedAtOperator'];
    }
    if (requestParameters['filterConfigLastModifiedAtAbsolute'] != null) {
      queryParameters['filter.config_last_modified_at.absolute'] = requestParameters['filterConfigLastModifiedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterConfigLastModifiedAtRelativeToNow'] != null) {
      queryParameters['filter.config_last_modified_at.relative_to_now'] = requestParameters['filterConfigLastModifiedAtRelativeToNow'];
    }
    if (requestParameters['filterConfigLastModifiedByIds'] != null) {
      queryParameters['filter.config_last_modified_by_ids'] = requestParameters['filterConfigLastModifiedByIds'];
    }
    if (requestParameters['filterConfigLastAccessedAtOperator'] != null) {
      queryParameters['filter.config_last_accessed_at.operator'] = requestParameters['filterConfigLastAccessedAtOperator'];
    }
    if (requestParameters['filterConfigLastAccessedAtAbsolute'] != null) {
      queryParameters['filter.config_last_accessed_at.absolute'] = requestParameters['filterConfigLastAccessedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterConfigLastAccessedAtRelativeToNow'] != null) {
      queryParameters['filter.config_last_accessed_at.relative_to_now'] = requestParameters['filterConfigLastAccessedAtRelativeToNow'];
    }
    if (requestParameters['filterConfigLastAccessedByIds'] != null) {
      queryParameters['filter.config_last_accessed_by_ids'] = requestParameters['filterConfigLastAccessedByIds'];
    }
    if (requestParameters['filterConfigDeletedAtOperator'] != null) {
      queryParameters['filter.config_deleted_at.operator'] = requestParameters['filterConfigDeletedAtOperator'];
    }
    if (requestParameters['filterConfigDeletedAtAbsolute'] != null) {
      queryParameters['filter.config_deleted_at.absolute'] = requestParameters['filterConfigDeletedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterConfigDeletedAtRelativeToNow'] != null) {
      queryParameters['filter.config_deleted_at.relative_to_now'] = requestParameters['filterConfigDeletedAtRelativeToNow'];
    }
    if (requestParameters['filterConfigDeletedByIds'] != null) {
      queryParameters['filter.config_deleted_by_ids'] = requestParameters['filterConfigDeletedByIds'];
    }
    if (requestParameters['filterSecretLastModifiedAtOperator'] != null) {
      queryParameters['filter.secret_last_modified_at.operator'] = requestParameters['filterSecretLastModifiedAtOperator'];
    }
    if (requestParameters['filterSecretLastModifiedAtAbsolute'] != null) {
      queryParameters['filter.secret_last_modified_at.absolute'] = requestParameters['filterSecretLastModifiedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterSecretLastModifiedAtRelativeToNow'] != null) {
      queryParameters['filter.secret_last_modified_at.relative_to_now'] = requestParameters['filterSecretLastModifiedAtRelativeToNow'];
    }
    if (requestParameters['filterSecretLastModifiedByIds'] != null) {
      queryParameters['filter.secret_last_modified_by_ids'] = requestParameters['filterSecretLastModifiedByIds'];
    }
    if (requestParameters['filterSecretLastAccessedAtOperator'] != null) {
      queryParameters['filter.secret_last_accessed_at.operator'] = requestParameters['filterSecretLastAccessedAtOperator'];
    }
    if (requestParameters['filterSecretLastAccessedAtAbsolute'] != null) {
      queryParameters['filter.secret_last_accessed_at.absolute'] = requestParameters['filterSecretLastAccessedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterSecretLastAccessedAtRelativeToNow'] != null) {
      queryParameters['filter.secret_last_accessed_at.relative_to_now'] = requestParameters['filterSecretLastAccessedAtRelativeToNow'];
    }
    if (requestParameters['filterSecretLastAccessedByIds'] != null) {
      queryParameters['filter.secret_last_accessed_by_ids'] = requestParameters['filterSecretLastAccessedByIds'];
    }
    if (requestParameters['filterSecretDeletedAtOperator'] != null) {
      queryParameters['filter.secret_deleted_at.operator'] = requestParameters['filterSecretDeletedAtOperator'];
    }
    if (requestParameters['filterSecretDeletedAtAbsolute'] != null) {
      queryParameters['filter.secret_deleted_at.absolute'] = requestParameters['filterSecretDeletedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterSecretDeletedAtRelativeToNow'] != null) {
      queryParameters['filter.secret_deleted_at.relative_to_now'] = requestParameters['filterSecretDeletedAtRelativeToNow'];
    }
    if (requestParameters['filterSecretDeletedByIds'] != null) {
      queryParameters['filter.secret_deleted_by_ids'] = requestParameters['filterSecretDeletedByIds'];
    }
    if (requestParameters['filterSecretUndeletedAtOperator'] != null) {
      queryParameters['filter.secret_undeleted_at.operator'] = requestParameters['filterSecretUndeletedAtOperator'];
    }
    if (requestParameters['filterSecretUndeletedAtAbsolute'] != null) {
      queryParameters['filter.secret_undeleted_at.absolute'] = requestParameters['filterSecretUndeletedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterSecretUndeletedAtRelativeToNow'] != null) {
      queryParameters['filter.secret_undeleted_at.relative_to_now'] = requestParameters['filterSecretUndeletedAtRelativeToNow'];
    }
    if (requestParameters['filterSecretUndeletedByIds'] != null) {
      queryParameters['filter.secret_undeleted_by_ids'] = requestParameters['filterSecretUndeletedByIds'];
    }
    if (requestParameters['filterSecretDestroyedAtOperator'] != null) {
      queryParameters['filter.secret_destroyed_at.operator'] = requestParameters['filterSecretDestroyedAtOperator'];
    }
    if (requestParameters['filterSecretDestroyedAtAbsolute'] != null) {
      queryParameters['filter.secret_destroyed_at.absolute'] = requestParameters['filterSecretDestroyedAtAbsolute'].toISOString();
    }
    if (requestParameters['filterSecretDestroyedAtRelativeToNow'] != null) {
      queryParameters['filter.secret_destroyed_at.relative_to_now'] = requestParameters['filterSecretDestroyedAtRelativeToNow'];
    }
    if (requestParameters['filterSecretDestroyedByIds'] != null) {
      queryParameters['filter.secret_destroyed_by_ids'] = requestParameters['filterSecretDestroyedByIds'];
    }
    if (requestParameters['filterExpiresOrNextRotationAtOperator'] != null) {
      queryParameters['filter.expires_or_next_rotation_at.operator'] = requestParameters['filterExpiresOrNextRotationAtOperator'];
    }
    if (requestParameters['filterExpiresOrNextRotationAtAbsolute'] != null) {
      queryParameters['filter.expires_or_next_rotation_at.absolute'] = requestParameters['filterExpiresOrNextRotationAtAbsolute'].toISOString();
    }
    if (requestParameters['filterExpiresOrNextRotationAtRelativeToNow'] != null) {
      queryParameters['filter.expires_or_next_rotation_at.relative_to_now'] = requestParameters['filterExpiresOrNextRotationAtRelativeToNow'];
    }
    const headerParameters = {};
    if (this.configuration && this.configuration.apiKey) {
      headerParameters["Authorization"] = await this.configuration.apiKey("Authorization"); // bearer authentication
    }
    const response = await this.request({
      path: `/vault-reporting/2025-05-05/organizations/{organization_id}/projects/{project_id}/clusters/{cluster_id}/reports/secrets-inventory/count`.replace(`{${"organization_id"}}`, encodeURIComponent(String(requestParameters['organizationId']))).replace(`{${"project_id"}}`, encodeURIComponent(String(requestParameters['projectId']))).replace(`{${"cluster_id"}}`, encodeURIComponent(String(requestParameters['clusterId']))),
      method: 'GET',
      headers: headerParameters,
      query: queryParameters
    }, initOverrides);
    return new JSONApiResponse(response, jsonValue => VaultReporting20250505FetchSecretsInventoryCountResponseFromJSON(jsonValue));
  }

  /**
   */
  async fetchSecretsInventoryCount(requestParameters, initOverrides) {
    const response = await this.fetchSecretsInventoryCountRaw(requestParameters, initOverrides);
    return await response.value();
  }
}

/**
  * @export
  * @enum {string}
  */
let FetchDistinctEntityIdsColumnEnum = /*#__PURE__*/function (FetchDistinctEntityIdsColumnEnum) {
  FetchDistinctEntityIdsColumnEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchDistinctEntityIdsColumnEnum["CREATED_BY_ID"] = "CREATED_BY_ID";
  FetchDistinctEntityIdsColumnEnum["CONFIG_LAST_MODIFIED_BY_ID"] = "CONFIG_LAST_MODIFIED_BY_ID";
  FetchDistinctEntityIdsColumnEnum["CONFIG_LAST_ACCESSED_BY_ID"] = "CONFIG_LAST_ACCESSED_BY_ID";
  FetchDistinctEntityIdsColumnEnum["CONFIG_DELETED_BY_ID"] = "CONFIG_DELETED_BY_ID";
  FetchDistinctEntityIdsColumnEnum["SECRET_LAST_MODIFIED_BY_ID"] = "SECRET_LAST_MODIFIED_BY_ID";
  FetchDistinctEntityIdsColumnEnum["SECRET_LAST_ACCESSED_BY_ID"] = "SECRET_LAST_ACCESSED_BY_ID";
  FetchDistinctEntityIdsColumnEnum["SECRET_DELETED_BY_ID"] = "SECRET_DELETED_BY_ID";
  FetchDistinctEntityIdsColumnEnum["SECRET_UNDELETED_BY_ID"] = "SECRET_UNDELETED_BY_ID";
  FetchDistinctEntityIdsColumnEnum["SECRET_DESTROYED_BY_ID"] = "SECRET_DESTROYED_BY_ID";
  return FetchDistinctEntityIdsColumnEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryFilterCreatedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryFilterCreatedAtOperatorEnum) {
  FetchSecretsInventoryFilterCreatedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryFilterCreatedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryFilterCreatedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryFilterCreatedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryFilterCreatedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryFilterCreatedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryFilterConfigLastModifiedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryFilterConfigLastModifiedAtOperatorEnum) {
  FetchSecretsInventoryFilterConfigLastModifiedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryFilterConfigLastModifiedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryFilterConfigLastModifiedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryFilterConfigLastModifiedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryFilterConfigLastModifiedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryFilterConfigLastModifiedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryFilterConfigLastAccessedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryFilterConfigLastAccessedAtOperatorEnum) {
  FetchSecretsInventoryFilterConfigLastAccessedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryFilterConfigLastAccessedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryFilterConfigLastAccessedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryFilterConfigLastAccessedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryFilterConfigLastAccessedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryFilterConfigLastAccessedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryFilterConfigDeletedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryFilterConfigDeletedAtOperatorEnum) {
  FetchSecretsInventoryFilterConfigDeletedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryFilterConfigDeletedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryFilterConfigDeletedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryFilterConfigDeletedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryFilterConfigDeletedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryFilterConfigDeletedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryFilterSecretLastModifiedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryFilterSecretLastModifiedAtOperatorEnum) {
  FetchSecretsInventoryFilterSecretLastModifiedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryFilterSecretLastModifiedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryFilterSecretLastModifiedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryFilterSecretLastModifiedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryFilterSecretLastModifiedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryFilterSecretLastModifiedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryFilterSecretLastAccessedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryFilterSecretLastAccessedAtOperatorEnum) {
  FetchSecretsInventoryFilterSecretLastAccessedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryFilterSecretLastAccessedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryFilterSecretLastAccessedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryFilterSecretLastAccessedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryFilterSecretLastAccessedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryFilterSecretLastAccessedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryFilterSecretDeletedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryFilterSecretDeletedAtOperatorEnum) {
  FetchSecretsInventoryFilterSecretDeletedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryFilterSecretDeletedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryFilterSecretDeletedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryFilterSecretDeletedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryFilterSecretDeletedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryFilterSecretDeletedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryFilterSecretUndeletedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryFilterSecretUndeletedAtOperatorEnum) {
  FetchSecretsInventoryFilterSecretUndeletedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryFilterSecretUndeletedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryFilterSecretUndeletedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryFilterSecretUndeletedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryFilterSecretUndeletedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryFilterSecretUndeletedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryFilterSecretDestroyedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryFilterSecretDestroyedAtOperatorEnum) {
  FetchSecretsInventoryFilterSecretDestroyedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryFilterSecretDestroyedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryFilterSecretDestroyedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryFilterSecretDestroyedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryFilterSecretDestroyedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryFilterSecretDestroyedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryFilterExpiresOrNextRotationAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryFilterExpiresOrNextRotationAtOperatorEnum) {
  FetchSecretsInventoryFilterExpiresOrNextRotationAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryFilterExpiresOrNextRotationAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryFilterExpiresOrNextRotationAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryFilterExpiresOrNextRotationAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryFilterExpiresOrNextRotationAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryFilterExpiresOrNextRotationAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryCountFilterCreatedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryCountFilterCreatedAtOperatorEnum) {
  FetchSecretsInventoryCountFilterCreatedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryCountFilterCreatedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryCountFilterCreatedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryCountFilterCreatedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryCountFilterCreatedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryCountFilterCreatedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryCountFilterConfigLastModifiedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryCountFilterConfigLastModifiedAtOperatorEnum) {
  FetchSecretsInventoryCountFilterConfigLastModifiedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryCountFilterConfigLastModifiedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryCountFilterConfigLastModifiedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryCountFilterConfigLastModifiedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryCountFilterConfigLastModifiedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryCountFilterConfigLastModifiedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryCountFilterConfigLastAccessedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryCountFilterConfigLastAccessedAtOperatorEnum) {
  FetchSecretsInventoryCountFilterConfigLastAccessedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryCountFilterConfigLastAccessedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryCountFilterConfigLastAccessedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryCountFilterConfigLastAccessedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryCountFilterConfigLastAccessedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryCountFilterConfigLastAccessedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryCountFilterConfigDeletedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryCountFilterConfigDeletedAtOperatorEnum) {
  FetchSecretsInventoryCountFilterConfigDeletedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryCountFilterConfigDeletedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryCountFilterConfigDeletedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryCountFilterConfigDeletedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryCountFilterConfigDeletedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryCountFilterConfigDeletedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryCountFilterSecretLastModifiedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryCountFilterSecretLastModifiedAtOperatorEnum) {
  FetchSecretsInventoryCountFilterSecretLastModifiedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryCountFilterSecretLastModifiedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryCountFilterSecretLastModifiedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryCountFilterSecretLastModifiedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryCountFilterSecretLastModifiedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryCountFilterSecretLastModifiedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryCountFilterSecretLastAccessedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryCountFilterSecretLastAccessedAtOperatorEnum) {
  FetchSecretsInventoryCountFilterSecretLastAccessedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryCountFilterSecretLastAccessedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryCountFilterSecretLastAccessedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryCountFilterSecretLastAccessedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryCountFilterSecretLastAccessedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryCountFilterSecretLastAccessedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryCountFilterSecretDeletedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryCountFilterSecretDeletedAtOperatorEnum) {
  FetchSecretsInventoryCountFilterSecretDeletedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryCountFilterSecretDeletedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryCountFilterSecretDeletedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryCountFilterSecretDeletedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryCountFilterSecretDeletedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryCountFilterSecretDeletedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryCountFilterSecretUndeletedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryCountFilterSecretUndeletedAtOperatorEnum) {
  FetchSecretsInventoryCountFilterSecretUndeletedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryCountFilterSecretUndeletedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryCountFilterSecretUndeletedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryCountFilterSecretUndeletedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryCountFilterSecretUndeletedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryCountFilterSecretUndeletedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryCountFilterSecretDestroyedAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryCountFilterSecretDestroyedAtOperatorEnum) {
  FetchSecretsInventoryCountFilterSecretDestroyedAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryCountFilterSecretDestroyedAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryCountFilterSecretDestroyedAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryCountFilterSecretDestroyedAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryCountFilterSecretDestroyedAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryCountFilterSecretDestroyedAtOperatorEnum;
}({});
/**
  * @export
  * @enum {string}
  */
let FetchSecretsInventoryCountFilterExpiresOrNextRotationAtOperatorEnum = /*#__PURE__*/function (FetchSecretsInventoryCountFilterExpiresOrNextRotationAtOperatorEnum) {
  FetchSecretsInventoryCountFilterExpiresOrNextRotationAtOperatorEnum["UNSPECIFIED"] = "UNSPECIFIED";
  FetchSecretsInventoryCountFilterExpiresOrNextRotationAtOperatorEnum["LESS_THAN"] = "LESS_THAN";
  FetchSecretsInventoryCountFilterExpiresOrNextRotationAtOperatorEnum["LESS_THAN_OR_EQUAL"] = "LESS_THAN_OR_EQUAL";
  FetchSecretsInventoryCountFilterExpiresOrNextRotationAtOperatorEnum["GREATER_THAN"] = "GREATER_THAN";
  FetchSecretsInventoryCountFilterExpiresOrNextRotationAtOperatorEnum["GREATER_THAN_OR_EQUAL"] = "GREATER_THAN_OR_EQUAL";
  return FetchSecretsInventoryCountFilterExpiresOrNextRotationAtOperatorEnum;
}({});

export { FetchDistinctEntityIdsColumnEnum, FetchSecretsInventoryCountFilterConfigDeletedAtOperatorEnum, FetchSecretsInventoryCountFilterConfigLastAccessedAtOperatorEnum, FetchSecretsInventoryCountFilterConfigLastModifiedAtOperatorEnum, FetchSecretsInventoryCountFilterCreatedAtOperatorEnum, FetchSecretsInventoryCountFilterExpiresOrNextRotationAtOperatorEnum, FetchSecretsInventoryCountFilterSecretDeletedAtOperatorEnum, FetchSecretsInventoryCountFilterSecretDestroyedAtOperatorEnum, FetchSecretsInventoryCountFilterSecretLastAccessedAtOperatorEnum, FetchSecretsInventoryCountFilterSecretLastModifiedAtOperatorEnum, FetchSecretsInventoryCountFilterSecretUndeletedAtOperatorEnum, FetchSecretsInventoryFilterConfigDeletedAtOperatorEnum, FetchSecretsInventoryFilterConfigLastAccessedAtOperatorEnum, FetchSecretsInventoryFilterConfigLastModifiedAtOperatorEnum, FetchSecretsInventoryFilterCreatedAtOperatorEnum, FetchSecretsInventoryFilterExpiresOrNextRotationAtOperatorEnum, FetchSecretsInventoryFilterSecretDeletedAtOperatorEnum, FetchSecretsInventoryFilterSecretDestroyedAtOperatorEnum, FetchSecretsInventoryFilterSecretLastAccessedAtOperatorEnum, FetchSecretsInventoryFilterSecretLastModifiedAtOperatorEnum, FetchSecretsInventoryFilterSecretUndeletedAtOperatorEnum, VaultReportingServiceApi };
//# sourceMappingURL=VaultReportingServiceApi.js.map
