// Copyright IBM Corp. 2016, 2025
// SPDX-License-Identifier: BUSL-1.1

package main

import (
	"log"
	"os"

	"github.com/hashicorp/vault/plugins/database/hana"
	"github.com/hashicorp/vault/sdk/database/dbplugin/v5"
)

func main() {
	err := Run()
	if err != nil {
		log.Println(err)
		os.Exit(1)
	}
}

// Run instantiates a HANA object, and runs the RPC server for the plugin
func Run() error {
	dbplugin.ServeMultiplex(hana.New)

	return nil
}
