/*	$Id: login_hotp.c,v 1.2 2011/03/11 22:19:39 sthen Exp $ */
/*
 * Copyright (c) 2011 Stuart Henderson <sthen@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <sys/types.h>
#include <sys/resource.h>
#include <sys/param.h>

#include <signal.h>
#include <syslog.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <login_cap.h>
#include <bsd_auth.h>
#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <err.h>
#include <util.h>

#include <oath.h>

#include "common.h"

/* login.conf strings */
#define CAP_WINDOW		"x-window"

#define HOTP_USERS		"/tmp/hotp-users"

int
oath_login(char *username, char *class)
{
	login_cap_t	*lc;
	
	int ret, r = 1;
	char *otp = NULL, *s;
	time_t last_otp;
	char invokinguser[MAXLOGNAME];
	const char *errstr;
	size_t window = 0;

	invokinguser[0] = '\0';

	setpriority(PRIO_PROCESS, 0, 0);

	openlog(NULL, LOG_ODELAY, LOG_AUTH);

	if (username == NULL)
		return (AUTH_FAILED);

	ret = AUTH_FAILED;

	lc = login_getclass(class);
	if (lc == NULL) {
		syslog(LOG_ERR, "couldn't find %s in login.conf", class);
		exit(1);
	}

	s = login_getcapstr(lc, CAP_WINDOW, NULL, NULL);
	if (s != NULL) {
	        window = strtonum(s, 0, UINT_MAX, &errstr);
        	if (errstr)
                	errx(1, "The window size is %s: %s", errstr, s);
	}

	if (oath_check_version(OATH_VERSION) == NULL) {
		syslog(LOG_ERR, "liboath version mismatch\n");
	}

	r = oath_init();
	if (r != 0) {
		syslog(LOG_ERR, "failed to initialize: %d\n", r);
		exit(1);
	}

	otp = getpass("OTP:");

	if (oath_authenticate_usersfile(HOTP_USERS, username, otp,
	    window, NULL, &last_otp) == OATH_OK)
		ret = AUTH_OK;

	if (otp != NULL)
		memset(otp, 0, strlen(otp));

	oath_done();

	return (ret);
}
