vpn-ca(1)

# NAME

vpn-ca - simple CA to issue client and server certificates

# SYNOPSIS

	*vpn-ca* *-init-ca* [*-name* _NAME_] [*-not-after* _NOT-AFTER_] [*-domain-constraint* _DOMAIN-CONSTRAINT_]

	*vpn-ca* *-server* *-name* _NAME_ [*-alt-dns-name* _DNS-NAME_] [*-not-after* _NOT-AFTER_] [*-ou* _OU_] [*-out-crt* _OUT-CRT_] [*-out-key* _OUT-KEY_]
	
	*vpn-ca* *-client* *-name* _NAME_ *[-not-after* _NOT-AFTER_] [*-ou* OU] [*-out-crt* _OUT-CRT_] [*-out-key* _OUT-KEY_]

# DESCRIPTION

Simple CA that can be used to manage server and client certificates for use 
with e.g. TLS VPNs, 802.1X or a simple home lab with self issued certificates.

# OPTIONS

*-init-ca*
	Initialize a new CA, write CA certificate to *ca.crt* and key to *ca.key*

*-domain-constraint* _DOMAIN-CONSTRAINT_
	DNS Domain Constraint for CA. See section 4.2.1.10 of RFC 5280

*-name* _NAME_
	Common Name on the CA/Server/Client Certificate

*-alt-dns-name* _DNS-NAME_
	DNS "Subject Alternative Name" for Server Certificate. Can be specified 
	more than once. The name specified using *-name* is always automatically 
	added

*-not-after* _NOT-AFTER_
	Limit Certificate Validity for CA/Server/Client Certificate. The parameter 
	MUST be formatted either as RFC 3339, e.g. "2006-01-02T15:04:05Z07:00" or 
	the literal string "CA" indicating the certificate expires at the same 
	moment as the CA

*-server*
	Generate a Server Certificate/Key

*-client*
	Generate a Client Certificate/Key

*-ou* _OU_
	Organizational Unit on the Server/Client Certificate

*-out-crt* _OUT-CRT_
	Write the Server/Client Certificate to Specified File

*-out-key* _OUT-KEY_
	Write the Server/Client Key to Specified File

# ENVIRONMENT VARIABLES

The following environment variables can be set to modify the behavior:

*CA_DIR*=_DIR_
	The directory to write/read the CA certificate/key to/from and where to 
	write the server and client certificates. The default value is ".", i.e. 
	the current directory.

*CA_KEY_TYPE*=_ALGORITHM_
	The type of key used when generating CA/server/client certificates. The 
	default is "ECDSA". The other acceptable value is "EdDSA".

# ALGORITHMS

Algorithms can be specified with the *CA_KEY_TYPE* environment variable as 
shown above.

[[ *CA_KEY_TYPE*
:- _ALGORITHM_
|-  ECDSA
:[  NIST P-384/secp384r1 curve
|-  EdDSA
:[  Curve25519 (Ed25519)

# CAVEATS

Server certificates also set the "subjectAltName" in the X.509 certificate for 
which the *-name* must be allowed, i.e. only characters that are valid in 
domain names.

When specifying *-out-crt* and *-out-key* together with *-client* this allows
you to avoid the check on the *-name* parameter and allows you to specify
characters outside of the ones allowed for domain names, see EXAMPLES.

When not specifying *-not-after* with a CA it will default to 5 years. When 
not specifying it with *-client* or *-server* it will be 1 year.

The *-not-after* MUST NOT extend beyond the life of the CA, trying to do so
will result in an error!

It is not necessary to use the same *CA_KEY_TYPE* consistently. You can have 
e.g. a Root CA with EdDSA, but use that to sign ECDSA certificates.

We recommend you use EdDSA if possible. It is the most modern, secure and fast 
algorithm. However, not all software, most notably web browsers, supports EdDSA 
yet, however, most other applications using TLS do. In order to use TLS with
EdDSA, TLSv1.3 is required.  With OpenSSL, one needs OpenSSL >= 1.1.1.

# EXAMPLES

Initialize the CA (valid for 5 years) with an ECDSA key with the NIST 
P-384/secp384r1 curve:

```
vpn-ca -init-ca -name "My Root CA"
```

Initialize the CA and use EdDSA for the key:

```
CA_KEY_TYPE=EdDSA vpn-ca -init-ca
```

Add a DNS domain constraint to the CA. Names starting with a "." mean all
sub-domains. Names starting without "." mean only that name. The example below
allows issuing sub-domains under ".home.arpa", .e.g "foo.home.arpa":

```
vpn-ca -init-ca -domain-constraint .home.arpa
```

Generate a CA, and specify when it expires:

```
vpn-ca -init-ca -not-after 2030-12-31T23:59:59+00:00
```

Generate a server certificate, valid for 1 year:

```
vpn-ca -server -name server.example.org
```

Generate a server certificate, with "Subject Alternative Name":

```
vpn-ca -server -name www.example.org -alt-dns-name example.org -alt-dns-name secure.example.org
```

Generate a client certificate, valid for 1 year:

```
vpn-ca -client -name 12345678
```

Generate client certificate and specify explicitly when it expires:

```
vpn-ca -client -name 12345678 -not-after 2020-12-12T12:12:12+00:00
```

Generate a client certificate, valid for 90 days:

```
vpn-ca -client -name 23456789 -not-after $(date -d "+90 days" +%FT%T%:z)
```

Generate a client certificate and make it expire together with the CA:

```
vpn-ca -client -name 12345678 -not-after CA
```

Specify a file to write the generated client certificate and key to:

```
vpn-ca -client -name "🎉" -out-crt out.crt -out-key out.key
```

# AUTHORS

François Kooman <fkooman@tuxed.net>
