/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.util;

import io.jenetics.internal.util.require;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.stream.Stream;

public class reflect {
    private reflect() {
        require.noInstance();
    }

    public static void setField(Object target, String name, Object value) {
        Field field = reflect.findField(target.getClass(), name).orElseThrow(() -> new IllegalArgumentException(name + " not found."));
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Optional<Field> findField(Class<?> cls, String name) {
        return reflect.allFields(cls).filter(f -> f.getName().equals(name)).findFirst();
    }

    private static Stream<Field> allFields(Class<?> cls) {
        return reflect.allClasses(cls).flatMap(c -> Stream.of(c.getDeclaredFields()));
    }

    private static Stream<Class<?>> allClasses(Class<?> cls) {
        return Stream.concat(Stream.of(cls), Optional.ofNullable(cls.getSuperclass()).map(reflect::allClasses).orElse(Stream.empty()));
    }
}

