/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.country.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.data.CountryField;
import com.ubnt.data.X;
import com.ubnt.return.C;
import com.ubnt.return.H;
import com.ubnt.service.country.model.AfcChannel;
import com.ubnt.service.country.model.CountryChannelPolicy;
import com.ubnt.service.country.model.ImmutableCountryChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.immutables.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JsonDeserialize(builder=ImmutableCountryChannel.Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
@H
@C
public abstract class CountryChannel {
    @JsonProperty(value="code")
    @Value.Default
    public String code() {
        return "";
    }

    @JsonProperty(value="name")
    @Value.Default
    public String name() {
        return "";
    }

    @JsonProperty(value="key")
    @Value.Default
    public String key() {
        return "";
    }

    @JsonIgnore
    @Value.Default
    public boolean hasChannelData() {
        return true;
    }

    @JsonProperty(value="channels_6e")
    public abstract List<Number> channels6e();

    @JsonProperty(value="channels_6e_320")
    public abstract List<Number> channels6e320();

    @JsonProperty(value="channels_6e_160")
    public abstract List<Number> channels6e160();

    @JsonProperty(value="channels_6e_40")
    public abstract List<Number> channels6e40();

    @JsonProperty(value="channels_6e_80")
    public abstract List<Number> channels6e80();

    @JsonProperty(value="channels_6e_indoor")
    public abstract List<Number> channels6eIndoor();

    @JsonProperty(value="channels_6e_outdoor")
    public abstract List<Number> channels6eOutdoor();

    @JsonProperty(value="channels_6e_psc")
    public abstract List<Number> channels6ePsc();

    @JsonProperty(value="channels_ad_outdoor")
    public abstract List<Number> channelsAdOutdoor();

    @JsonProperty(value="channels_ad_1080")
    public abstract List<Number> channelsAd1080();

    @JsonProperty(value="channels_ad_2160")
    public abstract List<Number> channelsAd2160();

    @JsonProperty(value="channels_ad_4320")
    public abstract List<Number> channelsAd4320();

    @JsonProperty(value="channels_ad_ext_outdoor")
    public abstract List<Number> channelsAdExtOutdoor();

    @JsonProperty(value="channels_ad_ext_1080")
    public abstract List<Number> channelsAdExt1080();

    @JsonProperty(value="channels_ad_ext_2160")
    public abstract List<Number> channelsAdExt2160();

    @JsonProperty(value="channels_na")
    public abstract List<Number> channelsNa();

    @JsonProperty(value="channels_na_160")
    public abstract List<Number> channelsNa160();

    @JsonProperty(value="channels_na_240")
    public abstract List<Number> channelsNa240();

    @JsonProperty(value="channels_na_40")
    public abstract List<Number> channelsNa40();

    @JsonProperty(value="channels_na_80")
    public abstract List<Number> channelsNa80();

    @JsonProperty(value="channels_na_dfs")
    public abstract List<Number> channelsNaDfs();

    @JsonProperty(value="channels_na_indoor")
    public abstract List<Number> channelsNaIndoor();

    @JsonProperty(value="channels_na_outdoor")
    public abstract List<Number> channelsNaOutdoor();

    @JsonProperty(value="channels_ng")
    public abstract List<Number> channelsNg();

    @JsonProperty(value="channels_ng_40")
    public abstract List<Number> channelsNg40();

    @JsonProperty(value="channels_ng_indoor")
    public abstract List<Number> channelsNgIndoor();

    @JsonProperty(value="channels_ng_outdoor")
    public abstract List<Number> channelsNgOutdoor();

    @JsonProperty(value="afc")
    @Value.Default
    public AfcChannel afc() {
        return AfcChannel.empty();
    }

    @JsonProperty(value="hints")
    public abstract Set<CountryChannelPolicy> hints();

    @Value.Auxiliary
    public List<Number> getChannels(String string) {
        List<Number> list = CountryField.Channel.findChannelGetterFunction(string).apply(this);
        return (List)ObjectUtils.defaultIfNull(list, Collections.emptyList());
    }

    @Value.Auxiliary
    public List<Integer> getIntegerChannels(String string) {
        return this.getChannels(string).stream().filter(number -> number.equals(number.intValue())).map(Number::intValue).collect(Collectors.toList());
    }

    @Value.Auxiliary
    public List<Integer> getAfcChannels(int n2) {
        return this.afc().getChannels(n2);
    }

    @Value.Auxiliary
    public CountryChannel withoutChannelData() {
        return CountryChannel.builder().code(this.code()).key(this.key()).name(this.name()).hasChannelData(false).build();
    }

    @Value.Auxiliary
    public X toXDto() {
        X x2 = new X().append("key", this.key()).append("name", this.name()).append("code", this.code()).append("hints", this.hints());
        Arrays.stream(CountryField.Channel.values()).filter(channel -> channel.getChannelGetter() != null).forEach(channel -> x2.put(channel.getValue(), channel.getChannelGetter().apply(this)));
        x2.append("afc", this.afc().toXDto());
        return x2;
    }

    public static ImmutableCountryChannel.Builder builder() {
        return ImmutableCountryChannel.builder();
    }
}

