// Code generated by mockery v2.53.4. DO NOT EDIT.

// Regenerate this file using `make plugin-mocks`.

package plugintest

import (
	io "io"
	http "net/http"

	logr "github.com/mattermost/logr/v2"

	mock "github.com/stretchr/testify/mock"

	model "github.com/mattermost/mattermost/server/public/model"
)

// API is an autogenerated mock type for the API type
type API struct {
	mock.Mock
}

// AddChannelMember provides a mock function with given fields: channelId, userID
func (_m *API) AddChannelMember(channelId string, userID string) (*model.ChannelMember, *model.AppError) {
	ret := _m.Called(channelId, userID)

	if len(ret) == 0 {
		panic("no return value specified for AddChannelMember")
	}

	var r0 *model.ChannelMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string) (*model.ChannelMember, *model.AppError)); ok {
		return rf(channelId, userID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.ChannelMember); ok {
		r0 = rf(channelId, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(channelId, userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// AddReaction provides a mock function with given fields: reaction
func (_m *API) AddReaction(reaction *model.Reaction) (*model.Reaction, *model.AppError) {
	ret := _m.Called(reaction)

	if len(ret) == 0 {
		panic("no return value specified for AddReaction")
	}

	var r0 *model.Reaction
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Reaction) (*model.Reaction, *model.AppError)); ok {
		return rf(reaction)
	}
	if rf, ok := ret.Get(0).(func(*model.Reaction) *model.Reaction); ok {
		r0 = rf(reaction)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Reaction)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Reaction) *model.AppError); ok {
		r1 = rf(reaction)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// AddUserToChannel provides a mock function with given fields: channelId, userID, asUserId
func (_m *API) AddUserToChannel(channelId string, userID string, asUserId string) (*model.ChannelMember, *model.AppError) {
	ret := _m.Called(channelId, userID, asUserId)

	if len(ret) == 0 {
		panic("no return value specified for AddUserToChannel")
	}

	var r0 *model.ChannelMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, string) (*model.ChannelMember, *model.AppError)); ok {
		return rf(channelId, userID, asUserId)
	}
	if rf, ok := ret.Get(0).(func(string, string, string) *model.ChannelMember); ok {
		r0 = rf(channelId, userID, asUserId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, string) *model.AppError); ok {
		r1 = rf(channelId, userID, asUserId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CopyFileInfos provides a mock function with given fields: userID, fileIds
func (_m *API) CopyFileInfos(userID string, fileIds []string) ([]string, *model.AppError) {
	ret := _m.Called(userID, fileIds)

	if len(ret) == 0 {
		panic("no return value specified for CopyFileInfos")
	}

	var r0 []string
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []string) ([]string, *model.AppError)); ok {
		return rf(userID, fileIds)
	}
	if rf, ok := ret.Get(0).(func(string, []string) []string); ok {
		r0 = rf(userID, fileIds)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string) *model.AppError); ok {
		r1 = rf(userID, fileIds)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CountPropertyFields provides a mock function with given fields: groupID, includeDeleted
func (_m *API) CountPropertyFields(groupID string, includeDeleted bool) (int64, error) {
	ret := _m.Called(groupID, includeDeleted)

	if len(ret) == 0 {
		panic("no return value specified for CountPropertyFields")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string, bool) (int64, error)); ok {
		return rf(groupID, includeDeleted)
	}
	if rf, ok := ret.Get(0).(func(string, bool) int64); ok {
		r0 = rf(groupID, includeDeleted)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(string, bool) error); ok {
		r1 = rf(groupID, includeDeleted)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CountPropertyFieldsForTarget provides a mock function with given fields: groupID, targetType, targetID, includeDeleted
func (_m *API) CountPropertyFieldsForTarget(groupID string, targetType string, targetID string, includeDeleted bool) (int64, error) {
	ret := _m.Called(groupID, targetType, targetID, includeDeleted)

	if len(ret) == 0 {
		panic("no return value specified for CountPropertyFieldsForTarget")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, string, bool) (int64, error)); ok {
		return rf(groupID, targetType, targetID, includeDeleted)
	}
	if rf, ok := ret.Get(0).(func(string, string, string, bool) int64); ok {
		r0 = rf(groupID, targetType, targetID, includeDeleted)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(string, string, string, bool) error); ok {
		r1 = rf(groupID, targetType, targetID, includeDeleted)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateBot provides a mock function with given fields: bot
func (_m *API) CreateBot(bot *model.Bot) (*model.Bot, *model.AppError) {
	ret := _m.Called(bot)

	if len(ret) == 0 {
		panic("no return value specified for CreateBot")
	}

	var r0 *model.Bot
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Bot) (*model.Bot, *model.AppError)); ok {
		return rf(bot)
	}
	if rf, ok := ret.Get(0).(func(*model.Bot) *model.Bot); ok {
		r0 = rf(bot)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Bot)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Bot) *model.AppError); ok {
		r1 = rf(bot)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateChannel provides a mock function with given fields: channel
func (_m *API) CreateChannel(channel *model.Channel) (*model.Channel, *model.AppError) {
	ret := _m.Called(channel)

	if len(ret) == 0 {
		panic("no return value specified for CreateChannel")
	}

	var r0 *model.Channel
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Channel) (*model.Channel, *model.AppError)); ok {
		return rf(channel)
	}
	if rf, ok := ret.Get(0).(func(*model.Channel) *model.Channel); ok {
		r0 = rf(channel)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Channel) *model.AppError); ok {
		r1 = rf(channel)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateChannelSidebarCategory provides a mock function with given fields: userID, teamID, newCategory
func (_m *API) CreateChannelSidebarCategory(userID string, teamID string, newCategory *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, *model.AppError) {
	ret := _m.Called(userID, teamID, newCategory)

	if len(ret) == 0 {
		panic("no return value specified for CreateChannelSidebarCategory")
	}

	var r0 *model.SidebarCategoryWithChannels
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, *model.AppError)); ok {
		return rf(userID, teamID, newCategory)
	}
	if rf, ok := ret.Get(0).(func(string, string, *model.SidebarCategoryWithChannels) *model.SidebarCategoryWithChannels); ok {
		r0 = rf(userID, teamID, newCategory)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.SidebarCategoryWithChannels)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, *model.SidebarCategoryWithChannels) *model.AppError); ok {
		r1 = rf(userID, teamID, newCategory)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateCommand provides a mock function with given fields: cmd
func (_m *API) CreateCommand(cmd *model.Command) (*model.Command, error) {
	ret := _m.Called(cmd)

	if len(ret) == 0 {
		panic("no return value specified for CreateCommand")
	}

	var r0 *model.Command
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.Command) (*model.Command, error)); ok {
		return rf(cmd)
	}
	if rf, ok := ret.Get(0).(func(*model.Command) *model.Command); ok {
		r0 = rf(cmd)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Command)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Command) error); ok {
		r1 = rf(cmd)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateDefaultSyncableMemberships provides a mock function with given fields: params
func (_m *API) CreateDefaultSyncableMemberships(params model.CreateDefaultMembershipParams) *model.AppError {
	ret := _m.Called(params)

	if len(ret) == 0 {
		panic("no return value specified for CreateDefaultSyncableMemberships")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(model.CreateDefaultMembershipParams) *model.AppError); ok {
		r0 = rf(params)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// CreateGroup provides a mock function with given fields: group
func (_m *API) CreateGroup(group *model.Group) (*model.Group, *model.AppError) {
	ret := _m.Called(group)

	if len(ret) == 0 {
		panic("no return value specified for CreateGroup")
	}

	var r0 *model.Group
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Group) (*model.Group, *model.AppError)); ok {
		return rf(group)
	}
	if rf, ok := ret.Get(0).(func(*model.Group) *model.Group); ok {
		r0 = rf(group)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Group) *model.AppError); ok {
		r1 = rf(group)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateOAuthApp provides a mock function with given fields: app
func (_m *API) CreateOAuthApp(app *model.OAuthApp) (*model.OAuthApp, *model.AppError) {
	ret := _m.Called(app)

	if len(ret) == 0 {
		panic("no return value specified for CreateOAuthApp")
	}

	var r0 *model.OAuthApp
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.OAuthApp) (*model.OAuthApp, *model.AppError)); ok {
		return rf(app)
	}
	if rf, ok := ret.Get(0).(func(*model.OAuthApp) *model.OAuthApp); ok {
		r0 = rf(app)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.OAuthApp)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.OAuthApp) *model.AppError); ok {
		r1 = rf(app)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreatePost provides a mock function with given fields: post
func (_m *API) CreatePost(post *model.Post) (*model.Post, *model.AppError) {
	ret := _m.Called(post)

	if len(ret) == 0 {
		panic("no return value specified for CreatePost")
	}

	var r0 *model.Post
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Post) (*model.Post, *model.AppError)); ok {
		return rf(post)
	}
	if rf, ok := ret.Get(0).(func(*model.Post) *model.Post); ok {
		r0 = rf(post)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Post)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Post) *model.AppError); ok {
		r1 = rf(post)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreatePropertyField provides a mock function with given fields: field
func (_m *API) CreatePropertyField(field *model.PropertyField) (*model.PropertyField, error) {
	ret := _m.Called(field)

	if len(ret) == 0 {
		panic("no return value specified for CreatePropertyField")
	}

	var r0 *model.PropertyField
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.PropertyField) (*model.PropertyField, error)); ok {
		return rf(field)
	}
	if rf, ok := ret.Get(0).(func(*model.PropertyField) *model.PropertyField); ok {
		r0 = rf(field)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PropertyField)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.PropertyField) error); ok {
		r1 = rf(field)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreatePropertyValue provides a mock function with given fields: value
func (_m *API) CreatePropertyValue(value *model.PropertyValue) (*model.PropertyValue, error) {
	ret := _m.Called(value)

	if len(ret) == 0 {
		panic("no return value specified for CreatePropertyValue")
	}

	var r0 *model.PropertyValue
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.PropertyValue) (*model.PropertyValue, error)); ok {
		return rf(value)
	}
	if rf, ok := ret.Get(0).(func(*model.PropertyValue) *model.PropertyValue); ok {
		r0 = rf(value)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PropertyValue)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.PropertyValue) error); ok {
		r1 = rf(value)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateSession provides a mock function with given fields: session
func (_m *API) CreateSession(session *model.Session) (*model.Session, *model.AppError) {
	ret := _m.Called(session)

	if len(ret) == 0 {
		panic("no return value specified for CreateSession")
	}

	var r0 *model.Session
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Session) (*model.Session, *model.AppError)); ok {
		return rf(session)
	}
	if rf, ok := ret.Get(0).(func(*model.Session) *model.Session); ok {
		r0 = rf(session)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Session)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Session) *model.AppError); ok {
		r1 = rf(session)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateTeam provides a mock function with given fields: team
func (_m *API) CreateTeam(team *model.Team) (*model.Team, *model.AppError) {
	ret := _m.Called(team)

	if len(ret) == 0 {
		panic("no return value specified for CreateTeam")
	}

	var r0 *model.Team
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Team) (*model.Team, *model.AppError)); ok {
		return rf(team)
	}
	if rf, ok := ret.Get(0).(func(*model.Team) *model.Team); ok {
		r0 = rf(team)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Team)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Team) *model.AppError); ok {
		r1 = rf(team)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateTeamMember provides a mock function with given fields: teamID, userID
func (_m *API) CreateTeamMember(teamID string, userID string) (*model.TeamMember, *model.AppError) {
	ret := _m.Called(teamID, userID)

	if len(ret) == 0 {
		panic("no return value specified for CreateTeamMember")
	}

	var r0 *model.TeamMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string) (*model.TeamMember, *model.AppError)); ok {
		return rf(teamID, userID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.TeamMember); ok {
		r0 = rf(teamID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.TeamMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(teamID, userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateTeamMembers provides a mock function with given fields: teamID, userIds, requestorId
func (_m *API) CreateTeamMembers(teamID string, userIds []string, requestorId string) ([]*model.TeamMember, *model.AppError) {
	ret := _m.Called(teamID, userIds, requestorId)

	if len(ret) == 0 {
		panic("no return value specified for CreateTeamMembers")
	}

	var r0 []*model.TeamMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []string, string) ([]*model.TeamMember, *model.AppError)); ok {
		return rf(teamID, userIds, requestorId)
	}
	if rf, ok := ret.Get(0).(func(string, []string, string) []*model.TeamMember); ok {
		r0 = rf(teamID, userIds, requestorId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.TeamMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string, string) *model.AppError); ok {
		r1 = rf(teamID, userIds, requestorId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateTeamMembersGracefully provides a mock function with given fields: teamID, userIds, requestorId
func (_m *API) CreateTeamMembersGracefully(teamID string, userIds []string, requestorId string) ([]*model.TeamMemberWithError, *model.AppError) {
	ret := _m.Called(teamID, userIds, requestorId)

	if len(ret) == 0 {
		panic("no return value specified for CreateTeamMembersGracefully")
	}

	var r0 []*model.TeamMemberWithError
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []string, string) ([]*model.TeamMemberWithError, *model.AppError)); ok {
		return rf(teamID, userIds, requestorId)
	}
	if rf, ok := ret.Get(0).(func(string, []string, string) []*model.TeamMemberWithError); ok {
		r0 = rf(teamID, userIds, requestorId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.TeamMemberWithError)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string, string) *model.AppError); ok {
		r1 = rf(teamID, userIds, requestorId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateUploadSession provides a mock function with given fields: us
func (_m *API) CreateUploadSession(us *model.UploadSession) (*model.UploadSession, error) {
	ret := _m.Called(us)

	if len(ret) == 0 {
		panic("no return value specified for CreateUploadSession")
	}

	var r0 *model.UploadSession
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.UploadSession) (*model.UploadSession, error)); ok {
		return rf(us)
	}
	if rf, ok := ret.Get(0).(func(*model.UploadSession) *model.UploadSession); ok {
		r0 = rf(us)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.UploadSession)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.UploadSession) error); ok {
		r1 = rf(us)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateUser provides a mock function with given fields: user
func (_m *API) CreateUser(user *model.User) (*model.User, *model.AppError) {
	ret := _m.Called(user)

	if len(ret) == 0 {
		panic("no return value specified for CreateUser")
	}

	var r0 *model.User
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.User) (*model.User, *model.AppError)); ok {
		return rf(user)
	}
	if rf, ok := ret.Get(0).(func(*model.User) *model.User); ok {
		r0 = rf(user)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.User) *model.AppError); ok {
		r1 = rf(user)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateUserAccessToken provides a mock function with given fields: token
func (_m *API) CreateUserAccessToken(token *model.UserAccessToken) (*model.UserAccessToken, *model.AppError) {
	ret := _m.Called(token)

	if len(ret) == 0 {
		panic("no return value specified for CreateUserAccessToken")
	}

	var r0 *model.UserAccessToken
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.UserAccessToken) (*model.UserAccessToken, *model.AppError)); ok {
		return rf(token)
	}
	if rf, ok := ret.Get(0).(func(*model.UserAccessToken) *model.UserAccessToken); ok {
		r0 = rf(token)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.UserAccessToken)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.UserAccessToken) *model.AppError); ok {
		r1 = rf(token)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// DeleteChannel provides a mock function with given fields: channelId
func (_m *API) DeleteChannel(channelId string) *model.AppError {
	ret := _m.Called(channelId)

	if len(ret) == 0 {
		panic("no return value specified for DeleteChannel")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(channelId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeleteChannelMember provides a mock function with given fields: channelId, userID
func (_m *API) DeleteChannelMember(channelId string, userID string) *model.AppError {
	ret := _m.Called(channelId, userID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteChannelMember")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string) *model.AppError); ok {
		r0 = rf(channelId, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeleteCommand provides a mock function with given fields: commandID
func (_m *API) DeleteCommand(commandID string) error {
	ret := _m.Called(commandID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteCommand")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(commandID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteEphemeralPost provides a mock function with given fields: userID, postId
func (_m *API) DeleteEphemeralPost(userID string, postId string) {
	_m.Called(userID, postId)
}

// DeleteGroup provides a mock function with given fields: groupID
func (_m *API) DeleteGroup(groupID string) (*model.Group, *model.AppError) {
	ret := _m.Called(groupID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteGroup")
	}

	var r0 *model.Group
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.Group, *model.AppError)); ok {
		return rf(groupID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Group); ok {
		r0 = rf(groupID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(groupID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// DeleteGroupConstrainedMemberships provides a mock function with no fields
func (_m *API) DeleteGroupConstrainedMemberships() *model.AppError {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for DeleteGroupConstrainedMemberships")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func() *model.AppError); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeleteGroupMember provides a mock function with given fields: groupID, userID
func (_m *API) DeleteGroupMember(groupID string, userID string) (*model.GroupMember, *model.AppError) {
	ret := _m.Called(groupID, userID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteGroupMember")
	}

	var r0 *model.GroupMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string) (*model.GroupMember, *model.AppError)); ok {
		return rf(groupID, userID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.GroupMember); ok {
		r0 = rf(groupID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.GroupMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(groupID, userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// DeleteGroupSyncable provides a mock function with given fields: groupID, syncableID, syncableType
func (_m *API) DeleteGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, *model.AppError) {
	ret := _m.Called(groupID, syncableID, syncableType)

	if len(ret) == 0 {
		panic("no return value specified for DeleteGroupSyncable")
	}

	var r0 *model.GroupSyncable
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, model.GroupSyncableType) (*model.GroupSyncable, *model.AppError)); ok {
		return rf(groupID, syncableID, syncableType)
	}
	if rf, ok := ret.Get(0).(func(string, string, model.GroupSyncableType) *model.GroupSyncable); ok {
		r0 = rf(groupID, syncableID, syncableType)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.GroupSyncable)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, model.GroupSyncableType) *model.AppError); ok {
		r1 = rf(groupID, syncableID, syncableType)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// DeleteOAuthApp provides a mock function with given fields: appID
func (_m *API) DeleteOAuthApp(appID string) *model.AppError {
	ret := _m.Called(appID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteOAuthApp")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(appID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeletePost provides a mock function with given fields: postId
func (_m *API) DeletePost(postId string) *model.AppError {
	ret := _m.Called(postId)

	if len(ret) == 0 {
		panic("no return value specified for DeletePost")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(postId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeletePreferencesForUser provides a mock function with given fields: userID, preferences
func (_m *API) DeletePreferencesForUser(userID string, preferences []model.Preference) *model.AppError {
	ret := _m.Called(userID, preferences)

	if len(ret) == 0 {
		panic("no return value specified for DeletePreferencesForUser")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []model.Preference) *model.AppError); ok {
		r0 = rf(userID, preferences)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeletePropertyField provides a mock function with given fields: groupID, fieldID
func (_m *API) DeletePropertyField(groupID string, fieldID string) error {
	ret := _m.Called(groupID, fieldID)

	if len(ret) == 0 {
		panic("no return value specified for DeletePropertyField")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string) error); ok {
		r0 = rf(groupID, fieldID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeletePropertyValue provides a mock function with given fields: groupID, valueID
func (_m *API) DeletePropertyValue(groupID string, valueID string) error {
	ret := _m.Called(groupID, valueID)

	if len(ret) == 0 {
		panic("no return value specified for DeletePropertyValue")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string) error); ok {
		r0 = rf(groupID, valueID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeletePropertyValuesForField provides a mock function with given fields: groupID, fieldID
func (_m *API) DeletePropertyValuesForField(groupID string, fieldID string) error {
	ret := _m.Called(groupID, fieldID)

	if len(ret) == 0 {
		panic("no return value specified for DeletePropertyValuesForField")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string) error); ok {
		r0 = rf(groupID, fieldID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeletePropertyValuesForTarget provides a mock function with given fields: groupID, targetType, targetID
func (_m *API) DeletePropertyValuesForTarget(groupID string, targetType string, targetID string) error {
	ret := _m.Called(groupID, targetType, targetID)

	if len(ret) == 0 {
		panic("no return value specified for DeletePropertyValuesForTarget")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string, string) error); ok {
		r0 = rf(groupID, targetType, targetID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteTeam provides a mock function with given fields: teamID
func (_m *API) DeleteTeam(teamID string) *model.AppError {
	ret := _m.Called(teamID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteTeam")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeleteTeamMember provides a mock function with given fields: teamID, userID, requestorId
func (_m *API) DeleteTeamMember(teamID string, userID string, requestorId string) *model.AppError {
	ret := _m.Called(teamID, userID, requestorId)

	if len(ret) == 0 {
		panic("no return value specified for DeleteTeamMember")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, string) *model.AppError); ok {
		r0 = rf(teamID, userID, requestorId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeleteUser provides a mock function with given fields: userID
func (_m *API) DeleteUser(userID string) *model.AppError {
	ret := _m.Called(userID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteUser")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DisablePlugin provides a mock function with given fields: id
func (_m *API) DisablePlugin(id string) *model.AppError {
	ret := _m.Called(id)

	if len(ret) == 0 {
		panic("no return value specified for DisablePlugin")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// EnablePlugin provides a mock function with given fields: id
func (_m *API) EnablePlugin(id string) *model.AppError {
	ret := _m.Called(id)

	if len(ret) == 0 {
		panic("no return value specified for EnablePlugin")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// EnsureBotUser provides a mock function with given fields: bot
func (_m *API) EnsureBotUser(bot *model.Bot) (string, error) {
	ret := _m.Called(bot)

	if len(ret) == 0 {
		panic("no return value specified for EnsureBotUser")
	}

	var r0 string
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.Bot) (string, error)); ok {
		return rf(bot)
	}
	if rf, ok := ret.Get(0).(func(*model.Bot) string); ok {
		r0 = rf(bot)
	} else {
		r0 = ret.Get(0).(string)
	}

	if rf, ok := ret.Get(1).(func(*model.Bot) error); ok {
		r1 = rf(bot)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ExecuteSlashCommand provides a mock function with given fields: commandArgs
func (_m *API) ExecuteSlashCommand(commandArgs *model.CommandArgs) (*model.CommandResponse, error) {
	ret := _m.Called(commandArgs)

	if len(ret) == 0 {
		panic("no return value specified for ExecuteSlashCommand")
	}

	var r0 *model.CommandResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.CommandArgs) (*model.CommandResponse, error)); ok {
		return rf(commandArgs)
	}
	if rf, ok := ret.Get(0).(func(*model.CommandArgs) *model.CommandResponse); ok {
		r0 = rf(commandArgs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.CommandResponse)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.CommandArgs) error); ok {
		r1 = rf(commandArgs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ExtendSessionExpiry provides a mock function with given fields: sessionID, newExpiry
func (_m *API) ExtendSessionExpiry(sessionID string, newExpiry int64) *model.AppError {
	ret := _m.Called(sessionID, newExpiry)

	if len(ret) == 0 {
		panic("no return value specified for ExtendSessionExpiry")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, int64) *model.AppError); ok {
		r0 = rf(sessionID, newExpiry)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// GetBot provides a mock function with given fields: botUserId, includeDeleted
func (_m *API) GetBot(botUserId string, includeDeleted bool) (*model.Bot, *model.AppError) {
	ret := _m.Called(botUserId, includeDeleted)

	if len(ret) == 0 {
		panic("no return value specified for GetBot")
	}

	var r0 *model.Bot
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, bool) (*model.Bot, *model.AppError)); ok {
		return rf(botUserId, includeDeleted)
	}
	if rf, ok := ret.Get(0).(func(string, bool) *model.Bot); ok {
		r0 = rf(botUserId, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Bot)
		}
	}

	if rf, ok := ret.Get(1).(func(string, bool) *model.AppError); ok {
		r1 = rf(botUserId, includeDeleted)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetBots provides a mock function with given fields: options
func (_m *API) GetBots(options *model.BotGetOptions) ([]*model.Bot, *model.AppError) {
	ret := _m.Called(options)

	if len(ret) == 0 {
		panic("no return value specified for GetBots")
	}

	var r0 []*model.Bot
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.BotGetOptions) ([]*model.Bot, *model.AppError)); ok {
		return rf(options)
	}
	if rf, ok := ret.Get(0).(func(*model.BotGetOptions) []*model.Bot); ok {
		r0 = rf(options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Bot)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.BotGetOptions) *model.AppError); ok {
		r1 = rf(options)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetBundlePath provides a mock function with no fields
func (_m *API) GetBundlePath() (string, error) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetBundlePath")
	}

	var r0 string
	var r1 error
	if rf, ok := ret.Get(0).(func() (string, error)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannel provides a mock function with given fields: channelId
func (_m *API) GetChannel(channelId string) (*model.Channel, *model.AppError) {
	ret := _m.Called(channelId)

	if len(ret) == 0 {
		panic("no return value specified for GetChannel")
	}

	var r0 *model.Channel
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.Channel, *model.AppError)); ok {
		return rf(channelId)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Channel); ok {
		r0 = rf(channelId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(channelId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelByName provides a mock function with given fields: teamID, name, includeDeleted
func (_m *API) GetChannelByName(teamID string, name string, includeDeleted bool) (*model.Channel, *model.AppError) {
	ret := _m.Called(teamID, name, includeDeleted)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelByName")
	}

	var r0 *model.Channel
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, bool) (*model.Channel, *model.AppError)); ok {
		return rf(teamID, name, includeDeleted)
	}
	if rf, ok := ret.Get(0).(func(string, string, bool) *model.Channel); ok {
		r0 = rf(teamID, name, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, bool) *model.AppError); ok {
		r1 = rf(teamID, name, includeDeleted)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelByNameForTeamName provides a mock function with given fields: teamName, channelName, includeDeleted
func (_m *API) GetChannelByNameForTeamName(teamName string, channelName string, includeDeleted bool) (*model.Channel, *model.AppError) {
	ret := _m.Called(teamName, channelName, includeDeleted)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelByNameForTeamName")
	}

	var r0 *model.Channel
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, bool) (*model.Channel, *model.AppError)); ok {
		return rf(teamName, channelName, includeDeleted)
	}
	if rf, ok := ret.Get(0).(func(string, string, bool) *model.Channel); ok {
		r0 = rf(teamName, channelName, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, bool) *model.AppError); ok {
		r1 = rf(teamName, channelName, includeDeleted)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelMember provides a mock function with given fields: channelId, userID
func (_m *API) GetChannelMember(channelId string, userID string) (*model.ChannelMember, *model.AppError) {
	ret := _m.Called(channelId, userID)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelMember")
	}

	var r0 *model.ChannelMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string) (*model.ChannelMember, *model.AppError)); ok {
		return rf(channelId, userID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.ChannelMember); ok {
		r0 = rf(channelId, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(channelId, userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelMembers provides a mock function with given fields: channelId, page, perPage
func (_m *API) GetChannelMembers(channelId string, page int, perPage int) (model.ChannelMembers, *model.AppError) {
	ret := _m.Called(channelId, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelMembers")
	}

	var r0 model.ChannelMembers
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, int, int) (model.ChannelMembers, *model.AppError)); ok {
		return rf(channelId, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, int, int) model.ChannelMembers); ok {
		r0 = rf(channelId, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembers)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(channelId, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelMembersByIds provides a mock function with given fields: channelId, userIds
func (_m *API) GetChannelMembersByIds(channelId string, userIds []string) (model.ChannelMembers, *model.AppError) {
	ret := _m.Called(channelId, userIds)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelMembersByIds")
	}

	var r0 model.ChannelMembers
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []string) (model.ChannelMembers, *model.AppError)); ok {
		return rf(channelId, userIds)
	}
	if rf, ok := ret.Get(0).(func(string, []string) model.ChannelMembers); ok {
		r0 = rf(channelId, userIds)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembers)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string) *model.AppError); ok {
		r1 = rf(channelId, userIds)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelMembersForUser provides a mock function with given fields: teamID, userID, page, perPage
func (_m *API) GetChannelMembersForUser(teamID string, userID string, page int, perPage int) ([]*model.ChannelMember, *model.AppError) {
	ret := _m.Called(teamID, userID, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelMembersForUser")
	}

	var r0 []*model.ChannelMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, int, int) ([]*model.ChannelMember, *model.AppError)); ok {
		return rf(teamID, userID, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, string, int, int) []*model.ChannelMember); ok {
		r0 = rf(teamID, userID, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, int, int) *model.AppError); ok {
		r1 = rf(teamID, userID, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelSidebarCategories provides a mock function with given fields: userID, teamID
func (_m *API) GetChannelSidebarCategories(userID string, teamID string) (*model.OrderedSidebarCategories, *model.AppError) {
	ret := _m.Called(userID, teamID)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelSidebarCategories")
	}

	var r0 *model.OrderedSidebarCategories
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string) (*model.OrderedSidebarCategories, *model.AppError)); ok {
		return rf(userID, teamID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.OrderedSidebarCategories); ok {
		r0 = rf(userID, teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.OrderedSidebarCategories)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(userID, teamID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelStats provides a mock function with given fields: channelId
func (_m *API) GetChannelStats(channelId string) (*model.ChannelStats, *model.AppError) {
	ret := _m.Called(channelId)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelStats")
	}

	var r0 *model.ChannelStats
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.ChannelStats, *model.AppError)); ok {
		return rf(channelId)
	}
	if rf, ok := ret.Get(0).(func(string) *model.ChannelStats); ok {
		r0 = rf(channelId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelStats)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(channelId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelsForTeamForUser provides a mock function with given fields: teamID, userID, includeDeleted
func (_m *API) GetChannelsForTeamForUser(teamID string, userID string, includeDeleted bool) ([]*model.Channel, *model.AppError) {
	ret := _m.Called(teamID, userID, includeDeleted)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelsForTeamForUser")
	}

	var r0 []*model.Channel
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, bool) ([]*model.Channel, *model.AppError)); ok {
		return rf(teamID, userID, includeDeleted)
	}
	if rf, ok := ret.Get(0).(func(string, string, bool) []*model.Channel); ok {
		r0 = rf(teamID, userID, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, bool) *model.AppError); ok {
		r1 = rf(teamID, userID, includeDeleted)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetCloudLimits provides a mock function with no fields
func (_m *API) GetCloudLimits() (*model.ProductLimits, error) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetCloudLimits")
	}

	var r0 *model.ProductLimits
	var r1 error
	if rf, ok := ret.Get(0).(func() (*model.ProductLimits, error)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() *model.ProductLimits); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ProductLimits)
		}
	}

	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetCommand provides a mock function with given fields: commandID
func (_m *API) GetCommand(commandID string) (*model.Command, error) {
	ret := _m.Called(commandID)

	if len(ret) == 0 {
		panic("no return value specified for GetCommand")
	}

	var r0 *model.Command
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (*model.Command, error)); ok {
		return rf(commandID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Command); ok {
		r0 = rf(commandID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Command)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(commandID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetConfig provides a mock function with no fields
func (_m *API) GetConfig() *model.Config {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetConfig")
	}

	var r0 *model.Config
	if rf, ok := ret.Get(0).(func() *model.Config); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Config)
		}
	}

	return r0
}

// GetDiagnosticId provides a mock function with no fields
func (_m *API) GetDiagnosticId() string {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetDiagnosticId")
	}

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// GetDirectChannel provides a mock function with given fields: userId1, userId2
func (_m *API) GetDirectChannel(userId1 string, userId2 string) (*model.Channel, *model.AppError) {
	ret := _m.Called(userId1, userId2)

	if len(ret) == 0 {
		panic("no return value specified for GetDirectChannel")
	}

	var r0 *model.Channel
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string) (*model.Channel, *model.AppError)); ok {
		return rf(userId1, userId2)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.Channel); ok {
		r0 = rf(userId1, userId2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(userId1, userId2)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetEmoji provides a mock function with given fields: emojiId
func (_m *API) GetEmoji(emojiId string) (*model.Emoji, *model.AppError) {
	ret := _m.Called(emojiId)

	if len(ret) == 0 {
		panic("no return value specified for GetEmoji")
	}

	var r0 *model.Emoji
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.Emoji, *model.AppError)); ok {
		return rf(emojiId)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Emoji); ok {
		r0 = rf(emojiId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Emoji)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(emojiId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetEmojiByName provides a mock function with given fields: name
func (_m *API) GetEmojiByName(name string) (*model.Emoji, *model.AppError) {
	ret := _m.Called(name)

	if len(ret) == 0 {
		panic("no return value specified for GetEmojiByName")
	}

	var r0 *model.Emoji
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.Emoji, *model.AppError)); ok {
		return rf(name)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Emoji); ok {
		r0 = rf(name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Emoji)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(name)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetEmojiImage provides a mock function with given fields: emojiId
func (_m *API) GetEmojiImage(emojiId string) ([]byte, string, *model.AppError) {
	ret := _m.Called(emojiId)

	if len(ret) == 0 {
		panic("no return value specified for GetEmojiImage")
	}

	var r0 []byte
	var r1 string
	var r2 *model.AppError
	if rf, ok := ret.Get(0).(func(string) ([]byte, string, *model.AppError)); ok {
		return rf(emojiId)
	}
	if rf, ok := ret.Get(0).(func(string) []byte); ok {
		r0 = rf(emojiId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	if rf, ok := ret.Get(1).(func(string) string); ok {
		r1 = rf(emojiId)
	} else {
		r1 = ret.Get(1).(string)
	}

	if rf, ok := ret.Get(2).(func(string) *model.AppError); ok {
		r2 = rf(emojiId)
	} else {
		if ret.Get(2) != nil {
			r2 = ret.Get(2).(*model.AppError)
		}
	}

	return r0, r1, r2
}

// GetEmojiList provides a mock function with given fields: sortBy, page, perPage
func (_m *API) GetEmojiList(sortBy string, page int, perPage int) ([]*model.Emoji, *model.AppError) {
	ret := _m.Called(sortBy, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for GetEmojiList")
	}

	var r0 []*model.Emoji
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, int, int) ([]*model.Emoji, *model.AppError)); ok {
		return rf(sortBy, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, int, int) []*model.Emoji); ok {
		r0 = rf(sortBy, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Emoji)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(sortBy, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetFile provides a mock function with given fields: fileId
func (_m *API) GetFile(fileId string) ([]byte, *model.AppError) {
	ret := _m.Called(fileId)

	if len(ret) == 0 {
		panic("no return value specified for GetFile")
	}

	var r0 []byte
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) ([]byte, *model.AppError)); ok {
		return rf(fileId)
	}
	if rf, ok := ret.Get(0).(func(string) []byte); ok {
		r0 = rf(fileId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(fileId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetFileInfo provides a mock function with given fields: fileId
func (_m *API) GetFileInfo(fileId string) (*model.FileInfo, *model.AppError) {
	ret := _m.Called(fileId)

	if len(ret) == 0 {
		panic("no return value specified for GetFileInfo")
	}

	var r0 *model.FileInfo
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.FileInfo, *model.AppError)); ok {
		return rf(fileId)
	}
	if rf, ok := ret.Get(0).(func(string) *model.FileInfo); ok {
		r0 = rf(fileId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.FileInfo)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(fileId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetFileInfos provides a mock function with given fields: page, perPage, opt
func (_m *API) GetFileInfos(page int, perPage int, opt *model.GetFileInfosOptions) ([]*model.FileInfo, *model.AppError) {
	ret := _m.Called(page, perPage, opt)

	if len(ret) == 0 {
		panic("no return value specified for GetFileInfos")
	}

	var r0 []*model.FileInfo
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(int, int, *model.GetFileInfosOptions) ([]*model.FileInfo, *model.AppError)); ok {
		return rf(page, perPage, opt)
	}
	if rf, ok := ret.Get(0).(func(int, int, *model.GetFileInfosOptions) []*model.FileInfo); ok {
		r0 = rf(page, perPage, opt)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.FileInfo)
		}
	}

	if rf, ok := ret.Get(1).(func(int, int, *model.GetFileInfosOptions) *model.AppError); ok {
		r1 = rf(page, perPage, opt)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetFileLink provides a mock function with given fields: fileId
func (_m *API) GetFileLink(fileId string) (string, *model.AppError) {
	ret := _m.Called(fileId)

	if len(ret) == 0 {
		panic("no return value specified for GetFileLink")
	}

	var r0 string
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (string, *model.AppError)); ok {
		return rf(fileId)
	}
	if rf, ok := ret.Get(0).(func(string) string); ok {
		r0 = rf(fileId)
	} else {
		r0 = ret.Get(0).(string)
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(fileId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroup provides a mock function with given fields: groupId
func (_m *API) GetGroup(groupId string) (*model.Group, *model.AppError) {
	ret := _m.Called(groupId)

	if len(ret) == 0 {
		panic("no return value specified for GetGroup")
	}

	var r0 *model.Group
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.Group, *model.AppError)); ok {
		return rf(groupId)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Group); ok {
		r0 = rf(groupId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(groupId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroupByName provides a mock function with given fields: name
func (_m *API) GetGroupByName(name string) (*model.Group, *model.AppError) {
	ret := _m.Called(name)

	if len(ret) == 0 {
		panic("no return value specified for GetGroupByName")
	}

	var r0 *model.Group
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.Group, *model.AppError)); ok {
		return rf(name)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Group); ok {
		r0 = rf(name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(name)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroupByRemoteID provides a mock function with given fields: remoteID, groupSource
func (_m *API) GetGroupByRemoteID(remoteID string, groupSource model.GroupSource) (*model.Group, *model.AppError) {
	ret := _m.Called(remoteID, groupSource)

	if len(ret) == 0 {
		panic("no return value specified for GetGroupByRemoteID")
	}

	var r0 *model.Group
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, model.GroupSource) (*model.Group, *model.AppError)); ok {
		return rf(remoteID, groupSource)
	}
	if rf, ok := ret.Get(0).(func(string, model.GroupSource) *model.Group); ok {
		r0 = rf(remoteID, groupSource)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(string, model.GroupSource) *model.AppError); ok {
		r1 = rf(remoteID, groupSource)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroupChannel provides a mock function with given fields: userIds
func (_m *API) GetGroupChannel(userIds []string) (*model.Channel, *model.AppError) {
	ret := _m.Called(userIds)

	if len(ret) == 0 {
		panic("no return value specified for GetGroupChannel")
	}

	var r0 *model.Channel
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func([]string) (*model.Channel, *model.AppError)); ok {
		return rf(userIds)
	}
	if rf, ok := ret.Get(0).(func([]string) *model.Channel); ok {
		r0 = rf(userIds)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func([]string) *model.AppError); ok {
		r1 = rf(userIds)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroupMemberUsers provides a mock function with given fields: groupID, page, perPage
func (_m *API) GetGroupMemberUsers(groupID string, page int, perPage int) ([]*model.User, *model.AppError) {
	ret := _m.Called(groupID, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for GetGroupMemberUsers")
	}

	var r0 []*model.User
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, int, int) ([]*model.User, *model.AppError)); ok {
		return rf(groupID, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, int, int) []*model.User); ok {
		r0 = rf(groupID, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(groupID, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroupSyncable provides a mock function with given fields: groupID, syncableID, syncableType
func (_m *API) GetGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, *model.AppError) {
	ret := _m.Called(groupID, syncableID, syncableType)

	if len(ret) == 0 {
		panic("no return value specified for GetGroupSyncable")
	}

	var r0 *model.GroupSyncable
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, model.GroupSyncableType) (*model.GroupSyncable, *model.AppError)); ok {
		return rf(groupID, syncableID, syncableType)
	}
	if rf, ok := ret.Get(0).(func(string, string, model.GroupSyncableType) *model.GroupSyncable); ok {
		r0 = rf(groupID, syncableID, syncableType)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.GroupSyncable)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, model.GroupSyncableType) *model.AppError); ok {
		r1 = rf(groupID, syncableID, syncableType)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroupSyncables provides a mock function with given fields: groupID, syncableType
func (_m *API) GetGroupSyncables(groupID string, syncableType model.GroupSyncableType) ([]*model.GroupSyncable, *model.AppError) {
	ret := _m.Called(groupID, syncableType)

	if len(ret) == 0 {
		panic("no return value specified for GetGroupSyncables")
	}

	var r0 []*model.GroupSyncable
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, model.GroupSyncableType) ([]*model.GroupSyncable, *model.AppError)); ok {
		return rf(groupID, syncableType)
	}
	if rf, ok := ret.Get(0).(func(string, model.GroupSyncableType) []*model.GroupSyncable); ok {
		r0 = rf(groupID, syncableType)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.GroupSyncable)
		}
	}

	if rf, ok := ret.Get(1).(func(string, model.GroupSyncableType) *model.AppError); ok {
		r1 = rf(groupID, syncableType)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroups provides a mock function with given fields: page, perPage, opts, viewRestrictions
func (_m *API) GetGroups(page int, perPage int, opts model.GroupSearchOpts, viewRestrictions *model.ViewUsersRestrictions) ([]*model.Group, *model.AppError) {
	ret := _m.Called(page, perPage, opts, viewRestrictions)

	if len(ret) == 0 {
		panic("no return value specified for GetGroups")
	}

	var r0 []*model.Group
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(int, int, model.GroupSearchOpts, *model.ViewUsersRestrictions) ([]*model.Group, *model.AppError)); ok {
		return rf(page, perPage, opts, viewRestrictions)
	}
	if rf, ok := ret.Get(0).(func(int, int, model.GroupSearchOpts, *model.ViewUsersRestrictions) []*model.Group); ok {
		r0 = rf(page, perPage, opts, viewRestrictions)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(int, int, model.GroupSearchOpts, *model.ViewUsersRestrictions) *model.AppError); ok {
		r1 = rf(page, perPage, opts, viewRestrictions)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroupsBySource provides a mock function with given fields: groupSource
func (_m *API) GetGroupsBySource(groupSource model.GroupSource) ([]*model.Group, *model.AppError) {
	ret := _m.Called(groupSource)

	if len(ret) == 0 {
		panic("no return value specified for GetGroupsBySource")
	}

	var r0 []*model.Group
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(model.GroupSource) ([]*model.Group, *model.AppError)); ok {
		return rf(groupSource)
	}
	if rf, ok := ret.Get(0).(func(model.GroupSource) []*model.Group); ok {
		r0 = rf(groupSource)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(model.GroupSource) *model.AppError); ok {
		r1 = rf(groupSource)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroupsForUser provides a mock function with given fields: userID
func (_m *API) GetGroupsForUser(userID string) ([]*model.Group, *model.AppError) {
	ret := _m.Called(userID)

	if len(ret) == 0 {
		panic("no return value specified for GetGroupsForUser")
	}

	var r0 []*model.Group
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) ([]*model.Group, *model.AppError)); ok {
		return rf(userID)
	}
	if rf, ok := ret.Get(0).(func(string) []*model.Group); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetLDAPUserAttributes provides a mock function with given fields: userID, attributes
func (_m *API) GetLDAPUserAttributes(userID string, attributes []string) (map[string]string, *model.AppError) {
	ret := _m.Called(userID, attributes)

	if len(ret) == 0 {
		panic("no return value specified for GetLDAPUserAttributes")
	}

	var r0 map[string]string
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []string) (map[string]string, *model.AppError)); ok {
		return rf(userID, attributes)
	}
	if rf, ok := ret.Get(0).(func(string, []string) map[string]string); ok {
		r0 = rf(userID, attributes)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]string)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string) *model.AppError); ok {
		r1 = rf(userID, attributes)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetLicense provides a mock function with no fields
func (_m *API) GetLicense() *model.License {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetLicense")
	}

	var r0 *model.License
	if rf, ok := ret.Get(0).(func() *model.License); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.License)
		}
	}

	return r0
}

// GetOAuthApp provides a mock function with given fields: appID
func (_m *API) GetOAuthApp(appID string) (*model.OAuthApp, *model.AppError) {
	ret := _m.Called(appID)

	if len(ret) == 0 {
		panic("no return value specified for GetOAuthApp")
	}

	var r0 *model.OAuthApp
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.OAuthApp, *model.AppError)); ok {
		return rf(appID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.OAuthApp); ok {
		r0 = rf(appID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.OAuthApp)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(appID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPluginConfig provides a mock function with no fields
func (_m *API) GetPluginConfig() map[string]interface{} {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetPluginConfig")
	}

	var r0 map[string]interface{}
	if rf, ok := ret.Get(0).(func() map[string]interface{}); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]interface{})
		}
	}

	return r0
}

// GetPluginID provides a mock function with no fields
func (_m *API) GetPluginID() string {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetPluginID")
	}

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// GetPluginStatus provides a mock function with given fields: id
func (_m *API) GetPluginStatus(id string) (*model.PluginStatus, *model.AppError) {
	ret := _m.Called(id)

	if len(ret) == 0 {
		panic("no return value specified for GetPluginStatus")
	}

	var r0 *model.PluginStatus
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.PluginStatus, *model.AppError)); ok {
		return rf(id)
	}
	if rf, ok := ret.Get(0).(func(string) *model.PluginStatus); ok {
		r0 = rf(id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PluginStatus)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(id)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPlugins provides a mock function with no fields
func (_m *API) GetPlugins() ([]*model.Manifest, *model.AppError) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetPlugins")
	}

	var r0 []*model.Manifest
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func() ([]*model.Manifest, *model.AppError)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() []*model.Manifest); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Manifest)
		}
	}

	if rf, ok := ret.Get(1).(func() *model.AppError); ok {
		r1 = rf()
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPost provides a mock function with given fields: postId
func (_m *API) GetPost(postId string) (*model.Post, *model.AppError) {
	ret := _m.Called(postId)

	if len(ret) == 0 {
		panic("no return value specified for GetPost")
	}

	var r0 *model.Post
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.Post, *model.AppError)); ok {
		return rf(postId)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Post); ok {
		r0 = rf(postId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Post)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(postId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPostThread provides a mock function with given fields: postId
func (_m *API) GetPostThread(postId string) (*model.PostList, *model.AppError) {
	ret := _m.Called(postId)

	if len(ret) == 0 {
		panic("no return value specified for GetPostThread")
	}

	var r0 *model.PostList
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.PostList, *model.AppError)); ok {
		return rf(postId)
	}
	if rf, ok := ret.Get(0).(func(string) *model.PostList); ok {
		r0 = rf(postId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PostList)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(postId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPostsAfter provides a mock function with given fields: channelId, postId, page, perPage
func (_m *API) GetPostsAfter(channelId string, postId string, page int, perPage int) (*model.PostList, *model.AppError) {
	ret := _m.Called(channelId, postId, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for GetPostsAfter")
	}

	var r0 *model.PostList
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, int, int) (*model.PostList, *model.AppError)); ok {
		return rf(channelId, postId, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, string, int, int) *model.PostList); ok {
		r0 = rf(channelId, postId, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PostList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, int, int) *model.AppError); ok {
		r1 = rf(channelId, postId, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPostsBefore provides a mock function with given fields: channelId, postId, page, perPage
func (_m *API) GetPostsBefore(channelId string, postId string, page int, perPage int) (*model.PostList, *model.AppError) {
	ret := _m.Called(channelId, postId, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for GetPostsBefore")
	}

	var r0 *model.PostList
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, int, int) (*model.PostList, *model.AppError)); ok {
		return rf(channelId, postId, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, string, int, int) *model.PostList); ok {
		r0 = rf(channelId, postId, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PostList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, int, int) *model.AppError); ok {
		r1 = rf(channelId, postId, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPostsForChannel provides a mock function with given fields: channelId, page, perPage
func (_m *API) GetPostsForChannel(channelId string, page int, perPage int) (*model.PostList, *model.AppError) {
	ret := _m.Called(channelId, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for GetPostsForChannel")
	}

	var r0 *model.PostList
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, int, int) (*model.PostList, *model.AppError)); ok {
		return rf(channelId, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, int, int) *model.PostList); ok {
		r0 = rf(channelId, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PostList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(channelId, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPostsSince provides a mock function with given fields: channelId, time
func (_m *API) GetPostsSince(channelId string, time int64) (*model.PostList, *model.AppError) {
	ret := _m.Called(channelId, time)

	if len(ret) == 0 {
		panic("no return value specified for GetPostsSince")
	}

	var r0 *model.PostList
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, int64) (*model.PostList, *model.AppError)); ok {
		return rf(channelId, time)
	}
	if rf, ok := ret.Get(0).(func(string, int64) *model.PostList); ok {
		r0 = rf(channelId, time)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PostList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int64) *model.AppError); ok {
		r1 = rf(channelId, time)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPreferenceForUser provides a mock function with given fields: userID, category, name
func (_m *API) GetPreferenceForUser(userID string, category string, name string) (model.Preference, *model.AppError) {
	ret := _m.Called(userID, category, name)

	if len(ret) == 0 {
		panic("no return value specified for GetPreferenceForUser")
	}

	var r0 model.Preference
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, string) (model.Preference, *model.AppError)); ok {
		return rf(userID, category, name)
	}
	if rf, ok := ret.Get(0).(func(string, string, string) model.Preference); ok {
		r0 = rf(userID, category, name)
	} else {
		r0 = ret.Get(0).(model.Preference)
	}

	if rf, ok := ret.Get(1).(func(string, string, string) *model.AppError); ok {
		r1 = rf(userID, category, name)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPreferencesForUser provides a mock function with given fields: userID
func (_m *API) GetPreferencesForUser(userID string) ([]model.Preference, *model.AppError) {
	ret := _m.Called(userID)

	if len(ret) == 0 {
		panic("no return value specified for GetPreferencesForUser")
	}

	var r0 []model.Preference
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) ([]model.Preference, *model.AppError)); ok {
		return rf(userID)
	}
	if rf, ok := ret.Get(0).(func(string) []model.Preference); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.Preference)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetProfileImage provides a mock function with given fields: userID
func (_m *API) GetProfileImage(userID string) ([]byte, *model.AppError) {
	ret := _m.Called(userID)

	if len(ret) == 0 {
		panic("no return value specified for GetProfileImage")
	}

	var r0 []byte
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) ([]byte, *model.AppError)); ok {
		return rf(userID)
	}
	if rf, ok := ret.Get(0).(func(string) []byte); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPropertyField provides a mock function with given fields: groupID, fieldID
func (_m *API) GetPropertyField(groupID string, fieldID string) (*model.PropertyField, error) {
	ret := _m.Called(groupID, fieldID)

	if len(ret) == 0 {
		panic("no return value specified for GetPropertyField")
	}

	var r0 *model.PropertyField
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (*model.PropertyField, error)); ok {
		return rf(groupID, fieldID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.PropertyField); ok {
		r0 = rf(groupID, fieldID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PropertyField)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(groupID, fieldID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPropertyFieldByName provides a mock function with given fields: groupID, targetID, name
func (_m *API) GetPropertyFieldByName(groupID string, targetID string, name string) (*model.PropertyField, error) {
	ret := _m.Called(groupID, targetID, name)

	if len(ret) == 0 {
		panic("no return value specified for GetPropertyFieldByName")
	}

	var r0 *model.PropertyField
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, string) (*model.PropertyField, error)); ok {
		return rf(groupID, targetID, name)
	}
	if rf, ok := ret.Get(0).(func(string, string, string) *model.PropertyField); ok {
		r0 = rf(groupID, targetID, name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PropertyField)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, string) error); ok {
		r1 = rf(groupID, targetID, name)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPropertyFields provides a mock function with given fields: groupID, ids
func (_m *API) GetPropertyFields(groupID string, ids []string) ([]*model.PropertyField, error) {
	ret := _m.Called(groupID, ids)

	if len(ret) == 0 {
		panic("no return value specified for GetPropertyFields")
	}

	var r0 []*model.PropertyField
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []string) ([]*model.PropertyField, error)); ok {
		return rf(groupID, ids)
	}
	if rf, ok := ret.Get(0).(func(string, []string) []*model.PropertyField); ok {
		r0 = rf(groupID, ids)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.PropertyField)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string) error); ok {
		r1 = rf(groupID, ids)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPropertyGroup provides a mock function with given fields: name
func (_m *API) GetPropertyGroup(name string) (*model.PropertyGroup, error) {
	ret := _m.Called(name)

	if len(ret) == 0 {
		panic("no return value specified for GetPropertyGroup")
	}

	var r0 *model.PropertyGroup
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (*model.PropertyGroup, error)); ok {
		return rf(name)
	}
	if rf, ok := ret.Get(0).(func(string) *model.PropertyGroup); ok {
		r0 = rf(name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PropertyGroup)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(name)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPropertyValue provides a mock function with given fields: groupID, valueID
func (_m *API) GetPropertyValue(groupID string, valueID string) (*model.PropertyValue, error) {
	ret := _m.Called(groupID, valueID)

	if len(ret) == 0 {
		panic("no return value specified for GetPropertyValue")
	}

	var r0 *model.PropertyValue
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (*model.PropertyValue, error)); ok {
		return rf(groupID, valueID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.PropertyValue); ok {
		r0 = rf(groupID, valueID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PropertyValue)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(groupID, valueID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPropertyValues provides a mock function with given fields: groupID, ids
func (_m *API) GetPropertyValues(groupID string, ids []string) ([]*model.PropertyValue, error) {
	ret := _m.Called(groupID, ids)

	if len(ret) == 0 {
		panic("no return value specified for GetPropertyValues")
	}

	var r0 []*model.PropertyValue
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []string) ([]*model.PropertyValue, error)); ok {
		return rf(groupID, ids)
	}
	if rf, ok := ret.Get(0).(func(string, []string) []*model.PropertyValue); ok {
		r0 = rf(groupID, ids)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.PropertyValue)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string) error); ok {
		r1 = rf(groupID, ids)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPublicChannelsForTeam provides a mock function with given fields: teamID, page, perPage
func (_m *API) GetPublicChannelsForTeam(teamID string, page int, perPage int) ([]*model.Channel, *model.AppError) {
	ret := _m.Called(teamID, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for GetPublicChannelsForTeam")
	}

	var r0 []*model.Channel
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, int, int) ([]*model.Channel, *model.AppError)); ok {
		return rf(teamID, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, int, int) []*model.Channel); ok {
		r0 = rf(teamID, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(teamID, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetReactions provides a mock function with given fields: postId
func (_m *API) GetReactions(postId string) ([]*model.Reaction, *model.AppError) {
	ret := _m.Called(postId)

	if len(ret) == 0 {
		panic("no return value specified for GetReactions")
	}

	var r0 []*model.Reaction
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) ([]*model.Reaction, *model.AppError)); ok {
		return rf(postId)
	}
	if rf, ok := ret.Get(0).(func(string) []*model.Reaction); ok {
		r0 = rf(postId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Reaction)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(postId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetServerVersion provides a mock function with no fields
func (_m *API) GetServerVersion() string {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetServerVersion")
	}

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// GetSession provides a mock function with given fields: sessionID
func (_m *API) GetSession(sessionID string) (*model.Session, *model.AppError) {
	ret := _m.Called(sessionID)

	if len(ret) == 0 {
		panic("no return value specified for GetSession")
	}

	var r0 *model.Session
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.Session, *model.AppError)); ok {
		return rf(sessionID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Session); ok {
		r0 = rf(sessionID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Session)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(sessionID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetSystemInstallDate provides a mock function with no fields
func (_m *API) GetSystemInstallDate() (int64, *model.AppError) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetSystemInstallDate")
	}

	var r0 int64
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func() (int64, *model.AppError)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func() *model.AppError); ok {
		r1 = rf()
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeam provides a mock function with given fields: teamID
func (_m *API) GetTeam(teamID string) (*model.Team, *model.AppError) {
	ret := _m.Called(teamID)

	if len(ret) == 0 {
		panic("no return value specified for GetTeam")
	}

	var r0 *model.Team
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.Team, *model.AppError)); ok {
		return rf(teamID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Team); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Team)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(teamID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamByName provides a mock function with given fields: name
func (_m *API) GetTeamByName(name string) (*model.Team, *model.AppError) {
	ret := _m.Called(name)

	if len(ret) == 0 {
		panic("no return value specified for GetTeamByName")
	}

	var r0 *model.Team
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.Team, *model.AppError)); ok {
		return rf(name)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Team); ok {
		r0 = rf(name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Team)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(name)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamIcon provides a mock function with given fields: teamID
func (_m *API) GetTeamIcon(teamID string) ([]byte, *model.AppError) {
	ret := _m.Called(teamID)

	if len(ret) == 0 {
		panic("no return value specified for GetTeamIcon")
	}

	var r0 []byte
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) ([]byte, *model.AppError)); ok {
		return rf(teamID)
	}
	if rf, ok := ret.Get(0).(func(string) []byte); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(teamID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamMember provides a mock function with given fields: teamID, userID
func (_m *API) GetTeamMember(teamID string, userID string) (*model.TeamMember, *model.AppError) {
	ret := _m.Called(teamID, userID)

	if len(ret) == 0 {
		panic("no return value specified for GetTeamMember")
	}

	var r0 *model.TeamMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string) (*model.TeamMember, *model.AppError)); ok {
		return rf(teamID, userID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.TeamMember); ok {
		r0 = rf(teamID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.TeamMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(teamID, userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamMembers provides a mock function with given fields: teamID, page, perPage
func (_m *API) GetTeamMembers(teamID string, page int, perPage int) ([]*model.TeamMember, *model.AppError) {
	ret := _m.Called(teamID, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for GetTeamMembers")
	}

	var r0 []*model.TeamMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, int, int) ([]*model.TeamMember, *model.AppError)); ok {
		return rf(teamID, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, int, int) []*model.TeamMember); ok {
		r0 = rf(teamID, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.TeamMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(teamID, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamMembersForUser provides a mock function with given fields: userID, page, perPage
func (_m *API) GetTeamMembersForUser(userID string, page int, perPage int) ([]*model.TeamMember, *model.AppError) {
	ret := _m.Called(userID, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for GetTeamMembersForUser")
	}

	var r0 []*model.TeamMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, int, int) ([]*model.TeamMember, *model.AppError)); ok {
		return rf(userID, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, int, int) []*model.TeamMember); ok {
		r0 = rf(userID, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.TeamMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(userID, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamStats provides a mock function with given fields: teamID
func (_m *API) GetTeamStats(teamID string) (*model.TeamStats, *model.AppError) {
	ret := _m.Called(teamID)

	if len(ret) == 0 {
		panic("no return value specified for GetTeamStats")
	}

	var r0 *model.TeamStats
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.TeamStats, *model.AppError)); ok {
		return rf(teamID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.TeamStats); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.TeamStats)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(teamID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeams provides a mock function with no fields
func (_m *API) GetTeams() ([]*model.Team, *model.AppError) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetTeams")
	}

	var r0 []*model.Team
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func() ([]*model.Team, *model.AppError)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() []*model.Team); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Team)
		}
	}

	if rf, ok := ret.Get(1).(func() *model.AppError); ok {
		r1 = rf()
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamsForUser provides a mock function with given fields: userID
func (_m *API) GetTeamsForUser(userID string) ([]*model.Team, *model.AppError) {
	ret := _m.Called(userID)

	if len(ret) == 0 {
		panic("no return value specified for GetTeamsForUser")
	}

	var r0 []*model.Team
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) ([]*model.Team, *model.AppError)); ok {
		return rf(userID)
	}
	if rf, ok := ret.Get(0).(func(string) []*model.Team); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Team)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamsUnreadForUser provides a mock function with given fields: userID
func (_m *API) GetTeamsUnreadForUser(userID string) ([]*model.TeamUnread, *model.AppError) {
	ret := _m.Called(userID)

	if len(ret) == 0 {
		panic("no return value specified for GetTeamsUnreadForUser")
	}

	var r0 []*model.TeamUnread
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) ([]*model.TeamUnread, *model.AppError)); ok {
		return rf(userID)
	}
	if rf, ok := ret.Get(0).(func(string) []*model.TeamUnread); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.TeamUnread)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTelemetryId provides a mock function with no fields
func (_m *API) GetTelemetryId() string {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetTelemetryId")
	}

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// GetUnsanitizedConfig provides a mock function with no fields
func (_m *API) GetUnsanitizedConfig() *model.Config {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetUnsanitizedConfig")
	}

	var r0 *model.Config
	if rf, ok := ret.Get(0).(func() *model.Config); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Config)
		}
	}

	return r0
}

// GetUploadSession provides a mock function with given fields: uploadID
func (_m *API) GetUploadSession(uploadID string) (*model.UploadSession, error) {
	ret := _m.Called(uploadID)

	if len(ret) == 0 {
		panic("no return value specified for GetUploadSession")
	}

	var r0 *model.UploadSession
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (*model.UploadSession, error)); ok {
		return rf(uploadID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.UploadSession); ok {
		r0 = rf(uploadID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.UploadSession)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(uploadID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUser provides a mock function with given fields: userID
func (_m *API) GetUser(userID string) (*model.User, *model.AppError) {
	ret := _m.Called(userID)

	if len(ret) == 0 {
		panic("no return value specified for GetUser")
	}

	var r0 *model.User
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.User, *model.AppError)); ok {
		return rf(userID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.User); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUserByEmail provides a mock function with given fields: email
func (_m *API) GetUserByEmail(email string) (*model.User, *model.AppError) {
	ret := _m.Called(email)

	if len(ret) == 0 {
		panic("no return value specified for GetUserByEmail")
	}

	var r0 *model.User
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.User, *model.AppError)); ok {
		return rf(email)
	}
	if rf, ok := ret.Get(0).(func(string) *model.User); ok {
		r0 = rf(email)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(email)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUserByUsername provides a mock function with given fields: name
func (_m *API) GetUserByUsername(name string) (*model.User, *model.AppError) {
	ret := _m.Called(name)

	if len(ret) == 0 {
		panic("no return value specified for GetUserByUsername")
	}

	var r0 *model.User
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.User, *model.AppError)); ok {
		return rf(name)
	}
	if rf, ok := ret.Get(0).(func(string) *model.User); ok {
		r0 = rf(name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(name)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUserStatus provides a mock function with given fields: userID
func (_m *API) GetUserStatus(userID string) (*model.Status, *model.AppError) {
	ret := _m.Called(userID)

	if len(ret) == 0 {
		panic("no return value specified for GetUserStatus")
	}

	var r0 *model.Status
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.Status, *model.AppError)); ok {
		return rf(userID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Status); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Status)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUserStatusesByIds provides a mock function with given fields: userIds
func (_m *API) GetUserStatusesByIds(userIds []string) ([]*model.Status, *model.AppError) {
	ret := _m.Called(userIds)

	if len(ret) == 0 {
		panic("no return value specified for GetUserStatusesByIds")
	}

	var r0 []*model.Status
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func([]string) ([]*model.Status, *model.AppError)); ok {
		return rf(userIds)
	}
	if rf, ok := ret.Get(0).(func([]string) []*model.Status); ok {
		r0 = rf(userIds)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Status)
		}
	}

	if rf, ok := ret.Get(1).(func([]string) *model.AppError); ok {
		r1 = rf(userIds)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUsers provides a mock function with given fields: options
func (_m *API) GetUsers(options *model.UserGetOptions) ([]*model.User, *model.AppError) {
	ret := _m.Called(options)

	if len(ret) == 0 {
		panic("no return value specified for GetUsers")
	}

	var r0 []*model.User
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.UserGetOptions) ([]*model.User, *model.AppError)); ok {
		return rf(options)
	}
	if rf, ok := ret.Get(0).(func(*model.UserGetOptions) []*model.User); ok {
		r0 = rf(options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.UserGetOptions) *model.AppError); ok {
		r1 = rf(options)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUsersByIds provides a mock function with given fields: userIDs
func (_m *API) GetUsersByIds(userIDs []string) ([]*model.User, *model.AppError) {
	ret := _m.Called(userIDs)

	if len(ret) == 0 {
		panic("no return value specified for GetUsersByIds")
	}

	var r0 []*model.User
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func([]string) ([]*model.User, *model.AppError)); ok {
		return rf(userIDs)
	}
	if rf, ok := ret.Get(0).(func([]string) []*model.User); ok {
		r0 = rf(userIDs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func([]string) *model.AppError); ok {
		r1 = rf(userIDs)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUsersByUsernames provides a mock function with given fields: usernames
func (_m *API) GetUsersByUsernames(usernames []string) ([]*model.User, *model.AppError) {
	ret := _m.Called(usernames)

	if len(ret) == 0 {
		panic("no return value specified for GetUsersByUsernames")
	}

	var r0 []*model.User
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func([]string) ([]*model.User, *model.AppError)); ok {
		return rf(usernames)
	}
	if rf, ok := ret.Get(0).(func([]string) []*model.User); ok {
		r0 = rf(usernames)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func([]string) *model.AppError); ok {
		r1 = rf(usernames)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUsersInChannel provides a mock function with given fields: channelID, sortBy, page, perPage
func (_m *API) GetUsersInChannel(channelID string, sortBy string, page int, perPage int) ([]*model.User, *model.AppError) {
	ret := _m.Called(channelID, sortBy, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for GetUsersInChannel")
	}

	var r0 []*model.User
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, int, int) ([]*model.User, *model.AppError)); ok {
		return rf(channelID, sortBy, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, string, int, int) []*model.User); ok {
		r0 = rf(channelID, sortBy, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, int, int) *model.AppError); ok {
		r1 = rf(channelID, sortBy, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUsersInTeam provides a mock function with given fields: teamID, page, perPage
func (_m *API) GetUsersInTeam(teamID string, page int, perPage int) ([]*model.User, *model.AppError) {
	ret := _m.Called(teamID, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for GetUsersInTeam")
	}

	var r0 []*model.User
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, int, int) ([]*model.User, *model.AppError)); ok {
		return rf(teamID, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, int, int) []*model.User); ok {
		r0 = rf(teamID, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(teamID, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// HasPermissionTo provides a mock function with given fields: userID, permission
func (_m *API) HasPermissionTo(userID string, permission *model.Permission) bool {
	ret := _m.Called(userID, permission)

	if len(ret) == 0 {
		panic("no return value specified for HasPermissionTo")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func(string, *model.Permission) bool); ok {
		r0 = rf(userID, permission)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// HasPermissionToChannel provides a mock function with given fields: userID, channelId, permission
func (_m *API) HasPermissionToChannel(userID string, channelId string, permission *model.Permission) bool {
	ret := _m.Called(userID, channelId, permission)

	if len(ret) == 0 {
		panic("no return value specified for HasPermissionToChannel")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func(string, string, *model.Permission) bool); ok {
		r0 = rf(userID, channelId, permission)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// HasPermissionToTeam provides a mock function with given fields: userID, teamID, permission
func (_m *API) HasPermissionToTeam(userID string, teamID string, permission *model.Permission) bool {
	ret := _m.Called(userID, teamID, permission)

	if len(ret) == 0 {
		panic("no return value specified for HasPermissionToTeam")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func(string, string, *model.Permission) bool); ok {
		r0 = rf(userID, teamID, permission)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// InstallPlugin provides a mock function with given fields: file, replace
func (_m *API) InstallPlugin(file io.Reader, replace bool) (*model.Manifest, *model.AppError) {
	ret := _m.Called(file, replace)

	if len(ret) == 0 {
		panic("no return value specified for InstallPlugin")
	}

	var r0 *model.Manifest
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(io.Reader, bool) (*model.Manifest, *model.AppError)); ok {
		return rf(file, replace)
	}
	if rf, ok := ret.Get(0).(func(io.Reader, bool) *model.Manifest); ok {
		r0 = rf(file, replace)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Manifest)
		}
	}

	if rf, ok := ret.Get(1).(func(io.Reader, bool) *model.AppError); ok {
		r1 = rf(file, replace)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// InviteRemoteToChannel provides a mock function with given fields: channelID, remoteID, userID, shareIfNotShared
func (_m *API) InviteRemoteToChannel(channelID string, remoteID string, userID string, shareIfNotShared bool) error {
	ret := _m.Called(channelID, remoteID, userID, shareIfNotShared)

	if len(ret) == 0 {
		panic("no return value specified for InviteRemoteToChannel")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string, string, bool) error); ok {
		r0 = rf(channelID, remoteID, userID, shareIfNotShared)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// IsEnterpriseReady provides a mock function with no fields
func (_m *API) IsEnterpriseReady() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsEnterpriseReady")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// KVCompareAndDelete provides a mock function with given fields: key, oldValue
func (_m *API) KVCompareAndDelete(key string, oldValue []byte) (bool, *model.AppError) {
	ret := _m.Called(key, oldValue)

	if len(ret) == 0 {
		panic("no return value specified for KVCompareAndDelete")
	}

	var r0 bool
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []byte) (bool, *model.AppError)); ok {
		return rf(key, oldValue)
	}
	if rf, ok := ret.Get(0).(func(string, []byte) bool); ok {
		r0 = rf(key, oldValue)
	} else {
		r0 = ret.Get(0).(bool)
	}

	if rf, ok := ret.Get(1).(func(string, []byte) *model.AppError); ok {
		r1 = rf(key, oldValue)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// KVCompareAndSet provides a mock function with given fields: key, oldValue, newValue
func (_m *API) KVCompareAndSet(key string, oldValue []byte, newValue []byte) (bool, *model.AppError) {
	ret := _m.Called(key, oldValue, newValue)

	if len(ret) == 0 {
		panic("no return value specified for KVCompareAndSet")
	}

	var r0 bool
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []byte, []byte) (bool, *model.AppError)); ok {
		return rf(key, oldValue, newValue)
	}
	if rf, ok := ret.Get(0).(func(string, []byte, []byte) bool); ok {
		r0 = rf(key, oldValue, newValue)
	} else {
		r0 = ret.Get(0).(bool)
	}

	if rf, ok := ret.Get(1).(func(string, []byte, []byte) *model.AppError); ok {
		r1 = rf(key, oldValue, newValue)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// KVDelete provides a mock function with given fields: key
func (_m *API) KVDelete(key string) *model.AppError {
	ret := _m.Called(key)

	if len(ret) == 0 {
		panic("no return value specified for KVDelete")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(key)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// KVDeleteAll provides a mock function with no fields
func (_m *API) KVDeleteAll() *model.AppError {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for KVDeleteAll")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func() *model.AppError); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// KVGet provides a mock function with given fields: key
func (_m *API) KVGet(key string) ([]byte, *model.AppError) {
	ret := _m.Called(key)

	if len(ret) == 0 {
		panic("no return value specified for KVGet")
	}

	var r0 []byte
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) ([]byte, *model.AppError)); ok {
		return rf(key)
	}
	if rf, ok := ret.Get(0).(func(string) []byte); ok {
		r0 = rf(key)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(key)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// KVList provides a mock function with given fields: page, perPage
func (_m *API) KVList(page int, perPage int) ([]string, *model.AppError) {
	ret := _m.Called(page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for KVList")
	}

	var r0 []string
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(int, int) ([]string, *model.AppError)); ok {
		return rf(page, perPage)
	}
	if rf, ok := ret.Get(0).(func(int, int) []string); ok {
		r0 = rf(page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	if rf, ok := ret.Get(1).(func(int, int) *model.AppError); ok {
		r1 = rf(page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// KVSet provides a mock function with given fields: key, value
func (_m *API) KVSet(key string, value []byte) *model.AppError {
	ret := _m.Called(key, value)

	if len(ret) == 0 {
		panic("no return value specified for KVSet")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []byte) *model.AppError); ok {
		r0 = rf(key, value)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// KVSetWithExpiry provides a mock function with given fields: key, value, expireInSeconds
func (_m *API) KVSetWithExpiry(key string, value []byte, expireInSeconds int64) *model.AppError {
	ret := _m.Called(key, value, expireInSeconds)

	if len(ret) == 0 {
		panic("no return value specified for KVSetWithExpiry")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []byte, int64) *model.AppError); ok {
		r0 = rf(key, value, expireInSeconds)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// KVSetWithOptions provides a mock function with given fields: key, value, options
func (_m *API) KVSetWithOptions(key string, value []byte, options model.PluginKVSetOptions) (bool, *model.AppError) {
	ret := _m.Called(key, value, options)

	if len(ret) == 0 {
		panic("no return value specified for KVSetWithOptions")
	}

	var r0 bool
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []byte, model.PluginKVSetOptions) (bool, *model.AppError)); ok {
		return rf(key, value, options)
	}
	if rf, ok := ret.Get(0).(func(string, []byte, model.PluginKVSetOptions) bool); ok {
		r0 = rf(key, value, options)
	} else {
		r0 = ret.Get(0).(bool)
	}

	if rf, ok := ret.Get(1).(func(string, []byte, model.PluginKVSetOptions) *model.AppError); ok {
		r1 = rf(key, value, options)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// ListBuiltInCommands provides a mock function with no fields
func (_m *API) ListBuiltInCommands() ([]*model.Command, error) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for ListBuiltInCommands")
	}

	var r0 []*model.Command
	var r1 error
	if rf, ok := ret.Get(0).(func() ([]*model.Command, error)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() []*model.Command); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Command)
		}
	}

	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListCommands provides a mock function with given fields: teamID
func (_m *API) ListCommands(teamID string) ([]*model.Command, error) {
	ret := _m.Called(teamID)

	if len(ret) == 0 {
		panic("no return value specified for ListCommands")
	}

	var r0 []*model.Command
	var r1 error
	if rf, ok := ret.Get(0).(func(string) ([]*model.Command, error)); ok {
		return rf(teamID)
	}
	if rf, ok := ret.Get(0).(func(string) []*model.Command); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Command)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListCustomCommands provides a mock function with given fields: teamID
func (_m *API) ListCustomCommands(teamID string) ([]*model.Command, error) {
	ret := _m.Called(teamID)

	if len(ret) == 0 {
		panic("no return value specified for ListCustomCommands")
	}

	var r0 []*model.Command
	var r1 error
	if rf, ok := ret.Get(0).(func(string) ([]*model.Command, error)); ok {
		return rf(teamID)
	}
	if rf, ok := ret.Get(0).(func(string) []*model.Command); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Command)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListPluginCommands provides a mock function with given fields: teamID
func (_m *API) ListPluginCommands(teamID string) ([]*model.Command, error) {
	ret := _m.Called(teamID)

	if len(ret) == 0 {
		panic("no return value specified for ListPluginCommands")
	}

	var r0 []*model.Command
	var r1 error
	if rf, ok := ret.Get(0).(func(string) ([]*model.Command, error)); ok {
		return rf(teamID)
	}
	if rf, ok := ret.Get(0).(func(string) []*model.Command); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Command)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// LoadPluginConfiguration provides a mock function with given fields: dest
func (_m *API) LoadPluginConfiguration(dest interface{}) error {
	ret := _m.Called(dest)

	if len(ret) == 0 {
		panic("no return value specified for LoadPluginConfiguration")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(interface{}) error); ok {
		r0 = rf(dest)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// LogAuditRec provides a mock function with given fields: rec
func (_m *API) LogAuditRec(rec *model.AuditRecord) {
	_m.Called(rec)
}

// LogAuditRecWithLevel provides a mock function with given fields: rec, level
func (_m *API) LogAuditRecWithLevel(rec *model.AuditRecord, level logr.Level) {
	_m.Called(rec, level)
}

// LogDebug provides a mock function with given fields: msg, keyValuePairs
func (_m *API) LogDebug(msg string, keyValuePairs ...interface{}) {
	var _ca []interface{}
	_ca = append(_ca, msg)
	_ca = append(_ca, keyValuePairs...)
	_m.Called(_ca...)
}

// LogError provides a mock function with given fields: msg, keyValuePairs
func (_m *API) LogError(msg string, keyValuePairs ...interface{}) {
	var _ca []interface{}
	_ca = append(_ca, msg)
	_ca = append(_ca, keyValuePairs...)
	_m.Called(_ca...)
}

// LogInfo provides a mock function with given fields: msg, keyValuePairs
func (_m *API) LogInfo(msg string, keyValuePairs ...interface{}) {
	var _ca []interface{}
	_ca = append(_ca, msg)
	_ca = append(_ca, keyValuePairs...)
	_m.Called(_ca...)
}

// LogWarn provides a mock function with given fields: msg, keyValuePairs
func (_m *API) LogWarn(msg string, keyValuePairs ...interface{}) {
	var _ca []interface{}
	_ca = append(_ca, msg)
	_ca = append(_ca, keyValuePairs...)
	_m.Called(_ca...)
}

// OpenInteractiveDialog provides a mock function with given fields: dialog
func (_m *API) OpenInteractiveDialog(dialog model.OpenDialogRequest) *model.AppError {
	ret := _m.Called(dialog)

	if len(ret) == 0 {
		panic("no return value specified for OpenInteractiveDialog")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(model.OpenDialogRequest) *model.AppError); ok {
		r0 = rf(dialog)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// PatchBot provides a mock function with given fields: botUserId, botPatch
func (_m *API) PatchBot(botUserId string, botPatch *model.BotPatch) (*model.Bot, *model.AppError) {
	ret := _m.Called(botUserId, botPatch)

	if len(ret) == 0 {
		panic("no return value specified for PatchBot")
	}

	var r0 *model.Bot
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, *model.BotPatch) (*model.Bot, *model.AppError)); ok {
		return rf(botUserId, botPatch)
	}
	if rf, ok := ret.Get(0).(func(string, *model.BotPatch) *model.Bot); ok {
		r0 = rf(botUserId, botPatch)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Bot)
		}
	}

	if rf, ok := ret.Get(1).(func(string, *model.BotPatch) *model.AppError); ok {
		r1 = rf(botUserId, botPatch)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// PatchChannelMembersNotifications provides a mock function with given fields: members, notifyProps
func (_m *API) PatchChannelMembersNotifications(members []*model.ChannelMemberIdentifier, notifyProps map[string]string) *model.AppError {
	ret := _m.Called(members, notifyProps)

	if len(ret) == 0 {
		panic("no return value specified for PatchChannelMembersNotifications")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func([]*model.ChannelMemberIdentifier, map[string]string) *model.AppError); ok {
		r0 = rf(members, notifyProps)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// PermanentDeleteBot provides a mock function with given fields: botUserId
func (_m *API) PermanentDeleteBot(botUserId string) *model.AppError {
	ret := _m.Called(botUserId)

	if len(ret) == 0 {
		panic("no return value specified for PermanentDeleteBot")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(botUserId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// PluginHTTP provides a mock function with given fields: request
func (_m *API) PluginHTTP(request *http.Request) *http.Response {
	ret := _m.Called(request)

	if len(ret) == 0 {
		panic("no return value specified for PluginHTTP")
	}

	var r0 *http.Response
	if rf, ok := ret.Get(0).(func(*http.Request) *http.Response); ok {
		r0 = rf(request)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*http.Response)
		}
	}

	return r0
}

// PublishPluginClusterEvent provides a mock function with given fields: ev, opts
func (_m *API) PublishPluginClusterEvent(ev model.PluginClusterEvent, opts model.PluginClusterEventSendOptions) error {
	ret := _m.Called(ev, opts)

	if len(ret) == 0 {
		panic("no return value specified for PublishPluginClusterEvent")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(model.PluginClusterEvent, model.PluginClusterEventSendOptions) error); ok {
		r0 = rf(ev, opts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PublishUserTyping provides a mock function with given fields: userID, channelId, parentId
func (_m *API) PublishUserTyping(userID string, channelId string, parentId string) *model.AppError {
	ret := _m.Called(userID, channelId, parentId)

	if len(ret) == 0 {
		panic("no return value specified for PublishUserTyping")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, string) *model.AppError); ok {
		r0 = rf(userID, channelId, parentId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// PublishWebSocketEvent provides a mock function with given fields: event, payload, broadcast
func (_m *API) PublishWebSocketEvent(event string, payload map[string]interface{}, broadcast *model.WebsocketBroadcast) {
	_m.Called(event, payload, broadcast)
}

// ReadFile provides a mock function with given fields: path
func (_m *API) ReadFile(path string) ([]byte, *model.AppError) {
	ret := _m.Called(path)

	if len(ret) == 0 {
		panic("no return value specified for ReadFile")
	}

	var r0 []byte
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) ([]byte, *model.AppError)); ok {
		return rf(path)
	}
	if rf, ok := ret.Get(0).(func(string) []byte); ok {
		r0 = rf(path)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(path)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// RegisterCollectionAndTopic provides a mock function with given fields: collectionType, topicType
func (_m *API) RegisterCollectionAndTopic(collectionType string, topicType string) error {
	ret := _m.Called(collectionType, topicType)

	if len(ret) == 0 {
		panic("no return value specified for RegisterCollectionAndTopic")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string) error); ok {
		r0 = rf(collectionType, topicType)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RegisterCommand provides a mock function with given fields: command
func (_m *API) RegisterCommand(command *model.Command) error {
	ret := _m.Called(command)

	if len(ret) == 0 {
		panic("no return value specified for RegisterCommand")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(*model.Command) error); ok {
		r0 = rf(command)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RegisterPluginForSharedChannels provides a mock function with given fields: opts
func (_m *API) RegisterPluginForSharedChannels(opts model.RegisterPluginOpts) (string, error) {
	ret := _m.Called(opts)

	if len(ret) == 0 {
		panic("no return value specified for RegisterPluginForSharedChannels")
	}

	var r0 string
	var r1 error
	if rf, ok := ret.Get(0).(func(model.RegisterPluginOpts) (string, error)); ok {
		return rf(opts)
	}
	if rf, ok := ret.Get(0).(func(model.RegisterPluginOpts) string); ok {
		r0 = rf(opts)
	} else {
		r0 = ret.Get(0).(string)
	}

	if rf, ok := ret.Get(1).(func(model.RegisterPluginOpts) error); ok {
		r1 = rf(opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RegisterPropertyGroup provides a mock function with given fields: name
func (_m *API) RegisterPropertyGroup(name string) (*model.PropertyGroup, error) {
	ret := _m.Called(name)

	if len(ret) == 0 {
		panic("no return value specified for RegisterPropertyGroup")
	}

	var r0 *model.PropertyGroup
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (*model.PropertyGroup, error)); ok {
		return rf(name)
	}
	if rf, ok := ret.Get(0).(func(string) *model.PropertyGroup); ok {
		r0 = rf(name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PropertyGroup)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(name)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RemovePlugin provides a mock function with given fields: id
func (_m *API) RemovePlugin(id string) *model.AppError {
	ret := _m.Called(id)

	if len(ret) == 0 {
		panic("no return value specified for RemovePlugin")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// RemoveReaction provides a mock function with given fields: reaction
func (_m *API) RemoveReaction(reaction *model.Reaction) *model.AppError {
	ret := _m.Called(reaction)

	if len(ret) == 0 {
		panic("no return value specified for RemoveReaction")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Reaction) *model.AppError); ok {
		r0 = rf(reaction)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// RemoveTeamIcon provides a mock function with given fields: teamID
func (_m *API) RemoveTeamIcon(teamID string) *model.AppError {
	ret := _m.Called(teamID)

	if len(ret) == 0 {
		panic("no return value specified for RemoveTeamIcon")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// RemoveUserCustomStatus provides a mock function with given fields: userID
func (_m *API) RemoveUserCustomStatus(userID string) *model.AppError {
	ret := _m.Called(userID)

	if len(ret) == 0 {
		panic("no return value specified for RemoveUserCustomStatus")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// RequestTrialLicense provides a mock function with given fields: requesterID, users, termsAccepted, receiveEmailsAccepted
func (_m *API) RequestTrialLicense(requesterID string, users int, termsAccepted bool, receiveEmailsAccepted bool) *model.AppError {
	ret := _m.Called(requesterID, users, termsAccepted, receiveEmailsAccepted)

	if len(ret) == 0 {
		panic("no return value specified for RequestTrialLicense")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, int, bool, bool) *model.AppError); ok {
		r0 = rf(requesterID, users, termsAccepted, receiveEmailsAccepted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// RestoreGroup provides a mock function with given fields: groupID
func (_m *API) RestoreGroup(groupID string) (*model.Group, *model.AppError) {
	ret := _m.Called(groupID)

	if len(ret) == 0 {
		panic("no return value specified for RestoreGroup")
	}

	var r0 *model.Group
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) (*model.Group, *model.AppError)); ok {
		return rf(groupID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Group); ok {
		r0 = rf(groupID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(groupID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// RevokeSession provides a mock function with given fields: sessionID
func (_m *API) RevokeSession(sessionID string) *model.AppError {
	ret := _m.Called(sessionID)

	if len(ret) == 0 {
		panic("no return value specified for RevokeSession")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(sessionID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// RevokeUserAccessToken provides a mock function with given fields: tokenID
func (_m *API) RevokeUserAccessToken(tokenID string) *model.AppError {
	ret := _m.Called(tokenID)

	if len(ret) == 0 {
		panic("no return value specified for RevokeUserAccessToken")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(tokenID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// RolesGrantPermission provides a mock function with given fields: roleNames, permissionId
func (_m *API) RolesGrantPermission(roleNames []string, permissionId string) bool {
	ret := _m.Called(roleNames, permissionId)

	if len(ret) == 0 {
		panic("no return value specified for RolesGrantPermission")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func([]string, string) bool); ok {
		r0 = rf(roleNames, permissionId)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// SaveConfig provides a mock function with given fields: config
func (_m *API) SaveConfig(config *model.Config) *model.AppError {
	ret := _m.Called(config)

	if len(ret) == 0 {
		panic("no return value specified for SaveConfig")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Config) *model.AppError); ok {
		r0 = rf(config)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// SavePluginConfig provides a mock function with given fields: config
func (_m *API) SavePluginConfig(config map[string]interface{}) *model.AppError {
	ret := _m.Called(config)

	if len(ret) == 0 {
		panic("no return value specified for SavePluginConfig")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(map[string]interface{}) *model.AppError); ok {
		r0 = rf(config)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// SearchChannels provides a mock function with given fields: teamID, term
func (_m *API) SearchChannels(teamID string, term string) ([]*model.Channel, *model.AppError) {
	ret := _m.Called(teamID, term)

	if len(ret) == 0 {
		panic("no return value specified for SearchChannels")
	}

	var r0 []*model.Channel
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string) ([]*model.Channel, *model.AppError)); ok {
		return rf(teamID, term)
	}
	if rf, ok := ret.Get(0).(func(string, string) []*model.Channel); ok {
		r0 = rf(teamID, term)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(teamID, term)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// SearchPostsInTeam provides a mock function with given fields: teamID, paramsList
func (_m *API) SearchPostsInTeam(teamID string, paramsList []*model.SearchParams) ([]*model.Post, *model.AppError) {
	ret := _m.Called(teamID, paramsList)

	if len(ret) == 0 {
		panic("no return value specified for SearchPostsInTeam")
	}

	var r0 []*model.Post
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []*model.SearchParams) ([]*model.Post, *model.AppError)); ok {
		return rf(teamID, paramsList)
	}
	if rf, ok := ret.Get(0).(func(string, []*model.SearchParams) []*model.Post); ok {
		r0 = rf(teamID, paramsList)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Post)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []*model.SearchParams) *model.AppError); ok {
		r1 = rf(teamID, paramsList)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// SearchPostsInTeamForUser provides a mock function with given fields: teamID, userID, searchParams
func (_m *API) SearchPostsInTeamForUser(teamID string, userID string, searchParams model.SearchParameter) (*model.PostSearchResults, *model.AppError) {
	ret := _m.Called(teamID, userID, searchParams)

	if len(ret) == 0 {
		panic("no return value specified for SearchPostsInTeamForUser")
	}

	var r0 *model.PostSearchResults
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, model.SearchParameter) (*model.PostSearchResults, *model.AppError)); ok {
		return rf(teamID, userID, searchParams)
	}
	if rf, ok := ret.Get(0).(func(string, string, model.SearchParameter) *model.PostSearchResults); ok {
		r0 = rf(teamID, userID, searchParams)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PostSearchResults)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, model.SearchParameter) *model.AppError); ok {
		r1 = rf(teamID, userID, searchParams)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// SearchPropertyFields provides a mock function with given fields: groupID, opts
func (_m *API) SearchPropertyFields(groupID string, opts model.PropertyFieldSearchOpts) ([]*model.PropertyField, error) {
	ret := _m.Called(groupID, opts)

	if len(ret) == 0 {
		panic("no return value specified for SearchPropertyFields")
	}

	var r0 []*model.PropertyField
	var r1 error
	if rf, ok := ret.Get(0).(func(string, model.PropertyFieldSearchOpts) ([]*model.PropertyField, error)); ok {
		return rf(groupID, opts)
	}
	if rf, ok := ret.Get(0).(func(string, model.PropertyFieldSearchOpts) []*model.PropertyField); ok {
		r0 = rf(groupID, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.PropertyField)
		}
	}

	if rf, ok := ret.Get(1).(func(string, model.PropertyFieldSearchOpts) error); ok {
		r1 = rf(groupID, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SearchPropertyValues provides a mock function with given fields: groupID, opts
func (_m *API) SearchPropertyValues(groupID string, opts model.PropertyValueSearchOpts) ([]*model.PropertyValue, error) {
	ret := _m.Called(groupID, opts)

	if len(ret) == 0 {
		panic("no return value specified for SearchPropertyValues")
	}

	var r0 []*model.PropertyValue
	var r1 error
	if rf, ok := ret.Get(0).(func(string, model.PropertyValueSearchOpts) ([]*model.PropertyValue, error)); ok {
		return rf(groupID, opts)
	}
	if rf, ok := ret.Get(0).(func(string, model.PropertyValueSearchOpts) []*model.PropertyValue); ok {
		r0 = rf(groupID, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.PropertyValue)
		}
	}

	if rf, ok := ret.Get(1).(func(string, model.PropertyValueSearchOpts) error); ok {
		r1 = rf(groupID, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SearchTeams provides a mock function with given fields: term
func (_m *API) SearchTeams(term string) ([]*model.Team, *model.AppError) {
	ret := _m.Called(term)

	if len(ret) == 0 {
		panic("no return value specified for SearchTeams")
	}

	var r0 []*model.Team
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string) ([]*model.Team, *model.AppError)); ok {
		return rf(term)
	}
	if rf, ok := ret.Get(0).(func(string) []*model.Team); ok {
		r0 = rf(term)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Team)
		}
	}

	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(term)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// SearchUsers provides a mock function with given fields: search
func (_m *API) SearchUsers(search *model.UserSearch) ([]*model.User, *model.AppError) {
	ret := _m.Called(search)

	if len(ret) == 0 {
		panic("no return value specified for SearchUsers")
	}

	var r0 []*model.User
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.UserSearch) ([]*model.User, *model.AppError)); ok {
		return rf(search)
	}
	if rf, ok := ret.Get(0).(func(*model.UserSearch) []*model.User); ok {
		r0 = rf(search)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.UserSearch) *model.AppError); ok {
		r1 = rf(search)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// SendEphemeralPost provides a mock function with given fields: userID, post
func (_m *API) SendEphemeralPost(userID string, post *model.Post) *model.Post {
	ret := _m.Called(userID, post)

	if len(ret) == 0 {
		panic("no return value specified for SendEphemeralPost")
	}

	var r0 *model.Post
	if rf, ok := ret.Get(0).(func(string, *model.Post) *model.Post); ok {
		r0 = rf(userID, post)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Post)
		}
	}

	return r0
}

// SendMail provides a mock function with given fields: to, subject, htmlBody
func (_m *API) SendMail(to string, subject string, htmlBody string) *model.AppError {
	ret := _m.Called(to, subject, htmlBody)

	if len(ret) == 0 {
		panic("no return value specified for SendMail")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, string) *model.AppError); ok {
		r0 = rf(to, subject, htmlBody)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// SendPushNotification provides a mock function with given fields: notification, userID
func (_m *API) SendPushNotification(notification *model.PushNotification, userID string) *model.AppError {
	ret := _m.Called(notification, userID)

	if len(ret) == 0 {
		panic("no return value specified for SendPushNotification")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.PushNotification, string) *model.AppError); ok {
		r0 = rf(notification, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// SetFileSearchableContent provides a mock function with given fields: fileID, content
func (_m *API) SetFileSearchableContent(fileID string, content string) *model.AppError {
	ret := _m.Called(fileID, content)

	if len(ret) == 0 {
		panic("no return value specified for SetFileSearchableContent")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string) *model.AppError); ok {
		r0 = rf(fileID, content)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// SetProfileImage provides a mock function with given fields: userID, data
func (_m *API) SetProfileImage(userID string, data []byte) *model.AppError {
	ret := _m.Called(userID, data)

	if len(ret) == 0 {
		panic("no return value specified for SetProfileImage")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []byte) *model.AppError); ok {
		r0 = rf(userID, data)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// SetTeamIcon provides a mock function with given fields: teamID, data
func (_m *API) SetTeamIcon(teamID string, data []byte) *model.AppError {
	ret := _m.Called(teamID, data)

	if len(ret) == 0 {
		panic("no return value specified for SetTeamIcon")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []byte) *model.AppError); ok {
		r0 = rf(teamID, data)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// SetUserStatusTimedDND provides a mock function with given fields: userId, endtime
func (_m *API) SetUserStatusTimedDND(userId string, endtime int64) (*model.Status, *model.AppError) {
	ret := _m.Called(userId, endtime)

	if len(ret) == 0 {
		panic("no return value specified for SetUserStatusTimedDND")
	}

	var r0 *model.Status
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, int64) (*model.Status, *model.AppError)); ok {
		return rf(userId, endtime)
	}
	if rf, ok := ret.Get(0).(func(string, int64) *model.Status); ok {
		r0 = rf(userId, endtime)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Status)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int64) *model.AppError); ok {
		r1 = rf(userId, endtime)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// ShareChannel provides a mock function with given fields: sc
func (_m *API) ShareChannel(sc *model.SharedChannel) (*model.SharedChannel, error) {
	ret := _m.Called(sc)

	if len(ret) == 0 {
		panic("no return value specified for ShareChannel")
	}

	var r0 *model.SharedChannel
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.SharedChannel) (*model.SharedChannel, error)); ok {
		return rf(sc)
	}
	if rf, ok := ret.Get(0).(func(*model.SharedChannel) *model.SharedChannel); ok {
		r0 = rf(sc)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.SharedChannel)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.SharedChannel) error); ok {
		r1 = rf(sc)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SyncSharedChannel provides a mock function with given fields: channelID
func (_m *API) SyncSharedChannel(channelID string) error {
	ret := _m.Called(channelID)

	if len(ret) == 0 {
		panic("no return value specified for SyncSharedChannel")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(channelID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UninviteRemoteFromChannel provides a mock function with given fields: channelID, remoteID
func (_m *API) UninviteRemoteFromChannel(channelID string, remoteID string) error {
	ret := _m.Called(channelID, remoteID)

	if len(ret) == 0 {
		panic("no return value specified for UninviteRemoteFromChannel")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string) error); ok {
		r0 = rf(channelID, remoteID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UnregisterCommand provides a mock function with given fields: teamID, trigger
func (_m *API) UnregisterCommand(teamID string, trigger string) error {
	ret := _m.Called(teamID, trigger)

	if len(ret) == 0 {
		panic("no return value specified for UnregisterCommand")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string) error); ok {
		r0 = rf(teamID, trigger)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UnregisterPluginForSharedChannels provides a mock function with given fields: pluginID
func (_m *API) UnregisterPluginForSharedChannels(pluginID string) error {
	ret := _m.Called(pluginID)

	if len(ret) == 0 {
		panic("no return value specified for UnregisterPluginForSharedChannels")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(pluginID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UnshareChannel provides a mock function with given fields: channelID
func (_m *API) UnshareChannel(channelID string) (bool, error) {
	ret := _m.Called(channelID)

	if len(ret) == 0 {
		panic("no return value specified for UnshareChannel")
	}

	var r0 bool
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (bool, error)); ok {
		return rf(channelID)
	}
	if rf, ok := ret.Get(0).(func(string) bool); ok {
		r0 = rf(channelID)
	} else {
		r0 = ret.Get(0).(bool)
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateBotActive provides a mock function with given fields: botUserId, active
func (_m *API) UpdateBotActive(botUserId string, active bool) (*model.Bot, *model.AppError) {
	ret := _m.Called(botUserId, active)

	if len(ret) == 0 {
		panic("no return value specified for UpdateBotActive")
	}

	var r0 *model.Bot
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, bool) (*model.Bot, *model.AppError)); ok {
		return rf(botUserId, active)
	}
	if rf, ok := ret.Get(0).(func(string, bool) *model.Bot); ok {
		r0 = rf(botUserId, active)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Bot)
		}
	}

	if rf, ok := ret.Get(1).(func(string, bool) *model.AppError); ok {
		r1 = rf(botUserId, active)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateChannel provides a mock function with given fields: channel
func (_m *API) UpdateChannel(channel *model.Channel) (*model.Channel, *model.AppError) {
	ret := _m.Called(channel)

	if len(ret) == 0 {
		panic("no return value specified for UpdateChannel")
	}

	var r0 *model.Channel
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Channel) (*model.Channel, *model.AppError)); ok {
		return rf(channel)
	}
	if rf, ok := ret.Get(0).(func(*model.Channel) *model.Channel); ok {
		r0 = rf(channel)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Channel) *model.AppError); ok {
		r1 = rf(channel)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateChannelMemberNotifications provides a mock function with given fields: channelId, userID, notifications
func (_m *API) UpdateChannelMemberNotifications(channelId string, userID string, notifications map[string]string) (*model.ChannelMember, *model.AppError) {
	ret := _m.Called(channelId, userID, notifications)

	if len(ret) == 0 {
		panic("no return value specified for UpdateChannelMemberNotifications")
	}

	var r0 *model.ChannelMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, map[string]string) (*model.ChannelMember, *model.AppError)); ok {
		return rf(channelId, userID, notifications)
	}
	if rf, ok := ret.Get(0).(func(string, string, map[string]string) *model.ChannelMember); ok {
		r0 = rf(channelId, userID, notifications)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, map[string]string) *model.AppError); ok {
		r1 = rf(channelId, userID, notifications)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateChannelMemberRoles provides a mock function with given fields: channelId, userID, newRoles
func (_m *API) UpdateChannelMemberRoles(channelId string, userID string, newRoles string) (*model.ChannelMember, *model.AppError) {
	ret := _m.Called(channelId, userID, newRoles)

	if len(ret) == 0 {
		panic("no return value specified for UpdateChannelMemberRoles")
	}

	var r0 *model.ChannelMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, string) (*model.ChannelMember, *model.AppError)); ok {
		return rf(channelId, userID, newRoles)
	}
	if rf, ok := ret.Get(0).(func(string, string, string) *model.ChannelMember); ok {
		r0 = rf(channelId, userID, newRoles)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, string) *model.AppError); ok {
		r1 = rf(channelId, userID, newRoles)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateChannelSidebarCategories provides a mock function with given fields: userID, teamID, categories
func (_m *API) UpdateChannelSidebarCategories(userID string, teamID string, categories []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, *model.AppError) {
	ret := _m.Called(userID, teamID, categories)

	if len(ret) == 0 {
		panic("no return value specified for UpdateChannelSidebarCategories")
	}

	var r0 []*model.SidebarCategoryWithChannels
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, *model.AppError)); ok {
		return rf(userID, teamID, categories)
	}
	if rf, ok := ret.Get(0).(func(string, string, []*model.SidebarCategoryWithChannels) []*model.SidebarCategoryWithChannels); ok {
		r0 = rf(userID, teamID, categories)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.SidebarCategoryWithChannels)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, []*model.SidebarCategoryWithChannels) *model.AppError); ok {
		r1 = rf(userID, teamID, categories)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateCommand provides a mock function with given fields: commandID, updatedCmd
func (_m *API) UpdateCommand(commandID string, updatedCmd *model.Command) (*model.Command, error) {
	ret := _m.Called(commandID, updatedCmd)

	if len(ret) == 0 {
		panic("no return value specified for UpdateCommand")
	}

	var r0 *model.Command
	var r1 error
	if rf, ok := ret.Get(0).(func(string, *model.Command) (*model.Command, error)); ok {
		return rf(commandID, updatedCmd)
	}
	if rf, ok := ret.Get(0).(func(string, *model.Command) *model.Command); ok {
		r0 = rf(commandID, updatedCmd)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Command)
		}
	}

	if rf, ok := ret.Get(1).(func(string, *model.Command) error); ok {
		r1 = rf(commandID, updatedCmd)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateEphemeralPost provides a mock function with given fields: userID, post
func (_m *API) UpdateEphemeralPost(userID string, post *model.Post) *model.Post {
	ret := _m.Called(userID, post)

	if len(ret) == 0 {
		panic("no return value specified for UpdateEphemeralPost")
	}

	var r0 *model.Post
	if rf, ok := ret.Get(0).(func(string, *model.Post) *model.Post); ok {
		r0 = rf(userID, post)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Post)
		}
	}

	return r0
}

// UpdateGroup provides a mock function with given fields: group
func (_m *API) UpdateGroup(group *model.Group) (*model.Group, *model.AppError) {
	ret := _m.Called(group)

	if len(ret) == 0 {
		panic("no return value specified for UpdateGroup")
	}

	var r0 *model.Group
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Group) (*model.Group, *model.AppError)); ok {
		return rf(group)
	}
	if rf, ok := ret.Get(0).(func(*model.Group) *model.Group); ok {
		r0 = rf(group)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Group) *model.AppError); ok {
		r1 = rf(group)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateGroupSyncable provides a mock function with given fields: groupSyncable
func (_m *API) UpdateGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, *model.AppError) {
	ret := _m.Called(groupSyncable)

	if len(ret) == 0 {
		panic("no return value specified for UpdateGroupSyncable")
	}

	var r0 *model.GroupSyncable
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.GroupSyncable) (*model.GroupSyncable, *model.AppError)); ok {
		return rf(groupSyncable)
	}
	if rf, ok := ret.Get(0).(func(*model.GroupSyncable) *model.GroupSyncable); ok {
		r0 = rf(groupSyncable)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.GroupSyncable)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.GroupSyncable) *model.AppError); ok {
		r1 = rf(groupSyncable)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateOAuthApp provides a mock function with given fields: app
func (_m *API) UpdateOAuthApp(app *model.OAuthApp) (*model.OAuthApp, *model.AppError) {
	ret := _m.Called(app)

	if len(ret) == 0 {
		panic("no return value specified for UpdateOAuthApp")
	}

	var r0 *model.OAuthApp
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.OAuthApp) (*model.OAuthApp, *model.AppError)); ok {
		return rf(app)
	}
	if rf, ok := ret.Get(0).(func(*model.OAuthApp) *model.OAuthApp); ok {
		r0 = rf(app)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.OAuthApp)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.OAuthApp) *model.AppError); ok {
		r1 = rf(app)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdatePost provides a mock function with given fields: post
func (_m *API) UpdatePost(post *model.Post) (*model.Post, *model.AppError) {
	ret := _m.Called(post)

	if len(ret) == 0 {
		panic("no return value specified for UpdatePost")
	}

	var r0 *model.Post
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Post) (*model.Post, *model.AppError)); ok {
		return rf(post)
	}
	if rf, ok := ret.Get(0).(func(*model.Post) *model.Post); ok {
		r0 = rf(post)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Post)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Post) *model.AppError); ok {
		r1 = rf(post)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdatePreferencesForUser provides a mock function with given fields: userID, preferences
func (_m *API) UpdatePreferencesForUser(userID string, preferences []model.Preference) *model.AppError {
	ret := _m.Called(userID, preferences)

	if len(ret) == 0 {
		panic("no return value specified for UpdatePreferencesForUser")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []model.Preference) *model.AppError); ok {
		r0 = rf(userID, preferences)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// UpdatePropertyField provides a mock function with given fields: groupID, field
func (_m *API) UpdatePropertyField(groupID string, field *model.PropertyField) (*model.PropertyField, error) {
	ret := _m.Called(groupID, field)

	if len(ret) == 0 {
		panic("no return value specified for UpdatePropertyField")
	}

	var r0 *model.PropertyField
	var r1 error
	if rf, ok := ret.Get(0).(func(string, *model.PropertyField) (*model.PropertyField, error)); ok {
		return rf(groupID, field)
	}
	if rf, ok := ret.Get(0).(func(string, *model.PropertyField) *model.PropertyField); ok {
		r0 = rf(groupID, field)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PropertyField)
		}
	}

	if rf, ok := ret.Get(1).(func(string, *model.PropertyField) error); ok {
		r1 = rf(groupID, field)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdatePropertyFields provides a mock function with given fields: groupID, fields
func (_m *API) UpdatePropertyFields(groupID string, fields []*model.PropertyField) ([]*model.PropertyField, error) {
	ret := _m.Called(groupID, fields)

	if len(ret) == 0 {
		panic("no return value specified for UpdatePropertyFields")
	}

	var r0 []*model.PropertyField
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []*model.PropertyField) ([]*model.PropertyField, error)); ok {
		return rf(groupID, fields)
	}
	if rf, ok := ret.Get(0).(func(string, []*model.PropertyField) []*model.PropertyField); ok {
		r0 = rf(groupID, fields)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.PropertyField)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []*model.PropertyField) error); ok {
		r1 = rf(groupID, fields)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdatePropertyValue provides a mock function with given fields: groupID, value
func (_m *API) UpdatePropertyValue(groupID string, value *model.PropertyValue) (*model.PropertyValue, error) {
	ret := _m.Called(groupID, value)

	if len(ret) == 0 {
		panic("no return value specified for UpdatePropertyValue")
	}

	var r0 *model.PropertyValue
	var r1 error
	if rf, ok := ret.Get(0).(func(string, *model.PropertyValue) (*model.PropertyValue, error)); ok {
		return rf(groupID, value)
	}
	if rf, ok := ret.Get(0).(func(string, *model.PropertyValue) *model.PropertyValue); ok {
		r0 = rf(groupID, value)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PropertyValue)
		}
	}

	if rf, ok := ret.Get(1).(func(string, *model.PropertyValue) error); ok {
		r1 = rf(groupID, value)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdatePropertyValues provides a mock function with given fields: groupID, values
func (_m *API) UpdatePropertyValues(groupID string, values []*model.PropertyValue) ([]*model.PropertyValue, error) {
	ret := _m.Called(groupID, values)

	if len(ret) == 0 {
		panic("no return value specified for UpdatePropertyValues")
	}

	var r0 []*model.PropertyValue
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []*model.PropertyValue) ([]*model.PropertyValue, error)); ok {
		return rf(groupID, values)
	}
	if rf, ok := ret.Get(0).(func(string, []*model.PropertyValue) []*model.PropertyValue); ok {
		r0 = rf(groupID, values)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.PropertyValue)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []*model.PropertyValue) error); ok {
		r1 = rf(groupID, values)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateSharedChannel provides a mock function with given fields: sc
func (_m *API) UpdateSharedChannel(sc *model.SharedChannel) (*model.SharedChannel, error) {
	ret := _m.Called(sc)

	if len(ret) == 0 {
		panic("no return value specified for UpdateSharedChannel")
	}

	var r0 *model.SharedChannel
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.SharedChannel) (*model.SharedChannel, error)); ok {
		return rf(sc)
	}
	if rf, ok := ret.Get(0).(func(*model.SharedChannel) *model.SharedChannel); ok {
		r0 = rf(sc)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.SharedChannel)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.SharedChannel) error); ok {
		r1 = rf(sc)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateSharedChannelCursor provides a mock function with given fields: channelID, remoteID, cusror
func (_m *API) UpdateSharedChannelCursor(channelID string, remoteID string, cusror model.GetPostsSinceForSyncCursor) error {
	ret := _m.Called(channelID, remoteID, cusror)

	if len(ret) == 0 {
		panic("no return value specified for UpdateSharedChannelCursor")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string, model.GetPostsSinceForSyncCursor) error); ok {
		r0 = rf(channelID, remoteID, cusror)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateTeam provides a mock function with given fields: team
func (_m *API) UpdateTeam(team *model.Team) (*model.Team, *model.AppError) {
	ret := _m.Called(team)

	if len(ret) == 0 {
		panic("no return value specified for UpdateTeam")
	}

	var r0 *model.Team
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Team) (*model.Team, *model.AppError)); ok {
		return rf(team)
	}
	if rf, ok := ret.Get(0).(func(*model.Team) *model.Team); ok {
		r0 = rf(team)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Team)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Team) *model.AppError); ok {
		r1 = rf(team)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateTeamMemberRoles provides a mock function with given fields: teamID, userID, newRoles
func (_m *API) UpdateTeamMemberRoles(teamID string, userID string, newRoles string) (*model.TeamMember, *model.AppError) {
	ret := _m.Called(teamID, userID, newRoles)

	if len(ret) == 0 {
		panic("no return value specified for UpdateTeamMemberRoles")
	}

	var r0 *model.TeamMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, string) (*model.TeamMember, *model.AppError)); ok {
		return rf(teamID, userID, newRoles)
	}
	if rf, ok := ret.Get(0).(func(string, string, string) *model.TeamMember); ok {
		r0 = rf(teamID, userID, newRoles)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.TeamMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, string) *model.AppError); ok {
		r1 = rf(teamID, userID, newRoles)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateUser provides a mock function with given fields: user
func (_m *API) UpdateUser(user *model.User) (*model.User, *model.AppError) {
	ret := _m.Called(user)

	if len(ret) == 0 {
		panic("no return value specified for UpdateUser")
	}

	var r0 *model.User
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.User) (*model.User, *model.AppError)); ok {
		return rf(user)
	}
	if rf, ok := ret.Get(0).(func(*model.User) *model.User); ok {
		r0 = rf(user)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.User) *model.AppError); ok {
		r1 = rf(user)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateUserActive provides a mock function with given fields: userID, active
func (_m *API) UpdateUserActive(userID string, active bool) *model.AppError {
	ret := _m.Called(userID, active)

	if len(ret) == 0 {
		panic("no return value specified for UpdateUserActive")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, bool) *model.AppError); ok {
		r0 = rf(userID, active)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// UpdateUserAuth provides a mock function with given fields: userID, userAuth
func (_m *API) UpdateUserAuth(userID string, userAuth *model.UserAuth) (*model.UserAuth, *model.AppError) {
	ret := _m.Called(userID, userAuth)

	if len(ret) == 0 {
		panic("no return value specified for UpdateUserAuth")
	}

	var r0 *model.UserAuth
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, *model.UserAuth) (*model.UserAuth, *model.AppError)); ok {
		return rf(userID, userAuth)
	}
	if rf, ok := ret.Get(0).(func(string, *model.UserAuth) *model.UserAuth); ok {
		r0 = rf(userID, userAuth)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.UserAuth)
		}
	}

	if rf, ok := ret.Get(1).(func(string, *model.UserAuth) *model.AppError); ok {
		r1 = rf(userID, userAuth)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateUserCustomStatus provides a mock function with given fields: userID, customStatus
func (_m *API) UpdateUserCustomStatus(userID string, customStatus *model.CustomStatus) *model.AppError {
	ret := _m.Called(userID, customStatus)

	if len(ret) == 0 {
		panic("no return value specified for UpdateUserCustomStatus")
	}

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, *model.CustomStatus) *model.AppError); ok {
		r0 = rf(userID, customStatus)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// UpdateUserRoles provides a mock function with given fields: userID, newRoles
func (_m *API) UpdateUserRoles(userID string, newRoles string) (*model.User, *model.AppError) {
	ret := _m.Called(userID, newRoles)

	if len(ret) == 0 {
		panic("no return value specified for UpdateUserRoles")
	}

	var r0 *model.User
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string) (*model.User, *model.AppError)); ok {
		return rf(userID, newRoles)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.User); ok {
		r0 = rf(userID, newRoles)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(userID, newRoles)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateUserStatus provides a mock function with given fields: userID, status
func (_m *API) UpdateUserStatus(userID string, status string) (*model.Status, *model.AppError) {
	ret := _m.Called(userID, status)

	if len(ret) == 0 {
		panic("no return value specified for UpdateUserStatus")
	}

	var r0 *model.Status
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string) (*model.Status, *model.AppError)); ok {
		return rf(userID, status)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.Status); ok {
		r0 = rf(userID, status)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Status)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(userID, status)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UploadData provides a mock function with given fields: us, rd
func (_m *API) UploadData(us *model.UploadSession, rd io.Reader) (*model.FileInfo, error) {
	ret := _m.Called(us, rd)

	if len(ret) == 0 {
		panic("no return value specified for UploadData")
	}

	var r0 *model.FileInfo
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.UploadSession, io.Reader) (*model.FileInfo, error)); ok {
		return rf(us, rd)
	}
	if rf, ok := ret.Get(0).(func(*model.UploadSession, io.Reader) *model.FileInfo); ok {
		r0 = rf(us, rd)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.FileInfo)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.UploadSession, io.Reader) error); ok {
		r1 = rf(us, rd)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UploadFile provides a mock function with given fields: data, channelId, filename
func (_m *API) UploadFile(data []byte, channelId string, filename string) (*model.FileInfo, *model.AppError) {
	ret := _m.Called(data, channelId, filename)

	if len(ret) == 0 {
		panic("no return value specified for UploadFile")
	}

	var r0 *model.FileInfo
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func([]byte, string, string) (*model.FileInfo, *model.AppError)); ok {
		return rf(data, channelId, filename)
	}
	if rf, ok := ret.Get(0).(func([]byte, string, string) *model.FileInfo); ok {
		r0 = rf(data, channelId, filename)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.FileInfo)
		}
	}

	if rf, ok := ret.Get(1).(func([]byte, string, string) *model.AppError); ok {
		r1 = rf(data, channelId, filename)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpsertGroupMember provides a mock function with given fields: groupID, userID
func (_m *API) UpsertGroupMember(groupID string, userID string) (*model.GroupMember, *model.AppError) {
	ret := _m.Called(groupID, userID)

	if len(ret) == 0 {
		panic("no return value specified for UpsertGroupMember")
	}

	var r0 *model.GroupMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string) (*model.GroupMember, *model.AppError)); ok {
		return rf(groupID, userID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.GroupMember); ok {
		r0 = rf(groupID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.GroupMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(groupID, userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpsertGroupMembers provides a mock function with given fields: groupID, userIDs
func (_m *API) UpsertGroupMembers(groupID string, userIDs []string) ([]*model.GroupMember, *model.AppError) {
	ret := _m.Called(groupID, userIDs)

	if len(ret) == 0 {
		panic("no return value specified for UpsertGroupMembers")
	}

	var r0 []*model.GroupMember
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []string) ([]*model.GroupMember, *model.AppError)); ok {
		return rf(groupID, userIDs)
	}
	if rf, ok := ret.Get(0).(func(string, []string) []*model.GroupMember); ok {
		r0 = rf(groupID, userIDs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.GroupMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string) *model.AppError); ok {
		r1 = rf(groupID, userIDs)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpsertGroupSyncable provides a mock function with given fields: groupSyncable
func (_m *API) UpsertGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, *model.AppError) {
	ret := _m.Called(groupSyncable)

	if len(ret) == 0 {
		panic("no return value specified for UpsertGroupSyncable")
	}

	var r0 *model.GroupSyncable
	var r1 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.GroupSyncable) (*model.GroupSyncable, *model.AppError)); ok {
		return rf(groupSyncable)
	}
	if rf, ok := ret.Get(0).(func(*model.GroupSyncable) *model.GroupSyncable); ok {
		r0 = rf(groupSyncable)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.GroupSyncable)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.GroupSyncable) *model.AppError); ok {
		r1 = rf(groupSyncable)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpsertPropertyValue provides a mock function with given fields: value
func (_m *API) UpsertPropertyValue(value *model.PropertyValue) (*model.PropertyValue, error) {
	ret := _m.Called(value)

	if len(ret) == 0 {
		panic("no return value specified for UpsertPropertyValue")
	}

	var r0 *model.PropertyValue
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.PropertyValue) (*model.PropertyValue, error)); ok {
		return rf(value)
	}
	if rf, ok := ret.Get(0).(func(*model.PropertyValue) *model.PropertyValue); ok {
		r0 = rf(value)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PropertyValue)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.PropertyValue) error); ok {
		r1 = rf(value)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpsertPropertyValues provides a mock function with given fields: values
func (_m *API) UpsertPropertyValues(values []*model.PropertyValue) ([]*model.PropertyValue, error) {
	ret := _m.Called(values)

	if len(ret) == 0 {
		panic("no return value specified for UpsertPropertyValues")
	}

	var r0 []*model.PropertyValue
	var r1 error
	if rf, ok := ret.Get(0).(func([]*model.PropertyValue) ([]*model.PropertyValue, error)); ok {
		return rf(values)
	}
	if rf, ok := ret.Get(0).(func([]*model.PropertyValue) []*model.PropertyValue); ok {
		r0 = rf(values)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.PropertyValue)
		}
	}

	if rf, ok := ret.Get(1).(func([]*model.PropertyValue) error); ok {
		r1 = rf(values)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// NewAPI creates a new instance of API. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewAPI(t interface {
	mock.TestingT
	Cleanup(func())
}) *API {
	mock := &API{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
