// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

package model

// Code generated by github.com/tinylib/msgp DO NOT EDIT.

import (
	"github.com/tinylib/msgp/msgp"
)

// DecodeMsg implements msgp.Decodable
func (z *TeamMember) DecodeMsg(dc *msgp.Reader) (err error) {
	var zb0001 uint32
	zb0001, err = dc.ReadArrayHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0001 != 9 {
		err = msgp.ArrayError{Wanted: 9, Got: zb0001}
		return
	}
	z.TeamId, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "TeamId")
		return
	}
	z.UserId, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "UserId")
		return
	}
	z.Roles, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "Roles")
		return
	}
	z.DeleteAt, err = dc.ReadInt64()
	if err != nil {
		err = msgp.WrapError(err, "DeleteAt")
		return
	}
	z.SchemeGuest, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "SchemeGuest")
		return
	}
	z.SchemeUser, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "SchemeUser")
		return
	}
	z.SchemeAdmin, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "SchemeAdmin")
		return
	}
	z.ExplicitRoles, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "ExplicitRoles")
		return
	}
	z.CreateAt, err = dc.ReadInt64()
	if err != nil {
		err = msgp.WrapError(err, "CreateAt")
		return
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *TeamMember) EncodeMsg(en *msgp.Writer) (err error) {
	// array header, size 9
	err = en.Append(0x99)
	if err != nil {
		return
	}
	err = en.WriteString(z.TeamId)
	if err != nil {
		err = msgp.WrapError(err, "TeamId")
		return
	}
	err = en.WriteString(z.UserId)
	if err != nil {
		err = msgp.WrapError(err, "UserId")
		return
	}
	err = en.WriteString(z.Roles)
	if err != nil {
		err = msgp.WrapError(err, "Roles")
		return
	}
	err = en.WriteInt64(z.DeleteAt)
	if err != nil {
		err = msgp.WrapError(err, "DeleteAt")
		return
	}
	err = en.WriteBool(z.SchemeGuest)
	if err != nil {
		err = msgp.WrapError(err, "SchemeGuest")
		return
	}
	err = en.WriteBool(z.SchemeUser)
	if err != nil {
		err = msgp.WrapError(err, "SchemeUser")
		return
	}
	err = en.WriteBool(z.SchemeAdmin)
	if err != nil {
		err = msgp.WrapError(err, "SchemeAdmin")
		return
	}
	err = en.WriteString(z.ExplicitRoles)
	if err != nil {
		err = msgp.WrapError(err, "ExplicitRoles")
		return
	}
	err = en.WriteInt64(z.CreateAt)
	if err != nil {
		err = msgp.WrapError(err, "CreateAt")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *TeamMember) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// array header, size 9
	o = append(o, 0x99)
	o = msgp.AppendString(o, z.TeamId)
	o = msgp.AppendString(o, z.UserId)
	o = msgp.AppendString(o, z.Roles)
	o = msgp.AppendInt64(o, z.DeleteAt)
	o = msgp.AppendBool(o, z.SchemeGuest)
	o = msgp.AppendBool(o, z.SchemeUser)
	o = msgp.AppendBool(o, z.SchemeAdmin)
	o = msgp.AppendString(o, z.ExplicitRoles)
	o = msgp.AppendInt64(o, z.CreateAt)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TeamMember) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadArrayHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0001 != 9 {
		err = msgp.ArrayError{Wanted: 9, Got: zb0001}
		return
	}
	z.TeamId, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "TeamId")
		return
	}
	z.UserId, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "UserId")
		return
	}
	z.Roles, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Roles")
		return
	}
	z.DeleteAt, bts, err = msgp.ReadInt64Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "DeleteAt")
		return
	}
	z.SchemeGuest, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "SchemeGuest")
		return
	}
	z.SchemeUser, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "SchemeUser")
		return
	}
	z.SchemeAdmin, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "SchemeAdmin")
		return
	}
	z.ExplicitRoles, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "ExplicitRoles")
		return
	}
	z.CreateAt, bts, err = msgp.ReadInt64Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "CreateAt")
		return
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *TeamMember) Msgsize() (s int) {
	s = 1 + msgp.StringPrefixSize + len(z.TeamId) + msgp.StringPrefixSize + len(z.UserId) + msgp.StringPrefixSize + len(z.Roles) + msgp.Int64Size + msgp.BoolSize + msgp.BoolSize + msgp.BoolSize + msgp.StringPrefixSize + len(z.ExplicitRoles) + msgp.Int64Size
	return
}
