// See <https://github.com/apache/pdfbox/blob/4438b8fdc67a3a9ebfb194595d0e81f88b708a37/pdfbox/src/main/java/org/apache/pdfbox/pdmodel/font/encoding/MacRomanEncoding.java>
use phf::phf_map;

pub(crate) fn get(code: u8) -> Option<&'static str> {
    MAC_ROMAN.get(&code).copied()
}

pub(crate) fn get_inverse(name: &str) -> Option<u8> {
    MAC_ROMAN_INVERSE.get(name).copied()
}

static MAC_ROMAN: phf::Map<u8, &'static str> = phf_map! {
    65u8 => "A",
    174u8 => "AE",
    231u8 => "Aacute",
    229u8 => "Acircumflex",
    128u8 => "Adieresis",
    203u8 => "Agrave",
    129u8 => "Aring",
    204u8 => "Atilde",
    66u8 => "B",
    67u8 => "C",
    130u8 => "Ccedilla",
    68u8 => "D",
    69u8 => "E",
    131u8 => "Eacute",
    230u8 => "Ecircumflex",
    232u8 => "Edieresis",
    233u8 => "Egrave",
    70u8 => "F",
    71u8 => "G",
    72u8 => "H",
    73u8 => "I",
    234u8 => "Iacute",
    235u8 => "Icircumflex",
    236u8 => "Idieresis",
    237u8 => "Igrave",
    74u8 => "J",
    75u8 => "K",
    76u8 => "L",
    77u8 => "M",
    78u8 => "N",
    132u8 => "Ntilde",
    79u8 => "O",
    206u8 => "OE",
    238u8 => "Oacute",
    239u8 => "Ocircumflex",
    133u8 => "Odieresis",
    241u8 => "Ograve",
    175u8 => "Oslash",
    205u8 => "Otilde",
    80u8 => "P",
    81u8 => "Q",
    82u8 => "R",
    83u8 => "S",
    84u8 => "T",
    85u8 => "U",
    242u8 => "Uacute",
    243u8 => "Ucircumflex",
    134u8 => "Udieresis",
    244u8 => "Ugrave",
    86u8 => "V",
    87u8 => "W",
    88u8 => "X",
    89u8 => "Y",
    217u8 => "Ydieresis",
    90u8 => "Z",
    97u8 => "a",
    135u8 => "aacute",
    137u8 => "acircumflex",
    171u8 => "acute",
    138u8 => "adieresis",
    190u8 => "ae",
    136u8 => "agrave",
    38u8 => "ampersand",
    140u8 => "aring",
    94u8 => "asciicircum",
    126u8 => "asciitilde",
    42u8 => "asterisk",
    64u8 => "at",
    139u8 => "atilde",
    98u8 => "b",
    92u8 => "backslash",
    124u8 => "bar",
    123u8 => "braceleft",
    125u8 => "braceright",
    91u8 => "bracketleft",
    93u8 => "bracketright",
    249u8 => "breve",
    165u8 => "bullet",
    99u8 => "c",
    255u8 => "caron",
    141u8 => "ccedilla",
    252u8 => "cedilla",
    162u8 => "cent",
    246u8 => "circumflex",
    58u8 => "colon",
    44u8 => "comma",
    169u8 => "copyright",
    219u8 => "currency",
    100u8 => "d",
    160u8 => "dagger",
    224u8 => "daggerdbl",
    161u8 => "degree",
    172u8 => "dieresis",
    214u8 => "divide",
    36u8 => "dollar",
    250u8 => "dotaccent",
    245u8 => "dotlessi",
    101u8 => "e",
    142u8 => "eacute",
    144u8 => "ecircumflex",
    145u8 => "edieresis",
    143u8 => "egrave",
    56u8 => "eight",
    201u8 => "ellipsis",
    209u8 => "emdash",
    208u8 => "endash",
    61u8 => "equal",
    33u8 => "exclam",
    193u8 => "exclamdown",
    102u8 => "f",
    222u8 => "fi",
    53u8 => "five",
    223u8 => "fl",
    196u8 => "florin",
    52u8 => "four",
    218u8 => "fraction",
    103u8 => "g",
    167u8 => "germandbls",
    96u8 => "grave",
    62u8 => "greater",
    199u8 => "guillemotleft",
    200u8 => "guillemotright",
    220u8 => "guilsinglleft",
    221u8 => "guilsinglright",
    104u8 => "h",
    253u8 => "hungarumlaut",
    45u8 => "hyphen",
    105u8 => "i",
    146u8 => "iacute",
    148u8 => "icircumflex",
    149u8 => "idieresis",
    147u8 => "igrave",
    106u8 => "j",
    107u8 => "k",
    108u8 => "l",
    60u8 => "less",
    194u8 => "logicalnot",
    109u8 => "m",
    248u8 => "macron",
    181u8 => "mu",
    110u8 => "n",
    57u8 => "nine",
    150u8 => "ntilde",
    35u8 => "numbersign",
    111u8 => "o",
    151u8 => "oacute",
    153u8 => "ocircumflex",
    154u8 => "odieresis",
    207u8 => "oe",
    254u8 => "ogonek",
    152u8 => "ograve",
    49u8 => "one",
    187u8 => "ordfeminine",
    188u8 => "ordmasculine",
    191u8 => "oslash",
    155u8 => "otilde",
    112u8 => "p",
    166u8 => "paragraph",
    40u8 => "parenleft",
    41u8 => "parenright",
    37u8 => "percent",
    46u8 => "period",
    225u8 => "periodcentered",
    228u8 => "perthousand",
    43u8 => "plus",
    177u8 => "plusminus",
    113u8 => "q",
    63u8 => "question",
    192u8 => "questiondown",
    34u8 => "quotedbl",
    227u8 => "quotedblbase",
    210u8 => "quotedblleft",
    211u8 => "quotedblright",
    212u8 => "quoteleft",
    213u8 => "quoteright",
    226u8 => "quotesinglbase",
    39u8 => "quotesingle",
    114u8 => "r",
    168u8 => "registered",
    251u8 => "ring",
    115u8 => "s",
    164u8 => "section",
    59u8 => "semicolon",
    55u8 => "seven",
    54u8 => "six",
    47u8 => "slash",
    32u8 => "space",
    163u8 => "sterling",
    116u8 => "t",
    51u8 => "three",
    247u8 => "tilde",
    170u8 => "trademark",
    50u8 => "two",
    117u8 => "u",
    156u8 => "uacute",
    158u8 => "ucircumflex",
    159u8 => "udieresis",
    157u8 => "ugrave",
    95u8 => "underscore",
    118u8 => "v",
    119u8 => "w",
    120u8 => "x",
    121u8 => "y",
    216u8 => "ydieresis",
    180u8 => "yen",
    122u8 => "z",
    48u8 => "zero",
    202u8 => "nbspace",
};

static MAC_ROMAN_INVERSE: phf::Map<&'static str, u8> = phf_map! {
     "A" => 65u8,
     "AE" => 174u8,
     "Aacute" => 231u8,
     "Acircumflex" => 229u8,
     "Adieresis" => 128u8,
     "Agrave" => 203u8,
     "Aring" => 129u8,
     "Atilde" => 204u8,
     "B" => 66u8,
     "C" => 67u8,
     "Ccedilla" => 130u8,
     "D" => 68u8,
     "E" => 69u8,
     "Eacute" => 131u8,
     "Ecircumflex" => 230u8,
     "Edieresis" => 232u8,
     "Egrave" => 233u8,
     "F" => 70u8,
     "G" => 71u8,
     "H" => 72u8,
     "I" => 73u8,
     "Iacute" => 234u8,
     "Icircumflex" => 235u8,
     "Idieresis" => 236u8,
     "Igrave" => 237u8,
     "J" => 74u8,
     "K" => 75u8,
     "L" => 76u8,
     "M" => 77u8,
     "N" => 78u8,
     "Ntilde" => 132u8,
     "O" => 79u8,
     "OE" => 206u8,
     "Oacute" => 238u8,
     "Ocircumflex" => 239u8,
     "Odieresis" => 133u8,
     "Ograve" => 241u8,
     "Oslash" => 175u8,
     "Otilde" => 205u8,
     "P" => 80u8,
     "Q" => 81u8,
     "R" => 82u8,
     "S" => 83u8,
     "T" => 84u8,
     "U" => 85u8,
     "Uacute" => 242u8,
     "Ucircumflex" => 243u8,
     "Udieresis" => 134u8,
     "Ugrave" => 244u8,
     "V" => 86u8,
     "W" => 87u8,
     "X" => 88u8,
     "Y" => 89u8,
     "Ydieresis" => 217u8,
     "Z" => 90u8,
     "a" => 97u8,
     "aacute" => 135u8,
     "acircumflex" => 137u8,
     "acute" => 171u8,
     "adieresis" => 138u8,
     "ae" => 190u8,
     "agrave" => 136u8,
     "ampersand" => 38u8,
     "aring" => 140u8,
     "asciicircum" => 94u8,
     "asciitilde" => 126u8,
     "asterisk" => 42u8,
     "at" => 64u8,
     "atilde" => 139u8,
     "b" => 98u8,
     "backslash" => 92u8,
     "bar" => 124u8,
     "braceleft" => 123u8,
     "braceright" => 125u8,
     "bracketleft" => 91u8,
     "bracketright" => 93u8,
     "breve" => 249u8,
     "bullet" => 165u8,
     "c" => 99u8,
     "caron" => 255u8,
     "ccedilla" => 141u8,
     "cedilla" => 252u8,
     "cent" => 162u8,
     "circumflex" => 246u8,
     "colon" => 58u8,
     "comma" => 44u8,
     "copyright" => 169u8,
     "currency" => 219u8,
     "d" => 100u8,
     "dagger" => 160u8,
     "daggerdbl" => 224u8,
     "degree" => 161u8,
     "dieresis" => 172u8,
     "divide" => 214u8,
     "dollar" => 36u8,
     "dotaccent" => 250u8,
     "dotlessi" => 245u8,
     "e" => 101u8,
     "eacute" => 142u8,
     "ecircumflex" => 144u8,
     "edieresis" => 145u8,
     "egrave" => 143u8,
     "eight" => 56u8,
     "ellipsis" => 201u8,
     "emdash" => 209u8,
     "endash" => 208u8,
     "equal" => 61u8,
     "exclam" => 33u8,
     "exclamdown" => 193u8,
     "f" => 102u8,
     "fi" => 222u8,
     "five" => 53u8,
     "fl" => 223u8,
     "florin" => 196u8,
     "four" => 52u8,
     "fraction" => 218u8,
     "g" => 103u8,
     "germandbls" => 167u8,
     "grave" => 96u8,
     "greater" => 62u8,
     "guillemotleft" => 199u8,
     "guillemotright" => 200u8,
     "guilsinglleft" => 220u8,
     "guilsinglright" => 221u8,
     "h" => 104u8,
     "hungarumlaut" => 253u8,
     "hyphen" => 45u8,
     "i" => 105u8,
     "iacute" => 146u8,
     "icircumflex" => 148u8,
     "idieresis" => 149u8,
     "igrave" => 147u8,
     "j" => 106u8,
     "k" => 107u8,
     "l" => 108u8,
     "less" => 60u8,
     "logicalnot" => 194u8,
     "m" => 109u8,
     "macron" => 248u8,
     "mu" => 181u8,
     "n" => 110u8,
     "nine" => 57u8,
     "ntilde" => 150u8,
     "numbersign" => 35u8,
     "o" => 111u8,
     "oacute" => 151u8,
     "ocircumflex" => 153u8,
     "odieresis" => 154u8,
     "oe" => 207u8,
     "ogonek" => 254u8,
     "ograve" => 152u8,
     "one" => 49u8,
     "ordfeminine" => 187u8,
     "ordmasculine" => 188u8,
     "oslash" => 191u8,
     "otilde" => 155u8,
     "p" => 112u8,
     "paragraph" => 166u8,
     "parenleft" => 40u8,
     "parenright" => 41u8,
     "percent" => 37u8,
     "period" => 46u8,
     "periodcentered" => 225u8,
     "perthousand" => 228u8,
     "plus" => 43u8,
     "plusminus" => 177u8,
     "q" => 113u8,
     "question" => 63u8,
     "questiondown" => 192u8,
     "quotedbl" => 34u8,
     "quotedblbase" => 227u8,
     "quotedblleft" => 210u8,
     "quotedblright" => 211u8,
     "quoteleft" => 212u8,
     "quoteright" => 213u8,
     "quotesinglbase" => 226u8,
     "quotesingle" => 39u8,
     "r" => 114u8,
     "registered" => 168u8,
     "ring" => 251u8,
     "s" => 115u8,
     "section" => 164u8,
     "semicolon" => 59u8,
     "seven" => 55u8,
     "six" => 54u8,
     "slash" => 47u8,
     "space" => 32u8,
     "sterling" => 163u8,
     "t" => 116u8,
     "three" => 51u8,
     "tilde" => 247u8,
     "trademark" => 170u8,
     "two" => 50u8,
     "u" => 117u8,
     "uacute" => 156u8,
     "ucircumflex" => 158u8,
     "udieresis" => 159u8,
     "ugrave" => 157u8,
     "underscore" => 95u8,
     "v" => 118u8,
     "w" => 119u8,
     "x" => 120u8,
     "y" => 121u8,
     "ydieresis" => 216u8,
     "yen" => 180u8,
     "z" => 122u8,
     "zero" => 48u8,
     "nbspace" => 202u8,
};
