// See <https://github.com/apache/pdfbox/blob/4438b8fdc67a3a9ebfb194595d0e81f88b708a37/pdfbox/src/main/java/org/apache/pdfbox/pdmodel/font/encoding/MacExpertEncoding.java>
use phf::phf_map;

pub(crate) fn get(code: u8) -> Option<&'static str> {
    MAC_EXPERT.get(&code).copied()
}

static MAC_EXPERT: phf::Map<u8, &'static str> = phf_map! {
    190u8 => "AEsmall",
    135u8 => "Aacutesmall",
    137u8 => "Acircumflexsmall",
    39u8 => "Acutesmall",
    138u8 => "Adieresissmall",
    136u8 => "Agravesmall",
    140u8 => "Aringsmall",
    97u8 => "Asmall",
    139u8 => "Atildesmall",
    243u8 => "Brevesmall",
    98u8 => "Bsmall",
    174u8 => "Caronsmall",
    141u8 => "Ccedillasmall",
    201u8 => "Cedillasmall",
    94u8 => "Circumflexsmall",
    99u8 => "Csmall",
    172u8 => "Dieresissmall",
    250u8 => "Dotaccentsmall",
    100u8 => "Dsmall",
    142u8 => "Eacutesmall",
    144u8 => "Ecircumflexsmall",
    145u8 => "Edieresissmall",
    143u8 => "Egravesmall",
    101u8 => "Esmall",
    68u8 => "Ethsmall",
    102u8 => "Fsmall",
    96u8 => "Gravesmall",
    103u8 => "Gsmall",
    104u8 => "Hsmall",
    34u8 => "Hungarumlautsmall",
    146u8 => "Iacutesmall",
    148u8 => "Icircumflexsmall",
    149u8 => "Idieresissmall",
    147u8 => "Igravesmall",
    105u8 => "Ismall",
    106u8 => "Jsmall",
    107u8 => "Ksmall",
    194u8 => "Lslashsmall",
    108u8 => "Lsmall",
    244u8 => "Macronsmall",
    109u8 => "Msmall",
    110u8 => "Nsmall",
    150u8 => "Ntildesmall",
    207u8 => "OEsmall",
    151u8 => "Oacutesmall",
    153u8 => "Ocircumflexsmall",
    154u8 => "Odieresissmall",
    242u8 => "Ogoneksmall",
    152u8 => "Ogravesmall",
    191u8 => "Oslashsmall",
    111u8 => "Osmall",
    155u8 => "Otildesmall",
    112u8 => "Psmall",
    113u8 => "Qsmall",
    251u8 => "Ringsmall",
    114u8 => "Rsmall",
    167u8 => "Scaronsmall",
    115u8 => "Ssmall",
    185u8 => "Thornsmall",
    126u8 => "Tildesmall",
    116u8 => "Tsmall",
    156u8 => "Uacutesmall",
    158u8 => "Ucircumflexsmall",
    159u8 => "Udieresissmall",
    157u8 => "Ugravesmall",
    117u8 => "Usmall",
    118u8 => "Vsmall",
    119u8 => "Wsmall",
    120u8 => "Xsmall",
    180u8 => "Yacutesmall",
    216u8 => "Ydieresissmall",
    121u8 => "Ysmall",
    189u8 => "Zcaronsmall",
    122u8 => "Zsmall",
    38u8 => "ampersandsmall",
    129u8 => "asuperior",
    245u8 => "bsuperior",
    169u8 => "centinferior",
    35u8 => "centoldstyle",
    130u8 => "centsuperior",
    58u8 => "colon",
    123u8 => "colonmonetary",
    44u8 => "comma",
    178u8 => "commainferior",
    248u8 => "commasuperior",
    182u8 => "dollarinferior",
    36u8 => "dollaroldstyle",
    37u8 => "dollarsuperior",
    235u8 => "dsuperior",
    165u8 => "eightinferior",
    56u8 => "eightoldstyle",
    161u8 => "eightsuperior",
    228u8 => "esuperior",
    214u8 => "exclamdownsmall",
    33u8 => "exclamsmall",
    86u8 => "ff",
    89u8 => "ffi",
    90u8 => "ffl",
    87u8 => "fi",
    208u8 => "figuredash",
    76u8 => "fiveeighths",
    176u8 => "fiveinferior",
    53u8 => "fiveoldstyle",
    222u8 => "fivesuperior",
    88u8 => "fl",
    162u8 => "fourinferior",
    52u8 => "fouroldstyle",
    221u8 => "foursuperior",
    47u8 => "fraction",
    45u8 => "hyphen",
    95u8 => "hypheninferior",
    209u8 => "hyphensuperior",
    233u8 => "isuperior",
    241u8 => "lsuperior",
    247u8 => "msuperior",
    187u8 => "nineinferior",
    57u8 => "nineoldstyle",
    225u8 => "ninesuperior",
    246u8 => "nsuperior",
    43u8 => "onedotenleader",
    74u8 => "oneeighth",
    124u8 => "onefitted",
    72u8 => "onehalf",
    193u8 => "oneinferior",
    49u8 => "oneoldstyle",
    71u8 => "onequarter",
    218u8 => "onesuperior",
    78u8 => "onethird",
    175u8 => "osuperior",
    91u8 => "parenleftinferior",
    40u8 => "parenleftsuperior",
    93u8 => "parenrightinferior",
    41u8 => "parenrightsuperior",
    46u8 => "period",
    179u8 => "periodinferior",
    249u8 => "periodsuperior",
    192u8 => "questiondownsmall",
    63u8 => "questionsmall",
    229u8 => "rsuperior",
    125u8 => "rupiah",
    59u8 => "semicolon",
    77u8 => "seveneighths",
    166u8 => "seveninferior",
    55u8 => "sevenoldstyle",
    224u8 => "sevensuperior",
    164u8 => "sixinferior",
    54u8 => "sixoldstyle",
    223u8 => "sixsuperior",
    32u8 => "space",
    234u8 => "ssuperior",
    75u8 => "threeeighths",
    163u8 => "threeinferior",
    51u8 => "threeoldstyle",
    73u8 => "threequarters",
    61u8 => "threequartersemdash",
    220u8 => "threesuperior",
    230u8 => "tsuperior",
    42u8 => "twodotenleader",
    170u8 => "twoinferior",
    50u8 => "twooldstyle",
    219u8 => "twosuperior",
    79u8 => "twothirds",
    188u8 => "zeroinferior",
    48u8 => "zerooldstyle",
    226u8 => "zerosuperior",
};
