// This file is generated by `codegen/src/html.rs` and derived from:
//
// - https://html.spec.whatwg.org/commit-snapshots/942e63def84b91fa62efd1f924e3f330ad15c62f/
// - https://fetch.spec.whatwg.org/commit-snapshots/5261b5195b43984f099f8b9eb076f39878e35489/
// - https://www.w3.org/TR/2017/CR-referrer-policy-20170126/
// - https://www.w3.org/TR/2017/REC-wai-aria-1.1-20171214/
//
// Do not edit by hand.

#![cfg_attr(rustfmt, rustfmt_skip)]

use super::{ElemInfo, AttrInfo, Type};

/// A list of all HTML elements.
pub const ELEMS: &[ElemInfo] = &[
    ElemInfo::new(
        "a",
        "Hyperlink.",
        &[115, 129, 132, 167, 176, 177, 203, 210],
    ),
    ElemInfo::new(
        "abbr",
        "Abbreviation.",
        &[],
    ),
    ElemInfo::new(
        "address",
        "Contact information for a page or article element.",
        &[],
    ),
    ElemInfo::new(
        "area",
        "Hyperlink or dead area on an image map.",
        &[83, 102, 115, 129, 167, 176, 177, 192, 203],
    ),
    ElemInfo::new(
        "article",
        "Self-contained syndicatable or reusable composition.",
        &[],
    ),
    ElemInfo::new(
        "aside",
        "Sidebar for tangentially related content.",
        &[],
    ),
    ElemInfo::new(
        "audio",
        "Audio player.",
        &[88, 101, 103, 142, 153, 173, 197],
    ),
    ElemInfo::new(
        "b",
        "Keywords.",
        &[],
    ),
    ElemInfo::new(
        "base",
        "Base URL and default target navigable for hyperlinks and forms.",
        &[131, 204],
    ),
    ElemInfo::new(
        "bdi",
        "Text directionality isolation.",
        &[],
    ),
    ElemInfo::new(
        "bdo",
        "Text directionality formatting.",
        &[],
    ),
    ElemInfo::new(
        "blockquote",
        "A section quoted from another source.",
        &[92],
    ),
    ElemInfo::new(
        "body",
        "Document body.",
        &[],
    ),
    ElemInfo::new(
        "br",
        "Line break, e.g. in poem or postal address.",
        &[],
    ),
    ElemInfo::new(
        "button",
        "Button control.",
        &[98, 99, 112, 120, 121, 122, 123, 124, 125, 154, 170, 171, 211, 217],
    ),
    ElemInfo::new(
        "canvas",
        "Scriptable bitmap canvas.",
        &[127, 222],
    ),
    ElemInfo::new(
        "caption",
        "Table caption.",
        &[],
    ),
    ElemInfo::new(
        "cite",
        "Title of a work.",
        &[],
    ),
    ElemInfo::new(
        "code",
        "Computer code.",
        &[],
    ),
    ElemInfo::new(
        "col",
        "Table column.",
        &[196],
    ),
    ElemInfo::new(
        "colgroup",
        "Group of columns in a table.",
        &[196],
    ),
    ElemInfo::new(
        "data",
        "Machine-readable equivalent.",
        &[218],
    ),
    ElemInfo::new(
        "datalist",
        "Container for options for combo box control.",
        &[],
    ),
    ElemInfo::new(
        "dd",
        "Content for corresponding dt element(s).",
        &[],
    ),
    ElemInfo::new(
        "del",
        "A removal from the document.",
        &[92, 105],
    ),
    ElemInfo::new(
        "details",
        "Disclosure control for hiding details.",
        &[155, 163],
    ),
    ElemInfo::new(
        "dfn",
        "Defining instance.",
        &[],
    ),
    ElemInfo::new(
        "dialog",
        "Dialog box or window.",
        &[164],
    ),
    ElemInfo::new(
        "div",
        "Generic flow container, or container for name-value groups in dl elements.",
        &[],
    ),
    ElemInfo::new(
        "dl",
        "Association list consisting of zero or more name-value groups.",
        &[],
    ),
    ElemInfo::new(
        "dt",
        "Legend for corresponding dd element(s).",
        &[],
    ),
    ElemInfo::new(
        "em",
        "Stress emphasis.",
        &[],
    ),
    ElemInfo::new(
        "embed",
        "Plugin.",
        &[127, 197, 212, 222],
    ),
    ElemInfo::new(
        "fieldset",
        "Group of form controls.",
        &[113, 120, 154],
    ),
    ElemInfo::new(
        "figcaption",
        "Caption for figure.",
        &[],
    ),
    ElemInfo::new(
        "figure",
        "Figure with optional caption.",
        &[],
    ),
    ElemInfo::new(
        "footer",
        "Footer for a page or section.",
        &[],
    ),
    ElemInfo::new(
        "form",
        "User-submittable form.",
        &[78, 79, 86, 116, 148, 156, 162, 179, 205],
    ),
    ElemInfo::new(
        "h1",
        "Heading.",
        &[],
    ),
    ElemInfo::new(
        "h2",
        "Heading.",
        &[],
    ),
    ElemInfo::new(
        "h3",
        "Heading.",
        &[],
    ),
    ElemInfo::new(
        "h4",
        "Heading.",
        &[],
    ),
    ElemInfo::new(
        "h5",
        "Heading.",
        &[],
    ),
    ElemInfo::new(
        "h6",
        "Heading.",
        &[],
    ),
    ElemInfo::new(
        "head",
        "Container for document metadata.",
        &[],
    ),
    ElemInfo::new(
        "header",
        "Introductory or navigational aids for a page or section.",
        &[],
    ),
    ElemInfo::new(
        "hgroup",
        "Heading container.",
        &[],
    ),
    ElemInfo::new(
        "hr",
        "Thematic break.",
        &[],
    ),
    ElemInfo::new(
        "html",
        "Root element.",
        &[],
    ),
    ElemInfo::new(
        "i",
        "Alternate voice.",
        &[],
    ),
    ElemInfo::new(
        "iframe",
        "Child navigable.",
        &[80, 81, 127, 141, 157, 176, 184, 197, 198, 222],
    ),
    ElemInfo::new(
        "img",
        "Image.",
        &[83, 103, 107, 117, 127, 137, 141, 176, 195, 197, 200, 216, 222],
    ),
    ElemInfo::new(
        "input",
        "Form control.",
        &[77, 82, 83, 87, 91, 95, 111, 112, 120, 121, 122, 123, 124, 125, 127, 140, 144, 146, 149, 151, 152, 154, 166, 168, 170, 171, 174, 180, 193, 197, 202, 213, 219, 222],
    ),
    ElemInfo::new(
        "ins",
        "An addition to the document.",
        &[92, 105],
    ),
    ElemInfo::new(
        "kbd",
        "User input.",
        &[],
    ),
    ElemInfo::new(
        "label",
        "Caption for a form control.",
        &[118],
    ),
    ElemInfo::new(
        "legend",
        "Caption for fieldset.",
        &[],
    ),
    ElemInfo::new(
        "li",
        "List item.",
        &[220],
    ),
    ElemInfo::new(
        "link",
        "Link metadata.",
        &[84, 89, 94, 103, 114, 117, 130, 132, 134, 135, 136, 147, 176, 178, 194, 210],
    ),
    ElemInfo::new(
        "main",
        "Container for the dominant contents of the document.",
        &[],
    ),
    ElemInfo::new(
        "map",
        "Image map.",
        &[158],
    ),
    ElemInfo::new(
        "mark",
        "Highlight.",
        &[],
    ),
    ElemInfo::new(
        "menu",
        "Menu of commands.",
        &[],
    ),
    ElemInfo::new(
        "meta",
        "Text metadata.",
        &[90, 100, 133, 147, 159],
    ),
    ElemInfo::new(
        "meter",
        "Gauge.",
        &[128, 143, 145, 150, 165, 221],
    ),
    ElemInfo::new(
        "nav",
        "Section with navigational links.",
        &[],
    ),
    ElemInfo::new(
        "noscript",
        "Fallback content for script.",
        &[],
    ),
    ElemInfo::new(
        "object",
        "Image, child navigable, or plugin.",
        &[104, 120, 127, 157, 212, 222],
    ),
    ElemInfo::new(
        "ol",
        "Ordered list.",
        &[181, 201, 214],
    ),
    ElemInfo::new(
        "optgroup",
        "Group of options in a list box.",
        &[112, 139],
    ),
    ElemInfo::new(
        "option",
        "Option in a list box or combo box control.",
        &[112, 139, 186, 217],
    ),
    ElemInfo::new(
        "output",
        "Calculated output value.",
        &[119, 120, 154],
    ),
    ElemInfo::new(
        "p",
        "Paragraph.",
        &[],
    ),
    ElemInfo::new(
        "picture",
        "Image.",
        &[],
    ),
    ElemInfo::new(
        "pre",
        "Block of preformatted text.",
        &[],
    ),
    ElemInfo::new(
        "progress",
        "Progress bar.",
        &[145, 221],
    ),
    ElemInfo::new(
        "q",
        "Quotation.",
        &[92],
    ),
    ElemInfo::new(
        "rp",
        "Parenthesis for ruby annotation text.",
        &[],
    ),
    ElemInfo::new(
        "rt",
        "Ruby annotation text.",
        &[],
    ),
    ElemInfo::new(
        "ruby",
        "Ruby annotation(s).",
        &[],
    ),
    ElemInfo::new(
        "s",
        "Inaccurate text.",
        &[],
    ),
    ElemInfo::new(
        "samp",
        "Computer output.",
        &[],
    ),
    ElemInfo::new(
        "script",
        "Embedded script.",
        &[85, 89, 103, 109, 117, 136, 161, 176, 197, 215],
    ),
    ElemInfo::new(
        "search",
        "Container for search controls.",
        &[],
    ),
    ElemInfo::new(
        "section",
        "Generic document or application section.",
        &[],
    ),
    ElemInfo::new(
        "select",
        "List box control.",
        &[87, 112, 120, 152, 154, 180, 193],
    ),
    ElemInfo::new(
        "slot",
        "Shadow tree slot.",
        &[160],
    ),
    ElemInfo::new(
        "small",
        "Side comment.",
        &[],
    ),
    ElemInfo::new(
        "source",
        "Image source for img or media source for video or audio.",
        &[127, 147, 195, 197, 200, 212, 222],
    ),
    ElemInfo::new(
        "span",
        "Generic phrasing container.",
        &[],
    ),
    ElemInfo::new(
        "strong",
        "Importance.",
        &[],
    ),
    ElemInfo::new(
        "style",
        "Embedded styling information.",
        &[89, 147],
    ),
    ElemInfo::new(
        "sub",
        "Subscript.",
        &[],
    ),
    ElemInfo::new(
        "summary",
        "Caption for details.",
        &[],
    ),
    ElemInfo::new(
        "sup",
        "Superscript.",
        &[],
    ),
    ElemInfo::new(
        "table",
        "Table.",
        &[],
    ),
    ElemInfo::new(
        "tbody",
        "Group of rows in a table.",
        &[],
    ),
    ElemInfo::new(
        "td",
        "Table cell.",
        &[97, 126, 183],
    ),
    ElemInfo::new(
        "template",
        "Template.",
        &[187, 188, 189, 190, 191],
    ),
    ElemInfo::new(
        "textarea",
        "Multiline text controls.",
        &[87, 96, 111, 112, 120, 146, 151, 154, 168, 174, 180, 182, 223],
    ),
    ElemInfo::new(
        "tfoot",
        "Group of footer rows in a table.",
        &[],
    ),
    ElemInfo::new(
        "th",
        "Table header cell.",
        &[76, 97, 126, 183, 185],
    ),
    ElemInfo::new(
        "thead",
        "Group of heading rows in a table.",
        &[],
    ),
    ElemInfo::new(
        "time",
        "Machine-readable equivalent of date- or time-related data.",
        &[106],
    ),
    ElemInfo::new(
        "title",
        "Document title.",
        &[],
    ),
    ElemInfo::new(
        "tr",
        "Table row.",
        &[],
    ),
    ElemInfo::new(
        "track",
        "Timed text track.",
        &[108, 138, 139, 197, 199],
    ),
    ElemInfo::new(
        "u",
        "Unarticulated annotation.",
        &[],
    ),
    ElemInfo::new(
        "ul",
        "List.",
        &[],
    ),
    ElemInfo::new(
        "var",
        "Variable.",
        &[],
    ),
    ElemInfo::new(
        "video",
        "Video player.",
        &[88, 101, 103, 127, 142, 153, 169, 172, 173, 197, 222],
    ),
    ElemInfo::new(
        "wbr",
        "Line breaking opportunity.",
        &[],
    ),
];

/// A list of all elements' attributes.
pub const ATTRS: &[AttrInfo] = &[
    AttrInfo::new(
        "accesskey",
        "Keyboard shortcut to activate or focus element. Expects a single-codepoint string or an array thereof.",
        Type::List(&Type::Char, ' ', true),
    ),
    AttrInfo::new(
        "aria-activedescendant",
        "Identifies the currently active element when DOM focus is on a composite widget, textbox, group, or application.",
        Type::Str,
    ),
    AttrInfo::new(
        "aria-atomic",
        "Indicates whether assistive technologies will present all, or only parts of, the changed region based on the change notifications defined by the aria-relevant attribute.",
        Type::TrueFalse,
    ),
    AttrInfo::new(
        "aria-autocomplete",
        "Indicates whether inputting text could trigger display of one or more predictions of the user's intended value for an input and specifies how predictions would be presented if they are made.",
        Type::Union(&[Type::None, Type::Strings(317, 320)]),
    ),
    AttrInfo::new(
        "aria-busy",
        "Indicates an element is being modified and that assistive technologies MAY want to wait until the modifications are complete before exposing them to the user.",
        Type::TrueFalse,
    ),
    AttrInfo::new(
        "aria-checked",
        "Indicates the current \"checked\" state of checkboxes, radio buttons, and other widgets. See related aria-pressed and aria-selected.",
        Type::Union(&[Type::TrueFalse, Type::Strings(320, 321)]),
    ),
    AttrInfo::new(
        "aria-colcount",
        "Defines the total number of columns in a table, grid, or treegrid. See related aria-colindex.",
        Type::Int,
    ),
    AttrInfo::new(
        "aria-colindex",
        "Defines an element's column index or position with respect to the total number of columns within a table, grid, or treegrid. See related aria-colcount and aria-colspan.",
        Type::Int,
    ),
    AttrInfo::new(
        "aria-colspan",
        "Defines the number of columns spanned by a cell or gridcell within a table, grid, or treegrid. See related aria-colindex and aria-rowspan.",
        Type::Int,
    ),
    AttrInfo::new(
        "aria-controls",
        "Identifies the element (or elements) whose contents or presence are controlled by the current element. See related aria-owns.",
        Type::List(&Type::Str, ' ', true),
    ),
    AttrInfo::new(
        "aria-current",
        "Indicates the element that represents the current item within a container or set of related elements.",
        Type::Union(&[Type::TrueFalse, Type::Strings(321, 326)]),
    ),
    AttrInfo::new(
        "aria-describedby",
        "Identifies the element (or elements) that describes the object. See related aria-labelledby.",
        Type::List(&Type::Str, ' ', true),
    ),
    AttrInfo::new(
        "aria-details",
        "Identifies the element that provides a detailed, extended description for the object. See related aria-describedby.",
        Type::Str,
    ),
    AttrInfo::new(
        "aria-disabled",
        "Indicates that the element is perceivable but disabled, so it is not editable or otherwise operable. See related aria-hidden and aria-readonly.",
        Type::TrueFalse,
    ),
    AttrInfo::new(
        "aria-errormessage",
        "Identifies the element that provides an error message for the object. See related aria-invalid and aria-describedby.",
        Type::Str,
    ),
    AttrInfo::new(
        "aria-expanded",
        "Indicates whether the element, or another grouping element it controls, is currently expanded or collapsed.",
        Type::Union(&[Type::TrueFalse, Type::NoneUndefined]),
    ),
    AttrInfo::new(
        "aria-flowto",
        "Identifies the next element (or elements) in an alternate reading order of content which, at the user's discretion, allows assistive technology to override the general default of reading in document source order.",
        Type::List(&Type::Str, ' ', true),
    ),
    AttrInfo::new(
        "aria-haspopup",
        "Indicates the availability and type of interactive popup element, such as menu or dialog, that can be triggered by an element.",
        Type::Union(&[Type::TrueFalse, Type::Strings(326, 331)]),
    ),
    AttrInfo::new(
        "aria-hidden",
        "Indicates whether the element is exposed to an accessibility API. See related aria-disabled.",
        Type::Union(&[Type::TrueFalse, Type::NoneUndefined]),
    ),
    AttrInfo::new(
        "aria-invalid",
        "Indicates the entered value does not conform to the format expected by the application. See related aria-errormessage.",
        Type::Union(&[Type::TrueFalse, Type::Strings(331, 333)]),
    ),
    AttrInfo::new(
        "aria-keyshortcuts",
        "Indicates keyboard shortcuts that an author has implemented to activate or give focus to an element.",
        Type::Str,
    ),
    AttrInfo::new(
        "aria-label",
        "Defines a string value that labels the current element. See related aria-labelledby.",
        Type::Str,
    ),
    AttrInfo::new(
        "aria-labelledby",
        "Identifies the element (or elements) that labels the current element. See related aria-describedby.",
        Type::List(&Type::Str, ' ', true),
    ),
    AttrInfo::new(
        "aria-level",
        "Defines the hierarchical level of an element within a structure.",
        Type::Int,
    ),
    AttrInfo::new(
        "aria-live",
        "Indicates that an element will be updated, and describes the types of updates the user agents, assistive technologies, and user can expect from the live region.",
        Type::Strings(333, 336),
    ),
    AttrInfo::new(
        "aria-modal",
        "Indicates whether an element is modal when displayed.",
        Type::TrueFalse,
    ),
    AttrInfo::new(
        "aria-multiline",
        "Indicates whether a text box accepts multiple lines of input or only a single line.",
        Type::TrueFalse,
    ),
    AttrInfo::new(
        "aria-multiselectable",
        "Indicates that the user may select more than one item from the current selectable descendants.",
        Type::TrueFalse,
    ),
    AttrInfo::new(
        "aria-orientation",
        "Indicates whether the element's orientation is horizontal, vertical, or unknown/ambiguous.",
        Type::Strings(336, 339),
    ),
    AttrInfo::new(
        "aria-owns",
        "Identifies an element (or elements) in order to define a visual, functional, or contextual parent/child relationship between DOM elements where the DOM hierarchy cannot be used to represent the relationship. See related aria-controls.",
        Type::List(&Type::Str, ' ', true),
    ),
    AttrInfo::new(
        "aria-placeholder",
        "Defines a short hint (a word or short phrase) intended to aid the user with data entry when the control has no value. A hint could be a sample value or a brief description of the expected format.",
        Type::Str,
    ),
    AttrInfo::new(
        "aria-posinset",
        "Defines an element's number or position in the current set of listitems or treeitems. Not required if all elements in the set are present in the DOM. See related aria-setsize.",
        Type::Int,
    ),
    AttrInfo::new(
        "aria-pressed",
        "Indicates the current \"pressed\" state of toggle buttons. See related aria-checked and aria-selected.",
        Type::Union(&[Type::TrueFalse, Type::Strings(320, 321)]),
    ),
    AttrInfo::new(
        "aria-readonly",
        "Indicates that the element is not editable, but is otherwise operable. See related aria-disabled.",
        Type::TrueFalse,
    ),
    AttrInfo::new(
        "aria-relevant",
        "Indicates what notifications the user agent will trigger when the accessibility tree within a live region is modified. See related aria-atomic.",
        Type::List(&Type::Strings(339, 344), ' ', true),
    ),
    AttrInfo::new(
        "aria-required",
        "Indicates that user input is required on the element before a form may be submitted.",
        Type::TrueFalse,
    ),
    AttrInfo::new(
        "aria-roledescription",
        "Defines a human-readable, author-localized description for the role of an element.",
        Type::Str,
    ),
    AttrInfo::new(
        "aria-rowcount",
        "Defines the total number of rows in a table, grid, or treegrid. See related aria-rowindex.",
        Type::Int,
    ),
    AttrInfo::new(
        "aria-rowindex",
        "Defines an element's row index or position with respect to the total number of rows within a table, grid, or treegrid. See related aria-rowcount and aria-rowspan.",
        Type::Int,
    ),
    AttrInfo::new(
        "aria-rowspan",
        "Defines the number of rows spanned by a cell or gridcell within a table, grid, or treegrid. See related aria-rowindex and aria-colspan.",
        Type::Int,
    ),
    AttrInfo::new(
        "aria-selected",
        "Indicates the current \"selected\" state of various widgets. See related aria-checked and aria-pressed.",
        Type::Union(&[Type::TrueFalse, Type::NoneUndefined]),
    ),
    AttrInfo::new(
        "aria-setsize",
        "Defines the number of items in the current set of listitems or treeitems. Not required if all elements in the set are present in the DOM. See related aria-posinset.",
        Type::Int,
    ),
    AttrInfo::new(
        "aria-sort",
        "Indicates if items in a table or grid are sorted in ascending or descending order.",
        Type::Union(&[Type::None, Type::Strings(344, 347)]),
    ),
    AttrInfo::new(
        "aria-valuemax",
        "Defines the maximum allowed value for a range widget.",
        Type::Float,
    ),
    AttrInfo::new(
        "aria-valuemin",
        "Defines the minimum allowed value for a range widget.",
        Type::Float,
    ),
    AttrInfo::new(
        "aria-valuenow",
        "Defines the current value for a range widget. See related aria-valuetext.",
        Type::Float,
    ),
    AttrInfo::new(
        "aria-valuetext",
        "Defines the human readable text alternative of aria-valuenow for a range widget.",
        Type::Str,
    ),
    AttrInfo::new(
        "autocapitalize",
        "Recommended autocapitalization behavior (for supported input methods).",
        Type::Union(&[Type::OnOff, Type::None, Type::Strings(23, 26)]),
    ),
    AttrInfo::new(
        "autocorrect",
        "Recommended autocorrection behavior (for supported input methods).",
        Type::OnOff,
    ),
    AttrInfo::new(
        "autofocus",
        "Automatically focus the element when the page is loaded.",
        Type::Presence,
    ),
    AttrInfo::new(
        "class",
        "Classes to which the element belongs.",
        Type::List(&Type::Str, ' ', true),
    ),
    AttrInfo::new(
        "contenteditable",
        "Whether the element is editable.",
        Type::Union(&[Type::TrueFalse, Type::Strings(98, 99)]),
    ),
    AttrInfo::new(
        "dir",
        "The text directionality of the element.",
        Type::Union(&[Type::HorizontalDir, Type::Auto]),
    ),
    AttrInfo::new(
        "draggable",
        "Whether the element is draggable.",
        Type::TrueFalse,
    ),
    AttrInfo::new(
        "enterkeyhint",
        "Hint for selecting an enter key action.",
        Type::Strings(106, 113),
    ),
    AttrInfo::new(
        "hidden",
        "Whether the element is relevant.",
        Type::Union(&[Type::Presence, Type::Strings(122, 123)]),
    ),
    AttrInfo::new(
        "id",
        "The element's ID.",
        Type::Str,
    ),
    AttrInfo::new(
        "inert",
        "Whether the element is inert.",
        Type::Presence,
    ),
    AttrInfo::new(
        "inputmode",
        "Hint for selecting an input modality.",
        Type::Union(&[Type::None, Type::Strings(128, 135)]),
    ),
    AttrInfo::new(
        "is",
        "Creates a customized built-in element.",
        Type::Str,
    ),
    AttrInfo::new(
        "itemid",
        "Global identifier for a microdata item.",
        Type::Str,
    ),
    AttrInfo::new(
        "itemprop",
        "Property names of a microdata item.",
        Type::List(&Type::Str, ' ', true),
    ),
    AttrInfo::new(
        "itemref",
        "Referenced elements.",
        Type::List(&Type::Str, ' ', true),
    ),
    AttrInfo::new(
        "itemscope",
        "Introduces a microdata item.",
        Type::Presence,
    ),
    AttrInfo::new(
        "itemtype",
        "Item types of a microdata item.",
        Type::List(&Type::Str, ' ', true),
    ),
    AttrInfo::new(
        "lang",
        "Language of the element.",
        Type::Union(&[Type::Str, Type::NoneEmpty]),
    ),
    AttrInfo::new(
        "nonce",
        "Cryptographic nonce used in Content Security Policy checks.",
        Type::Str,
    ),
    AttrInfo::new(
        "popover",
        "Makes the element a popover element.",
        Type::Union(&[Type::Auto, Type::Strings(142, 143)]),
    ),
    AttrInfo::new(
        "role",
        "An ARIA role.",
        Type::Union(&[Type::None, Type::Strings(237, 317)]),
    ),
    AttrInfo::new(
        "slot",
        "The element's desired slot.",
        Type::Str,
    ),
    AttrInfo::new(
        "spellcheck",
        "Whether the element is to have its spelling and grammar checked.",
        Type::TrueFalse,
    ),
    AttrInfo::new(
        "style",
        "Presentational and formatting instructions.",
        Type::Str,
    ),
    AttrInfo::new(
        "tabindex",
        "Whether the element is focusable and sequentially focusable, and the relative order of the element for the purposes of sequential focus navigation.",
        Type::Int,
    ),
    AttrInfo::new(
        "title",
        "Advisory information for the element.",
        Type::Str,
    ),
    AttrInfo::new(
        "translate",
        "Whether the element is to be translated when the page is localized.",
        Type::YesNo,
    ),
    AttrInfo::new(
        "writingsuggestions",
        "Whether the element can offer writing suggestions or not.",
        Type::TrueFalse,
    ),
    AttrInfo::new(
        "abbr",
        "Alternative label to use for the header cell when referencing the cell in other contexts.",
        Type::Str,
    ),
    AttrInfo::new(
        "accept",
        "Hint for expected file type in file upload controls.",
        Type::List(&Type::Str, ',', true),
    ),
    AttrInfo::new(
        "accept-charset",
        "Character encodings to use for form submission.",
        Type::Strings(0, 1),
    ),
    AttrInfo::new(
        "action",
        "URL to use for form submission.",
        Type::Str,
    ),
    AttrInfo::new(
        "allow",
        "Permissions policy to be applied to the iframe's contents.",
        Type::Str,
    ),
    AttrInfo::new(
        "allowfullscreen",
        "Whether to allow the iframe's contents to use requestFullscreen().",
        Type::Presence,
    ),
    AttrInfo::new(
        "alpha",
        "Allow the color's alpha component to be set.",
        Type::Presence,
    ),
    AttrInfo::new(
        "alt",
        "Replacement text for use when images are not available.",
        Type::Str,
    ),
    AttrInfo::new(
        "as",
        "Potential destination for a preload request (for rel=\"preload\" and rel=\"modulepreload\").",
        Type::Strings(1, 23),
    ),
    AttrInfo::new(
        "async",
        "Execute script when available, without blocking while fetching.",
        Type::Presence,
    ),
    AttrInfo::new(
        "autocomplete",
        "Default setting for autofill feature for controls in the form.",
        Type::OnOff,
    ),
    AttrInfo::new(
        "autocomplete",
        "Hint for form autofill feature.",
        Type::List(&Type::Strings(26, 87), ' ', true),
    ),
    AttrInfo::new(
        "autoplay",
        "Hint that the media resource can be started automatically when the page is loaded.",
        Type::Presence,
    ),
    AttrInfo::new(
        "blocking",
        "Whether the element is potentially render-blocking.",
        Type::List(&Type::Strings(87, 88), ' ', true),
    ),
    AttrInfo::new(
        "charset",
        "Character encoding declaration.",
        Type::Strings(0, 1),
    ),
    AttrInfo::new(
        "checked",
        "Whether the control is checked.",
        Type::Presence,
    ),
    AttrInfo::new(
        "cite",
        "Link to the source of the quotation or more information about the edit.",
        Type::Str,
    ),
    AttrInfo::new(
        "closedby",
        "Which user actions will close the dialog.",
        Type::Union(&[Type::None, Type::Strings(88, 90)]),
    ),
    AttrInfo::new(
        "color",
        "Color to use when customizing a site's icon (for rel=\"mask-icon\").",
        Type::Color,
    ),
    AttrInfo::new(
        "colorspace",
        "The color space of the serialized color.",
        Type::Strings(90, 92),
    ),
    AttrInfo::new(
        "cols",
        "Maximum number of characters per line.",
        Type::PositiveInt,
    ),
    AttrInfo::new(
        "colspan",
        "Number of columns that the cell is to span.",
        Type::PositiveInt,
    ),
    AttrInfo::new(
        "command",
        "Indicates to the targeted element which action to take.",
        Type::Union(&[Type::Strings(92, 98), Type::Str]),
    ),
    AttrInfo::new(
        "commandfor",
        "Targets another element to be invoked.",
        Type::Str,
    ),
    AttrInfo::new(
        "content",
        "Value of the element.",
        Type::Str,
    ),
    AttrInfo::new(
        "controls",
        "Show user agent controls.",
        Type::Presence,
    ),
    AttrInfo::new(
        "coords",
        "Coordinates for the shape to be created in an image map. Expects an array of floating point numbers.",
        Type::List(&Type::Float, ',', false),
    ),
    AttrInfo::new(
        "crossorigin",
        "How the element handles crossorigin requests.",
        Type::Strings(99, 101),
    ),
    AttrInfo::new(
        "data",
        "Address of the resource.",
        Type::Str,
    ),
    AttrInfo::new(
        "datetime",
        "Date and (optionally) time of the change.",
        Type::Datetime,
    ),
    AttrInfo::new(
        "datetime",
        "Machine-readable value.",
        Type::Union(&[Type::Duration, Type::Datetime]),
    ),
    AttrInfo::new(
        "decoding",
        "Decoding hint to use when processing this image for presentation.",
        Type::Union(&[Type::Auto, Type::Strings(101, 103)]),
    ),
    AttrInfo::new(
        "default",
        "Enable the track if no other text track is more suitable.",
        Type::Presence,
    ),
    AttrInfo::new(
        "defer",
        "Defer script execution.",
        Type::Presence,
    ),
    AttrInfo::new(
        "dir",
        "The text directionality of the element.",
        Type::HorizontalDir,
    ),
    AttrInfo::new(
        "dirname",
        "Name of form control to use for sending the element's directionality in form submission.",
        Type::Str,
    ),
    AttrInfo::new(
        "disabled",
        "Whether the form control is disabled.",
        Type::Presence,
    ),
    AttrInfo::new(
        "disabled",
        "Whether the descendant form controls, except any inside legend, are disabled.",
        Type::Presence,
    ),
    AttrInfo::new(
        "disabled",
        "Whether the link is disabled.",
        Type::Presence,
    ),
    AttrInfo::new(
        "download",
        "Whether to download the resource instead of navigating to it, and its filename if so.",
        Type::Str,
    ),
    AttrInfo::new(
        "enctype",
        "Entry list encoding type to use for form submission.",
        Type::Strings(103, 106),
    ),
    AttrInfo::new(
        "fetchpriority",
        "Sets the priority for fetches initiated by the element.",
        Type::Union(&[Type::Auto, Type::Strings(113, 115)]),
    ),
    AttrInfo::new(
        "for",
        "Associate the label with form control.",
        Type::Str,
    ),
    AttrInfo::new(
        "for",
        "Specifies controls from which the output was calculated.",
        Type::List(&Type::Str, ' ', true),
    ),
    AttrInfo::new(
        "form",
        "Associates the element with a form element.",
        Type::Str,
    ),
    AttrInfo::new(
        "formaction",
        "URL to use for form submission.",
        Type::Str,
    ),
    AttrInfo::new(
        "formenctype",
        "Entry list encoding type to use for form submission.",
        Type::Strings(103, 106),
    ),
    AttrInfo::new(
        "formmethod",
        "Variant to use for form submission.",
        Type::Strings(115, 118),
    ),
    AttrInfo::new(
        "formnovalidate",
        "Bypass form control validation for form submission.",
        Type::Presence,
    ),
    AttrInfo::new(
        "formtarget",
        "Navigable for form submission.",
        Type::Union(&[Type::Strings(118, 122), Type::Str]),
    ),
    AttrInfo::new(
        "headers",
        "The header cells for this cell.",
        Type::List(&Type::Str, ' ', true),
    ),
    AttrInfo::new(
        "height",
        "Vertical dimension.",
        Type::NonNegativeInt,
    ),
    AttrInfo::new(
        "high",
        "Low limit of high range.",
        Type::Float,
    ),
    AttrInfo::new(
        "href",
        "Address of the hyperlink.",
        Type::Str,
    ),
    AttrInfo::new(
        "href",
        "Address of the hyperlink.",
        Type::Str,
    ),
    AttrInfo::new(
        "href",
        "Document base URL.",
        Type::Str,
    ),
    AttrInfo::new(
        "hreflang",
        "Language of the linked resource.",
        Type::Str,
    ),
    AttrInfo::new(
        "http-equiv",
        "Pragma directive.",
        Type::Strings(123, 128),
    ),
    AttrInfo::new(
        "imagesizes",
        "Image sizes for different page layouts (for rel=\"preload\"). Expects an array of dictionaries with the keys `condition` (string) and `size` (length).",
        Type::List(&Type::SourceSize, ',', false),
    ),
    AttrInfo::new(
        "imagesrcset",
        "Images to use in different situations, e.g., high-resolution displays, small monitors, etc. (for rel=\"preload\"). Expects an array of dictionaries with the keys `src` (string) and `width` (integer) or `density` (float).",
        Type::List(&Type::ImageCandidate, ',', false),
    ),
    AttrInfo::new(
        "integrity",
        "Integrity metadata used in Subresource Integrity checks.",
        Type::Str,
    ),
    AttrInfo::new(
        "ismap",
        "Whether the image is a server-side image map.",
        Type::Presence,
    ),
    AttrInfo::new(
        "kind",
        "The type of text track.",
        Type::Strings(135, 140),
    ),
    AttrInfo::new(
        "label",
        "User-visible label.",
        Type::Str,
    ),
    AttrInfo::new(
        "list",
        "List of autocomplete options.",
        Type::Str,
    ),
    AttrInfo::new(
        "loading",
        "Used when determining loading deferral.",
        Type::Strings(140, 142),
    ),
    AttrInfo::new(
        "loop",
        "Whether to loop the media resource.",
        Type::Presence,
    ),
    AttrInfo::new(
        "low",
        "High limit of low range.",
        Type::Float,
    ),
    AttrInfo::new(
        "max",
        "Maximum value.",
        Type::Union(&[Type::Str, Type::Float, Type::Datetime]),
    ),
    AttrInfo::new(
        "max",
        "Upper bound of range.",
        Type::Float,
    ),
    AttrInfo::new(
        "maxlength",
        "Maximum length of value.",
        Type::NonNegativeInt,
    ),
    AttrInfo::new(
        "media",
        "Applicable media.",
        Type::Str,
    ),
    AttrInfo::new(
        "method",
        "Variant to use for form submission.",
        Type::Strings(115, 118),
    ),
    AttrInfo::new(
        "min",
        "Minimum value.",
        Type::Union(&[Type::Str, Type::Float, Type::Datetime]),
    ),
    AttrInfo::new(
        "min",
        "Lower bound of range.",
        Type::Float,
    ),
    AttrInfo::new(
        "minlength",
        "Minimum length of value.",
        Type::NonNegativeInt,
    ),
    AttrInfo::new(
        "multiple",
        "Whether to allow multiple values.",
        Type::Presence,
    ),
    AttrInfo::new(
        "muted",
        "Whether to mute the media resource by default.",
        Type::Presence,
    ),
    AttrInfo::new(
        "name",
        "Name of the element to use for form submission and in the form.elements API.",
        Type::Str,
    ),
    AttrInfo::new(
        "name",
        "Name of group of mutually-exclusive details elements.",
        Type::Str,
    ),
    AttrInfo::new(
        "name",
        "Name of form to use in the document.forms API.",
        Type::Str,
    ),
    AttrInfo::new(
        "name",
        "Name of content navigable.",
        Type::Union(&[Type::Strings(118, 122), Type::Str]),
    ),
    AttrInfo::new(
        "name",
        "Name of image map to reference from the usemap attribute.",
        Type::Str,
    ),
    AttrInfo::new(
        "name",
        "Metadata name.",
        Type::Str,
    ),
    AttrInfo::new(
        "name",
        "Name of shadow tree slot.",
        Type::Str,
    ),
    AttrInfo::new(
        "nomodule",
        "Prevents execution in user agents that support module scripts.",
        Type::Presence,
    ),
    AttrInfo::new(
        "novalidate",
        "Bypass form control validation for form submission.",
        Type::Presence,
    ),
    AttrInfo::new(
        "open",
        "Whether the details are visible.",
        Type::Presence,
    ),
    AttrInfo::new(
        "open",
        "Whether the dialog box is showing.",
        Type::Presence,
    ),
    AttrInfo::new(
        "optimum",
        "Optimum value in gauge.",
        Type::Float,
    ),
    AttrInfo::new(
        "pattern",
        "Pattern to be matched by the form control's value.",
        Type::Str,
    ),
    AttrInfo::new(
        "ping",
        "URLs to ping.",
        Type::List(&Type::Str, ' ', true),
    ),
    AttrInfo::new(
        "placeholder",
        "User-visible label to be placed within the form control.",
        Type::Str,
    ),
    AttrInfo::new(
        "playsinline",
        "Encourage the user agent to display video content within the element's playback area.",
        Type::Presence,
    ),
    AttrInfo::new(
        "popovertarget",
        "Targets a popover element to toggle, show, or hide.",
        Type::Str,
    ),
    AttrInfo::new(
        "popovertargetaction",
        "Indicates whether a targeted popover element is to be toggled, shown, or hidden.",
        Type::Strings(143, 146),
    ),
    AttrInfo::new(
        "poster",
        "Poster frame to show prior to video playback.",
        Type::Str,
    ),
    AttrInfo::new(
        "preload",
        "Hints how much buffering the media resource will likely need.",
        Type::Union(&[Type::None, Type::Auto, Type::Strings(139, 140)]),
    ),
    AttrInfo::new(
        "readonly",
        "Whether to allow the value to be edited by the user.",
        Type::Presence,
    ),
    AttrInfo::new(
        "readonly",
        "Affects willValidate, plus any behavior added by the custom element author.",
        Type::Presence,
    ),
    AttrInfo::new(
        "referrerpolicy",
        "Referrer policy for fetches initiated by the element.",
        Type::Union(&[Type::Strings(146, 154), Type::NoneEmpty]),
    ),
    AttrInfo::new(
        "rel",
        "Relationship between the location in the document containing the hyperlink and the destination resource.",
        Type::List(&Type::Strings(154, 181), ' ', true),
    ),
    AttrInfo::new(
        "rel",
        "Relationship between the document containing the hyperlink and the destination resource.",
        Type::List(&Type::Strings(154, 181), ' ', true),
    ),
    AttrInfo::new(
        "rel",
        "Relationship between the document containing the form and its action destination",
        Type::List(&Type::Strings(154, 181), ' ', true),
    ),
    AttrInfo::new(
        "required",
        "Whether the control is required for form submission.",
        Type::Presence,
    ),
    AttrInfo::new(
        "reversed",
        "Number the list backwards.",
        Type::Presence,
    ),
    AttrInfo::new(
        "rows",
        "Number of lines to show.",
        Type::PositiveInt,
    ),
    AttrInfo::new(
        "rowspan",
        "Number of rows that the cell is to span.",
        Type::NonNegativeInt,
    ),
    AttrInfo::new(
        "sandbox",
        "Security rules for nested content.",
        Type::List(&Type::Strings(181, 194), ' ', true),
    ),
    AttrInfo::new(
        "scope",
        "Specifies which cells the header cell applies to.",
        Type::Strings(194, 198),
    ),
    AttrInfo::new(
        "selected",
        "Whether the option is selected by default.",
        Type::Presence,
    ),
    AttrInfo::new(
        "shadowrootclonable",
        "Sets clonable on a declarative shadow root.",
        Type::Presence,
    ),
    AttrInfo::new(
        "shadowrootcustomelementregistry",
        "Enables declarative shadow roots to indicate they will use a custom element registry.",
        Type::Presence,
    ),
    AttrInfo::new(
        "shadowrootdelegatesfocus",
        "Sets delegates focus on a declarative shadow root.",
        Type::Presence,
    ),
    AttrInfo::new(
        "shadowrootmode",
        "Enables streaming declarative shadow roots.",
        Type::Strings(198, 200),
    ),
    AttrInfo::new(
        "shadowrootserializable",
        "Sets serializable on a declarative shadow root.",
        Type::Presence,
    ),
    AttrInfo::new(
        "shape",
        "The kind of shape to be created in an image map.",
        Type::Strings(200, 204),
    ),
    AttrInfo::new(
        "size",
        "Size of the control.",
        Type::PositiveInt,
    ),
    AttrInfo::new(
        "sizes",
        "Sizes of the icons (for rel=\"icon\"). Expects an array of sizes. Each size is specified as an array of two integers (width and height).",
        Type::List(&Type::IconSize, ' ', false),
    ),
    AttrInfo::new(
        "sizes",
        "Image sizes for different page layouts. Expects an array of dictionaries with the keys `condition` (string) and `size` (length).",
        Type::List(&Type::SourceSize, ',', false),
    ),
    AttrInfo::new(
        "span",
        "Number of columns spanned by the element.",
        Type::PositiveInt,
    ),
    AttrInfo::new(
        "src",
        "Address of the resource.",
        Type::Str,
    ),
    AttrInfo::new(
        "srcdoc",
        "A document to render in the iframe.",
        Type::Str,
    ),
    AttrInfo::new(
        "srclang",
        "Language of the text track.",
        Type::Str,
    ),
    AttrInfo::new(
        "srcset",
        "Images to use in different situations, e.g., high-resolution displays, small monitors, etc. Expects an array of dictionaries with the keys `src` (string) and `width` (integer) or `density` (float).",
        Type::List(&Type::ImageCandidate, ',', false),
    ),
    AttrInfo::new(
        "start",
        "Starting value of the list.",
        Type::Int,
    ),
    AttrInfo::new(
        "step",
        "Granularity to be matched by the form control's value.",
        Type::Union(&[Type::PositiveFloat, Type::Strings(88, 89)]),
    ),
    AttrInfo::new(
        "target",
        "Navigable for hyperlink navigation.",
        Type::Union(&[Type::Strings(118, 122), Type::Str]),
    ),
    AttrInfo::new(
        "target",
        "Default navigable for hyperlink navigation and form submission.",
        Type::Union(&[Type::Strings(118, 122), Type::Str]),
    ),
    AttrInfo::new(
        "target",
        "Navigable for form submission.",
        Type::Union(&[Type::Strings(118, 122), Type::Str]),
    ),
    AttrInfo::new(
        "title",
        "Full term or expansion of abbreviation.",
        Type::Str,
    ),
    AttrInfo::new(
        "title",
        "Description of pattern (when used with pattern attribute).",
        Type::Str,
    ),
    AttrInfo::new(
        "title",
        "Title of the link.",
        Type::Str,
    ),
    AttrInfo::new(
        "title",
        "CSS style sheet set name.",
        Type::Str,
    ),
    AttrInfo::new(
        "type",
        "Hint for the type of the referenced resource.",
        Type::Str,
    ),
    AttrInfo::new(
        "type",
        "Type of button.",
        Type::Strings(204, 207),
    ),
    AttrInfo::new(
        "type",
        "Type of embedded resource.",
        Type::Str,
    ),
    AttrInfo::new(
        "type",
        "Type of form control.",
        Type::Strings(207, 229),
    ),
    AttrInfo::new(
        "type",
        "Kind of list marker.",
        Type::Strings(229, 234),
    ),
    AttrInfo::new(
        "type",
        "Type of script.",
        Type::Union(&[Type::Strings(234, 235), Type::Str]),
    ),
    AttrInfo::new(
        "usemap",
        "Name of image map to use.",
        Type::Str,
    ),
    AttrInfo::new(
        "value",
        "Value to be used for form submission.",
        Type::Str,
    ),
    AttrInfo::new(
        "value",
        "Machine-readable value.",
        Type::Str,
    ),
    AttrInfo::new(
        "value",
        "Value of the form control.",
        Type::Union(&[Type::Str, Type::Float, Type::Datetime, Type::Color, Type::List(&Type::Str, ',', false)]),
    ),
    AttrInfo::new(
        "value",
        "Ordinal value of the list item.",
        Type::Int,
    ),
    AttrInfo::new(
        "value",
        "Current value of the element.",
        Type::Float,
    ),
    AttrInfo::new(
        "width",
        "Horizontal dimension.",
        Type::NonNegativeInt,
    ),
    AttrInfo::new(
        "wrap",
        "How the value of the form control is to be wrapped for form submission.",
        Type::Strings(235, 237),
    ),
];

/// The first `ATTRS_GLOBAL` attributes in `ATTRS` apply to all elements.
pub const ATTRS_GLOBAL: usize = 76;

/// Strings referenced by [`Type::Strings`].
pub const ATTR_STRINGS: &[(&str, &str)] = &[
    ("utf-8", ""),
    ("audio", ""),
    ("audioworklet", ""),
    ("document", ""),
    ("embed", ""),
    ("font", ""),
    ("frame", ""),
    ("iframe", ""),
    ("image", ""),
    ("json", ""),
    ("manifest", ""),
    ("object", ""),
    ("paintworklet", ""),
    ("report", ""),
    ("script", ""),
    ("serviceworker", ""),
    ("sharedworker", ""),
    ("style", ""),
    ("track", ""),
    ("video", ""),
    ("webidentity", ""),
    ("worker", ""),
    ("xslt", ""),
    ("sentences", ""),
    ("words", ""),
    ("characters", ""),
    ("shipping", ""),
    ("billing", ""),
    ("name", ""),
    ("honorific-prefix", ""),
    ("given-name", ""),
    ("additional-name", ""),
    ("family-name", ""),
    ("honorific-suffix", ""),
    ("nickname", ""),
    ("username", ""),
    ("new-password", ""),
    ("current-password", ""),
    ("one-time-code", ""),
    ("organization-title", ""),
    ("organization", ""),
    ("street-address", ""),
    ("address-line1", ""),
    ("address-line2", ""),
    ("address-line3", ""),
    ("address-level4", ""),
    ("address-level3", ""),
    ("address-level2", ""),
    ("address-level1", ""),
    ("country", ""),
    ("country-name", ""),
    ("postal-code", ""),
    ("cc-name", ""),
    ("cc-given-name", ""),
    ("cc-additional-name", ""),
    ("cc-family-name", ""),
    ("cc-number", ""),
    ("cc-exp", ""),
    ("cc-exp-month", ""),
    ("cc-exp-year", ""),
    ("cc-csc", ""),
    ("cc-type", ""),
    ("transaction-currency", ""),
    ("transaction-amount", ""),
    ("language", ""),
    ("bday", ""),
    ("bday-day", ""),
    ("bday-month", ""),
    ("bday-year", ""),
    ("sex", ""),
    ("url", ""),
    ("photo", ""),
    ("home", ""),
    ("work", ""),
    ("mobile", ""),
    ("fax", ""),
    ("pager", ""),
    ("tel", ""),
    ("tel-country-code", ""),
    ("tel-national", ""),
    ("tel-area-code", ""),
    ("tel-local", ""),
    ("tel-local-prefix", ""),
    ("tel-local-suffix", ""),
    ("tel-extension", ""),
    ("email", ""),
    ("impp", ""),
    ("blocking", ""),
    ("any", ""),
    ("closerequest", ""),
    ("limited-srgb", ""),
    ("display-p3", ""),
    ("toggle-popover", ""),
    ("show-popover", ""),
    ("hide-popover", ""),
    ("close", ""),
    ("request-close", ""),
    ("show-modal", ""),
    ("plaintext-only", ""),
    ("anonymous", ""),
    ("use-credentials", ""),
    ("sync", ""),
    ("async", ""),
    ("application/x-www-form-urlencoded", ""),
    ("multipart/form-data", ""),
    ("text/plain", ""),
    ("enter", ""),
    ("done", ""),
    ("go", ""),
    ("next", ""),
    ("previous", ""),
    ("search", ""),
    ("send", ""),
    ("high", ""),
    ("low", ""),
    ("GET", ""),
    ("POST", ""),
    ("dialog", ""),
    ("_blank", ""),
    ("_self", ""),
    ("_parent", ""),
    ("_top", ""),
    ("until-found", ""),
    ("content-type", ""),
    ("default-style", ""),
    ("refresh", ""),
    ("x-ua-compatible", ""),
    ("content-security-policy", ""),
    ("text", ""),
    ("tel", ""),
    ("email", ""),
    ("url", ""),
    ("numeric", ""),
    ("decimal", ""),
    ("search", ""),
    ("subtitles", ""),
    ("captions", ""),
    ("descriptions", ""),
    ("chapters", ""),
    ("metadata", ""),
    ("lazy", ""),
    ("eager", ""),
    ("manual", ""),
    ("toggle", ""),
    ("show", ""),
    ("hide", ""),
    ("no-referrer", ""),
    ("no-referrer-when-downgrade", ""),
    ("same-origin", ""),
    ("origin", ""),
    ("strict-origin", ""),
    ("origin-when-cross-origin", ""),
    ("strict-origin-when-cross-origin", ""),
    ("unsafe-url", ""),
    ("alternate", ""),
    ("canonical", ""),
    ("author", ""),
    ("bookmark", ""),
    ("dns-prefetch", ""),
    ("expect", ""),
    ("external", ""),
    ("help", ""),
    ("icon", ""),
    ("manifest", ""),
    ("modulepreload", ""),
    ("license", ""),
    ("next", ""),
    ("nofollow", ""),
    ("noopener", ""),
    ("noreferrer", ""),
    ("opener", ""),
    ("pingback", ""),
    ("preconnect", ""),
    ("prefetch", ""),
    ("preload", ""),
    ("prev", ""),
    ("privacy-policy", ""),
    ("search", ""),
    ("stylesheet", ""),
    ("tag", ""),
    ("terms-of-service", ""),
    ("allow-downloads", ""),
    ("allow-forms", ""),
    ("allow-modals", ""),
    ("allow-orientation-lock", ""),
    ("allow-pointer-lock", ""),
    ("allow-popups", ""),
    ("allow-popups-to-escape-sandbox", ""),
    ("allow-presentation", ""),
    ("allow-same-origin", ""),
    ("allow-scripts", ""),
    ("allow-top-navigation", ""),
    ("allow-top-navigation-by-user-activation", ""),
    ("allow-top-navigation-to-custom-protocols", ""),
    ("row", ""),
    ("col", ""),
    ("rowgroup", ""),
    ("colgroup", ""),
    ("open", ""),
    ("closed", ""),
    ("circle", ""),
    ("default", ""),
    ("poly", ""),
    ("rect", ""),
    ("submit", ""),
    ("reset", ""),
    ("button", ""),
    ("hidden", ""),
    ("text", ""),
    ("search", ""),
    ("tel", ""),
    ("url", ""),
    ("email", ""),
    ("password", ""),
    ("date", ""),
    ("month", ""),
    ("week", ""),
    ("time", ""),
    ("datetime-local", ""),
    ("number", ""),
    ("range", ""),
    ("color", ""),
    ("checkbox", ""),
    ("radio", ""),
    ("file", ""),
    ("submit", ""),
    ("image", ""),
    ("reset", ""),
    ("button", ""),
    ("1", ""),
    ("a", ""),
    ("A", ""),
    ("i", ""),
    ("I", ""),
    ("module", ""),
    ("soft", ""),
    ("hard", ""),
    ("alert", "A type of live region with important, and usually time-sensitive, information. See related alertdialog and status."),
    ("alertdialog", "A type of dialog that contains an alert message, where initial focus goes to an element within the dialog. See related alert and dialog."),
    ("application", "A structure containing one or more focusable elements requiring user input, such as keyboard or gesture events, that do not follow a standard interaction pattern supported by a widget role."),
    ("article", "A section of a page that consists of a composition that forms an independent part of a document, page, or site."),
    ("banner", "A region that contains mostly site-oriented content, rather than page-specific content."),
    ("button", "An input that allows for user-triggered actions when clicked or pressed. See related link."),
    ("cell", "A cell in a tabular container. See related gridcell."),
    ("checkbox", "A checkable input that has three possible values: true, false, or mixed."),
    ("columnheader", "A cell containing header information for a column."),
    ("combobox", "A composite widget containing a single-line textbox and another element, such as a listbox or grid, that can dynamically pop up to help the user set the value of the textbox."),
    ("command", "A form of widget that performs an action but does not receive input data."),
    ("complementary", "A supporting section of the document, designed to be complementary to the main content at a similar level in the DOM hierarchy, but remains meaningful when separated from the main content."),
    ("composite", "A widget that may contain navigable descendants or owned children."),
    ("contentinfo", "A large perceivable region that contains information about the parent document."),
    ("definition", "A definition of a term or concept. See related term."),
    ("dialog", "A dialog is a descendant window of the primary window of a web application. For HTML pages, the primary application window is the entire web document, i.e., the body element."),
    ("directory", "A list of references to members of a group, such as a static table of contents."),
    ("document", "An element containing content that assistive technology users may want to browse in a reading mode."),
    ("feed", "A scrollable list of articles where scrolling may cause articles to be added to or removed from either end of the list."),
    ("figure", "A perceivable section of content that typically contains a graphical document, images, code snippets, or example text. The parts of a figure MAY be user-navigable."),
    ("form", "A landmark region that contains a collection of items and objects that, as a whole, combine to create a form. See related search."),
    ("grid", "A composite widget containing a collection of one or more rows with one or more cells where some or all cells in the grid are focusable by using methods of two-dimensional navigation, such as directional arrow keys."),
    ("gridcell", "A cell in a grid or treegrid."),
    ("group", "A set of user interface objects which are not intended to be included in a page summary or table of contents by assistive technologies."),
    ("heading", "A heading for a section of the page."),
    ("img", "A container for a collection of elements that form an image."),
    ("input", "A generic type of widget that allows user input."),
    ("landmark", "A perceivable section containing content that is relevant to a specific, author-specified  purpose and sufficiently important that users will likely want to be able to navigate to the section easily and to have it listed in a summary of the page. Such a page summary could be generated dynamically by a user agent or assistive technology."),
    ("link", "An interactive reference to an internal or external resource that, when activated, causes the user agent to navigate to that resource. See related button."),
    ("list", "A section containing listitem elements. See related listbox."),
    ("listbox", "A widget that allows the user to select one or more items from a list of choices. See related combobox and list."),
    ("listitem", "A single item in a list or directory."),
    ("log", "A type of live region where new information is added in meaningful order and old information may disappear. See related marquee."),
    ("main", "The main content of a document."),
    ("marquee", "A type of live region where non-essential information changes frequently. See related log."),
    ("math", "Content that represents a mathematical expression."),
    ("menu", "A type of widget that offers a list of choices to the user."),
    ("menubar", "A presentation of menu that usually remains visible and is usually presented horizontally."),
    ("menuitem", "An option in a set of choices contained by a menu or menubar."),
    ("menuitemcheckbox", "A menuitem with a checkable state whose possible values are true, false, or mixed."),
    ("menuitemradio", "A checkable menuitem in a set of elements with the same role, only one of which can be checked at a time."),
    ("navigation", "A collection of navigational elements (usually links) for navigating the document or related documents."),
    ("note", "A section whose content is parenthetic or ancillary to the main content of the resource."),
    ("option", "A selectable item in a select list."),
    ("presentation", "An element whose implicit native role semantics will not be mapped to the accessibility API. See synonym none."),
    ("progressbar", "An element that displays the progress status for tasks that take a long time."),
    ("radio", "A checkable input in a group of elements with the same role, only one of which can be checked at a time."),
    ("radiogroup", "A group of radio buttons."),
    ("range", "An input representing a range of values that can be set by the user."),
    ("region", "A perceivable section containing content that is relevant to a specific, author-specified  purpose and sufficiently important that users will likely want to be able to navigate to the section easily and to have it listed in a summary of the page. Such a page summary could be generated dynamically by a user agent or assistive technology."),
    ("roletype", "The base role from which all other roles in this taxonomy inherit."),
    ("row", "A row of cells in a tabular container."),
    ("rowgroup", "A structure containing one or more row elements in a tabular container."),
    ("rowheader", "A cell containing header information for a row in a grid."),
    ("scrollbar", "A graphical object that controls the scrolling of content within a viewing area, regardless of whether the content is fully displayed within the viewing area."),
    ("search", "A landmark region that contains a collection of items and objects that, as a whole, combine to create a search facility. See related form and searchbox."),
    ("searchbox", "A type of textbox intended for specifying search criteria. See related textbox and search."),
    ("section", "A renderable structural containment unit in a document or application."),
    ("sectionhead", "A structure that labels or summarizes the topic of its related section."),
    ("select", "A form widget that allows the user to make selections from a set of choices."),
    ("separator", "A divider that separates and distinguishes sections of content or groups of menuitems."),
    ("slider", "A user input where the user selects a value from within a given range."),
    ("spinbutton", "A form of range that expects the user to select from among discrete choices."),
    ("status", "A type of live region whose content is advisory information for the user but is not important enough to justify an alert, often but not necessarily presented as a status bar."),
    ("structure", "A document structural element."),
    ("switch", "A type of checkbox that represents on/off values, as opposed to checked/unchecked values. See related checkbox."),
    ("tab", "A grouping label providing a mechanism for selecting the tab content that is to be rendered to the user."),
    ("table", "A section containing data arranged in rows and columns. See related grid."),
    ("tablist", "A list of tab elements, which are references to tabpanel elements."),
    ("tabpanel", "A container for the resources associated with a tab, where each tab is contained in a tablist."),
    ("term", "A word or phrase with a corresponding definition. See related definition."),
    ("textbox", "A type of input that allows free-form text as its value."),
    ("timer", "A type of live region containing a numerical counter which indicates an amount of elapsed time from a start point, or the time remaining until an end point."),
    ("toolbar", "A collection of commonly used function buttons or controls represented in compact visual form."),
    ("tooltip", "A contextual popup that displays a description for an element."),
    ("tree", "A type of list that may contain sub-level nested groups that can be collapsed and expanded."),
    ("treegrid", "A grid whose rows can be expanded and collapsed in the same manner as for a tree."),
    ("treeitem", "An option item of a tree. This is an element within a tree that may be expanded or collapsed if it contains a sub-level group of tree item elements."),
    ("widget", "An interactive component of a graphical user interface (GUI)."),
    ("window", "A browser or application window."),
    ("inline", "When a user is providing input, text suggesting one way to complete the provided input may be dynamically inserted after the caret."),
    ("list", "When a user is providing input, an element containing a collection of values that could complete the provided input may be displayed."),
    ("both", "When a user is providing input, an element containing a collection of values that could complete the provided input may be displayed. If displayed, one value in the collection is automatically selected, and the text needed to complete the automatically selected value appears after the caret in the input."),
    ("mixed", "An intermediate value between true and false."),
    ("page", "Represents the current page within a set of pages."),
    ("step", "Represents the current step within a process."),
    ("location", "Represents the current location within an environment or context."),
    ("date", "Represents the current date within a collection of dates."),
    ("time", "Represents the current time within a set of times."),
    ("menu", "Indicates the popup is a menu."),
    ("listbox", "Indicates the popup is a listbox."),
    ("tree", "Indicates the popup is a tree."),
    ("grid", "Indicates the popup is a grid."),
    ("dialog", "Indicates the popup is a dialog."),
    ("grammar", "A grammatical error was detected."),
    ("spelling", "A spelling error was detected."),
    ("assertive", "Indicates that updates to the region have the highest priority and should be presented the user immediately."),
    ("off", "Indicates that updates to the region should not be presented to the user unless the used is currently focused on that region."),
    ("polite", "Indicates that updates to the region should be presented at the next graceful opportunity, such as at the end of speaking the current sentence or when the user pauses typing."),
    ("horizontal", "The element is oriented horizontally."),
    ("undefined", "The element's orientation is unknown/ambiguous."),
    ("vertical", "The element is oriented vertically."),
    ("additions", "Element nodes are added to the accessibility tree within the live region."),
    ("additions text", "Equivalent to the combination of values, \"additions text\"."),
    ("all", "Equivalent to the combination of all values, \"additions removals text\"."),
    ("removals", "Text content, a text alternative, or an element node within the live region is removed from the accessibility tree."),
    ("text", "Text content or a text alternative is added to any descendant in the accessibility tree of the live region."),
    ("ascending", "Items are sorted in ascending order by this column."),
    ("descending", "Items are sorted in descending order by this column."),
    ("other", "A sort algorithm other than ascending or descending has been applied."),
];
