// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(docsrs, feature(doc_cfg))]

use gio_sys as gio;
use glib_sys as glib;
use gobject_sys as gobject;
use gstreamer_sys as gst;

#[cfg(unix)]
#[allow(unused_imports)]
use libc::{dev_t, gid_t, pid_t, socklen_t, uid_t};
#[allow(unused_imports)]
use libc::{intptr_t, off_t, size_t, ssize_t, time_t, uintptr_t, FILE};
#[allow(unused_imports)]
use std::ffi::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Aliases
pub type GstValidateIssueId = glib::GQuark;

// Enums
pub type GstValidateActionReturn = c_int;
pub const GST_VALIDATE_EXECUTE_ACTION_ERROR: GstValidateActionReturn = 0;
pub const GST_VALIDATE_EXECUTE_ACTION_OK: GstValidateActionReturn = 1;
pub const GST_VALIDATE_EXECUTE_ACTION_ASYNC: GstValidateActionReturn = 2;
pub const GST_VALIDATE_EXECUTE_ACTION_NON_BLOCKING: GstValidateActionReturn = 3;
pub const GST_VALIDATE_EXECUTE_ACTION_INTERLACED: GstValidateActionReturn = 3;
pub const GST_VALIDATE_EXECUTE_ACTION_ERROR_REPORTED: GstValidateActionReturn = 4;
pub const GST_VALIDATE_EXECUTE_ACTION_IN_PROGRESS: GstValidateActionReturn = 5;
pub const GST_VALIDATE_EXECUTE_ACTION_NONE: GstValidateActionReturn = 6;
pub const GST_VALIDATE_EXECUTE_ACTION_DONE: GstValidateActionReturn = 7;

pub type GstValidateInterceptionReturn = c_int;
pub const GST_VALIDATE_REPORTER_DROP: GstValidateInterceptionReturn = 0;
pub const GST_VALIDATE_REPORTER_KEEP: GstValidateInterceptionReturn = 1;
pub const GST_VALIDATE_REPORTER_REPORT: GstValidateInterceptionReturn = 2;

pub type GstValidateReportLevel = c_int;
pub const GST_VALIDATE_REPORT_LEVEL_CRITICAL: GstValidateReportLevel = 0;
pub const GST_VALIDATE_REPORT_LEVEL_WARNING: GstValidateReportLevel = 1;
pub const GST_VALIDATE_REPORT_LEVEL_ISSUE: GstValidateReportLevel = 2;
pub const GST_VALIDATE_REPORT_LEVEL_IGNORE: GstValidateReportLevel = 3;
pub const GST_VALIDATE_REPORT_LEVEL_UNKNOWN: GstValidateReportLevel = 4;
pub const GST_VALIDATE_REPORT_LEVEL_EXPECTED: GstValidateReportLevel = 5;
pub const GST_VALIDATE_REPORT_LEVEL_NUM_ENTRIES: GstValidateReportLevel = 6;

pub type GstValidateReportingDetails = c_int;
pub const GST_VALIDATE_SHOW_UNKNOWN: GstValidateReportingDetails = 0;
pub const GST_VALIDATE_SHOW_NONE: GstValidateReportingDetails = 1;
pub const GST_VALIDATE_SHOW_SYNTHETIC: GstValidateReportingDetails = 2;
pub const GST_VALIDATE_SHOW_SUBCHAIN: GstValidateReportingDetails = 3;
pub const GST_VALIDATE_SHOW_MONITOR: GstValidateReportingDetails = 4;
pub const GST_VALIDATE_SHOW_ALL: GstValidateReportingDetails = 5;
pub const GST_VALIDATE_SHOW_SMART: GstValidateReportingDetails = 6;
pub const GST_VALIDATE_SHOW_COUNT: GstValidateReportingDetails = 7;

// Constants
pub const GST_VALIDATE_UNKNOWN_BOOL: c_int = -1;
pub const GST_VALIDATE_UNKNOWN_UINT64: c_int = -1;

// Flags
pub type GstValidateActionTypeFlags = c_uint;
pub const GST_VALIDATE_ACTION_TYPE_NONE: GstValidateActionTypeFlags = 0;
pub const GST_VALIDATE_ACTION_TYPE_CONFIG: GstValidateActionTypeFlags = 2;
pub const GST_VALIDATE_ACTION_TYPE_ASYNC: GstValidateActionTypeFlags = 4;
pub const GST_VALIDATE_ACTION_TYPE_NON_BLOCKING: GstValidateActionTypeFlags = 8;
pub const GST_VALIDATE_ACTION_TYPE_INTERLACED: GstValidateActionTypeFlags = 8;
pub const GST_VALIDATE_ACTION_TYPE_CAN_EXECUTE_ON_ADDITION: GstValidateActionTypeFlags = 16;
pub const GST_VALIDATE_ACTION_TYPE_NEEDS_CLOCK: GstValidateActionTypeFlags = 32;
pub const GST_VALIDATE_ACTION_TYPE_NO_EXECUTION_NOT_FATAL: GstValidateActionTypeFlags = 64;
pub const GST_VALIDATE_ACTION_TYPE_CAN_BE_OPTIONAL: GstValidateActionTypeFlags = 128;
pub const GST_VALIDATE_ACTION_TYPE_DOESNT_NEED_PIPELINE: GstValidateActionTypeFlags = 256;
pub const GST_VALIDATE_ACTION_TYPE_HANDLED_IN_CONFIG: GstValidateActionTypeFlags = 512;
pub const GST_VALIDATE_ACTION_TYPE_CHECK: GstValidateActionTypeFlags = 1024;

pub type GstValidateDebugFlags = c_uint;
pub const GST_VALIDATE_FATAL_DEFAULT: GstValidateDebugFlags = 0;
pub const GST_VALIDATE_FATAL_ISSUES: GstValidateDebugFlags = 1;
pub const GST_VALIDATE_FATAL_WARNINGS: GstValidateDebugFlags = 2;
pub const GST_VALIDATE_FATAL_CRITICALS: GstValidateDebugFlags = 4;
pub const GST_VALIDATE_PRINT_ISSUES: GstValidateDebugFlags = 8;
pub const GST_VALIDATE_PRINT_WARNINGS: GstValidateDebugFlags = 16;
pub const GST_VALIDATE_PRINT_CRITICALS: GstValidateDebugFlags = 32;

pub type GstValidateIssueFlags = c_uint;
pub const GST_VALIDATE_ISSUE_FLAGS_NONE: GstValidateIssueFlags = 0;
pub const GST_VALIDATE_ISSUE_FLAGS_FULL_DETAILS: GstValidateIssueFlags = 1;
pub const GST_VALIDATE_ISSUE_FLAGS_NO_BACKTRACE: GstValidateIssueFlags = 2;
pub const GST_VALIDATE_ISSUE_FLAGS_FORCE_BACKTRACE: GstValidateIssueFlags = 4;

pub type GstValidateMediaDescriptorWriterFlags = c_uint;
pub const GST_VALIDATE_MEDIA_DESCRIPTOR_WRITER_FLAGS_NONE: GstValidateMediaDescriptorWriterFlags =
    1;
pub const GST_VALIDATE_MEDIA_DESCRIPTOR_WRITER_FLAGS_NO_PARSER:
    GstValidateMediaDescriptorWriterFlags = 2;
pub const GST_VALIDATE_MEDIA_DESCRIPTOR_WRITER_FLAGS_FULL: GstValidateMediaDescriptorWriterFlags =
    4;
pub const GST_VALIDATE_MEDIA_DESCRIPTOR_WRITER_FLAGS_HANDLE_GLOGS:
    GstValidateMediaDescriptorWriterFlags = 8;

pub type GstValidateObjectSetPropertyFlags = c_uint;
pub const GST_VALIDATE_OBJECT_SET_PROPERTY_FLAGS_OPTIONAL: GstValidateObjectSetPropertyFlags = 1;
pub const GST_VALIDATE_OBJECT_SET_PROPERTY_FLAGS_NO_VALUE_CHECK: GstValidateObjectSetPropertyFlags =
    2;

pub type GstValidateStructureResolveVariablesFlags = c_uint;
pub const GST_VALIDATE_STRUCTURE_RESOLVE_VARIABLES_ALL: GstValidateStructureResolveVariablesFlags =
    0;
pub const GST_VALIDATE_STRUCTURE_RESOLVE_VARIABLES_LOCAL_ONLY:
    GstValidateStructureResolveVariablesFlags = 1;
pub const GST_VALIDATE_STRUCTURE_RESOLVE_VARIABLES_NO_FAILURE:
    GstValidateStructureResolveVariablesFlags = 2;
pub const GST_VALIDATE_STRUCTURE_RESOLVE_VARIABLES_NO_EXPRESSION:
    GstValidateStructureResolveVariablesFlags = 2;

pub type GstValidateVerbosityFlags = c_uint;
pub const GST_VALIDATE_VERBOSITY_NONE: GstValidateVerbosityFlags = 0;
pub const GST_VALIDATE_VERBOSITY_POSITION: GstValidateVerbosityFlags = 2;
pub const GST_VALIDATE_VERBOSITY_MESSAGES: GstValidateVerbosityFlags = 4;
pub const GST_VALIDATE_VERBOSITY_PROPS_CHANGES: GstValidateVerbosityFlags = 8;
pub const GST_VALIDATE_VERBOSITY_NEW_ELEMENTS: GstValidateVerbosityFlags = 16;
pub const GST_VALIDATE_VERBOSITY_ALL: GstValidateVerbosityFlags = 30;

// Callbacks
pub type GstValidateExecuteAction =
    Option<unsafe extern "C" fn(*mut GstValidateScenario, *mut GstValidateAction) -> c_int>;
pub type GstValidateGetIncludePathsFunc =
    Option<unsafe extern "C" fn(*const c_char) -> *mut *mut c_char>;
pub type GstValidateOverrideBufferHandler = Option<
    unsafe extern "C" fn(*mut GstValidateOverride, *mut GstValidateMonitor, *mut gst::GstBuffer),
>;
pub type GstValidateOverrideElementAddedHandler = Option<
    unsafe extern "C" fn(*mut GstValidateOverride, *mut GstValidateMonitor, *mut gst::GstElement),
>;
pub type GstValidateOverrideEventHandler = Option<
    unsafe extern "C" fn(*mut GstValidateOverride, *mut GstValidateMonitor, *mut gst::GstEvent),
>;
pub type GstValidateOverrideGetCapsHandler = Option<
    unsafe extern "C" fn(*mut GstValidateOverride, *mut GstValidateMonitor, *mut gst::GstCaps),
>;
pub type GstValidateOverrideQueryHandler = Option<
    unsafe extern "C" fn(*mut GstValidateOverride, *mut GstValidateMonitor, *mut gst::GstQuery),
>;
pub type GstValidateOverrideSetCapsHandler = Option<
    unsafe extern "C" fn(*mut GstValidateOverride, *mut GstValidateMonitor, *mut gst::GstCaps),
>;
pub type GstValidateParseVariableFunc =
    Option<unsafe extern "C" fn(*const c_char, *mut c_double, gpointer) -> c_int>;
pub type GstValidatePrepareAction = Option<unsafe extern "C" fn(*mut GstValidateAction) -> c_int>;

// Records
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateAction {
    pub mini_object: gst::GstMiniObject,
    pub type_: *const c_char,
    pub name: *const c_char,
    pub structure: *mut gst::GstStructure,
    pub action_number: c_uint,
    pub repeat: c_int,
    pub playback_time: gst::GstClockTime,
    pub lineno: c_int,
    pub filename: *mut c_char,
    pub debug: *mut c_char,
    pub n_repeats: c_int,
    pub rangename: *mut c_char,
    pub priv_: *mut GstValidateActionPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateAction {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateAction @ {self:p}"))
            .field("mini_object", &self.mini_object)
            .field("type_", &self.type_)
            .field("name", &self.name)
            .field("structure", &self.structure)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateActionParameter {
    pub name: *const c_char,
    pub description: *const c_char,
    pub mandatory: gboolean,
    pub types: *const c_char,
    pub possible_variables: *const c_char,
    pub def: *const c_char,
    pub free: glib::GDestroyNotify,
    pub _gst_reserved: [gpointer; 3],
}

impl ::std::fmt::Debug for GstValidateActionParameter {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateActionParameter @ {self:p}"))
            .field("name", &self.name)
            .field("description", &self.description)
            .field("mandatory", &self.mandatory)
            .field("types", &self.types)
            .field("possible_variables", &self.possible_variables)
            .field("def", &self.def)
            .field("free", &self.free)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstValidateActionPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstValidateActionPrivate = _GstValidateActionPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateActionType {
    pub mini_object: gst::GstMiniObject,
    pub name: *mut c_char,
    pub implementer_namespace: *mut c_char,
    pub prepare: GstValidatePrepareAction,
    pub execute: GstValidateExecuteAction,
    pub parameters: *mut GstValidateActionParameter,
    pub description: *mut c_char,
    pub flags: GstValidateActionTypeFlags,
    pub rank: gst::GstRank,
    pub overriden_type: *mut GstValidateActionType,
    pub priv_: *mut GstValidateActionTypePrivate,
    pub _gst_reserved: [gpointer; 20],
}

impl ::std::fmt::Debug for GstValidateActionType {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateActionType @ {self:p}"))
            .field("mini_object", &self.mini_object)
            .field("name", &self.name)
            .field("implementer_namespace", &self.implementer_namespace)
            .field("prepare", &self.prepare)
            .field("execute", &self.execute)
            .field("parameters", &self.parameters)
            .field("description", &self.description)
            .field("flags", &self.flags)
            .field("rank", &self.rank)
            .field("overriden_type", &self.overriden_type)
            .field("priv_", &self.priv_)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstValidateActionTypePrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstValidateActionTypePrivate = _GstValidateActionTypePrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateBinMonitorClass {
    pub parent_class: GstValidateElementMonitorClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateBinMonitorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateBinMonitorClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateElementMonitorClass {
    pub parent_class: GstValidateMonitorClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateElementMonitorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateElementMonitorClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateIssue {
    pub issue_id: GstValidateIssueId,
    pub summary: *mut c_char,
    pub description: *mut c_char,
    pub area: *mut c_char,
    pub name: *mut c_char,
    pub default_level: GstValidateReportLevel,
    pub refcount: c_int,
    pub flags: GstValidateIssueFlags,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateIssue {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateIssue @ {self:p}"))
            .field("issue_id", &self.issue_id)
            .field("summary", &self.summary)
            .field("description", &self.description)
            .field("area", &self.area)
            .field("name", &self.name)
            .field("default_level", &self.default_level)
            .field("refcount", &self.refcount)
            .field("flags", &self.flags)
            .field("_gst_reserved", &self._gst_reserved)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateMediaDescriptorClass {
    pub parent: gst::GstObjectClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateMediaDescriptorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateMediaDescriptorClass @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateMediaDescriptorParserClass {
    pub parent: GstValidateMediaDescriptorClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateMediaDescriptorParserClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateMediaDescriptorParserClass @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstValidateMediaDescriptorParserPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstValidateMediaDescriptorParserPrivate = _GstValidateMediaDescriptorParserPrivate;

#[repr(C)]
#[allow(dead_code)]
pub struct _GstValidateMediaDescriptorPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstValidateMediaDescriptorPrivate = _GstValidateMediaDescriptorPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateMediaDescriptorWriterClass {
    pub parent: GstValidateMediaDescriptorClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateMediaDescriptorWriterClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateMediaDescriptorWriterClass @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstValidateMediaDescriptorWriterPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstValidateMediaDescriptorWriterPrivate = _GstValidateMediaDescriptorWriterPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateMediaInfo {
    pub duration: gst::GstClockTime,
    pub is_image: gboolean,
    pub file_size: u64,
    pub seekable: gboolean,
    pub playback_error: *mut c_char,
    pub reverse_playback_error: *mut c_char,
    pub track_switch_error: *mut c_char,
    pub uri: *mut c_char,
    pub discover_only: gboolean,
    pub stream_info: *mut GstValidateStreamInfo,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateMediaInfo {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateMediaInfo @ {self:p}"))
            .field("duration", &self.duration)
            .field("is_image", &self.is_image)
            .field("file_size", &self.file_size)
            .field("seekable", &self.seekable)
            .field("playback_error", &self.playback_error)
            .field("reverse_playback_error", &self.reverse_playback_error)
            .field("track_switch_error", &self.track_switch_error)
            .field("uri", &self.uri)
            .field("discover_only", &self.discover_only)
            .field("stream_info", &self.stream_info)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateMonitorClass {
    pub parent_class: gst::GstObjectClass,
    pub setup: Option<unsafe extern "C" fn(*mut GstValidateMonitor) -> gboolean>,
    pub get_element: Option<unsafe extern "C" fn(*mut GstValidateMonitor) -> *mut gst::GstElement>,
    pub set_media_descriptor:
        Option<unsafe extern "C" fn(*mut GstValidateMonitor, *mut GstValidateMediaDescriptor)>,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateMonitorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateMonitorClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("setup", &self.setup)
            .field("get_element", &self.get_element)
            .field("set_media_descriptor", &self.set_media_descriptor)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateOverrideClass {
    pub parent_class: gst::GstObjectClass,
    pub can_attach:
        Option<unsafe extern "C" fn(*mut GstValidateOverride, *mut GstValidateMonitor) -> gboolean>,
    pub attached: Option<unsafe extern "C" fn(*mut GstValidateOverride)>,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateOverrideClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateOverrideClass @ {self:p}"))
            .field("can_attach", &self.can_attach)
            .field("attached", &self.attached)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstValidateOverridePrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstValidateOverridePrivate = _GstValidateOverridePrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateOverrideRegistry {
    pub mutex: glib::GMutex,
    pub name_overrides: glib::GQueue,
    pub gtype_overrides: glib::GQueue,
    pub klass_overrides: glib::GQueue,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateOverrideRegistry {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateOverrideRegistry @ {self:p}"))
            .field("mutex", &self.mutex)
            .field("name_overrides", &self.name_overrides)
            .field("gtype_overrides", &self.gtype_overrides)
            .field("klass_overrides", &self.klass_overrides)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidatePadMonitorClass {
    pub parent_class: GstValidateMonitorClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidatePadMonitorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidatePadMonitorClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstValidatePadSeekData {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstValidatePadSeekData = _GstValidatePadSeekData;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidatePipelineMonitorClass {
    pub parent_class: GstValidateBinMonitorClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidatePipelineMonitorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidatePipelineMonitorClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateReport {
    pub mini_object: gst::GstMiniObject,
    pub issue: *mut GstValidateIssue,
    pub level: GstValidateReportLevel,
    pub reporter: *mut GstValidateReporter,
    pub timestamp: gst::GstClockTime,
    pub message: *mut c_char,
    pub shadow_reports_lock: glib::GMutex,
    pub master_report: *mut GstValidateReport,
    pub shadow_reports: *mut glib::GList,
    pub repeated_reports: *mut glib::GList,
    pub reporting_level: GstValidateReportingDetails,
    pub reporter_name: *mut c_char,
    pub trace: *mut c_char,
    pub dotfile_name: *mut c_char,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateReport {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateReport @ {self:p}"))
            .field("mini_object", &self.mini_object)
            .field("issue", &self.issue)
            .field("level", &self.level)
            .field("reporter", &self.reporter)
            .field("timestamp", &self.timestamp)
            .field("message", &self.message)
            .field("shadow_reports_lock", &self.shadow_reports_lock)
            .field("master_report", &self.master_report)
            .field("shadow_reports", &self.shadow_reports)
            .field("repeated_reports", &self.repeated_reports)
            .field("reporting_level", &self.reporting_level)
            .field("reporter_name", &self.reporter_name)
            .field("trace", &self.trace)
            .field("dotfile_name", &self.dotfile_name)
            .field("_gst_reserved", &self._gst_reserved)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateReporterInterface {
    pub parent: gobject::GTypeInterface,
    pub intercept_report: Option<
        unsafe extern "C" fn(
            *mut GstValidateReporter,
            *mut GstValidateReport,
        ) -> GstValidateInterceptionReturn,
    >,
    pub get_reporting_level:
        Option<unsafe extern "C" fn(*mut GstValidateReporter) -> GstValidateReportingDetails>,
    pub get_pipeline:
        Option<unsafe extern "C" fn(*mut GstValidateReporter) -> *mut gst::GstPipeline>,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateReporterInterface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateReporterInterface @ {self:p}"))
            .field("parent", &self.parent)
            .field("intercept_report", &self.intercept_report)
            .field("get_reporting_level", &self.get_reporting_level)
            .field("get_pipeline", &self.get_pipeline)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateRunnerClass {
    pub parent_class: gst::GstTracerClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateRunnerClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateRunnerClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstValidateRunnerPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstValidateRunnerPrivate = _GstValidateRunnerPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateScenarioClass {
    pub parent_class: gst::GstObjectClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateScenarioClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateScenarioClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstValidateScenarioPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstValidateScenarioPrivate = _GstValidateScenarioPrivate;

#[repr(C)]
#[allow(dead_code)]
pub struct _GstValidateStreamInfo {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstValidateStreamInfo = _GstValidateStreamInfo;

// Classes
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateBinMonitor {
    pub parent: GstValidateElementMonitor,
    pub element_monitors: *mut glib::GList,
    pub scenario: *mut GstValidateScenario,
    pub element_added_id: c_ulong,
    pub element_removed_id: c_ulong,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateBinMonitor {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateBinMonitor @ {self:p}"))
            .field("parent", &self.parent)
            .field("element_monitors", &self.element_monitors)
            .field("scenario", &self.scenario)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateElementMonitor {
    pub parent: GstValidateMonitor,
    pub pad_added_id: c_ulong,
    pub pad_monitors: *mut glib::GList,
    pub is_decoder: gboolean,
    pub is_encoder: gboolean,
    pub is_demuxer: gboolean,
    pub is_converter: gboolean,
    pub is_sink: gboolean,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateElementMonitor {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateElementMonitor @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateMediaDescriptor {
    pub parent: gst::GstObject,
    pub lock: glib::GMutex,
    pub priv_: *mut GstValidateMediaDescriptorPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateMediaDescriptor {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateMediaDescriptor @ {self:p}"))
            .field("parent", &self.parent)
            .field("lock", &self.lock)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateMediaDescriptorParser {
    pub parent: GstValidateMediaDescriptor,
    pub priv_: *mut GstValidateMediaDescriptorParserPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateMediaDescriptorParser {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateMediaDescriptorParser @ {self:p}"))
            .field("parent", &self.parent)
            .field("priv_", &self.priv_)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateMediaDescriptorWriter {
    pub parent: GstValidateMediaDescriptor,
    pub priv_: *mut GstValidateMediaDescriptorWriterPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateMediaDescriptorWriter {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateMediaDescriptorWriter @ {self:p}"))
            .field("parent", &self.parent)
            .field("priv_", &self.priv_)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateMonitor {
    pub object: gst::GstObject,
    pub target: gobject::GWeakRef,
    pub pipeline: gobject::GWeakRef,
    pub mutex: glib::GMutex,
    pub target_name: *mut c_char,
    pub parent: *mut GstValidateMonitor,
    pub overrides_mutex: glib::GMutex,
    pub overrides: glib::GQueue,
    pub media_descriptor: *mut GstValidateMediaDescriptor,
    pub level: GstValidateReportingDetails,
    pub reports: *mut glib::GHashTable,
    pub verbosity: GstValidateVerbosityFlags,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateMonitor {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateMonitor @ {self:p}"))
            .field("object", &self.object)
            .field("target", &self.target)
            .field("pipeline", &self.pipeline)
            .field("mutex", &self.mutex)
            .field("target_name", &self.target_name)
            .field("parent", &self.parent)
            .field("overrides_mutex", &self.overrides_mutex)
            .field("overrides", &self.overrides)
            .field("media_descriptor", &self.media_descriptor)
            .field("level", &self.level)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateOverride {
    pub parent: gst::GstObject,
    pub buffer_handler: GstValidateOverrideBufferHandler,
    pub event_handler: GstValidateOverrideEventHandler,
    pub query_handler: GstValidateOverrideQueryHandler,
    pub buffer_probe_handler: GstValidateOverrideBufferHandler,
    pub getcaps_handler: GstValidateOverrideGetCapsHandler,
    pub setcaps_handler: GstValidateOverrideSetCapsHandler,
    pub element_added_handler: GstValidateOverrideElementAddedHandler,
    pub priv_: *mut GstValidateOverridePrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateOverride {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateOverride @ {self:p}"))
            .field("parent", &self.parent)
            .field("buffer_handler", &self.buffer_handler)
            .field("event_handler", &self.event_handler)
            .field("query_handler", &self.query_handler)
            .field("buffer_probe_handler", &self.buffer_probe_handler)
            .field("getcaps_handler", &self.getcaps_handler)
            .field("setcaps_handler", &self.setcaps_handler)
            .field("element_added_handler", &self.element_added_handler)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidatePadMonitor {
    pub parent: GstValidateMonitor,
    pub setup: gboolean,
    pub chain_func: gst::GstPadChainFunction,
    pub event_func: gst::GstPadEventFunction,
    pub event_full_func: gst::GstPadEventFullFunction,
    pub query_func: gst::GstPadQueryFunction,
    pub activatemode_func: gst::GstPadActivateModeFunction,
    pub get_range_func: gst::GstPadGetRangeFunction,
    pub pad_probe_id: c_ulong,
    pub last_caps: *mut gst::GstCaps,
    pub caps_is_audio: gboolean,
    pub caps_is_video: gboolean,
    pub caps_is_raw: gboolean,
    pub first_buffer: gboolean,
    pub has_segment: gboolean,
    pub is_eos: gboolean,
    pub pending_flush_stop: gboolean,
    pub pending_newsegment_seqnum: u32,
    pub pending_eos_seqnum: u32,
    pub seeks: *mut glib::GList,
    pub current_seek: *mut GstValidatePadSeekData,
    pub pending_buffer_discont: gboolean,
    pub expected_segment: *mut gst::GstEvent,
    pub serialized_events: *mut glib::GPtrArray,
    pub expired_events: *mut glib::GList,
    pub pending_setcaps_fields: *mut gst::GstStructure,
    pub last_refused_caps: *mut gst::GstCaps,
    pub last_query_filter: *mut gst::GstCaps,
    pub last_query_res: *mut gst::GstCaps,
    pub segment: gst::GstSegment,
    pub current_timestamp: gst::GstClockTime,
    pub current_duration: gst::GstClockTime,
    pub timestamp_range_start: gst::GstClockTime,
    pub timestamp_range_end: gst::GstClockTime,
    pub all_bufs: *mut glib::GList,
    pub current_buf: *mut glib::GList,
    pub check_buffers: gboolean,
    pub min_buf_freq: c_double,
    pub buffers_pushed: c_int,
    pub last_buffers_pushed: c_int,
    pub min_buf_freq_interval_ts: gst::GstClockTime,
    pub min_buf_freq_first_buffer_ts: gst::GstClockTime,
    pub min_buf_freq_start: gst::GstClockTime,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidatePadMonitor {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidatePadMonitor @ {self:p}"))
            .field("parent", &self.parent)
            .field("setup", &self.setup)
            .field("chain_func", &self.chain_func)
            .field("event_func", &self.event_func)
            .field("event_full_func", &self.event_full_func)
            .field("query_func", &self.query_func)
            .field("activatemode_func", &self.activatemode_func)
            .field("get_range_func", &self.get_range_func)
            .field("pad_probe_id", &self.pad_probe_id)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidatePipelineMonitor {
    pub parent: GstValidateBinMonitor,
    pub element_added_id: c_ulong,
    pub print_pos_srcid: c_uint,
    pub buffering: gboolean,
    pub got_error: gboolean,
    pub is_playbin: gboolean,
    pub is_playbin3: gboolean,
    pub stream_collection: *mut gst::GstStreamCollection,
    pub streams_selected: *mut glib::GList,
    pub deep_notify_id: c_ulong,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidatePipelineMonitor {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidatePipelineMonitor @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateRunner {
    pub object: gst::GstTracer,
    pub priv_: *mut GstValidateRunnerPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateRunner {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateRunner @ {self:p}"))
            .field("object", &self.object)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstValidateScenario {
    pub parent: gst::GstObject,
    pub description: *mut gst::GstStructure,
    pub priv_: *mut GstValidateScenarioPrivate,
    pub eos_handling_lock: glib::GMutex,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstValidateScenario {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstValidateScenario @ {self:p}"))
            .field("parent", &self.parent)
            .field("description", &self.description)
            .finish()
    }
}

// Interfaces
#[repr(C)]
#[allow(dead_code)]
pub struct GstValidateReporter {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for GstValidateReporter {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "GstValidateReporter @ {self:p}")
    }
}

extern "C" {

    //=========================================================================
    // GstValidateActionReturn
    //=========================================================================
    pub fn gst_validate_action_return_get_type() -> GType;
    pub fn gst_validate_action_return_get_name(r: GstValidateActionReturn) -> *const c_char;

    //=========================================================================
    // GstValidateInterceptionReturn
    //=========================================================================
    pub fn gst_validate_interception_return_get_type() -> GType;

    //=========================================================================
    // GstValidateReportLevel
    //=========================================================================
    pub fn gst_validate_report_level_get_type() -> GType;
    pub fn gst_validate_report_level_from_name(level_name: *const c_char)
        -> GstValidateReportLevel;
    pub fn gst_validate_report_level_get_name(level: GstValidateReportLevel) -> *const c_char;

    //=========================================================================
    // GstValidateReportingDetails
    //=========================================================================
    pub fn gst_validate_reporting_details_get_type() -> GType;

    //=========================================================================
    // GstValidateActionTypeFlags
    //=========================================================================
    pub fn gst_validate_action_type_flags_get_type() -> GType;

    //=========================================================================
    // GstValidateDebugFlags
    //=========================================================================
    pub fn gst_validate_debug_flags_get_type() -> GType;

    //=========================================================================
    // GstValidateIssueFlags
    //=========================================================================
    pub fn gst_validate_issue_flags_get_type() -> GType;

    //=========================================================================
    // GstValidateMediaDescriptorWriterFlags
    //=========================================================================
    pub fn gst_validate_media_descriptor_writer_flags_get_type() -> GType;

    //=========================================================================
    // GstValidateObjectSetPropertyFlags
    //=========================================================================
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_validate_object_set_property_flags_get_type() -> GType;

    //=========================================================================
    // GstValidateStructureResolveVariablesFlags
    //=========================================================================
    pub fn gst_validate_structure_resolve_variables_flags_get_type() -> GType;

    //=========================================================================
    // GstValidateVerbosityFlags
    //=========================================================================
    pub fn gst_validate_verbosity_flags_get_type() -> GType;

    //=========================================================================
    // GstValidateAction
    //=========================================================================
    pub fn gst_validate_action_get_type() -> GType;
    pub fn gst_validate_action_new(
        scenario: *mut GstValidateScenario,
        action_type: *mut GstValidateActionType,
        structure: *mut gst::GstStructure,
        add_to_lists: gboolean,
    ) -> *mut GstValidateAction;
    pub fn gst_validate_action_get_scenario(
        action: *mut GstValidateAction,
    ) -> *mut GstValidateScenario;
    pub fn gst_validate_action_ref(action: *mut GstValidateAction) -> *mut GstValidateAction;
    pub fn gst_validate_action_set_done(action: *mut GstValidateAction);
    pub fn gst_validate_action_unref(action: *mut GstValidateAction);
    pub fn gst_validate_action_get_clocktime(
        scenario: *mut GstValidateScenario,
        action: *mut GstValidateAction,
        name: *const c_char,
        retval: *mut gst::GstClockTime,
    ) -> gboolean;

    //=========================================================================
    // GstValidateActionType
    //=========================================================================
    pub fn gst_validate_action_type_get_type() -> GType;

    //=========================================================================
    // GstValidateIssue
    //=========================================================================
    pub fn gst_validate_issue_get_type() -> GType;
    pub fn gst_validate_issue_new(
        issue_id: GstValidateIssueId,
        summary: *const c_char,
        description: *const c_char,
        default_level: GstValidateReportLevel,
    ) -> *mut GstValidateIssue;
    pub fn gst_validate_issue_new_full(
        issue_id: GstValidateIssueId,
        summary: *const c_char,
        description: *const c_char,
        default_level: GstValidateReportLevel,
        flags: GstValidateIssueFlags,
    ) -> *mut GstValidateIssue;
    pub fn gst_validate_issue_get_id(issue: *mut GstValidateIssue) -> u32;
    pub fn gst_validate_issue_register(issue: *mut GstValidateIssue);
    pub fn gst_validate_issue_set_default_level(
        issue: *mut GstValidateIssue,
        default_level: GstValidateReportLevel,
    );
    pub fn gst_validate_issue_from_id(issue_id: GstValidateIssueId) -> *mut GstValidateIssue;

    //=========================================================================
    // GstValidateMediaInfo
    //=========================================================================
    pub fn gst_validate_media_info_clear(mi: *mut GstValidateMediaInfo);
    pub fn gst_validate_media_info_compare(
        expected: *mut GstValidateMediaInfo,
        extracted: *mut GstValidateMediaInfo,
    ) -> gboolean;
    pub fn gst_validate_media_info_free(mi: *mut GstValidateMediaInfo);
    pub fn gst_validate_media_info_init(mi: *mut GstValidateMediaInfo);
    pub fn gst_validate_media_info_inspect_uri(
        mi: *mut GstValidateMediaInfo,
        uri: *const c_char,
        discover_only: gboolean,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_validate_media_info_save(
        mi: *mut GstValidateMediaInfo,
        path: *const c_char,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_validate_media_info_to_string(
        mi: *mut GstValidateMediaInfo,
        length: *mut size_t,
    ) -> *mut c_char;
    pub fn gst_validate_media_info_load(
        path: *const c_char,
        error: *mut *mut glib::GError,
    ) -> *mut GstValidateMediaInfo;

    //=========================================================================
    // GstValidateOverrideRegistry
    //=========================================================================
    pub fn gst_validate_override_registry_get_override_for_names(
        reg: *mut GstValidateOverrideRegistry,
        name: *const c_char,
        ...
    ) -> *mut glib::GList;
    pub fn gst_validate_override_registry_get_override_list(
        registry: *mut GstValidateOverrideRegistry,
    ) -> *mut glib::GList;
    pub fn gst_validate_override_registry_attach_overrides(monitor: *mut GstValidateMonitor);
    pub fn gst_validate_override_registry_get() -> *mut GstValidateOverrideRegistry;
    pub fn gst_validate_override_registry_preload() -> c_int;

    //=========================================================================
    // GstValidateReport
    //=========================================================================
    pub fn gst_validate_report_get_type() -> GType;
    pub fn gst_validate_report_new(
        issue: *mut GstValidateIssue,
        reporter: *mut GstValidateReporter,
        message: *const c_char,
    ) -> *mut GstValidateReport;
    pub fn gst_validate_report_add_repeated_report(
        report: *mut GstValidateReport,
        repeated_report: *mut GstValidateReport,
    );
    pub fn gst_validate_report_check_abort(report: *mut GstValidateReport) -> gboolean;
    pub fn gst_validate_report_get_dotfile_name(report: *mut GstValidateReport) -> *mut c_char;
    pub fn gst_validate_report_get_issue(report: *mut GstValidateReport) -> *mut GstValidateIssue;
    pub fn gst_validate_report_get_issue_id(report: *mut GstValidateReport) -> u32;
    pub fn gst_validate_report_get_level(report: *mut GstValidateReport) -> GstValidateReportLevel;
    pub fn gst_validate_report_get_message(report: *mut GstValidateReport) -> *mut c_char;
    pub fn gst_validate_report_get_reporter(
        report: *mut GstValidateReport,
    ) -> *mut GstValidateReporter;
    pub fn gst_validate_report_get_reporter_name(report: *mut GstValidateReport) -> *mut c_char;
    pub fn gst_validate_report_get_reporting_level(
        report: *mut GstValidateReport,
    ) -> GstValidateReportingDetails;
    pub fn gst_validate_report_get_timestamp(report: *mut GstValidateReport) -> gst::GstClockTime;
    pub fn gst_validate_report_get_trace(report: *mut GstValidateReport) -> *mut c_char;
    pub fn gst_validate_report_print_description(report: *mut GstValidateReport);
    pub fn gst_validate_report_print_details(report: *mut GstValidateReport);
    pub fn gst_validate_report_print_detected_on(report: *mut GstValidateReport);
    pub fn gst_validate_report_print_level(report: *mut GstValidateReport);
    pub fn gst_validate_report_printf(report: *mut GstValidateReport);
    pub fn gst_validate_report_ref(report: *mut GstValidateReport) -> *mut GstValidateReport;
    pub fn gst_validate_report_set_master_report(
        report: *mut GstValidateReport,
        master_report: *mut GstValidateReport,
    ) -> gboolean;
    pub fn gst_validate_report_set_reporting_level(
        report: *mut GstValidateReport,
        level: GstValidateReportingDetails,
    );
    pub fn gst_validate_report_should_print(report: *mut GstValidateReport) -> gboolean;
    pub fn gst_validate_report_unref(report: *mut GstValidateReport);
    pub fn gst_validate_report_action(
        reporter: *mut GstValidateReporter,
        action: *mut GstValidateAction,
        issue_id: GstValidateIssueId,
        format: *const c_char,
        ...
    );
    pub fn gst_validate_report_init();
    //pub fn gst_validate_report_valist(reporter: *mut GstValidateReporter, issue_id: GstValidateIssueId, format: *const c_char, var_args: /*Unimplemented*/va_list);

    //=========================================================================
    // GstValidateBinMonitor
    //=========================================================================
    pub fn gst_validate_bin_monitor_get_type() -> GType;
    pub fn gst_validate_bin_monitor_new(
        bin: *mut gst::GstBin,
        runner: *mut GstValidateRunner,
        parent: *mut GstValidateMonitor,
    ) -> *mut GstValidateBinMonitor;
    pub fn gst_validate_bin_monitor_get_scenario(
        monitor: *mut GstValidateBinMonitor,
    ) -> *mut GstValidateScenario;

    //=========================================================================
    // GstValidateElementMonitor
    //=========================================================================
    pub fn gst_validate_element_monitor_get_type() -> GType;
    pub fn gst_validate_element_monitor_new(
        element: *mut gst::GstElement,
        runner: *mut GstValidateRunner,
        parent: *mut GstValidateMonitor,
    ) -> *mut GstValidateElementMonitor;

    //=========================================================================
    // GstValidateMediaDescriptor
    //=========================================================================
    pub fn gst_validate_media_descriptor_get_type() -> GType;
    pub fn gst_validate_media_descriptor_detects_frames(
        self_: *mut GstValidateMediaDescriptor,
    ) -> gboolean;
    pub fn gst_validate_media_descriptor_get_buffers(
        self_: *mut GstValidateMediaDescriptor,
        pad: *mut gst::GstPad,
        compare_func: glib::GCompareFunc,
        bufs: *mut *mut glib::GList,
    ) -> gboolean;
    pub fn gst_validate_media_descriptor_get_duration(
        self_: *mut GstValidateMediaDescriptor,
    ) -> gst::GstClockTime;
    pub fn gst_validate_media_descriptor_get_pads(
        self_: *mut GstValidateMediaDescriptor,
    ) -> *mut glib::GList;
    pub fn gst_validate_media_descriptor_get_seekable(
        self_: *mut GstValidateMediaDescriptor,
    ) -> gboolean;
    pub fn gst_validate_media_descriptor_has_frame_info(
        self_: *mut GstValidateMediaDescriptor,
    ) -> gboolean;

    //=========================================================================
    // GstValidateMediaDescriptorParser
    //=========================================================================
    pub fn gst_validate_media_descriptor_parser_get_type() -> GType;
    pub fn gst_validate_media_descriptor_parser_new(
        runner: *mut GstValidateRunner,
        xmlpath: *const c_char,
        error: *mut *mut glib::GError,
    ) -> *mut GstValidateMediaDescriptorParser;
    pub fn gst_validate_media_descriptor_parser_new_from_xml(
        runner: *mut GstValidateRunner,
        xml: *const c_char,
        error: *mut *mut glib::GError,
    ) -> *mut GstValidateMediaDescriptorParser;
    pub fn gst_validate_media_descriptor_parser_add_stream(
        parser: *mut GstValidateMediaDescriptorParser,
        pad: *mut gst::GstPad,
    ) -> gboolean;
    pub fn gst_validate_media_descriptor_parser_add_taglist(
        parser: *mut GstValidateMediaDescriptorParser,
        taglist: *mut gst::GstTagList,
    ) -> gboolean;
    pub fn gst_validate_media_descriptor_parser_all_stream_found(
        parser: *mut GstValidateMediaDescriptorParser,
    ) -> gboolean;
    pub fn gst_validate_media_descriptor_parser_all_tags_found(
        parser: *mut GstValidateMediaDescriptorParser,
    ) -> gboolean;
    pub fn gst_validate_media_descriptor_parser_get_xml_path(
        parser: *mut GstValidateMediaDescriptorParser,
    ) -> *mut c_char;

    //=========================================================================
    // GstValidateMediaDescriptorWriter
    //=========================================================================
    pub fn gst_validate_media_descriptor_writer_get_type() -> GType;
    pub fn gst_validate_media_descriptor_writer_new(
        runner: *mut GstValidateRunner,
        location: *const c_char,
        duration: gst::GstClockTime,
        seekable: gboolean,
    ) -> *mut GstValidateMediaDescriptorWriter;
    pub fn gst_validate_media_descriptor_writer_new_discover(
        runner: *mut GstValidateRunner,
        uri: *const c_char,
        flags: GstValidateMediaDescriptorWriterFlags,
        error: *mut *mut glib::GError,
    ) -> *mut GstValidateMediaDescriptorWriter;
    pub fn gst_validate_media_descriptor_writer_add_frame(
        writer: *mut GstValidateMediaDescriptorWriter,
        pad: *mut gst::GstPad,
        buf: *mut gst::GstBuffer,
    ) -> gboolean;
    pub fn gst_validate_media_descriptor_writer_add_pad(
        writer: *mut GstValidateMediaDescriptorWriter,
        pad: *mut gst::GstPad,
    ) -> gboolean;
    pub fn gst_validate_media_descriptor_writer_add_taglist(
        writer: *mut GstValidateMediaDescriptorWriter,
        taglist: *const gst::GstTagList,
    ) -> gboolean;
    pub fn gst_validate_media_descriptor_writer_add_tags(
        writer: *mut GstValidateMediaDescriptorWriter,
        stream_id: *const c_char,
        taglist: *const gst::GstTagList,
    ) -> gboolean;
    pub fn gst_validate_media_descriptor_writer_detects_frames(
        writer: *mut GstValidateMediaDescriptorWriter,
    ) -> gboolean;
    pub fn gst_validate_media_descriptor_writer_get_duration(
        writer: *mut GstValidateMediaDescriptorWriter,
    ) -> gst::GstClockTime;
    pub fn gst_validate_media_descriptor_writer_get_seekable(
        writer: *mut GstValidateMediaDescriptorWriter,
    ) -> gboolean;
    pub fn gst_validate_media_descriptor_writer_get_xml_path(
        writer: *mut GstValidateMediaDescriptorWriter,
    ) -> *mut c_char;
    pub fn gst_validate_media_descriptor_writer_serialize(
        writer: *mut GstValidateMediaDescriptorWriter,
    ) -> *mut c_char;
    pub fn gst_validate_media_descriptor_writer_write(
        writer: *mut GstValidateMediaDescriptorWriter,
        filename: *const c_char,
    ) -> gboolean;

    //=========================================================================
    // GstValidateMonitor
    //=========================================================================
    pub fn gst_validate_monitor_get_type() -> GType;
    pub fn gst_validate_monitor_factory_create(
        target: *mut gst::GstObject,
        runner: *mut GstValidateRunner,
        parent: *mut GstValidateMonitor,
    ) -> *mut GstValidateMonitor;
    pub fn gst_validate_monitor_attach_override(
        monitor: *mut GstValidateMonitor,
        override_: *mut GstValidateOverride,
    );
    pub fn gst_validate_monitor_get_element(
        monitor: *mut GstValidateMonitor,
    ) -> *mut gst::GstElement;
    pub fn gst_validate_monitor_get_element_name(monitor: *mut GstValidateMonitor) -> *mut c_char;
    pub fn gst_validate_monitor_get_pipeline(
        monitor: *mut GstValidateMonitor,
    ) -> *mut gst::GstPipeline;
    pub fn gst_validate_monitor_get_target(monitor: *mut GstValidateMonitor)
        -> *mut gst::GstObject;
    pub fn gst_validate_monitor_set_media_descriptor(
        monitor: *mut GstValidateMonitor,
        media_descriptor: *mut GstValidateMediaDescriptor,
    );

    //=========================================================================
    // GstValidateOverride
    //=========================================================================
    pub fn gst_validate_override_get_type() -> GType;
    pub fn gst_validate_override_new() -> *mut GstValidateOverride;
    pub fn gst_validate_override_register_by_klass(
        klass: *const c_char,
        override_: *mut GstValidateOverride,
    );
    pub fn gst_validate_override_register_by_name(
        name: *const c_char,
        override_: *mut GstValidateOverride,
    );
    pub fn gst_validate_override_register_by_type(
        gtype: GType,
        override_: *mut GstValidateOverride,
    );
    pub fn gst_validate_override_attached(override_: *mut GstValidateOverride);
    pub fn gst_validate_override_buffer_handler(
        override_: *mut GstValidateOverride,
        monitor: *mut GstValidateMonitor,
        buffer: *mut gst::GstBuffer,
    );
    pub fn gst_validate_override_buffer_probe_handler(
        override_: *mut GstValidateOverride,
        monitor: *mut GstValidateMonitor,
        buffer: *mut gst::GstBuffer,
    );
    pub fn gst_validate_override_can_attach(
        override_: *mut GstValidateOverride,
        monitor: *mut GstValidateMonitor,
    ) -> gboolean;
    pub fn gst_validate_override_change_severity(
        override_: *mut GstValidateOverride,
        issue_id: GstValidateIssueId,
        new_level: GstValidateReportLevel,
    );
    pub fn gst_validate_override_element_added_handler(
        override_: *mut GstValidateOverride,
        monitor: *mut GstValidateMonitor,
        child: *mut gst::GstElement,
    );
    pub fn gst_validate_override_event_handler(
        override_: *mut GstValidateOverride,
        monitor: *mut GstValidateMonitor,
        event: *mut gst::GstEvent,
    );
    pub fn gst_validate_override_free(override_: *mut GstValidateOverride);
    pub fn gst_validate_override_get_severity(
        override_: *mut GstValidateOverride,
        issue_id: GstValidateIssueId,
        default_level: GstValidateReportLevel,
    ) -> GstValidateReportLevel;
    pub fn gst_validate_override_getcaps_handler(
        override_: *mut GstValidateOverride,
        monitor: *mut GstValidateMonitor,
        caps: *mut gst::GstCaps,
    );
    pub fn gst_validate_override_query_handler(
        override_: *mut GstValidateOverride,
        monitor: *mut GstValidateMonitor,
        query: *mut gst::GstQuery,
    );
    pub fn gst_validate_override_set_buffer_handler(
        override_: *mut GstValidateOverride,
        handler: GstValidateOverrideBufferHandler,
    );
    pub fn gst_validate_override_set_buffer_probe_handler(
        override_: *mut GstValidateOverride,
        handler: GstValidateOverrideBufferHandler,
    );
    pub fn gst_validate_override_set_element_added_handler(
        override_: *mut GstValidateOverride,
        func: GstValidateOverrideElementAddedHandler,
    );
    pub fn gst_validate_override_set_event_handler(
        override_: *mut GstValidateOverride,
        handler: GstValidateOverrideEventHandler,
    );
    pub fn gst_validate_override_set_getcaps_handler(
        override_: *mut GstValidateOverride,
        handler: GstValidateOverrideGetCapsHandler,
    );
    pub fn gst_validate_override_set_query_handler(
        override_: *mut GstValidateOverride,
        handler: GstValidateOverrideQueryHandler,
    );
    pub fn gst_validate_override_set_setcaps_handler(
        override_: *mut GstValidateOverride,
        handler: GstValidateOverrideSetCapsHandler,
    );
    pub fn gst_validate_override_setcaps_handler(
        override_: *mut GstValidateOverride,
        monitor: *mut GstValidateMonitor,
        caps: *mut gst::GstCaps,
    );

    //=========================================================================
    // GstValidatePadMonitor
    //=========================================================================
    pub fn gst_validate_pad_monitor_get_type() -> GType;
    pub fn gst_validate_pad_monitor_new(
        pad: *mut gst::GstPad,
        runner: *mut GstValidateRunner,
        parent: *mut GstValidateElementMonitor,
    ) -> *mut GstValidatePadMonitor;

    //=========================================================================
    // GstValidatePipelineMonitor
    //=========================================================================
    pub fn gst_validate_pipeline_monitor_get_type() -> GType;
    pub fn gst_validate_pipeline_monitor_new(
        pipeline: *mut gst::GstPipeline,
        runner: *mut GstValidateRunner,
        parent: *mut GstValidateMonitor,
    ) -> *mut GstValidatePipelineMonitor;

    //=========================================================================
    // GstValidateRunner
    //=========================================================================
    pub fn gst_validate_runner_get_type() -> GType;
    pub fn gst_validate_runner_new() -> *mut GstValidateRunner;
    pub fn gst_validate_runner_add_report(
        runner: *mut GstValidateRunner,
        report: *mut GstValidateReport,
    );
    pub fn gst_validate_runner_exit(
        runner: *mut GstValidateRunner,
        print_result: gboolean,
    ) -> c_int;
    pub fn gst_validate_runner_get_default_reporting_level(
        runner: *mut GstValidateRunner,
    ) -> GstValidateReportingDetails;
    pub fn gst_validate_runner_get_reporting_level_for_name(
        runner: *mut GstValidateRunner,
        name: *const c_char,
    ) -> GstValidateReportingDetails;
    pub fn gst_validate_runner_get_reports(runner: *mut GstValidateRunner) -> *mut glib::GList;
    pub fn gst_validate_runner_get_reports_count(runner: *mut GstValidateRunner) -> c_uint;
    pub fn gst_validate_runner_printf(runner: *mut GstValidateRunner) -> c_int;

    //=========================================================================
    // GstValidateScenario
    //=========================================================================
    pub fn gst_validate_scenario_get_type() -> GType;
    pub fn gst_validate_scenario_deinit();
    pub fn gst_validate_scenario_factory_create(
        runner: *mut GstValidateRunner,
        pipeline: *mut gst::GstElement,
        scenario_name: *const c_char,
    ) -> *mut GstValidateScenario;
    pub fn gst_validate_scenario_execute_seek(
        scenario: *mut GstValidateScenario,
        action: *mut GstValidateAction,
        rate: c_double,
        format: gst::GstFormat,
        flags: gst::GstSeekFlags,
        start_type: gst::GstSeekType,
        start: gst::GstClockTime,
        stop_type: gst::GstSeekType,
        stop: gst::GstClockTime,
    ) -> c_int;
    pub fn gst_validate_scenario_get_actions(
        scenario: *mut GstValidateScenario,
    ) -> *mut glib::GList;
    pub fn gst_validate_scenario_get_pipeline(
        scenario: *mut GstValidateScenario,
    ) -> *mut gst::GstElement;
    pub fn gst_validate_scenario_get_target_state(
        scenario: *mut GstValidateScenario,
    ) -> gst::GstState;

    //=========================================================================
    // GstValidateReporter
    //=========================================================================
    pub fn gst_validate_reporter_get_type() -> GType;
    pub fn gst_validate_reporter_get_name(reporter: *mut GstValidateReporter) -> *const c_char;
    pub fn gst_validate_reporter_get_pipeline(
        reporter: *mut GstValidateReporter,
    ) -> *mut gst::GstPipeline;
    pub fn gst_validate_reporter_get_report(
        reporter: *mut GstValidateReporter,
        issue_id: GstValidateIssueId,
    ) -> *mut GstValidateReport;
    pub fn gst_validate_reporter_get_reporting_level(
        reporter: *mut GstValidateReporter,
    ) -> GstValidateReportingDetails;
    pub fn gst_validate_reporter_get_reports(
        reporter: *mut GstValidateReporter,
    ) -> *mut glib::GList;
    pub fn gst_validate_reporter_get_reports_count(reporter: *mut GstValidateReporter) -> c_int;
    pub fn gst_validate_reporter_get_runner(
        reporter: *mut GstValidateReporter,
    ) -> *mut GstValidateRunner;
    pub fn gst_validate_reporter_init(reporter: *mut GstValidateReporter, name: *const c_char);
    pub fn gst_validate_reporter_purge_reports(reporter: *mut GstValidateReporter);
    pub fn gst_validate_reporter_report_simple(
        reporter: *mut GstValidateReporter,
        issue_id: GstValidateIssueId,
        message: *const c_char,
    );
    pub fn gst_validate_reporter_set_handle_g_logs(reporter: *mut GstValidateReporter);
    pub fn gst_validate_reporter_set_name(reporter: *mut GstValidateReporter, name: *mut c_char);
    pub fn gst_validate_reporter_set_runner(
        reporter: *mut GstValidateReporter,
        runner: *mut GstValidateRunner,
    );

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn gst_validate_abort(format: *const c_char, ...);
    pub fn gst_validate_deinit();
    pub fn gst_validate_element_has_klass(
        element: *mut gst::GstElement,
        klass: *const c_char,
    ) -> gboolean;
    pub fn gst_validate_element_matches_target(
        element: *mut gst::GstElement,
        s: *mut gst::GstStructure,
    ) -> gboolean;
    pub fn gst_validate_error_structure(action: gpointer, format: *const c_char, ...);
    pub fn gst_validate_execute_action(
        action_type: *mut GstValidateActionType,
        action: *mut GstValidateAction,
    ) -> c_int;
    pub fn gst_validate_fail_on_missing_plugin() -> gboolean;
    pub fn gst_validate_get_action_type(type_name: *const c_char) -> *mut GstValidateActionType;
    pub fn gst_validate_has_colored_output() -> gboolean;
    pub fn gst_validate_init();
    pub fn gst_validate_init_debug();
    pub fn gst_validate_is_initialized() -> gboolean;
    pub fn gst_validate_list_scenarios(
        scenarios: *mut *mut c_char,
        num_scenarios: c_int,
        output_file: *mut c_char,
    ) -> gboolean;
    pub fn gst_validate_media_descriptors_compare(
        ref_: *mut GstValidateMediaDescriptor,
        compared: *mut GstValidateMediaDescriptor,
    ) -> gboolean;
    pub fn gst_validate_object_set_property(
        reporter: *mut GstValidateReporter,
        object: *mut gobject::GObject,
        property: *const c_char,
        value: *const gobject::GValue,
        optional: gboolean,
    ) -> GstValidateActionReturn;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_validate_object_set_property_full(
        reporter: *mut GstValidateReporter,
        object: *mut gobject::GObject,
        property: *const c_char,
        value: *const gobject::GValue,
        flags: GstValidateObjectSetPropertyFlags,
    ) -> GstValidateActionReturn;
    pub fn gst_validate_plugin_get_config(plugin: *mut gst::GstPlugin) -> *mut glib::GList;
    pub fn gst_validate_print_action(action: *mut GstValidateAction, message: *const c_char);
    pub fn gst_validate_print_action_types(
        wanted_types: *mut *const c_char,
        num_wanted_types: c_int,
    ) -> gboolean;
    pub fn gst_validate_print_issues();
    pub fn gst_validate_print_position(
        position: gst::GstClockTime,
        duration: gst::GstClockTime,
        rate: c_double,
        extra_info: *mut c_char,
    );
    pub fn gst_validate_printf(source: gpointer, format: *const c_char, ...);
    //pub fn gst_validate_printf_valist(source: gpointer, format: *const c_char, args: /*Unimplemented*/va_list);
    pub fn gst_validate_register_action_type(
        type_name: *const c_char,
        implementer_namespace: *const c_char,
        function: GstValidateExecuteAction,
        parameters: *mut GstValidateActionParameter,
        description: *const c_char,
        flags: GstValidateActionTypeFlags,
    ) -> *mut GstValidateActionType;
    pub fn gst_validate_register_action_type_dynamic(
        plugin: *mut gst::GstPlugin,
        type_name: *const c_char,
        rank: gst::GstRank,
        function: GstValidateExecuteAction,
        parameters: *mut GstValidateActionParameter,
        description: *const c_char,
        flags: GstValidateActionTypeFlags,
    ) -> *mut GstValidateActionType;
    pub fn gst_validate_replace_variables_in_string(
        incom: gpointer,
        local_vars: *mut gst::GstStructure,
        in_string: *const c_char,
        flags: GstValidateStructureResolveVariablesFlags,
    ) -> *mut c_char;
    pub fn gst_validate_report(
        reporter: *mut GstValidateReporter,
        issue_id: GstValidateIssueId,
        format: *const c_char,
        ...
    );
    pub fn gst_validate_set_globals(structure: *mut gst::GstStructure);
    pub fn gst_validate_setup_test_file(
        testfile: *const c_char,
        use_fakesinks: gboolean,
    ) -> *mut gst::GstStructure;
    pub fn gst_validate_skip_test(format: *const c_char, ...);
    pub fn gst_validate_spin_on_fault_signals();
    pub fn gst_validate_structs_parse_from_gfile(
        scenario_file: *mut gio::GFile,
        get_include_paths_func: GstValidateGetIncludePathsFunc,
    ) -> *mut glib::GList;
    pub fn gst_validate_structure_resolve_variables(
        source: gpointer,
        structure: *mut gst::GstStructure,
        local_variables: *mut gst::GstStructure,
        flags: GstValidateStructureResolveVariablesFlags,
    );
    pub fn gst_validate_structure_set_variables_from_struct_file(
        vars: *mut gst::GstStructure,
        struct_file: *const c_char,
    );
    pub fn gst_validate_utils_enum_from_str(
        type_: GType,
        str_enum: *const c_char,
        enum_value: *mut c_uint,
    ) -> gboolean;
    pub fn gst_validate_utils_flags_from_str(type_: GType, str_flags: *const c_char) -> c_uint;
    pub fn gst_validate_utils_get_clocktime(
        structure: *mut gst::GstStructure,
        name: *const c_char,
        retval: *mut gst::GstClockTime,
    ) -> gboolean;
    pub fn gst_validate_utils_get_strv(
        str: *mut gst::GstStructure,
        fieldname: *const c_char,
    ) -> *mut *mut c_char;
    pub fn gst_validate_utils_parse_expression(
        expr: *const c_char,
        variable_func: GstValidateParseVariableFunc,
        user_data: gpointer,
        error: *mut *mut c_char,
    ) -> c_double;
    pub fn gst_validate_utils_structs_parse_from_filename(
        scenario_file: *const c_char,
        get_include_paths_func: GstValidateGetIncludePathsFunc,
        file_path: *mut *mut c_char,
    ) -> *mut glib::GList;
    pub fn gst_validate_utils_test_file_get_meta(
        testfile: *const c_char,
        use_fakesinks: gboolean,
    ) -> *mut gst::GstStructure;

}
