// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::ffi;
use glib::{prelude::*, translate::*, GStr};

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstValidateReportLevel")]
pub enum ReportLevel {
    #[doc(alias = "GST_VALIDATE_REPORT_LEVEL_CRITICAL")]
    Critical,
    #[doc(alias = "GST_VALIDATE_REPORT_LEVEL_WARNING")]
    Warning,
    #[doc(alias = "GST_VALIDATE_REPORT_LEVEL_ISSUE")]
    Issue,
    #[doc(alias = "GST_VALIDATE_REPORT_LEVEL_IGNORE")]
    Ignore,
    #[doc(alias = "GST_VALIDATE_REPORT_LEVEL_UNKNOWN")]
    Unknown,
    #[doc(alias = "GST_VALIDATE_REPORT_LEVEL_EXPECTED")]
    Expected,
    #[doc(alias = "GST_VALIDATE_REPORT_LEVEL_NUM_ENTRIES")]
    NumEntries,
    #[doc(hidden)]
    __Unknown(i32),
}

impl ReportLevel {
    #[doc(alias = "gst_validate_report_level_from_name")]
    pub fn from_name(level_name: &str) -> ReportLevel {
        assert_initialized_main_thread!();
        unsafe {
            from_glib(ffi::gst_validate_report_level_from_name(
                level_name.to_glib_none().0,
            ))
        }
    }

    pub fn name<'a>(self) -> &'a GStr {
        unsafe {
            GStr::from_ptr(
                ffi::gst_validate_report_level_get_name(self.into_glib())
                    .as_ref()
                    .expect("gst_validate_report_level_get_name returned NULL"),
            )
        }
    }
}

impl std::fmt::Display for ReportLevel {
    #[inline]
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        f.write_str(&self.name())
    }
}

#[doc(hidden)]
impl IntoGlib for ReportLevel {
    type GlibType = ffi::GstValidateReportLevel;

    #[inline]
    fn into_glib(self) -> ffi::GstValidateReportLevel {
        match self {
            Self::Critical => ffi::GST_VALIDATE_REPORT_LEVEL_CRITICAL,
            Self::Warning => ffi::GST_VALIDATE_REPORT_LEVEL_WARNING,
            Self::Issue => ffi::GST_VALIDATE_REPORT_LEVEL_ISSUE,
            Self::Ignore => ffi::GST_VALIDATE_REPORT_LEVEL_IGNORE,
            Self::Unknown => ffi::GST_VALIDATE_REPORT_LEVEL_UNKNOWN,
            Self::Expected => ffi::GST_VALIDATE_REPORT_LEVEL_EXPECTED,
            Self::NumEntries => ffi::GST_VALIDATE_REPORT_LEVEL_NUM_ENTRIES,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstValidateReportLevel> for ReportLevel {
    #[inline]
    unsafe fn from_glib(value: ffi::GstValidateReportLevel) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::GST_VALIDATE_REPORT_LEVEL_CRITICAL => Self::Critical,
            ffi::GST_VALIDATE_REPORT_LEVEL_WARNING => Self::Warning,
            ffi::GST_VALIDATE_REPORT_LEVEL_ISSUE => Self::Issue,
            ffi::GST_VALIDATE_REPORT_LEVEL_IGNORE => Self::Ignore,
            ffi::GST_VALIDATE_REPORT_LEVEL_UNKNOWN => Self::Unknown,
            ffi::GST_VALIDATE_REPORT_LEVEL_EXPECTED => Self::Expected,
            ffi::GST_VALIDATE_REPORT_LEVEL_NUM_ENTRIES => Self::NumEntries,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ReportLevel {
    #[inline]
    #[doc(alias = "gst_validate_report_level_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::gst_validate_report_level_get_type()) }
    }
}

impl glib::HasParamSpec for ReportLevel {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for ReportLevel {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ReportLevel {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ReportLevel {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ReportLevel> for glib::Value {
    #[inline]
    fn from(v: ReportLevel) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstValidateReportingDetails")]
pub enum ReportingDetails {
    #[doc(alias = "GST_VALIDATE_SHOW_UNKNOWN")]
    Unknown,
    #[doc(alias = "GST_VALIDATE_SHOW_NONE")]
    None,
    #[doc(alias = "GST_VALIDATE_SHOW_SYNTHETIC")]
    Synthetic,
    #[doc(alias = "GST_VALIDATE_SHOW_SUBCHAIN")]
    Subchain,
    #[doc(alias = "GST_VALIDATE_SHOW_MONITOR")]
    Monitor,
    #[doc(alias = "GST_VALIDATE_SHOW_ALL")]
    All,
    #[doc(alias = "GST_VALIDATE_SHOW_SMART")]
    Smart,
    #[doc(alias = "GST_VALIDATE_SHOW_COUNT")]
    Count,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ReportingDetails {
    type GlibType = ffi::GstValidateReportingDetails;

    #[inline]
    fn into_glib(self) -> ffi::GstValidateReportingDetails {
        match self {
            Self::Unknown => ffi::GST_VALIDATE_SHOW_UNKNOWN,
            Self::None => ffi::GST_VALIDATE_SHOW_NONE,
            Self::Synthetic => ffi::GST_VALIDATE_SHOW_SYNTHETIC,
            Self::Subchain => ffi::GST_VALIDATE_SHOW_SUBCHAIN,
            Self::Monitor => ffi::GST_VALIDATE_SHOW_MONITOR,
            Self::All => ffi::GST_VALIDATE_SHOW_ALL,
            Self::Smart => ffi::GST_VALIDATE_SHOW_SMART,
            Self::Count => ffi::GST_VALIDATE_SHOW_COUNT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstValidateReportingDetails> for ReportingDetails {
    #[inline]
    unsafe fn from_glib(value: ffi::GstValidateReportingDetails) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::GST_VALIDATE_SHOW_UNKNOWN => Self::Unknown,
            ffi::GST_VALIDATE_SHOW_NONE => Self::None,
            ffi::GST_VALIDATE_SHOW_SYNTHETIC => Self::Synthetic,
            ffi::GST_VALIDATE_SHOW_SUBCHAIN => Self::Subchain,
            ffi::GST_VALIDATE_SHOW_MONITOR => Self::Monitor,
            ffi::GST_VALIDATE_SHOW_ALL => Self::All,
            ffi::GST_VALIDATE_SHOW_SMART => Self::Smart,
            ffi::GST_VALIDATE_SHOW_COUNT => Self::Count,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ReportingDetails {
    #[inline]
    #[doc(alias = "gst_validate_reporting_details_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::gst_validate_reporting_details_get_type()) }
    }
}

impl glib::HasParamSpec for ReportingDetails {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for ReportingDetails {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ReportingDetails {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ReportingDetails {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ReportingDetails> for glib::Value {
    #[inline]
    fn from(v: ReportingDetails) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}
