// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(docsrs, feature(doc_cfg))]

use gio_sys as gio;
use glib_sys as glib;
use gstreamer_sys as gst;

#[cfg(unix)]
#[allow(unused_imports)]
use libc::{dev_t, gid_t, pid_t, socklen_t, uid_t};
#[allow(unused_imports)]
use libc::{intptr_t, off_t, size_t, ssize_t, time_t, uintptr_t, FILE};
#[allow(unused_imports)]
use std::ffi::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Constants
pub const GST_NET_TIME_PACKET_SIZE: c_int = 16;
pub const GST_PTP_CLOCK_ID_NONE: u64 = 18446744073709551615;
pub const GST_PTP_STATISTICS_BEST_MASTER_CLOCK_SELECTED: &[u8] =
    b"GstPtpStatisticsBestMasterClockSelected\0";
pub const GST_PTP_STATISTICS_NEW_DOMAIN_FOUND: &[u8] = b"GstPtpStatisticsNewDomainFound\0";
pub const GST_PTP_STATISTICS_PATH_DELAY_MEASURED: &[u8] = b"GstPtpStatisticsPathDelayMeasured\0";
pub const GST_PTP_STATISTICS_TIME_UPDATED: &[u8] = b"GstPtpStatisticsTimeUpdated\0";

// Callbacks
pub type GstPtpStatisticsCallback =
    Option<unsafe extern "C" fn(u8, *const gst::GstStructure, gpointer) -> gboolean>;

// Records
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstNetAddressMeta {
    pub meta: gst::GstMeta,
    pub addr: *mut gio::GSocketAddress,
}

impl ::std::fmt::Debug for GstNetAddressMeta {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstNetAddressMeta @ {self:p}"))
            .field("meta", &self.meta)
            .field("addr", &self.addr)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstNetClientClockClass {
    pub parent_class: gst::GstSystemClockClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstNetClientClockClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstNetClientClockClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstNetClientClockPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstNetClientClockPrivate = _GstNetClientClockPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstNetControlMessageMeta {
    pub meta: gst::GstMeta,
    pub message: *mut gio::GSocketControlMessage,
}

impl ::std::fmt::Debug for GstNetControlMessageMeta {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstNetControlMessageMeta @ {self:p}"))
            .field("meta", &self.meta)
            .field("message", &self.message)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstNetTimePacket {
    pub local_time: gst::GstClockTime,
    pub remote_time: gst::GstClockTime,
}

impl ::std::fmt::Debug for GstNetTimePacket {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstNetTimePacket @ {self:p}"))
            .field("local_time", &self.local_time)
            .field("remote_time", &self.remote_time)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstNetTimeProviderClass {
    pub parent_class: gst::GstObjectClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstNetTimeProviderClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstNetTimeProviderClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("_gst_reserved", &self._gst_reserved)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstNetTimeProviderPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstNetTimeProviderPrivate = _GstNetTimeProviderPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstNtpClockClass {
    pub parent_class: gst::GstSystemClockClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstNtpClockClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstNtpClockClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstPtpClockClass {
    pub parent_class: gst::GstSystemClockClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstPtpClockClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstPtpClockClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[allow(dead_code)]
pub struct _GstPtpClockPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstPtpClockPrivate = _GstPtpClockPrivate;

// Classes
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstNetClientClock {
    pub clock: gst::GstSystemClock,
    pub priv_: *mut GstNetClientClockPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstNetClientClock {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstNetClientClock @ {self:p}"))
            .field("clock", &self.clock)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstNetTimeProvider {
    pub parent: gst::GstObject,
    pub priv_: *mut GstNetTimeProviderPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstNetTimeProvider {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstNetTimeProvider @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstNtpClock {
    pub clock: gst::GstSystemClock,
    pub priv_: *mut GstNetClientClockPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstNtpClock {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstNtpClock @ {self:p}"))
            .field("clock", &self.clock)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstPtpClock {
    pub clock: gst::GstSystemClock,
    pub priv_: *mut GstPtpClockPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstPtpClock {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstPtpClock @ {self:p}"))
            .field("clock", &self.clock)
            .finish()
    }
}

extern "C" {

    //=========================================================================
    // GstNetAddressMeta
    //=========================================================================
    pub fn gst_net_address_meta_get_info() -> *const gst::GstMetaInfo;

    //=========================================================================
    // GstNetControlMessageMeta
    //=========================================================================
    pub fn gst_net_control_message_meta_get_info() -> *const gst::GstMetaInfo;

    //=========================================================================
    // GstNetTimePacket
    //=========================================================================
    pub fn gst_net_time_packet_get_type() -> GType;
    pub fn gst_net_time_packet_new(buffer: *const [u8; 16]) -> *mut GstNetTimePacket;
    pub fn gst_net_time_packet_copy(packet: *const GstNetTimePacket) -> *mut GstNetTimePacket;
    pub fn gst_net_time_packet_free(packet: *mut GstNetTimePacket);
    pub fn gst_net_time_packet_send(
        packet: *const GstNetTimePacket,
        socket: *mut gio::GSocket,
        dest_address: *mut gio::GSocketAddress,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn gst_net_time_packet_serialize(packet: *const GstNetTimePacket) -> *mut [u8; 16];
    pub fn gst_net_time_packet_receive(
        socket: *mut gio::GSocket,
        src_address: *mut *mut gio::GSocketAddress,
        error: *mut *mut glib::GError,
    ) -> *mut GstNetTimePacket;

    //=========================================================================
    // GstNetClientClock
    //=========================================================================
    pub fn gst_net_client_clock_get_type() -> GType;
    pub fn gst_net_client_clock_new(
        name: *const c_char,
        remote_address: *const c_char,
        remote_port: c_int,
        base_time: gst::GstClockTime,
    ) -> *mut gst::GstClock;
    #[cfg(feature = "v1_28")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_28")))]
    pub fn gst_net_client_clock_deinit();

    //=========================================================================
    // GstNetTimeProvider
    //=========================================================================
    pub fn gst_net_time_provider_get_type() -> GType;
    pub fn gst_net_time_provider_new(
        clock: *mut gst::GstClock,
        address: *const c_char,
        port: c_int,
    ) -> *mut GstNetTimeProvider;

    //=========================================================================
    // GstNtpClock
    //=========================================================================
    pub fn gst_ntp_clock_get_type() -> GType;
    pub fn gst_ntp_clock_new(
        name: *const c_char,
        remote_address: *const c_char,
        remote_port: c_int,
        base_time: gst::GstClockTime,
    ) -> *mut gst::GstClock;

    //=========================================================================
    // GstPtpClock
    //=========================================================================
    pub fn gst_ptp_clock_get_type() -> GType;
    pub fn gst_ptp_clock_new(name: *const c_char, domain: c_uint) -> *mut gst::GstClock;

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn gst_buffer_add_net_address_meta(
        buffer: *mut gst::GstBuffer,
        addr: *mut gio::GSocketAddress,
    ) -> *mut GstNetAddressMeta;
    pub fn gst_buffer_add_net_control_message_meta(
        buffer: *mut gst::GstBuffer,
        message: *mut gio::GSocketControlMessage,
    ) -> *mut GstNetControlMessageMeta;
    pub fn gst_buffer_get_net_address_meta(buffer: *mut gst::GstBuffer) -> *mut GstNetAddressMeta;
    pub fn gst_net_address_meta_api_get_type() -> GType;
    pub fn gst_net_control_message_meta_api_get_type() -> GType;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_net_utils_set_socket_tos(socket: *mut gio::GSocket, qos_dscp: c_int) -> gboolean;
    pub fn gst_ptp_deinit();
    pub fn gst_ptp_init(clock_id: u64, interfaces: *mut *mut c_char) -> gboolean;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_ptp_init_full(config: *const gst::GstStructure) -> gboolean;
    pub fn gst_ptp_is_initialized() -> gboolean;
    pub fn gst_ptp_is_supported() -> gboolean;
    pub fn gst_ptp_statistics_callback_add(
        callback: GstPtpStatisticsCallback,
        user_data: gpointer,
        destroy_data: glib::GDestroyNotify,
    ) -> c_ulong;
    pub fn gst_ptp_statistics_callback_remove(id: c_ulong);

}
