// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{ffi, SourceBufferAppendMode};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstSourceBuffer")]
    pub struct SourceBuffer(Object<ffi::GstSourceBuffer, ffi::GstSourceBufferClass>) @extends gst::Object;

    match fn {
        type_ => || ffi::gst_source_buffer_get_type(),
    }
}

impl SourceBuffer {
    #[doc(alias = "gst_source_buffer_abort")]
    pub fn abort(&self) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_source_buffer_abort(self.to_glib_none().0, &mut error);
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_source_buffer_append_buffer")]
    pub fn append_buffer(&self, buf: gst::Buffer) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_source_buffer_append_buffer(
                self.to_glib_none().0,
                buf.into_glib_ptr(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_source_buffer_change_content_type")]
    pub fn change_content_type(&self, type_: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_source_buffer_change_content_type(
                self.to_glib_none().0,
                type_.to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_source_buffer_get_append_mode")]
    #[doc(alias = "get_append_mode")]
    #[doc(alias = "append-mode")]
    pub fn append_mode(&self) -> SourceBufferAppendMode {
        unsafe {
            from_glib(ffi::gst_source_buffer_get_append_mode(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_source_buffer_get_append_window_end")]
    #[doc(alias = "get_append_window_end")]
    #[doc(alias = "append-window-end")]
    pub fn append_window_end(&self) -> Option<gst::ClockTime> {
        unsafe {
            from_glib(ffi::gst_source_buffer_get_append_window_end(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_source_buffer_get_append_window_start")]
    #[doc(alias = "get_append_window_start")]
    #[doc(alias = "append-window-start")]
    pub fn append_window_start(&self) -> Option<gst::ClockTime> {
        unsafe {
            from_glib(ffi::gst_source_buffer_get_append_window_start(
                self.to_glib_none().0,
            ))
        }
    }

    //#[doc(alias = "gst_source_buffer_get_buffered")]
    //#[doc(alias = "get_buffered")]
    //pub fn buffered(&self) -> Result</*Unknown conversion*//*Unimplemented*/Array TypeId { ns_id: 1, id: 5 }, glib::Error> {
    //    unsafe { TODO: call ffi:gst_source_buffer_get_buffered() }
    //}

    #[doc(alias = "gst_source_buffer_get_content_type")]
    #[doc(alias = "get_content_type")]
    #[doc(alias = "content-type")]
    pub fn content_type(&self) -> glib::GString {
        unsafe {
            from_glib_full(ffi::gst_source_buffer_get_content_type(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_source_buffer_get_timestamp_offset")]
    #[doc(alias = "get_timestamp_offset")]
    #[doc(alias = "timestamp-offset")]
    pub fn timestamp_offset(&self) -> Option<gst::ClockTime> {
        unsafe {
            from_glib(ffi::gst_source_buffer_get_timestamp_offset(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_source_buffer_get_updating")]
    #[doc(alias = "get_updating")]
    #[doc(alias = "updating")]
    pub fn is_updating(&self) -> bool {
        unsafe { from_glib(ffi::gst_source_buffer_get_updating(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_source_buffer_remove")]
    pub fn remove(
        &self,
        start: impl Into<Option<gst::ClockTime>>,
        end: impl Into<Option<gst::ClockTime>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_source_buffer_remove(
                self.to_glib_none().0,
                start.into().into_glib(),
                end.into().into_glib(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_source_buffer_set_append_mode")]
    #[doc(alias = "append-mode")]
    pub fn set_append_mode(&self, mode: SourceBufferAppendMode) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_source_buffer_set_append_mode(
                self.to_glib_none().0,
                mode.into_glib(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_source_buffer_set_append_window_end")]
    pub fn set_append_window_end(
        &self,
        end: impl Into<Option<gst::ClockTime>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_source_buffer_set_append_window_end(
                self.to_glib_none().0,
                end.into().into_glib(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_source_buffer_set_append_window_start")]
    pub fn set_append_window_start(
        &self,
        start: impl Into<Option<gst::ClockTime>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_source_buffer_set_append_window_start(
                self.to_glib_none().0,
                start.into().into_glib(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gst_source_buffer_set_timestamp_offset")]
    #[doc(alias = "timestamp-offset")]
    pub fn set_timestamp_offset(
        &self,
        offset: impl Into<Option<gst::ClockTime>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::gst_source_buffer_set_timestamp_offset(
                self.to_glib_none().0,
                offset.into().into_glib(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "content-type")]
    pub fn set_content_type(&self, content_type: Option<&str>) {
        ObjectExt::set_property(self, "content-type", content_type)
    }

    #[doc(alias = "on-abort")]
    pub fn connect_on_abort<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn on_abort_trampoline<F: Fn(&SourceBuffer) + Send + Sync + 'static>(
            this: *mut ffi::GstSourceBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"on-abort".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    on_abort_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "on-error")]
    pub fn connect_on_error<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn on_error_trampoline<F: Fn(&SourceBuffer) + Send + Sync + 'static>(
            this: *mut ffi::GstSourceBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"on-error".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    on_error_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "on-update")]
    pub fn connect_on_update<F: Fn(&Self) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn on_update_trampoline<F: Fn(&SourceBuffer) + Send + Sync + 'static>(
            this: *mut ffi::GstSourceBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"on-update".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    on_update_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "on-update-end")]
    pub fn connect_on_update_end<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn on_update_end_trampoline<
            F: Fn(&SourceBuffer) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstSourceBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"on-update-end".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    on_update_end_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "on-update-start")]
    pub fn connect_on_update_start<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn on_update_start_trampoline<
            F: Fn(&SourceBuffer) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstSourceBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"on-update-start".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    on_update_start_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "append-mode")]
    pub fn connect_append_mode_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_append_mode_trampoline<
            F: Fn(&SourceBuffer) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstSourceBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::append-mode".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_append_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "append-window-end")]
    pub fn connect_append_window_end_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_append_window_end_trampoline<
            F: Fn(&SourceBuffer) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstSourceBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::append-window-end".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_append_window_end_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "append-window-start")]
    pub fn connect_append_window_start_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_append_window_start_trampoline<
            F: Fn(&SourceBuffer) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstSourceBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::append-window-start".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_append_window_start_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "buffered")]
    pub fn connect_buffered_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_buffered_trampoline<
            F: Fn(&SourceBuffer) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstSourceBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::buffered".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_buffered_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "content-type")]
    pub fn connect_content_type_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_content_type_trampoline<
            F: Fn(&SourceBuffer) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstSourceBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::content-type".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_content_type_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "timestamp-offset")]
    pub fn connect_timestamp_offset_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_timestamp_offset_trampoline<
            F: Fn(&SourceBuffer) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstSourceBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::timestamp-offset".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_timestamp_offset_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "updating")]
    pub fn connect_updating_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_updating_trampoline<
            F: Fn(&SourceBuffer) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstSourceBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::updating".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_updating_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

unsafe impl Send for SourceBuffer {}
unsafe impl Sync for SourceBuffer {}
