// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![cfg(unix)]

use gstreamer_mpegts_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::{Command, Stdio};
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["gstreamer-mpegts-1.0"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {cmd:?} failed, {status}").into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{name} {err}").into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing ';' separator");
        c_constants.push((name.to_owned(), value.to_owned()));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {rust_name}\nRust: {rust_value:?}\nC:    {c_value:?}",
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing first ';' separator");
        let (size, alignment) = value.split_once(';').expect("Missing second ';' separator");
        let size = size.parse().expect("Failed to parse size");
        let alignment = alignment.parse().expect("Failed to parse alignment");
        c_layouts.push((name.to_owned(), Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!("Layout mismatch for {rust_name}\nRust: {rust_layout:?}\nC:    {c_layout:?}",);
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut cmd = Command::new(exe);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }

    Ok(String::from_utf8(out.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "GstMpegtsATSCDescriptorType",
        Layout {
            size: size_of::<GstMpegtsATSCDescriptorType>(),
            alignment: align_of::<GstMpegtsATSCDescriptorType>(),
        },
    ),
    (
        "GstMpegtsATSCStreamType",
        Layout {
            size: size_of::<GstMpegtsATSCStreamType>(),
            alignment: align_of::<GstMpegtsATSCStreamType>(),
        },
    ),
    (
        "GstMpegtsAtscEIT",
        Layout {
            size: size_of::<GstMpegtsAtscEIT>(),
            alignment: align_of::<GstMpegtsAtscEIT>(),
        },
    ),
    (
        "GstMpegtsAtscEITEvent",
        Layout {
            size: size_of::<GstMpegtsAtscEITEvent>(),
            alignment: align_of::<GstMpegtsAtscEITEvent>(),
        },
    ),
    (
        "GstMpegtsAtscETT",
        Layout {
            size: size_of::<GstMpegtsAtscETT>(),
            alignment: align_of::<GstMpegtsAtscETT>(),
        },
    ),
    (
        "GstMpegtsAtscMGT",
        Layout {
            size: size_of::<GstMpegtsAtscMGT>(),
            alignment: align_of::<GstMpegtsAtscMGT>(),
        },
    ),
    (
        "GstMpegtsAtscMGTTable",
        Layout {
            size: size_of::<GstMpegtsAtscMGTTable>(),
            alignment: align_of::<GstMpegtsAtscMGTTable>(),
        },
    ),
    (
        "GstMpegtsAtscMGTTableType",
        Layout {
            size: size_of::<GstMpegtsAtscMGTTableType>(),
            alignment: align_of::<GstMpegtsAtscMGTTableType>(),
        },
    ),
    (
        "GstMpegtsAtscMultString",
        Layout {
            size: size_of::<GstMpegtsAtscMultString>(),
            alignment: align_of::<GstMpegtsAtscMultString>(),
        },
    ),
    (
        "GstMpegtsAtscRRT",
        Layout {
            size: size_of::<GstMpegtsAtscRRT>(),
            alignment: align_of::<GstMpegtsAtscRRT>(),
        },
    ),
    (
        "GstMpegtsAtscRRTDimension",
        Layout {
            size: size_of::<GstMpegtsAtscRRTDimension>(),
            alignment: align_of::<GstMpegtsAtscRRTDimension>(),
        },
    ),
    (
        "GstMpegtsAtscRRTDimensionValue",
        Layout {
            size: size_of::<GstMpegtsAtscRRTDimensionValue>(),
            alignment: align_of::<GstMpegtsAtscRRTDimensionValue>(),
        },
    ),
    (
        "GstMpegtsAtscSTT",
        Layout {
            size: size_of::<GstMpegtsAtscSTT>(),
            alignment: align_of::<GstMpegtsAtscSTT>(),
        },
    ),
    (
        "GstMpegtsAtscStringSegment",
        Layout {
            size: size_of::<GstMpegtsAtscStringSegment>(),
            alignment: align_of::<GstMpegtsAtscStringSegment>(),
        },
    ),
    (
        "GstMpegtsAtscVCT",
        Layout {
            size: size_of::<GstMpegtsAtscVCT>(),
            alignment: align_of::<GstMpegtsAtscVCT>(),
        },
    ),
    (
        "GstMpegtsAtscVCTSource",
        Layout {
            size: size_of::<GstMpegtsAtscVCTSource>(),
            alignment: align_of::<GstMpegtsAtscVCTSource>(),
        },
    ),
    (
        "GstMpegtsAudioPreselectionDescriptor",
        Layout {
            size: size_of::<GstMpegtsAudioPreselectionDescriptor>(),
            alignment: align_of::<GstMpegtsAudioPreselectionDescriptor>(),
        },
    ),
    (
        "GstMpegtsBAT",
        Layout {
            size: size_of::<GstMpegtsBAT>(),
            alignment: align_of::<GstMpegtsBAT>(),
        },
    ),
    (
        "GstMpegtsBATStream",
        Layout {
            size: size_of::<GstMpegtsBATStream>(),
            alignment: align_of::<GstMpegtsBATStream>(),
        },
    ),
    (
        "GstMpegtsCableDeliverySystemDescriptor",
        Layout {
            size: size_of::<GstMpegtsCableDeliverySystemDescriptor>(),
            alignment: align_of::<GstMpegtsCableDeliverySystemDescriptor>(),
        },
    ),
    (
        "GstMpegtsCableOuterFECScheme",
        Layout {
            size: size_of::<GstMpegtsCableOuterFECScheme>(),
            alignment: align_of::<GstMpegtsCableOuterFECScheme>(),
        },
    ),
    (
        "GstMpegtsComponentDescriptor",
        Layout {
            size: size_of::<GstMpegtsComponentDescriptor>(),
            alignment: align_of::<GstMpegtsComponentDescriptor>(),
        },
    ),
    (
        "GstMpegtsComponentStreamContent",
        Layout {
            size: size_of::<GstMpegtsComponentStreamContent>(),
            alignment: align_of::<GstMpegtsComponentStreamContent>(),
        },
    ),
    (
        "GstMpegtsContent",
        Layout {
            size: size_of::<GstMpegtsContent>(),
            alignment: align_of::<GstMpegtsContent>(),
        },
    ),
    (
        "GstMpegtsContentNibbleHi",
        Layout {
            size: size_of::<GstMpegtsContentNibbleHi>(),
            alignment: align_of::<GstMpegtsContentNibbleHi>(),
        },
    ),
    (
        "GstMpegtsDVBCodeRate",
        Layout {
            size: size_of::<GstMpegtsDVBCodeRate>(),
            alignment: align_of::<GstMpegtsDVBCodeRate>(),
        },
    ),
    (
        "GstMpegtsDVBDescriptorType",
        Layout {
            size: size_of::<GstMpegtsDVBDescriptorType>(),
            alignment: align_of::<GstMpegtsDVBDescriptorType>(),
        },
    ),
    (
        "GstMpegtsDVBExtendedDescriptorType",
        Layout {
            size: size_of::<GstMpegtsDVBExtendedDescriptorType>(),
            alignment: align_of::<GstMpegtsDVBExtendedDescriptorType>(),
        },
    ),
    (
        "GstMpegtsDVBLinkageDescriptor",
        Layout {
            size: size_of::<GstMpegtsDVBLinkageDescriptor>(),
            alignment: align_of::<GstMpegtsDVBLinkageDescriptor>(),
        },
    ),
    (
        "GstMpegtsDVBLinkageEvent",
        Layout {
            size: size_of::<GstMpegtsDVBLinkageEvent>(),
            alignment: align_of::<GstMpegtsDVBLinkageEvent>(),
        },
    ),
    (
        "GstMpegtsDVBLinkageExtendedEvent",
        Layout {
            size: size_of::<GstMpegtsDVBLinkageExtendedEvent>(),
            alignment: align_of::<GstMpegtsDVBLinkageExtendedEvent>(),
        },
    ),
    (
        "GstMpegtsDVBLinkageHandOverType",
        Layout {
            size: size_of::<GstMpegtsDVBLinkageHandOverType>(),
            alignment: align_of::<GstMpegtsDVBLinkageHandOverType>(),
        },
    ),
    (
        "GstMpegtsDVBLinkageMobileHandOver",
        Layout {
            size: size_of::<GstMpegtsDVBLinkageMobileHandOver>(),
            alignment: align_of::<GstMpegtsDVBLinkageMobileHandOver>(),
        },
    ),
    (
        "GstMpegtsDVBLinkageType",
        Layout {
            size: size_of::<GstMpegtsDVBLinkageType>(),
            alignment: align_of::<GstMpegtsDVBLinkageType>(),
        },
    ),
    (
        "GstMpegtsDVBParentalRatingItem",
        Layout {
            size: size_of::<GstMpegtsDVBParentalRatingItem>(),
            alignment: align_of::<GstMpegtsDVBParentalRatingItem>(),
        },
    ),
    (
        "GstMpegtsDVBScramblingModeType",
        Layout {
            size: size_of::<GstMpegtsDVBScramblingModeType>(),
            alignment: align_of::<GstMpegtsDVBScramblingModeType>(),
        },
    ),
    (
        "GstMpegtsDVBServiceListItem",
        Layout {
            size: size_of::<GstMpegtsDVBServiceListItem>(),
            alignment: align_of::<GstMpegtsDVBServiceListItem>(),
        },
    ),
    (
        "GstMpegtsDVBServiceType",
        Layout {
            size: size_of::<GstMpegtsDVBServiceType>(),
            alignment: align_of::<GstMpegtsDVBServiceType>(),
        },
    ),
    (
        "GstMpegtsDVBTeletextType",
        Layout {
            size: size_of::<GstMpegtsDVBTeletextType>(),
            alignment: align_of::<GstMpegtsDVBTeletextType>(),
        },
    ),
    (
        "GstMpegtsDataBroadcastDescriptor",
        Layout {
            size: size_of::<GstMpegtsDataBroadcastDescriptor>(),
            alignment: align_of::<GstMpegtsDataBroadcastDescriptor>(),
        },
    ),
    (
        "GstMpegtsDescriptor",
        Layout {
            size: size_of::<GstMpegtsDescriptor>(),
            alignment: align_of::<GstMpegtsDescriptor>(),
        },
    ),
    (
        "GstMpegtsDescriptorType",
        Layout {
            size: size_of::<GstMpegtsDescriptorType>(),
            alignment: align_of::<GstMpegtsDescriptorType>(),
        },
    ),
    (
        "GstMpegtsDvbMultilingualBouquetNameItem",
        Layout {
            size: size_of::<GstMpegtsDvbMultilingualBouquetNameItem>(),
            alignment: align_of::<GstMpegtsDvbMultilingualBouquetNameItem>(),
        },
    ),
    (
        "GstMpegtsDvbMultilingualComponentItem",
        Layout {
            size: size_of::<GstMpegtsDvbMultilingualComponentItem>(),
            alignment: align_of::<GstMpegtsDvbMultilingualComponentItem>(),
        },
    ),
    (
        "GstMpegtsDvbMultilingualNetworkNameItem",
        Layout {
            size: size_of::<GstMpegtsDvbMultilingualNetworkNameItem>(),
            alignment: align_of::<GstMpegtsDvbMultilingualNetworkNameItem>(),
        },
    ),
    (
        "GstMpegtsDvbMultilingualServiceNameItem",
        Layout {
            size: size_of::<GstMpegtsDvbMultilingualServiceNameItem>(),
            alignment: align_of::<GstMpegtsDvbMultilingualServiceNameItem>(),
        },
    ),
    (
        "GstMpegtsEIT",
        Layout {
            size: size_of::<GstMpegtsEIT>(),
            alignment: align_of::<GstMpegtsEIT>(),
        },
    ),
    (
        "GstMpegtsEITEvent",
        Layout {
            size: size_of::<GstMpegtsEITEvent>(),
            alignment: align_of::<GstMpegtsEITEvent>(),
        },
    ),
    (
        "GstMpegtsExtendedDescriptorType",
        Layout {
            size: size_of::<GstMpegtsExtendedDescriptorType>(),
            alignment: align_of::<GstMpegtsExtendedDescriptorType>(),
        },
    ),
    (
        "GstMpegtsExtendedEventDescriptor",
        Layout {
            size: size_of::<GstMpegtsExtendedEventDescriptor>(),
            alignment: align_of::<GstMpegtsExtendedEventDescriptor>(),
        },
    ),
    (
        "GstMpegtsExtendedEventItem",
        Layout {
            size: size_of::<GstMpegtsExtendedEventItem>(),
            alignment: align_of::<GstMpegtsExtendedEventItem>(),
        },
    ),
    (
        "GstMpegtsHdmvStreamType",
        Layout {
            size: size_of::<GstMpegtsHdmvStreamType>(),
            alignment: align_of::<GstMpegtsHdmvStreamType>(),
        },
    ),
    (
        "GstMpegtsISDBDescriptorType",
        Layout {
            size: size_of::<GstMpegtsISDBDescriptorType>(),
            alignment: align_of::<GstMpegtsISDBDescriptorType>(),
        },
    ),
    (
        "GstMpegtsISO639LanguageDescriptor",
        Layout {
            size: size_of::<GstMpegtsISO639LanguageDescriptor>(),
            alignment: align_of::<GstMpegtsISO639LanguageDescriptor>(),
        },
    ),
    (
        "GstMpegtsIso639AudioType",
        Layout {
            size: size_of::<GstMpegtsIso639AudioType>(),
            alignment: align_of::<GstMpegtsIso639AudioType>(),
        },
    ),
    (
        "GstMpegtsJpegXsDescriptor",
        Layout {
            size: size_of::<GstMpegtsJpegXsDescriptor>(),
            alignment: align_of::<GstMpegtsJpegXsDescriptor>(),
        },
    ),
    (
        "GstMpegtsLogicalChannel",
        Layout {
            size: size_of::<GstMpegtsLogicalChannel>(),
            alignment: align_of::<GstMpegtsLogicalChannel>(),
        },
    ),
    (
        "GstMpegtsLogicalChannelDescriptor",
        Layout {
            size: size_of::<GstMpegtsLogicalChannelDescriptor>(),
            alignment: align_of::<GstMpegtsLogicalChannelDescriptor>(),
        },
    ),
    (
        "GstMpegtsMetadataApplicationFormat",
        Layout {
            size: size_of::<GstMpegtsMetadataApplicationFormat>(),
            alignment: align_of::<GstMpegtsMetadataApplicationFormat>(),
        },
    ),
    (
        "GstMpegtsMetadataDescriptor",
        Layout {
            size: size_of::<GstMpegtsMetadataDescriptor>(),
            alignment: align_of::<GstMpegtsMetadataDescriptor>(),
        },
    ),
    (
        "GstMpegtsMetadataFormat",
        Layout {
            size: size_of::<GstMpegtsMetadataFormat>(),
            alignment: align_of::<GstMpegtsMetadataFormat>(),
        },
    ),
    (
        "GstMpegtsMetadataPointerDescriptor",
        Layout {
            size: size_of::<GstMpegtsMetadataPointerDescriptor>(),
            alignment: align_of::<GstMpegtsMetadataPointerDescriptor>(),
        },
    ),
    (
        "GstMpegtsMiscDescriptorType",
        Layout {
            size: size_of::<GstMpegtsMiscDescriptorType>(),
            alignment: align_of::<GstMpegtsMiscDescriptorType>(),
        },
    ),
    (
        "GstMpegtsModulationType",
        Layout {
            size: size_of::<GstMpegtsModulationType>(),
            alignment: align_of::<GstMpegtsModulationType>(),
        },
    ),
    (
        "GstMpegtsNIT",
        Layout {
            size: size_of::<GstMpegtsNIT>(),
            alignment: align_of::<GstMpegtsNIT>(),
        },
    ),
    (
        "GstMpegtsNITStream",
        Layout {
            size: size_of::<GstMpegtsNITStream>(),
            alignment: align_of::<GstMpegtsNITStream>(),
        },
    ),
    (
        "GstMpegtsPESMetadataMeta",
        Layout {
            size: size_of::<GstMpegtsPESMetadataMeta>(),
            alignment: align_of::<GstMpegtsPESMetadataMeta>(),
        },
    ),
    (
        "GstMpegtsPMT",
        Layout {
            size: size_of::<GstMpegtsPMT>(),
            alignment: align_of::<GstMpegtsPMT>(),
        },
    ),
    (
        "GstMpegtsPMTStream",
        Layout {
            size: size_of::<GstMpegtsPMTStream>(),
            alignment: align_of::<GstMpegtsPMTStream>(),
        },
    ),
    (
        "GstMpegtsPatProgram",
        Layout {
            size: size_of::<GstMpegtsPatProgram>(),
            alignment: align_of::<GstMpegtsPatProgram>(),
        },
    ),
    (
        "GstMpegtsRegistrationId",
        Layout {
            size: size_of::<GstMpegtsRegistrationId>(),
            alignment: align_of::<GstMpegtsRegistrationId>(),
        },
    ),
    (
        "GstMpegtsRunningStatus",
        Layout {
            size: size_of::<GstMpegtsRunningStatus>(),
            alignment: align_of::<GstMpegtsRunningStatus>(),
        },
    ),
    (
        "GstMpegtsSCTEDescriptorType",
        Layout {
            size: size_of::<GstMpegtsSCTEDescriptorType>(),
            alignment: align_of::<GstMpegtsSCTEDescriptorType>(),
        },
    ),
    (
        "GstMpegtsSCTESIT",
        Layout {
            size: size_of::<GstMpegtsSCTESIT>(),
            alignment: align_of::<GstMpegtsSCTESIT>(),
        },
    ),
    (
        "GstMpegtsSCTESpliceCommandType",
        Layout {
            size: size_of::<GstMpegtsSCTESpliceCommandType>(),
            alignment: align_of::<GstMpegtsSCTESpliceCommandType>(),
        },
    ),
    (
        "GstMpegtsSCTESpliceComponent",
        Layout {
            size: size_of::<GstMpegtsSCTESpliceComponent>(),
            alignment: align_of::<GstMpegtsSCTESpliceComponent>(),
        },
    ),
    (
        "GstMpegtsSCTESpliceDescriptor",
        Layout {
            size: size_of::<GstMpegtsSCTESpliceDescriptor>(),
            alignment: align_of::<GstMpegtsSCTESpliceDescriptor>(),
        },
    ),
    (
        "GstMpegtsSCTESpliceEvent",
        Layout {
            size: size_of::<GstMpegtsSCTESpliceEvent>(),
            alignment: align_of::<GstMpegtsSCTESpliceEvent>(),
        },
    ),
    (
        "GstMpegtsSDT",
        Layout {
            size: size_of::<GstMpegtsSDT>(),
            alignment: align_of::<GstMpegtsSDT>(),
        },
    ),
    (
        "GstMpegtsSDTService",
        Layout {
            size: size_of::<GstMpegtsSDTService>(),
            alignment: align_of::<GstMpegtsSDTService>(),
        },
    ),
    (
        "GstMpegtsSIT",
        Layout {
            size: size_of::<GstMpegtsSIT>(),
            alignment: align_of::<GstMpegtsSIT>(),
        },
    ),
    (
        "GstMpegtsSITService",
        Layout {
            size: size_of::<GstMpegtsSITService>(),
            alignment: align_of::<GstMpegtsSITService>(),
        },
    ),
    (
        "GstMpegtsSatelliteDeliverySystemDescriptor",
        Layout {
            size: size_of::<GstMpegtsSatelliteDeliverySystemDescriptor>(),
            alignment: align_of::<GstMpegtsSatelliteDeliverySystemDescriptor>(),
        },
    ),
    (
        "GstMpegtsSatellitePolarizationType",
        Layout {
            size: size_of::<GstMpegtsSatellitePolarizationType>(),
            alignment: align_of::<GstMpegtsSatellitePolarizationType>(),
        },
    ),
    (
        "GstMpegtsSatelliteRolloff",
        Layout {
            size: size_of::<GstMpegtsSatelliteRolloff>(),
            alignment: align_of::<GstMpegtsSatelliteRolloff>(),
        },
    ),
    (
        "GstMpegtsScteStreamType",
        Layout {
            size: size_of::<GstMpegtsScteStreamType>(),
            alignment: align_of::<GstMpegtsScteStreamType>(),
        },
    ),
    (
        "GstMpegtsSection",
        Layout {
            size: size_of::<GstMpegtsSection>(),
            alignment: align_of::<GstMpegtsSection>(),
        },
    ),
    (
        "GstMpegtsSectionATSCTableID",
        Layout {
            size: size_of::<GstMpegtsSectionATSCTableID>(),
            alignment: align_of::<GstMpegtsSectionATSCTableID>(),
        },
    ),
    (
        "GstMpegtsSectionDVBTableID",
        Layout {
            size: size_of::<GstMpegtsSectionDVBTableID>(),
            alignment: align_of::<GstMpegtsSectionDVBTableID>(),
        },
    ),
    (
        "GstMpegtsSectionSCTETableID",
        Layout {
            size: size_of::<GstMpegtsSectionSCTETableID>(),
            alignment: align_of::<GstMpegtsSectionSCTETableID>(),
        },
    ),
    (
        "GstMpegtsSectionTableID",
        Layout {
            size: size_of::<GstMpegtsSectionTableID>(),
            alignment: align_of::<GstMpegtsSectionTableID>(),
        },
    ),
    (
        "GstMpegtsSectionType",
        Layout {
            size: size_of::<GstMpegtsSectionType>(),
            alignment: align_of::<GstMpegtsSectionType>(),
        },
    ),
    (
        "GstMpegtsStreamType",
        Layout {
            size: size_of::<GstMpegtsStreamType>(),
            alignment: align_of::<GstMpegtsStreamType>(),
        },
    ),
    (
        "GstMpegtsT2DeliverySystemCell",
        Layout {
            size: size_of::<GstMpegtsT2DeliverySystemCell>(),
            alignment: align_of::<GstMpegtsT2DeliverySystemCell>(),
        },
    ),
    (
        "GstMpegtsT2DeliverySystemCellExtension",
        Layout {
            size: size_of::<GstMpegtsT2DeliverySystemCellExtension>(),
            alignment: align_of::<GstMpegtsT2DeliverySystemCellExtension>(),
        },
    ),
    (
        "GstMpegtsT2DeliverySystemDescriptor",
        Layout {
            size: size_of::<GstMpegtsT2DeliverySystemDescriptor>(),
            alignment: align_of::<GstMpegtsT2DeliverySystemDescriptor>(),
        },
    ),
    (
        "GstMpegtsTOT",
        Layout {
            size: size_of::<GstMpegtsTOT>(),
            alignment: align_of::<GstMpegtsTOT>(),
        },
    ),
    (
        "GstMpegtsTerrestrialDeliverySystemDescriptor",
        Layout {
            size: size_of::<GstMpegtsTerrestrialDeliverySystemDescriptor>(),
            alignment: align_of::<GstMpegtsTerrestrialDeliverySystemDescriptor>(),
        },
    ),
    (
        "GstMpegtsTerrestrialGuardInterval",
        Layout {
            size: size_of::<GstMpegtsTerrestrialGuardInterval>(),
            alignment: align_of::<GstMpegtsTerrestrialGuardInterval>(),
        },
    ),
    (
        "GstMpegtsTerrestrialHierarchy",
        Layout {
            size: size_of::<GstMpegtsTerrestrialHierarchy>(),
            alignment: align_of::<GstMpegtsTerrestrialHierarchy>(),
        },
    ),
    (
        "GstMpegtsTerrestrialTransmissionMode",
        Layout {
            size: size_of::<GstMpegtsTerrestrialTransmissionMode>(),
            alignment: align_of::<GstMpegtsTerrestrialTransmissionMode>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) ADDITIONAL_INFO_PAGE", "3"),
    (
        "(gint) GST_DVB_SERVICE_ADVANCED_CODEC_DIGITAL_RADIO_SOUND",
        "10",
    ),
    (
        "(gint) GST_DVB_SERVICE_ADVANCED_CODEC_HD_DIGITAL_TELEVISION",
        "25",
    ),
    (
        "(gint) GST_DVB_SERVICE_ADVANCED_CODEC_HD_NVOD_REFERENCE",
        "27",
    ),
    (
        "(gint) GST_DVB_SERVICE_ADVANCED_CODEC_HD_NVOD_TIME_SHIFTED",
        "26",
    ),
    ("(gint) GST_DVB_SERVICE_ADVANCED_CODEC_MOSAIC", "11"),
    (
        "(gint) GST_DVB_SERVICE_ADVANCED_CODEC_SD_DIGITAL_TELEVISION",
        "22",
    ),
    (
        "(gint) GST_DVB_SERVICE_ADVANCED_CODEC_SD_NVOD_REFERENCE",
        "24",
    ),
    (
        "(gint) GST_DVB_SERVICE_ADVANCED_CODEC_SD_NVOD_TIME_SHIFTED",
        "23",
    ),
    (
        "(gint) GST_DVB_SERVICE_ADVANCED_CODEC_STEREO_HD_DIGITAL_TELEVISION",
        "28",
    ),
    (
        "(gint) GST_DVB_SERVICE_ADVANCED_CODEC_STEREO_HD_NVOD_REFERENCE",
        "30",
    ),
    (
        "(gint) GST_DVB_SERVICE_ADVANCED_CODEC_STEREO_HD_NVOD_TIME_SHIFTED",
        "29",
    ),
    ("(gint) GST_DVB_SERVICE_DATA_BROADCAST", "12"),
    ("(gint) GST_DVB_SERVICE_DIGITAL_RADIO_SOUND", "2"),
    ("(gint) GST_DVB_SERVICE_DIGITAL_TELEVISION", "1"),
    ("(gint) GST_DVB_SERVICE_DVB_MHP", "16"),
    ("(gint) GST_DVB_SERVICE_DVB_SRM", "8"),
    ("(gint) GST_DVB_SERVICE_FM_RADIO", "7"),
    ("(gint) GST_DVB_SERVICE_MOSAIC", "6"),
    ("(gint) GST_DVB_SERVICE_MPEG2_HD_DIGITAL_TELEVISION", "17"),
    ("(gint) GST_DVB_SERVICE_NVOD_REFERENCE", "4"),
    ("(gint) GST_DVB_SERVICE_NVOD_TIME_SHIFTED", "5"),
    ("(gint) GST_DVB_SERVICE_RCS_FLS", "15"),
    ("(gint) GST_DVB_SERVICE_RCS_MAP", "14"),
    ("(gint) GST_DVB_SERVICE_RESERVED_00", "0"),
    ("(gint) GST_DVB_SERVICE_RESERVED_09", "9"),
    ("(gint) GST_DVB_SERVICE_RESERVED_0D_COMMON_INTERFACE", "13"),
    ("(gint) GST_DVB_SERVICE_RESERVED_FF", "31"),
    ("(gint) GST_DVB_SERVICE_TELETEXT", "3"),
    ("(gint) GST_MPEGTS_ATSC_MGT_TABLE_TYPE_EIT0", "256"),
    ("(gint) GST_MPEGTS_ATSC_MGT_TABLE_TYPE_EIT127", "383"),
    ("(gint) GST_MPEGTS_ATSC_MGT_TABLE_TYPE_ETT0", "512"),
    ("(gint) GST_MPEGTS_ATSC_MGT_TABLE_TYPE_ETT127", "639"),
    ("(gint) GST_MPEGTS_AUDIO_TYPE_CLEAN_EFFECTS", "1"),
    ("(gint) GST_MPEGTS_AUDIO_TYPE_HEARING_IMPAIRED", "2"),
    ("(gint) GST_MPEGTS_AUDIO_TYPE_UNDEFINED", "0"),
    (
        "(gint) GST_MPEGTS_AUDIO_TYPE_VISUAL_IMPAIRED_COMMENTARY",
        "3",
    ),
    ("(gint) GST_MPEGTS_CABLE_OUTER_FEC_NONE", "1"),
    ("(gint) GST_MPEGTS_CABLE_OUTER_FEC_RS_204_188", "2"),
    ("(gint) GST_MPEGTS_CABLE_OUTER_FEC_UNDEFINED", "0"),
    ("(gint) GST_MPEGTS_CONTENT_ARTS_CULTURE", "7"),
    ("(gint) GST_MPEGTS_CONTENT_CHILDREN_YOUTH_PROGRAM", "5"),
    ("(gint) GST_MPEGTS_CONTENT_EDUCATION_SCIENCE_FACTUAL", "9"),
    ("(gint) GST_MPEGTS_CONTENT_LEISURE_HOBBIES", "10"),
    ("(gint) GST_MPEGTS_CONTENT_MOVIE_DRAMA", "1"),
    ("(gint) GST_MPEGTS_CONTENT_MUSIC_BALLET_DANCE", "6"),
    ("(gint) GST_MPEGTS_CONTENT_NEWS_CURRENT_AFFAIRS", "2"),
    ("(gint) GST_MPEGTS_CONTENT_SHOW_GAME_SHOW", "3"),
    ("(gint) GST_MPEGTS_CONTENT_SOCIAL_POLITICAL_ECONOMICS", "8"),
    ("(gint) GST_MPEGTS_CONTENT_SPECIAL_CHARACTERISTICS", "11"),
    ("(gint) GST_MPEGTS_CONTENT_SPORTS", "4"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_CA_REPLACEMENT", "3"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_DATA_BROADCAST", "6"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_EPG", "2"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_EVENT", "13"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_EXTENDED_EVENT", "14"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_HAND_OVER_ASSOCIATED", "3"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_HAND_OVER_IDENTICAL", "1"),
    (
        "(gint) GST_MPEGTS_DVB_LINKAGE_HAND_OVER_LOCAL_VARIATION",
        "2",
    ),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_HAND_OVER_RESERVED", "0"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_INFORMATION", "1"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_IP_MAC_NOTIFICATION", "11"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_MOBILE_HAND_OVER", "8"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_RCS_MAP", "7"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_RESERVED_00", "0"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_SERVICE_REPLACEMENT", "5"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_SYSTEM_SOFTWARE_UPDATE", "9"),
    (
        "(gint) GST_MPEGTS_DVB_LINKAGE_TS_CONTAINING_COMPLETE_SI",
        "4",
    ),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_TS_CONTAINING_INT", "12"),
    ("(gint) GST_MPEGTS_DVB_LINKAGE_TS_CONTAINING_SSU", "10"),
    ("(gint) GST_MPEGTS_DVB_SCRAMBLING_MODE_ATIS_0", "112"),
    ("(gint) GST_MPEGTS_DVB_SCRAMBLING_MODE_ATIS_F", "127"),
    ("(gint) GST_MPEGTS_DVB_SCRAMBLING_MODE_CISSA", "16"),
    ("(gint) GST_MPEGTS_DVB_SCRAMBLING_MODE_CSA1", "1"),
    ("(gint) GST_MPEGTS_DVB_SCRAMBLING_MODE_CSA2", "2"),
    (
        "(gint) GST_MPEGTS_DVB_SCRAMBLING_MODE_CSA3_FULL_ENHANCED",
        "5",
    ),
    (
        "(gint) GST_MPEGTS_DVB_SCRAMBLING_MODE_CSA3_MINIMAL_ENHANCED",
        "4",
    ),
    ("(gint) GST_MPEGTS_DVB_SCRAMBLING_MODE_CSA3_STANDARD", "3"),
    ("(gint) GST_MPEGTS_DVB_SCRAMBLING_MODE_RESERVED", "0"),
    ("(gint) GST_MPEGTS_FEC_1_2", "1"),
    ("(gint) GST_MPEGTS_FEC_2_3", "2"),
    ("(gint) GST_MPEGTS_FEC_2_5", "12"),
    ("(gint) GST_MPEGTS_FEC_3_4", "3"),
    ("(gint) GST_MPEGTS_FEC_3_5", "10"),
    ("(gint) GST_MPEGTS_FEC_4_5", "4"),
    ("(gint) GST_MPEGTS_FEC_5_6", "5"),
    ("(gint) GST_MPEGTS_FEC_6_7", "6"),
    ("(gint) GST_MPEGTS_FEC_7_8", "7"),
    ("(gint) GST_MPEGTS_FEC_8_9", "8"),
    ("(gint) GST_MPEGTS_FEC_9_10", "11"),
    ("(gint) GST_MPEGTS_FEC_AUTO", "9"),
    ("(gint) GST_MPEGTS_FEC_NONE", "0"),
    ("(gint) GST_MPEGTS_GUARD_INTERVAL_19_128", "6"),
    ("(gint) GST_MPEGTS_GUARD_INTERVAL_19_256", "7"),
    ("(gint) GST_MPEGTS_GUARD_INTERVAL_1_128", "5"),
    ("(gint) GST_MPEGTS_GUARD_INTERVAL_1_16", "1"),
    ("(gint) GST_MPEGTS_GUARD_INTERVAL_1_32", "0"),
    ("(gint) GST_MPEGTS_GUARD_INTERVAL_1_4", "3"),
    ("(gint) GST_MPEGTS_GUARD_INTERVAL_1_8", "2"),
    ("(gint) GST_MPEGTS_GUARD_INTERVAL_AUTO", "4"),
    ("(gint) GST_MPEGTS_GUARD_INTERVAL_PN420", "8"),
    ("(gint) GST_MPEGTS_GUARD_INTERVAL_PN595", "9"),
    ("(gint) GST_MPEGTS_GUARD_INTERVAL_PN945", "10"),
    ("(gint) GST_MPEGTS_HIERARCHY_1", "1"),
    ("(gint) GST_MPEGTS_HIERARCHY_2", "2"),
    ("(gint) GST_MPEGTS_HIERARCHY_4", "3"),
    ("(gint) GST_MPEGTS_HIERARCHY_AUTO", "4"),
    ("(gint) GST_MPEGTS_HIERARCHY_NONE", "0"),
    (
        "(gint) GST_MPEGTS_METADATA_APPLICATION_FORMAT_IDENTIFIER_FIELD",
        "65535",
    ),
    ("(gint) GST_MPEGTS_METADATA_APPLICATION_FORMAT_ISAN", "16"),
    ("(gint) GST_MPEGTS_METADATA_APPLICATION_FORMAT_VSAN", "17"),
    ("(gint) GST_MPEGTS_METADATA_FORMAT_APPLICATION_FORMAT", "63"),
    ("(gint) GST_MPEGTS_METADATA_FORMAT_BIM", "17"),
    ("(gint) GST_MPEGTS_METADATA_FORMAT_IDENTIFIER_FIELD", "255"),
    ("(gint) GST_MPEGTS_METADATA_FORMAT_TEM", "16"),
    ("(gint) GST_MPEGTS_MODULATION_APSK_16", "10"),
    ("(gint) GST_MPEGTS_MODULATION_APSK_32", "11"),
    ("(gint) GST_MPEGTS_MODULATION_DQPSK", "12"),
    ("(gint) GST_MPEGTS_MODULATION_NONE", "14"),
    ("(gint) GST_MPEGTS_MODULATION_PSK_8", "9"),
    ("(gint) GST_MPEGTS_MODULATION_QAM_128", "4"),
    ("(gint) GST_MPEGTS_MODULATION_QAM_16", "1"),
    ("(gint) GST_MPEGTS_MODULATION_QAM_256", "5"),
    ("(gint) GST_MPEGTS_MODULATION_QAM_32", "2"),
    ("(gint) GST_MPEGTS_MODULATION_QAM_4_NR_", "13"),
    ("(gint) GST_MPEGTS_MODULATION_QAM_64", "3"),
    ("(gint) GST_MPEGTS_MODULATION_QAM_AUTO", "6"),
    ("(gint) GST_MPEGTS_MODULATION_QPSK", "0"),
    ("(gint) GST_MPEGTS_MODULATION_VSB_16", "8"),
    ("(gint) GST_MPEGTS_MODULATION_VSB_8", "7"),
    ("(gint) GST_MPEGTS_POLARIZATION_CIRCULAR_LEFT", "2"),
    ("(gint) GST_MPEGTS_POLARIZATION_CIRCULAR_RIGHT", "3"),
    ("(gint) GST_MPEGTS_POLARIZATION_LINEAR_HORIZONTAL", "0"),
    ("(gint) GST_MPEGTS_POLARIZATION_LINEAR_VERTICAL", "1"),
    ("(gint) GST_MPEGTS_ROLLOFF_20", "1"),
    ("(gint) GST_MPEGTS_ROLLOFF_25", "2"),
    ("(gint) GST_MPEGTS_ROLLOFF_35", "0"),
    ("(gint) GST_MPEGTS_ROLLOFF_AUTO", "4"),
    ("(gint) GST_MPEGTS_ROLLOFF_RESERVED", "3"),
    ("(gint) GST_MPEGTS_RUNNING_STATUS_NOT_RUNNING", "1"),
    ("(gint) GST_MPEGTS_RUNNING_STATUS_OFF_AIR", "5"),
    ("(gint) GST_MPEGTS_RUNNING_STATUS_PAUSING", "3"),
    ("(gint) GST_MPEGTS_RUNNING_STATUS_RUNNING", "4"),
    (
        "(gint) GST_MPEGTS_RUNNING_STATUS_STARTS_IN_FEW_SECONDS",
        "2",
    ),
    ("(gint) GST_MPEGTS_RUNNING_STATUS_UNDEFINED", "0"),
    ("(gint) GST_MPEGTS_SECTION_ATSC_CVCT", "13"),
    ("(gint) GST_MPEGTS_SECTION_ATSC_EIT", "16"),
    ("(gint) GST_MPEGTS_SECTION_ATSC_ETT", "15"),
    ("(gint) GST_MPEGTS_SECTION_ATSC_MGT", "14"),
    ("(gint) GST_MPEGTS_SECTION_ATSC_RRT", "18"),
    ("(gint) GST_MPEGTS_SECTION_ATSC_STT", "17"),
    ("(gint) GST_MPEGTS_SECTION_ATSC_TVCT", "12"),
    ("(gint) GST_MPEGTS_SECTION_BAT", "7"),
    ("(gint) GST_MPEGTS_SECTION_CAT", "3"),
    ("(gint) GST_MPEGTS_SECTION_EIT", "5"),
    ("(gint) GST_MPEGTS_SECTION_NIT", "6"),
    ("(gint) GST_MPEGTS_SECTION_PAT", "1"),
    ("(gint) GST_MPEGTS_SECTION_PMT", "2"),
    ("(gint) GST_MPEGTS_SECTION_SCTE_SIT", "19"),
    ("(gint) GST_MPEGTS_SECTION_SDT", "8"),
    ("(gint) GST_MPEGTS_SECTION_SIT", "11"),
    ("(gint) GST_MPEGTS_SECTION_TDT", "9"),
    ("(gint) GST_MPEGTS_SECTION_TOT", "10"),
    ("(gint) GST_MPEGTS_SECTION_TSDT", "4"),
    ("(gint) GST_MPEGTS_SECTION_UNKNOWN", "0"),
    ("(gint) GST_MPEGTS_STREAM_CONTENT_AAC", "6"),
    ("(gint) GST_MPEGTS_STREAM_CONTENT_AC_3", "4"),
    ("(gint) GST_MPEGTS_STREAM_CONTENT_AVC", "5"),
    ("(gint) GST_MPEGTS_STREAM_CONTENT_DTS", "7"),
    ("(gint) GST_MPEGTS_STREAM_CONTENT_MPEG1_LAYER2_AUDIO", "2"),
    ("(gint) GST_MPEGTS_STREAM_CONTENT_MPEG2_VIDEO", "1"),
    ("(gint) GST_MPEGTS_STREAM_CONTENT_SRM_CPCM", "8"),
    ("(gint) GST_MPEGTS_STREAM_CONTENT_TELETEXT_OR_SUBTITLE", "3"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_ATSC_AUDIO_AC3", "129"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_ATSC_AUDIO_DTS_HD", "136"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_ATSC_AUDIO_EAC3", "135"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_ATSC_DCII_VIDEO", "128"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_ATSC_ISOCH_DATA", "131"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_ATSC_SIT", "134"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_ATSC_SUBTITLING", "130"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_AUDIO_AAC_ADTS", "15"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_AUDIO_AAC_CLEAN", "28"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_AUDIO_AAC_LATM", "17"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_AUDIO_MPEG1", "3"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_AUDIO_MPEG2", "4"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_AUXILIARY", "14"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_DSMCC_A", "10"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_DSMCC_B", "11"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_DSMCC_C", "12"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_DSMCC_D", "13"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_DSM_CC", "8"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_HDMV_AUDIO_AC3", "129"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_HDMV_AUDIO_AC3_PLUS", "132"),
    (
        "(gint) GST_MPEGTS_STREAM_TYPE_HDMV_AUDIO_AC3_PLUS_SECONDARY",
        "161",
    ),
    (
        "(gint) GST_MPEGTS_STREAM_TYPE_HDMV_AUDIO_AC3_TRUE_HD",
        "131",
    ),
    ("(gint) GST_MPEGTS_STREAM_TYPE_HDMV_AUDIO_DTS", "130"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_HDMV_AUDIO_DTS_HD", "133"),
    (
        "(gint) GST_MPEGTS_STREAM_TYPE_HDMV_AUDIO_DTS_HD_MASTER_AUDIO",
        "134",
    ),
    (
        "(gint) GST_MPEGTS_STREAM_TYPE_HDMV_AUDIO_DTS_HD_SECONDARY",
        "162",
    ),
    ("(gint) GST_MPEGTS_STREAM_TYPE_HDMV_AUDIO_EAC3", "135"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_HDMV_AUDIO_LPCM", "128"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_HDMV_IGS", "145"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_HDMV_SUBPICTURE_PGS", "144"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_HDMV_SUBTITLE", "146"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_H_222_1", "9"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_IPMP_STREAM", "127"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_METADATA_DATA_CAROUSEL", "23"),
    (
        "(gint) GST_MPEGTS_STREAM_TYPE_METADATA_OBJECT_CAROUSEL",
        "24",
    ),
    ("(gint) GST_MPEGTS_STREAM_TYPE_METADATA_PES_PACKETS", "21"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_METADATA_SECTIONS", "22"),
    (
        "(gint) GST_MPEGTS_STREAM_TYPE_METADATA_SYNCHRONIZED_DOWNLOAD",
        "25",
    ),
    ("(gint) GST_MPEGTS_STREAM_TYPE_MHEG", "7"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_MPEG2_IPMP", "26"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_MPEG4_TIMED_TEXT", "29"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_PRIVATE_PES_PACKETS", "6"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_PRIVATE_SECTIONS", "5"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_RESERVED_00", "0"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_SCTE_ASYNC_DATA", "195"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_SCTE_DSMCC_DCB", "176"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_SCTE_DST_NRT", "149"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_SCTE_ISOCH_DATA", "131"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_SCTE_SIGNALING", "192"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_SCTE_SIT", "134"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_SCTE_SUBTITLING", "130"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_SCTE_SYNC_DATA", "194"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_SL_FLEXMUX_PES_PACKETS", "18"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_SL_FLEXMUX_SECTIONS", "19"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_SYNCHRONIZED_DOWNLOAD", "20"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_USER_PRIVATE_EA", "234"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_VIDEO_H264", "27"),
    (
        "(gint) GST_MPEGTS_STREAM_TYPE_VIDEO_H264_MVC_SUB_BITSTREAM",
        "32",
    ),
    (
        "(gint) GST_MPEGTS_STREAM_TYPE_VIDEO_H264_STEREO_ADDITIONAL_VIEW",
        "35",
    ),
    (
        "(gint) GST_MPEGTS_STREAM_TYPE_VIDEO_H264_SVC_SUB_BITSTREAM",
        "31",
    ),
    ("(gint) GST_MPEGTS_STREAM_TYPE_VIDEO_HEVC", "36"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_VIDEO_JP2K", "33"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_VIDEO_JPEG_XS", "50"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_VIDEO_MPEG1", "1"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_VIDEO_MPEG2", "2"),
    (
        "(gint) GST_MPEGTS_STREAM_TYPE_VIDEO_MPEG2_STEREO_ADDITIONAL_VIEW",
        "34",
    ),
    ("(gint) GST_MPEGTS_STREAM_TYPE_VIDEO_MPEG4", "16"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_VIDEO_RVC", "30"),
    ("(gint) GST_MPEGTS_STREAM_TYPE_VIDEO_VVC", "51"),
    ("(gint) GST_MPEGTS_TRANSMISSION_MODE_16K", "5"),
    ("(gint) GST_MPEGTS_TRANSMISSION_MODE_1K", "4"),
    ("(gint) GST_MPEGTS_TRANSMISSION_MODE_2K", "0"),
    ("(gint) GST_MPEGTS_TRANSMISSION_MODE_32K", "6"),
    ("(gint) GST_MPEGTS_TRANSMISSION_MODE_4K", "3"),
    ("(gint) GST_MPEGTS_TRANSMISSION_MODE_8K", "1"),
    ("(gint) GST_MPEGTS_TRANSMISSION_MODE_AUTO", "2"),
    ("(gint) GST_MPEGTS_TRANSMISSION_MODE_C1", "7"),
    ("(gint) GST_MPEGTS_TRANSMISSION_MODE_C3780", "8"),
    ("(gint) GST_MTS_DESC_ATSC_AC3", "129"),
    ("(gint) GST_MTS_DESC_ATSC_CAPTION_SERVICE", "134"),
    ("(gint) GST_MTS_DESC_ATSC_COMPONENT_NAME", "163"),
    ("(gint) GST_MTS_DESC_ATSC_CONTENT_ADVISORY", "135"),
    ("(gint) GST_MTS_DESC_ATSC_CRC32", "181"),
    ("(gint) GST_MTS_DESC_ATSC_DATA_SERVICE", "164"),
    ("(gint) GST_MTS_DESC_ATSC_DCC_ARRIVING_REQUEST", "169"),
    ("(gint) GST_MTS_DESC_ATSC_DCC_DEPARTING_REQUEST", "168"),
    ("(gint) GST_MTS_DESC_ATSC_DOWNLOAD_DESCRIPTOR", "166"),
    ("(gint) GST_MTS_DESC_ATSC_EAC3", "204"),
    ("(gint) GST_MTS_DESC_ATSC_ENHANCED_SIGNALING", "178"),
    ("(gint) GST_MTS_DESC_ATSC_EXTENDED_CHANNEL_NAME", "160"),
    ("(gint) GST_MTS_DESC_ATSC_GENRE", "171"),
    ("(gint) GST_MTS_DESC_ATSC_GROUP_LINK", "184"),
    ("(gint) GST_MTS_DESC_ATSC_MODULE_LINK", "180"),
    (
        "(gint) GST_MTS_DESC_ATSC_MULTIPROTOCOL_ENCAPSULATION",
        "167",
    ),
    ("(gint) GST_MTS_DESC_ATSC_PID_COUNT", "165"),
    ("(gint) GST_MTS_DESC_ATSC_PRIVATE_INFORMATION", "173"),
    ("(gint) GST_MTS_DESC_ATSC_REDISTRIBUTION_CONTROL", "170"),
    ("(gint) GST_MTS_DESC_ATSC_SERVICE_LOCATION", "161"),
    ("(gint) GST_MTS_DESC_ATSC_STUFFING", "128"),
    ("(gint) GST_MTS_DESC_ATSC_TIME_SHIFTED_SERVICE", "162"),
    ("(gint) GST_MTS_DESC_AUDIO_STREAM", "3"),
    ("(gint) GST_MTS_DESC_AUXILIARY_VIDEO_STREAM", "47"),
    ("(gint) GST_MTS_DESC_AVC_TIMING_AND_HRD", "42"),
    ("(gint) GST_MTS_DESC_AVC_VIDEO", "40"),
    ("(gint) GST_MTS_DESC_CA", "9"),
    ("(gint) GST_MTS_DESC_CONTENT_LABELING", "36"),
    ("(gint) GST_MTS_DESC_COPYRIGHT", "13"),
    ("(gint) GST_MTS_DESC_DATA_STREAM_ALIGNMENT", "6"),
    ("(gint) GST_MTS_DESC_DSMCC_ASSOCIATION_TAG", "20"),
    ("(gint) GST_MTS_DESC_DSMCC_CAROUSEL_IDENTIFIER", "19"),
    ("(gint) GST_MTS_DESC_DSMCC_DEFERRED_ASSOCIATION_TAG", "21"),
    ("(gint) GST_MTS_DESC_DSMCC_NPT_ENDPOINT", "24"),
    ("(gint) GST_MTS_DESC_DSMCC_NPT_REFERENCE", "23"),
    ("(gint) GST_MTS_DESC_DSMCC_STREAM_EVENT", "26"),
    ("(gint) GST_MTS_DESC_DSMCC_STREAM_MODE", "25"),
    ("(gint) GST_MTS_DESC_DTG_LOGICAL_CHANNEL", "131"),
    ("(gint) GST_MTS_DESC_DVB_AAC", "124"),
    ("(gint) GST_MTS_DESC_DVB_AC3", "106"),
    ("(gint) GST_MTS_DESC_DVB_ADAPTATION_FIELD_DATA", "112"),
    ("(gint) GST_MTS_DESC_DVB_ANCILLARY_DATA", "107"),
    ("(gint) GST_MTS_DESC_DVB_ANNOUNCEMENT_SUPPORT", "110"),
    ("(gint) GST_MTS_DESC_DVB_APPLICATION_SIGNALLING", "111"),
    ("(gint) GST_MTS_DESC_DVB_BOUQUET_NAME", "71"),
    ("(gint) GST_MTS_DESC_DVB_CABLE_DELIVERY_SYSTEM", "68"),
    ("(gint) GST_MTS_DESC_DVB_CA_IDENTIFIER", "83"),
    ("(gint) GST_MTS_DESC_DVB_CELL_FREQUENCY_LINK", "109"),
    ("(gint) GST_MTS_DESC_DVB_CELL_LIST", "108"),
    ("(gint) GST_MTS_DESC_DVB_COMPONENT", "80"),
    ("(gint) GST_MTS_DESC_DVB_CONTENT", "84"),
    ("(gint) GST_MTS_DESC_DVB_CONTENT_IDENTIFIER", "118"),
    ("(gint) GST_MTS_DESC_DVB_COUNTRY_AVAILABILITY", "73"),
    ("(gint) GST_MTS_DESC_DVB_DATA_BROADCAST", "100"),
    ("(gint) GST_MTS_DESC_DVB_DATA_BROADCAST_ID", "102"),
    ("(gint) GST_MTS_DESC_DVB_DEFAULT_AUTHORITY", "115"),
    ("(gint) GST_MTS_DESC_DVB_DSNG", "104"),
    ("(gint) GST_MTS_DESC_DVB_DTS", "123"),
    ("(gint) GST_MTS_DESC_DVB_ECM_REPETITION_RATE", "120"),
    ("(gint) GST_MTS_DESC_DVB_ENHANCED_AC3", "122"),
    ("(gint) GST_MTS_DESC_DVB_EXTENDED_EVENT", "78"),
    ("(gint) GST_MTS_DESC_DVB_EXTENSION", "127"),
    ("(gint) GST_MTS_DESC_DVB_FREQUENCY_LIST", "98"),
    ("(gint) GST_MTS_DESC_DVB_FTA_CONTENT_MANAGEMENT", "126"),
    ("(gint) GST_MTS_DESC_DVB_LINKAGE", "74"),
    ("(gint) GST_MTS_DESC_DVB_LOCAL_TIME_OFFSET", "88"),
    ("(gint) GST_MTS_DESC_DVB_MOSAIC", "81"),
    ("(gint) GST_MTS_DESC_DVB_MULTILINGUAL_BOUQUET_NAME", "92"),
    ("(gint) GST_MTS_DESC_DVB_MULTILINGUAL_COMPONENT", "94"),
    ("(gint) GST_MTS_DESC_DVB_MULTILINGUAL_NETWORK_NAME", "91"),
    ("(gint) GST_MTS_DESC_DVB_MULTILINGUAL_SERVICE_NAME", "93"),
    ("(gint) GST_MTS_DESC_DVB_NETWORK_NAME", "64"),
    ("(gint) GST_MTS_DESC_DVB_NVOD_REFERENCE", "75"),
    ("(gint) GST_MTS_DESC_DVB_PARENTAL_RATING", "85"),
    ("(gint) GST_MTS_DESC_DVB_PARTIAL_TRANSPORT_STREAM", "99"),
    ("(gint) GST_MTS_DESC_DVB_PDC", "105"),
    ("(gint) GST_MTS_DESC_DVB_PRIVATE_DATA_SPECIFIER", "95"),
    ("(gint) GST_MTS_DESC_DVB_RELATED_CONTENT", "116"),
    (
        "(gint) GST_MTS_DESC_DVB_S2_SATELLITE_DELIVERY_SYSTEM",
        "121",
    ),
    ("(gint) GST_MTS_DESC_DVB_SATELLITE_DELIVERY_SYSTEM", "67"),
    ("(gint) GST_MTS_DESC_DVB_SCRAMBLING", "101"),
    ("(gint) GST_MTS_DESC_DVB_SERVICE", "72"),
    ("(gint) GST_MTS_DESC_DVB_SERVICE_AVAILABILITY", "114"),
    ("(gint) GST_MTS_DESC_DVB_SERVICE_IDENTIFIER", "113"),
    ("(gint) GST_MTS_DESC_DVB_SERVICE_LIST", "65"),
    ("(gint) GST_MTS_DESC_DVB_SERVICE_MOVE", "96"),
    ("(gint) GST_MTS_DESC_DVB_SHORT_EVENT", "77"),
    ("(gint) GST_MTS_DESC_DVB_SHORT_SMOOTHING_BUFFER", "97"),
    ("(gint) GST_MTS_DESC_DVB_STREAM_IDENTIFIER", "82"),
    ("(gint) GST_MTS_DESC_DVB_STUFFING", "66"),
    ("(gint) GST_MTS_DESC_DVB_SUBTITLING", "89"),
    ("(gint) GST_MTS_DESC_DVB_TELEPHONE", "87"),
    ("(gint) GST_MTS_DESC_DVB_TELETEXT", "86"),
    ("(gint) GST_MTS_DESC_DVB_TERRESTRIAL_DELIVERY_SYSTEM", "90"),
    ("(gint) GST_MTS_DESC_DVB_TIMESLICE_FEC_IDENTIFIER", "119"),
    ("(gint) GST_MTS_DESC_DVB_TIME_SHIFTED_EVENT", "79"),
    ("(gint) GST_MTS_DESC_DVB_TIME_SHIFTED_SERVICE", "76"),
    ("(gint) GST_MTS_DESC_DVB_TRANSPORT_STREAM", "103"),
    ("(gint) GST_MTS_DESC_DVB_TVA_ID", "117"),
    ("(gint) GST_MTS_DESC_DVB_VBI_DATA", "69"),
    ("(gint) GST_MTS_DESC_DVB_VBI_TELETEXT", "70"),
    ("(gint) GST_MTS_DESC_DVB_XAIT_LOCATION", "125"),
    ("(gint) GST_MTS_DESC_EXTENSION", "63"),
    ("(gint) GST_MTS_DESC_EXTERNAL_ES_ID", "32"),
    ("(gint) GST_MTS_DESC_EXT_DVB_AC4", "21"),
    ("(gint) GST_MTS_DESC_EXT_DVB_AUDIO_PRESELECTION", "25"),
    ("(gint) GST_MTS_DESC_EXT_DVB_C2_DELIVERY_SYSTEM", "13"),
    ("(gint) GST_MTS_DESC_EXT_DVB_CP", "2"),
    ("(gint) GST_MTS_DESC_EXT_DVB_CPCM_DELIVERY_SIGNALLING", "1"),
    ("(gint) GST_MTS_DESC_EXT_DVB_CP_IDENTIFIER", "3"),
    ("(gint) GST_MTS_DESC_EXT_DVB_DTS_HD_AUDIO_STREAM", "14"),
    ("(gint) GST_MTS_DESC_EXT_DVB_DTS_NEUTRAL", "15"),
    ("(gint) GST_MTS_DESC_EXT_DVB_IMAGE_ICON", "0"),
    ("(gint) GST_MTS_DESC_EXT_DVB_MESSAGE", "8"),
    ("(gint) GST_MTS_DESC_EXT_DVB_NETWORK_CHANGE_NOTIFY", "7"),
    ("(gint) GST_MTS_DESC_EXT_DVB_SERVICE_RELOCATED", "11"),
    ("(gint) GST_MTS_DESC_EXT_DVB_SH_DELIVERY_SYSTEM", "5"),
    ("(gint) GST_MTS_DESC_EXT_DVB_SUPPLEMENTARY_AUDIO", "6"),
    ("(gint) GST_MTS_DESC_EXT_DVB_T2MI", "17"),
    ("(gint) GST_MTS_DESC_EXT_DVB_T2_DELIVERY_SYSTEM", "4"),
    ("(gint) GST_MTS_DESC_EXT_DVB_TARGET_REGION", "9"),
    ("(gint) GST_MTS_DESC_EXT_DVB_TARGET_REGION_NAME", "10"),
    ("(gint) GST_MTS_DESC_EXT_DVB_URI_LINKAGE", "19"),
    ("(gint) GST_MTS_DESC_EXT_DVB_VIDEO_DEPTH_RANGE", "16"),
    ("(gint) GST_MTS_DESC_EXT_DVB_XAIT_PID", "12"),
    ("(gint) GST_MTS_DESC_EXT_JXS_VIDEO", "20"),
    ("(gint) GST_MTS_DESC_FLEX_MUX_TIMING", "44"),
    ("(gint) GST_MTS_DESC_FMC", "31"),
    ("(gint) GST_MTS_DESC_FMX_BUFFER_SIZE", "34"),
    ("(gint) GST_MTS_DESC_HIERARCHY", "4"),
    ("(gint) GST_MTS_DESC_IBP", "18"),
    ("(gint) GST_MTS_DESC_IOD", "29"),
    ("(gint) GST_MTS_DESC_IPMP", "41"),
    ("(gint) GST_MTS_DESC_ISDB_AUDIO_COMPONENT", "196"),
    ("(gint) GST_MTS_DESC_ISDB_BASIC_LOCAL_EVENT", "208"),
    ("(gint) GST_MTS_DESC_ISDB_BOARD_INFORMATION", "219"),
    ("(gint) GST_MTS_DESC_ISDB_BROADCASTER_NAME", "216"),
    ("(gint) GST_MTS_DESC_ISDB_CA_CONTRACT_INFORMATION", "203"),
    ("(gint) GST_MTS_DESC_ISDB_CA_EMM_TS", "202"),
    ("(gint) GST_MTS_DESC_ISDB_CA_SERVICE", "204"),
    ("(gint) GST_MTS_DESC_ISDB_COMPONENT_GROUP", "217"),
    ("(gint) GST_MTS_DESC_ISDB_CONNECTED_TRANSMISSION", "221"),
    ("(gint) GST_MTS_DESC_ISDB_CONTENT_AVAILABILITY", "222"),
    ("(gint) GST_MTS_DESC_ISDB_DATA_CONTENT", "199"),
    ("(gint) GST_MTS_DESC_ISDB_DIGITAL_COPY_CONTROL", "193"),
    ("(gint) GST_MTS_DESC_ISDB_DOWNLOAD_CONTENT", "201"),
    ("(gint) GST_MTS_DESC_ISDB_EVENT_GROUP", "214"),
    ("(gint) GST_MTS_DESC_ISDB_EXTENDED_BROADCASTER", "206"),
    ("(gint) GST_MTS_DESC_ISDB_HIERARCHICAL_TRANSMISSION", "192"),
    ("(gint) GST_MTS_DESC_ISDB_HYPERLINK", "197"),
    ("(gint) GST_MTS_DESC_ISDB_LDT_LINKAGE", "220"),
    ("(gint) GST_MTS_DESC_ISDB_LOGO_TRANSMISSION", "207"),
    ("(gint) GST_MTS_DESC_ISDB_NETWORK_IDENTIFICATION", "194"),
    ("(gint) GST_MTS_DESC_ISDB_NODE_RELATION", "210"),
    ("(gint) GST_MTS_DESC_ISDB_PARTIAL_TS_TIME", "195"),
    ("(gint) GST_MTS_DESC_ISDB_REFERENCE", "209"),
    ("(gint) GST_MTS_DESC_ISDB_SERIES", "213"),
    ("(gint) GST_MTS_DESC_ISDB_SERVICE_GROUP", "224"),
    ("(gint) GST_MTS_DESC_ISDB_SHORT_NODE_INFORMATION", "211"),
    ("(gint) GST_MTS_DESC_ISDB_SI_PARAMETER", "215"),
    ("(gint) GST_MTS_DESC_ISDB_SI_PRIME_TS", "218"),
    ("(gint) GST_MTS_DESC_ISDB_STC_REFERENCE", "212"),
    ("(gint) GST_MTS_DESC_ISDB_TARGET_REGION", "198"),
    ("(gint) GST_MTS_DESC_ISDB_TS_INFORMATION", "205"),
    ("(gint) GST_MTS_DESC_ISDB_VIDEO_DECODE_CONTROL", "200"),
    ("(gint) GST_MTS_DESC_ISO_639_LANGUAGE", "10"),
    ("(gint) GST_MTS_DESC_J2K_VIDEO", "50"),
    ("(gint) GST_MTS_DESC_MAXIMUM_BITRATE", "14"),
    ("(gint) GST_MTS_DESC_METADATA", "38"),
    ("(gint) GST_MTS_DESC_METADATA_POINTER", "37"),
    ("(gint) GST_MTS_DESC_METADATA_STD", "39"),
    ("(gint) GST_MTS_DESC_MPEG2_AAC_AUDIO", "43"),
    ("(gint) GST_MTS_DESC_MPEG2_STEREOSCOPIC_VIDEO_FORMAT", "52"),
    ("(gint) GST_MTS_DESC_MPEG4_AUDIO", "28"),
    ("(gint) GST_MTS_DESC_MPEG4_AUDIO_EXTENSION", "46"),
    ("(gint) GST_MTS_DESC_MPEG4_TEXT", "45"),
    ("(gint) GST_MTS_DESC_MPEG4_VIDEO", "27"),
    ("(gint) GST_MTS_DESC_MULTIPLEX_BUFFER", "35"),
    ("(gint) GST_MTS_DESC_MULTIPLEX_BUFFER_UTILISATION", "12"),
    ("(gint) GST_MTS_DESC_MUX_CODE", "33"),
    ("(gint) GST_MTS_DESC_MVC_EXTENSION", "49"),
    ("(gint) GST_MTS_DESC_MVC_OPERATION_POINT", "51"),
    ("(gint) GST_MTS_DESC_PRIVATE_DATA_INDICATOR", "15"),
    ("(gint) GST_MTS_DESC_REGISTRATION", "5"),
    ("(gint) GST_MTS_DESC_RESERVED_00", "0"),
    ("(gint) GST_MTS_DESC_RESERVED_01", "1"),
    ("(gint) GST_MTS_DESC_SCTE_AC3", "129"),
    ("(gint) GST_MTS_DESC_SCTE_COMPONENT_NAME", "132"),
    ("(gint) GST_MTS_DESC_SCTE_EXTENDED_VIDEO", "131"),
    ("(gint) GST_MTS_DESC_SCTE_FRAME_RATE", "130"),
    ("(gint) GST_MTS_DESC_SCTE_FREQUENCY_SPEC", "144"),
    ("(gint) GST_MTS_DESC_SCTE_MODULATION_PARAMS", "145"),
    ("(gint) GST_MTS_DESC_SCTE_STUFFING", "128"),
    ("(gint) GST_MTS_DESC_SCTE_TRANSPORT_STREAM_ID", "146"),
    ("(gint) GST_MTS_DESC_SL", "30"),
    ("(gint) GST_MTS_DESC_SMOOTHING_BUFFER", "16"),
    ("(gint) GST_MTS_DESC_STD", "17"),
    ("(gint) GST_MTS_DESC_STEREOSCOPIC_PROGRAM_INFO", "53"),
    ("(gint) GST_MTS_DESC_STEREOSCOPIC_VIDEO_INFO", "54"),
    ("(gint) GST_MTS_DESC_SVC_EXTENSION", "48"),
    ("(gint) GST_MTS_DESC_SYSTEM_CLOCK", "11"),
    ("(gint) GST_MTS_DESC_TARGET_BACKGROUND_GRID", "7"),
    ("(gint) GST_MTS_DESC_VIDEO_STREAM", "2"),
    ("(gint) GST_MTS_DESC_VIDEO_WINDOW", "8"),
    ("(guint) GST_MTS_REGISTRATION_0", "0"),
    ("(guint) GST_MTS_REGISTRATION_AC_3", "1094921523"),
    ("(guint) GST_MTS_REGISTRATION_AC_4", "1094921524"),
    ("(guint) GST_MTS_REGISTRATION_BSSD", "1112757060"),
    ("(guint) GST_MTS_REGISTRATION_CUEI", "1129661769"),
    ("(guint) GST_MTS_REGISTRATION_DTS1", "1146377009"),
    ("(guint) GST_MTS_REGISTRATION_DTS2", "1146377010"),
    ("(guint) GST_MTS_REGISTRATION_DTS3", "1146377011"),
    ("(guint) GST_MTS_REGISTRATION_EAC3", "1161904947"),
    ("(guint) GST_MTS_REGISTRATION_ETV1", "1163154993"),
    ("(guint) GST_MTS_REGISTRATION_GA94", "1195456820"),
    ("(guint) GST_MTS_REGISTRATION_HDMV", "1212435798"),
    ("(guint) GST_MTS_REGISTRATION_KLVA", "1263294017"),
    ("(guint) GST_MTS_REGISTRATION_OPUS", "1330664787"),
    ("(guint) GST_MTS_REGISTRATION_OTHER_HEVC", "1212503619"),
    ("(guint) GST_MTS_REGISTRATION_TSHV", "1414744150"),
    ("(guint) GST_MTS_REGISTRATION_VC_1", "1447243057"),
    ("(guint) GST_MTS_REGISTRATION_drac", "1685217635"),
    ("(gint) GST_MTS_SCTE_DESC_AUDIO", "4"),
    ("(gint) GST_MTS_SCTE_DESC_AVAIL", "0"),
    ("(gint) GST_MTS_SCTE_DESC_DTMF", "1"),
    ("(gint) GST_MTS_SCTE_DESC_SEGMENTATION", "2"),
    ("(gint) GST_MTS_SCTE_DESC_TIME", "3"),
    ("(gint) GST_MTS_SCTE_SPLICE_COMMAND_BANDWIDTH", "7"),
    ("(gint) GST_MTS_SCTE_SPLICE_COMMAND_INSERT", "5"),
    ("(gint) GST_MTS_SCTE_SPLICE_COMMAND_NULL", "0"),
    ("(gint) GST_MTS_SCTE_SPLICE_COMMAND_PRIVATE", "255"),
    ("(gint) GST_MTS_SCTE_SPLICE_COMMAND_SCHEDULE", "4"),
    ("(gint) GST_MTS_SCTE_SPLICE_COMMAND_TIME", "6"),
    ("(gint) GST_MTS_TABLE_ID_14496_OBJET_DESCRIPTOR", "5"),
    ("(gint) GST_MTS_TABLE_ID_14496_SCENE_DESCRIPTION", "4"),
    ("(gint) GST_MTS_TABLE_ID_14496_SECTION", "8"),
    ("(gint) GST_MTS_TABLE_ID_23001_10_SECTION", "10"),
    ("(gint) GST_MTS_TABLE_ID_23001_11_SECTION", "9"),
    (
        "(gint) GST_MTS_TABLE_ID_APPLICATION_INFORMATION_TABLE",
        "116",
    ),
    ("(gint) GST_MTS_TABLE_ID_ATSC_AGGREGATE_DATA_EVENT", "217"),
    (
        "(gint) GST_MTS_TABLE_ID_ATSC_AGGREGATE_EVENT_INFORMATION",
        "214",
    ),
    (
        "(gint) GST_MTS_TABLE_ID_ATSC_AGGREGATE_EXTENDED_TEXT",
        "215",
    ),
    ("(gint) GST_MTS_TABLE_ID_ATSC_CABLE_VIRTUAL_CHANNEL", "201"),
    (
        "(gint) GST_MTS_TABLE_ID_ATSC_CHANNEL_OR_EVENT_EXTENDED_TEXT",
        "204",
    ),
    ("(gint) GST_MTS_TABLE_ID_ATSC_DATA_EVENT", "206"),
    ("(gint) GST_MTS_TABLE_ID_ATSC_DATA_SERVICE", "207"),
    (
        "(gint) GST_MTS_TABLE_ID_ATSC_DIRECTED_CHANNEL_CHANGE",
        "211",
    ),
    (
        "(gint) GST_MTS_TABLE_ID_ATSC_DIRECTED_CHANNEL_CHANGE_SECTION_CODE",
        "212",
    ),
    ("(gint) GST_MTS_TABLE_ID_ATSC_EVENT_INFORMATION", "203"),
    ("(gint) GST_MTS_TABLE_ID_ATSC_LONG_TERM_SERVICE", "210"),
    ("(gint) GST_MTS_TABLE_ID_ATSC_MASTER_GUIDE", "199"),
    ("(gint) GST_MTS_TABLE_ID_ATSC_NETWORK_RESOURCE", "209"),
    ("(gint) GST_MTS_TABLE_ID_ATSC_PROGRAM_IDENTIFIER", "208"),
    ("(gint) GST_MTS_TABLE_ID_ATSC_RATING_REGION", "202"),
    (
        "(gint) GST_MTS_TABLE_ID_ATSC_SATELLITE_VIRTUAL_CHANNEL",
        "218",
    ),
    ("(gint) GST_MTS_TABLE_ID_ATSC_SYSTEM_TIME", "205"),
    (
        "(gint) GST_MTS_TABLE_ID_ATSC_TERRESTRIAL_VIRTUAL_CHANNEL",
        "200",
    ),
    ("(gint) GST_MTS_TABLE_ID_BOUQUET_ASSOCIATION", "74"),
    ("(gint) GST_MTS_TABLE_ID_CA_MESSAGE_ECM_0", "128"),
    ("(gint) GST_MTS_TABLE_ID_CA_MESSAGE_ECM_1", "129"),
    ("(gint) GST_MTS_TABLE_ID_CA_MESSAGE_SYSTEM_PRIVATE_1", "130"),
    ("(gint) GST_MTS_TABLE_ID_CA_MESSAGE_SYSTEM_PRIVATE_N", "143"),
    ("(gint) GST_MTS_TABLE_ID_CMT", "164"),
    ("(gint) GST_MTS_TABLE_ID_CONDITIONAL_ACCESS", "1"),
    ("(gint) GST_MTS_TABLE_ID_CONTAINER", "117"),
    ("(gint) GST_MTS_TABLE_ID_CONTENT_IDENTIFIER", "119"),
    ("(gint) GST_MTS_TABLE_ID_DISCONTINUITY_INFORMATION", "126"),
    ("(gint) GST_MTS_TABLE_ID_DOWNLOADABLE_FONT_INFO", "76"),
    ("(gint) GST_MTS_TABLE_ID_DSM_CC_ADDRESSABLE_SECTIONS", "63"),
    (
        "(gint) GST_MTS_TABLE_ID_DSM_CC_DOWNLOAD_DATA_MESSAGES",
        "60",
    ),
    (
        "(gint) GST_MTS_TABLE_ID_DSM_CC_MULTIPROTO_ENCAPSULATED_DATA",
        "58",
    ),
    ("(gint) GST_MTS_TABLE_ID_DSM_CC_PRIVATE_DATA", "62"),
    ("(gint) GST_MTS_TABLE_ID_DSM_CC_STREAM_DESCRIPTORS", "61"),
    ("(gint) GST_MTS_TABLE_ID_DSM_CC_U_N_MESSAGES", "59"),
    (
        "(gint) GST_MTS_TABLE_ID_EVENT_INFORMATION_ACTUAL_TS_PRESENT",
        "78",
    ),
    (
        "(gint) GST_MTS_TABLE_ID_EVENT_INFORMATION_ACTUAL_TS_SCHEDULE_1",
        "80",
    ),
    (
        "(gint) GST_MTS_TABLE_ID_EVENT_INFORMATION_ACTUAL_TS_SCHEDULE_N",
        "95",
    ),
    (
        "(gint) GST_MTS_TABLE_ID_EVENT_INFORMATION_OTHER_TS_PRESENT",
        "79",
    ),
    (
        "(gint) GST_MTS_TABLE_ID_EVENT_INFORMATION_OTHER_TS_SCHEDULE_1",
        "96",
    ),
    (
        "(gint) GST_MTS_TABLE_ID_EVENT_INFORMATION_OTHER_TS_SCHEDULE_N",
        "111",
    ),
    ("(gint) GST_MTS_TABLE_ID_FCT", "161"),
    ("(gint) GST_MTS_TABLE_ID_IPMP_CONTROL_INFORMATION", "7"),
    ("(gint) GST_MTS_TABLE_ID_LL_FEC_PARITY_DATA_TABLE", "177"),
    ("(gint) GST_MTS_TABLE_ID_METADATA", "6"),
    ("(gint) GST_MTS_TABLE_ID_MPE_FEC", "120"),
    ("(gint) GST_MTS_TABLE_ID_MPE_IFEC", "122"),
    (
        "(gint) GST_MTS_TABLE_ID_NETWORK_INFORMATION_ACTUAL_NETWORK",
        "64",
    ),
    (
        "(gint) GST_MTS_TABLE_ID_NETWORK_INFORMATION_OTHER_NETWORK",
        "65",
    ),
    ("(gint) GST_MTS_TABLE_ID_PCR_PACKET_PAYLOAD", "166"),
    ("(gint) GST_MTS_TABLE_ID_PROGRAM_ASSOCIATION", "0"),
    ("(gint) GST_MTS_TABLE_ID_PROTECTION_MESSAGE", "123"),
    ("(gint) GST_MTS_TABLE_ID_RELATED_CONTENT", "118"),
    ("(gint) GST_MTS_TABLE_ID_RESOLUTION_NOTIFICATION", "121"),
    ("(gint) GST_MTS_TABLE_ID_RUNNING_STATUS", "113"),
    ("(gint) GST_MTS_TABLE_ID_SCT", "160"),
    ("(gint) GST_MTS_TABLE_ID_SCTE_DDB", "228"),
    ("(gint) GST_MTS_TABLE_ID_SCTE_DII", "227"),
    ("(gint) GST_MTS_TABLE_ID_SCTE_EAS", "216"),
    ("(gint) GST_MTS_TABLE_ID_SCTE_EBIF", "224"),
    ("(gint) GST_MTS_TABLE_ID_SCTE_EISS", "226"),
    ("(gint) GST_MTS_TABLE_ID_SCTE_RESERVED", "225"),
    ("(gint) GST_MTS_TABLE_ID_SCTE_SPLICE", "252"),
    ("(gint) GST_MTS_TABLE_ID_SELECTION_INFORMATION", "127"),
    (
        "(gint) GST_MTS_TABLE_ID_SERVICE_DESCRIPTION_ACTUAL_TS",
        "66",
    ),
    ("(gint) GST_MTS_TABLE_ID_SERVICE_DESCRIPTION_OTHER_TS", "70"),
    ("(gint) GST_MTS_TABLE_ID_SPT", "163"),
    ("(gint) GST_MTS_TABLE_ID_STUFFING", "114"),
    ("(gint) GST_MTS_TABLE_ID_TBTP", "165"),
    ("(gint) GST_MTS_TABLE_ID_TCT", "162"),
    ("(gint) GST_MTS_TABLE_ID_TIM", "176"),
    ("(gint) GST_MTS_TABLE_ID_TIME_DATE", "112"),
    ("(gint) GST_MTS_TABLE_ID_TIME_OFFSET", "115"),
    (
        "(gint) GST_MTS_TABLE_ID_TRANSMISSION_MODE_SUPPORT_PAYLOAD",
        "170",
    ),
    ("(gint) GST_MTS_TABLE_ID_TS_DESCRIPTION", "3"),
    ("(gint) GST_MTS_TABLE_ID_TS_PROGRAM_MAP", "2"),
    ("(gint) GST_MTS_TABLE_ID_UNSET", "255"),
    ("(gint) GST_MTS_TABLE_ID_UPDATE_NOTIFICATION", "75"),
    ("(gint) HEARING_IMPAIRED_PAGE", "5"),
    ("(gint) INITIAL_PAGE", "1"),
    ("(gint) PROGRAMME_SCHEDULE_PAGE", "4"),
    ("(gint) SUBTITLE_PAGE", "2"),
];
