
    static const char *IsAdlam()
    {
        return "[\\x1e900-\\x1e94b\\x1e950-\\x1e959\\x1e95e\\x1e95f]";
    }

    static const char *IsAhom()
    {
        return "[\\x11700-\\x1171a\\x1171d-\\x1172b\\x11730-\\x11746]";
    }

    static const char *IsAnatolian_Hieroglyphs()
    {
        return "[\\x14400-\\x14646]";
    }

    static const char *IsArabic()
    {
        return "[\\x600-\\x604\\x606-\\x60b\\x60d-\\x61a\\x61c-\\x61e"
            "\\x620-\\x63f\\x641-\\x64a\\x656-\\x66f\\x671-\\x6dc\\x6de-\\x6ff"
            "\\x750-\\x77f\\x870-\\x88e\\x890\\x891\\x898-\\x8e1\\x8e3-\\x8ff"
            "\\xfb50-\\xfbc2\\xfbd3-\\xfd3d\\xfd40-\\xfd8f\\xfd92-\\xfdc7"
            "\\xfdcf\\xfdf0-\\xfdff\\xfe70-\\xfe74\\xfe76-\\xfefc"
            "\\x10e60-\\x10e7e\\x1ee00-\\x1ee03\\x1ee05-\\x1ee1f"
            "\\x1ee21\\x1ee22\\x1ee24\\x1ee27\\x1ee29-\\x1ee32"
            "\\x1ee34-\\x1ee37\\x1ee39\\x1ee3b\\x1ee42\\x1ee47\\x1ee49\\x1ee4b"
            "\\x1ee4d-\\x1ee4f\\x1ee51\\x1ee52\\x1ee54\\x1ee57\\x1ee59\\x1ee5b"
            "\\x1ee5d\\x1ee5f\\x1ee61\\x1ee62\\x1ee64\\x1ee67-\\x1ee6a"
            "\\x1ee6c-\\x1ee72\\x1ee74-\\x1ee77\\x1ee79-\\x1ee7c\\x1ee7e"
            "\\x1ee80-\\x1ee89\\x1ee8b-\\x1ee9b\\x1eea1-\\x1eea3"
            "\\x1eea5-\\x1eea9\\x1eeab-\\x1eebb\\x1eef0\\x1eef1]";
    }

    static const char *IsArmenian()
    {
        return "[\\x531-\\x556\\x559-\\x58a\\x58d-\\x58f\\xfb13-\\xfb17]";
    }

    static const char *IsAvestan()
    {
        return "[\\x10b00-\\x10b35\\x10b39-\\x10b3f]";
    }

    static const char *IsBalinese()
    {
        return "[\\x1b00-\\x1b4c\\x1b50-\\x1b7e]";
    }

    static const char *IsBamum()
    {
        return "[\\xa6a0-\\xa6f7\\x16800-\\x16a38]";
    }

    static const char *IsBassa_Vah()
    {
        return "[\\x16ad0-\\x16aed\\x16af0-\\x16af5]";
    }

    static const char *IsBatak()
    {
        return "[\\x1bc0-\\x1bf3\\x1bfc-\\x1bff]";
    }

    static const char *IsBengali()
    {
        return "[\\x980-\\x983\\x985-\\x98c\\x98f\\x990\\x993-\\x9a8"
            "\\x9aa-\\x9b0\\x9b2\\x9b6-\\x9b9\\x9bc-\\x9c4\\x9c7\\x9c8"
            "\\x9cb-\\x9ce\\x9d7\\x9dc\\x9dd\\x9df-\\x9e3\\x9e6-\\x9fe]";
    }

    static const char *IsBhaiksuki()
    {
        return "[\\x11c00-\\x11c08\\x11c0a-\\x11c36\\x11c38-\\x11c45"
            "\\x11c50-\\x11c6c]";
    }

    static const char *IsBopomofo()
    {
        return "[\\x2ea\\x2eb\\x3105-\\x312f\\x31a0-\\x31bf]";
    }

    static const char *IsBrahmi()
    {
        return "[\\x11000-\\x1104d\\x11052-\\x11075\\x1107f]";
    }

    static const char *IsBraille()
    {
        return "[\\x2800-\\x28ff]";
    }

    static const char *IsBuginese()
    {
        return "[\\x1a00-\\x1a1b\\x1a1e\\x1a1f]";
    }

    static const char *IsBuhid()
    {
        return "[\\x1740-\\x1753]";
    }

    static const char *IsCanadian_Aboriginal()
    {
        return "[\\x1400-\\x167f\\x18b0-\\x18f5\\x11ab0-\\x11abf]";
    }

    static const char *IsCarian()
    {
        return "[\\x102a0-\\x102d0]";
    }

    static const char *IsCaucasian_Albanian()
    {
        return "[\\x10530-\\x10563\\x1056f]";
    }

    static const char *IsChakma()
    {
        return "[\\x11100-\\x11134\\x11136-\\x11147]";
    }

    static const char *IsCham()
    {
        return "[\\xaa00-\\xaa36\\xaa40-\\xaa4d\\xaa50-\\xaa59"
            "\\xaa5c-\\xaa5f]";
    }

    static const char *IsCherokee()
    {
        return "[\\x13a0-\\x13f5\\x13f8-\\x13fd\\xab70-\\xabbf]";
    }

    static const char *IsChorasmian()
    {
        return "[\\x10fb0-\\x10fcb]";
    }

    static const char *IsCommon()
    {
        return "[\\x0-\\x40\\x5b-\\x60\\x7b-\\xa9\\xab-\\xb9\\xbb-\\xbf\\xd7"
            "\\xf7\\x2b9-\\x2df\\x2e5-\\x2e9\\x2ec-\\x2ff\\x374\\x37e\\x385"
            "\\x387\\x605\\x60c\\x61b\\x61f\\x640\\x6dd\\x8e2\\x964\\x965\\xe3f"
            "\\xfd5-\\xfd8\\x10fb\\x16eb-\\x16ed\\x1735\\x1736\\x1802\\x1803"
            "\\x1805\\x1cd3\\x1ce1\\x1ce9-\\x1cec\\x1cee-\\x1cf3"
            "\\x1cf5-\\x1cf7\\x1cfa\\x2000-\\x200b\\x200e-\\x2064"
            "\\x2066-\\x2070\\x2074-\\x207e\\x2080-\\x208e\\x20a0-\\x20c0"
            "\\x2100-\\x2125\\x2127-\\x2129\\x212c-\\x2131\\x2133-\\x214d"
            "\\x214f-\\x215f\\x2189-\\x218b\\x2190-\\x2426\\x2440-\\x244a"
            "\\x2460-\\x27ff\\x2900-\\x2b73\\x2b76-\\x2b95\\x2b97-\\x2bff"
            "\\x2e00-\\x2e5d\\x2ff0-\\x2ffb\\x3000-\\x3004\\x3006"
            "\\x3008-\\x3020\\x3030-\\x3037\\x303c-\\x303f\\x309b\\x309c\\x30a0"
            "\\x30fb\\x30fc\\x3190-\\x319f\\x31c0-\\x31e3\\x3220-\\x325f"
            "\\x327f-\\x32cf\\x32ff\\x3358-\\x33ff\\x4dc0-\\x4dff"
            "\\xa700-\\xa721\\xa788-\\xa78a\\xa830-\\xa839\\xa92e\\xa9cf\\xab5b"
            "\\xab6a\\xab6b\\xfd3e\\xfd3f\\xfe10-\\xfe19\\xfe30-\\xfe52"
            "\\xfe54-\\xfe66\\xfe68-\\xfe6b\\xfeff\\xff01-\\xff20"
            "\\xff3b-\\xff40\\xff5b-\\xff65\\xff70\\xff9e\\xff9f"
            "\\xffe0-\\xffe6\\xffe8-\\xffee\\xfff9-\\xfffd\\x10100-\\x10102"
            "\\x10107-\\x10133\\x10137-\\x1013f\\x10190-\\x1019c"
            "\\x101d0-\\x101fc\\x102e1-\\x102fb\\x1bca0-\\x1bca3"
            "\\x1cf50-\\x1cfc3\\x1d000-\\x1d0f5\\x1d100-\\x1d126"
            "\\x1d129-\\x1d166\\x1d16a-\\x1d17a\\x1d183\\x1d184"
            "\\x1d18c-\\x1d1a9\\x1d1ae-\\x1d1ea\\x1d2e0-\\x1d2f3"
            "\\x1d300-\\x1d356\\x1d360-\\x1d378\\x1d400-\\x1d454"
            "\\x1d456-\\x1d49c\\x1d49e\\x1d49f\\x1d4a2\\x1d4a5\\x1d4a6"
            "\\x1d4a9-\\x1d4ac\\x1d4ae-\\x1d4b9\\x1d4bb\\x1d4bd-\\x1d4c3"
            "\\x1d4c5-\\x1d505\\x1d507-\\x1d50a\\x1d50d-\\x1d514"
            "\\x1d516-\\x1d51c\\x1d51e-\\x1d539\\x1d53b-\\x1d53e"
            "\\x1d540-\\x1d544\\x1d546\\x1d54a-\\x1d550\\x1d552-\\x1d6a5"
            "\\x1d6a8-\\x1d7cb\\x1d7ce-\\x1d7ff\\x1ec71-\\x1ecb4"
            "\\x1ed01-\\x1ed3d\\x1f000-\\x1f02b\\x1f030-\\x1f093"
            "\\x1f0a0-\\x1f0ae\\x1f0b1-\\x1f0bf\\x1f0c1-\\x1f0cf"
            "\\x1f0d1-\\x1f0f5\\x1f100-\\x1f1ad\\x1f1e6-\\x1f1ff"
            "\\x1f201\\x1f202\\x1f210-\\x1f23b\\x1f240-\\x1f248\\x1f250\\x1f251"
            "\\x1f260-\\x1f265\\x1f300-\\x1f6d7\\x1f6dd-\\x1f6ec"
            "\\x1f6f0-\\x1f6fc\\x1f700-\\x1f773\\x1f780-\\x1f7d8"
            "\\x1f7e0-\\x1f7eb\\x1f7f0\\x1f800-\\x1f80b\\x1f810-\\x1f847"
            "\\x1f850-\\x1f859\\x1f860-\\x1f887\\x1f890-\\x1f8ad"
            "\\x1f8b0\\x1f8b1\\x1f900-\\x1fa53\\x1fa60-\\x1fa6d"
            "\\x1fa70-\\x1fa74\\x1fa78-\\x1fa7c\\x1fa80-\\x1fa86"
            "\\x1fa90-\\x1faac\\x1fab0-\\x1faba\\x1fac0-\\x1fac5"
            "\\x1fad0-\\x1fad9\\x1fae0-\\x1fae7\\x1faf0-\\x1faf6"
            "\\x1fb00-\\x1fb92\\x1fb94-\\x1fbca\\x1fbf0-\\x1fbf9\\xe0001"
            "\\xe0020-\\xe007f]";
    }

    static const char *IsCoptic()
    {
        return "[\\x3e2-\\x3ef\\x2c80-\\x2cf3\\x2cf9-\\x2cff]";
    }

    static const char *IsCuneiform()
    {
        return "[\\x12000-\\x12399\\x12400-\\x1246e\\x12470-\\x12474"
            "\\x12480-\\x12543]";
    }

    static const char *IsCypriot()
    {
        return "[\\x10800-\\x10805\\x10808\\x1080a-\\x10835\\x10837\\x10838"
            "\\x1083c\\x1083f]";
    }

    static const char *IsCypro_Minoan()
    {
        return "[\\x12f90-\\x12ff2]";
    }

    static const char *IsCyrillic()
    {
        return "[\\x400-\\x484\\x487-\\x52f\\x1c80-\\x1c88\\x1d2b\\x1d78"
            "\\x2de0-\\x2dff\\xa640-\\xa69f\\xfe2e\\xfe2f]";
    }

    static const char *IsDeseret()
    {
        return "[\\x10400-\\x1044f]";
    }

    static const char *IsDevanagari()
    {
        return "[\\x900-\\x950\\x955-\\x963\\x966-\\x97f\\xa8e0-\\xa8ff]";
    }

    static const char *IsDives_Akuru()
    {
        return "[\\x11900-\\x11906\\x11909\\x1190c-\\x11913\\x11915\\x11916"
            "\\x11918-\\x11935\\x11937\\x11938\\x1193b-\\x11946"
            "\\x11950-\\x11959]";
    }

    static const char *IsDogra()
    {
        return "[\\x11800-\\x1183b]";
    }

    static const char *IsDuployan()
    {
        return "[\\x1bc00-\\x1bc6a\\x1bc70-\\x1bc7c\\x1bc80-\\x1bc88"
            "\\x1bc90-\\x1bc99\\x1bc9c-\\x1bc9f]";
    }

    static const char *IsEgyptian_Hieroglyphs()
    {
        return "[\\x13000-\\x1342e\\x13430-\\x13438]";
    }

    static const char *IsElbasan()
    {
        return "[\\x10500-\\x10527]";
    }

    static const char *IsElymaic()
    {
        return "[\\x10fe0-\\x10ff6]";
    }

    static const char *IsEthiopic()
    {
        return "[\\x1200-\\x1248\\x124a-\\x124d\\x1250-\\x1256\\x1258"
            "\\x125a-\\x125d\\x1260-\\x1288\\x128a-\\x128d\\x1290-\\x12b0"
            "\\x12b2-\\x12b5\\x12b8-\\x12be\\x12c0\\x12c2-\\x12c5"
            "\\x12c8-\\x12d6\\x12d8-\\x1310\\x1312-\\x1315\\x1318-\\x135a"
            "\\x135d-\\x137c\\x1380-\\x1399\\x2d80-\\x2d96\\x2da0-\\x2da6"
            "\\x2da8-\\x2dae\\x2db0-\\x2db6\\x2db8-\\x2dbe\\x2dc0-\\x2dc6"
            "\\x2dc8-\\x2dce\\x2dd0-\\x2dd6\\x2dd8-\\x2dde\\xab01-\\xab06"
            "\\xab09-\\xab0e\\xab11-\\xab16\\xab20-\\xab26\\xab28-\\xab2e"
            "\\x1e7e0-\\x1e7e6\\x1e7e8-\\x1e7eb\\x1e7ed\\x1e7ee"
            "\\x1e7f0-\\x1e7fe]";
    }

    static const char *IsGeorgian()
    {
        return "[\\x10a0-\\x10c5\\x10c7\\x10cd\\x10d0-\\x10fa\\x10fc-\\x10ff"
            "\\x1c90-\\x1cba\\x1cbd-\\x1cbf\\x2d00-\\x2d25\\x2d27\\x2d2d]";
    }

    static const char *IsGlagolitic()
    {
        return "[\\x2c00-\\x2c5f\\x1e000-\\x1e006\\x1e008-\\x1e018"
            "\\x1e01b-\\x1e021\\x1e023\\x1e024\\x1e026-\\x1e02a]";
    }

    static const char *IsGothic()
    {
        return "[\\x10330-\\x1034a]";
    }

    static const char *IsGrantha()
    {
        return "[\\x11300-\\x11303\\x11305-\\x1130c\\x1130f\\x11310"
            "\\x11313-\\x11328\\x1132a-\\x11330\\x11332\\x11333"
            "\\x11335-\\x11339\\x1133c-\\x11344\\x11347\\x11348"
            "\\x1134b-\\x1134d\\x11350\\x11357\\x1135d-\\x11363"
            "\\x11366-\\x1136c\\x11370-\\x11374]";
    }

    static const char *IsGreek()
    {
        return "[\\x370-\\x373\\x375-\\x377\\x37a-\\x37d\\x37f\\x384\\x386"
            "\\x388-\\x38a\\x38c\\x38e-\\x3a1\\x3a3-\\x3e1\\x3f0-\\x3ff"
            "\\x1d26-\\x1d2a\\x1d5d-\\x1d61\\x1d66-\\x1d6a\\x1dbf"
            "\\x1f00-\\x1f15\\x1f18-\\x1f1d\\x1f20-\\x1f45\\x1f48-\\x1f4d"
            "\\x1f50-\\x1f57\\x1f59\\x1f5b\\x1f5d\\x1f5f-\\x1f7d"
            "\\x1f80-\\x1fb4\\x1fb6-\\x1fc4\\x1fc6-\\x1fd3\\x1fd6-\\x1fdb"
            "\\x1fdd-\\x1fef\\x1ff2-\\x1ff4\\x1ff6-\\x1ffe\\x2126\\xab65"
            "\\x10140-\\x1018e\\x101a0\\x1d200-\\x1d245]";
    }

    static const char *IsGujarati()
    {
        return "[\\xa81-\\xa83\\xa85-\\xa8d\\xa8f-\\xa91\\xa93-\\xaa8"
            "\\xaaa-\\xab0\\xab2\\xab3\\xab5-\\xab9\\xabc-\\xac5\\xac7-\\xac9"
            "\\xacb-\\xacd\\xad0\\xae0-\\xae3\\xae6-\\xaf1\\xaf9-\\xaff]";
    }

    static const char *IsGunjala_Gondi()
    {
        return "[\\x11d60-\\x11d65\\x11d67\\x11d68\\x11d6a-\\x11d8e"
            "\\x11d90\\x11d91\\x11d93-\\x11d98\\x11da0-\\x11da9]";
    }

    static const char *IsGurmukhi()
    {
        return "[\\xa01-\\xa03\\xa05-\\xa0a\\xa0f\\xa10\\xa13-\\xa28"
            "\\xa2a-\\xa30\\xa32\\xa33\\xa35\\xa36\\xa38\\xa39\\xa3c"
            "\\xa3e-\\xa42\\xa47\\xa48\\xa4b-\\xa4d\\xa51\\xa59-\\xa5c\\xa5e"
            "\\xa66-\\xa76]";
    }

    static const char *IsHan()
    {
        return "[\\x2e80-\\x2e99\\x2e9b-\\x2ef3\\x2f00-\\x2fd5\\x3005\\x3007"
            "\\x3021-\\x3029\\x3038-\\x303b\\x3400-\\x4dbf\\x4e00-\\x9fff"
            "\\xf900-\\xfa6d\\xfa70-\\xfad9\\x16fe2\\x16fe3\\x16ff0\\x16ff1"
            "\\x20000-\\x2a6df\\x2a700-\\x2b738\\x2b740-\\x2b81d"
            "\\x2b820-\\x2cea1\\x2ceb0-\\x2ebe0\\x2f800-\\x2fa1d"
            "\\x30000-\\x3134a]";
    }

    static const char *IsHangul()
    {
        return "[\\x1100-\\x11ff\\x302e\\x302f\\x3131-\\x318e\\x3200-\\x321e"
            "\\x3260-\\x327e\\xa960-\\xa97c\\xac00-\\xd7a3\\xd7b0-\\xd7c6"
            "\\xd7cb-\\xd7fb\\xffa0-\\xffbe\\xffc2-\\xffc7\\xffca-\\xffcf"
            "\\xffd2-\\xffd7\\xffda-\\xffdc]";
    }

    static const char *IsHanifi_Rohingya()
    {
        return "[\\x10d00-\\x10d27\\x10d30-\\x10d39]";
    }

    static const char *IsHanunoo()
    {
        return "[\\x1720-\\x1734]";
    }

    static const char *IsHatran()
    {
        return "[\\x108e0-\\x108f2\\x108f4\\x108f5\\x108fb-\\x108ff]";
    }

    static const char *IsHebrew()
    {
        return "[\\x591-\\x5c7\\x5d0-\\x5ea\\x5ef-\\x5f4\\xfb1d-\\xfb36"
            "\\xfb38-\\xfb3c\\xfb3e\\xfb40\\xfb41\\xfb43\\xfb44"
            "\\xfb46-\\xfb4f]";
    }

    static const char *IsHiragana()
    {
        return "[\\x3041-\\x3096\\x309d-\\x309f\\x1b001-\\x1b11f"
            "\\x1b150-\\x1b152\\x1f200]";
    }

    static const char *IsImperial_Aramaic()
    {
        return "[\\x10840-\\x10855\\x10857-\\x1085f]";
    }

    static const char *IsInherited()
    {
        return "[\\x300-\\x36f\\x485\\x486\\x64b-\\x655\\x670\\x951-\\x954"
            "\\x1ab0-\\x1ace\\x1cd0-\\x1cd2\\x1cd4-\\x1ce0\\x1ce2-\\x1ce8"
            "\\x1ced\\x1cf4\\x1cf8\\x1cf9\\x1dc0-\\x1dff\\x200c\\x200d"
            "\\x20d0-\\x20f0\\x302a-\\x302d\\x3099\\x309a\\xfe00-\\xfe0f"
            "\\xfe20-\\xfe2d\\x101fd\\x102e0\\x1133b\\x1cf00-\\x1cf2d"
            "\\x1cf30-\\x1cf46\\x1d167-\\x1d169\\x1d17b-\\x1d182"
            "\\x1d185-\\x1d18b\\x1d1aa-\\x1d1ad\\xe0100-\\xe01ef]";
    }

    static const char *IsInscriptional_Pahlavi()
    {
        return "[\\x10b60-\\x10b72\\x10b78-\\x10b7f]";
    }

    static const char *IsInscriptional_Parthian()
    {
        return "[\\x10b40-\\x10b55\\x10b58-\\x10b5f]";
    }

    static const char *IsJavanese()
    {
        return "[\\xa980-\\xa9cd\\xa9d0-\\xa9d9\\xa9de\\xa9df]";
    }

    static const char *IsKaithi()
    {
        return "[\\x11080-\\x110c2\\x110cd]";
    }

    static const char *IsKannada()
    {
        return "[\\xc80-\\xc8c\\xc8e-\\xc90\\xc92-\\xca8\\xcaa-\\xcb3"
            "\\xcb5-\\xcb9\\xcbc-\\xcc4\\xcc6-\\xcc8\\xcca-\\xccd\\xcd5\\xcd6"
            "\\xcdd\\xcde\\xce0-\\xce3\\xce6-\\xcef\\xcf1\\xcf2]";
    }

    static const char *IsKatakana()
    {
        return "[\\x30a1-\\x30fa\\x30fd-\\x30ff\\x31f0-\\x31ff\\x32d0-\\x32fe"
            "\\x3300-\\x3357\\xff66-\\xff6f\\xff71-\\xff9d\\x1aff0-\\x1aff3"
            "\\x1aff5-\\x1affb\\x1affd\\x1affe\\x1b000\\x1b120-\\x1b122"
            "\\x1b164-\\x1b167]";
    }

    static const char *IsKayah_Li()
    {
        return "[\\xa900-\\xa92d\\xa92f]";
    }

    static const char *IsKharoshthi()
    {
        return "[\\x10a00-\\x10a03\\x10a05\\x10a06\\x10a0c-\\x10a13"
            "\\x10a15-\\x10a17\\x10a19-\\x10a35\\x10a38-\\x10a3a"
            "\\x10a3f-\\x10a48\\x10a50-\\x10a58]";
    }

    static const char *IsKhitan_Small_Script()
    {
        return "[\\x16fe4\\x18b00-\\x18cd5]";
    }

    static const char *IsKhmer()
    {
        return "[\\x1780-\\x17dd\\x17e0-\\x17e9\\x17f0-\\x17f9"
            "\\x19e0-\\x19ff]";
    }

    static const char *IsKhojki()
    {
        return "[\\x11200-\\x11211\\x11213-\\x1123e]";
    }

    static const char *IsKhudawadi()
    {
        return "[\\x112b0-\\x112ea\\x112f0-\\x112f9]";
    }

    static const char *IsLao()
    {
        return "[\\xe81\\xe82\\xe84\\xe86-\\xe8a\\xe8c-\\xea3\\xea5"
            "\\xea7-\\xebd\\xec0-\\xec4\\xec6\\xec8-\\xecd\\xed0-\\xed9"
            "\\xedc-\\xedf]";
    }

    static const char *IsLatin()
    {
        return "[\\x41-\\x5a\\x61-\\x7a\\xaa\\xba\\xc0-\\xd6\\xd8-\\xf6"
            "\\xf8-\\x2b8\\x2e0-\\x2e4\\x1d00-\\x1d25\\x1d2c-\\x1d5c"
            "\\x1d62-\\x1d65\\x1d6b-\\x1d77\\x1d79-\\x1dbe\\x1e00-\\x1eff"
            "\\x2071\\x207f\\x2090-\\x209c\\x212a\\x212b\\x2132\\x214e"
            "\\x2160-\\x2188\\x2c60-\\x2c7f\\xa722-\\xa787\\xa78b-\\xa7ca"
            "\\xa7d0\\xa7d1\\xa7d3\\xa7d5-\\xa7d9\\xa7f2-\\xa7ff"
            "\\xab30-\\xab5a\\xab5c-\\xab64\\xab66-\\xab69\\xfb00-\\xfb06"
            "\\xff21-\\xff3a\\xff41-\\xff5a\\x10780-\\x10785\\x10787-\\x107b0"
            "\\x107b2-\\x107ba\\x1df00-\\x1df1e]";
    }

    static const char *IsLepcha()
    {
        return "[\\x1c00-\\x1c37\\x1c3b-\\x1c49\\x1c4d-\\x1c4f]";
    }

    static const char *IsLimbu()
    {
        return "[\\x1900-\\x191e\\x1920-\\x192b\\x1930-\\x193b\\x1940"
            "\\x1944-\\x194f]";
    }

    static const char *IsLinear_A()
    {
        return "[\\x10600-\\x10736\\x10740-\\x10755\\x10760-\\x10767]";
    }

    static const char *IsLinear_B()
    {
        return "[\\x10000-\\x1000b\\x1000d-\\x10026\\x10028-\\x1003a"
            "\\x1003c\\x1003d\\x1003f-\\x1004d\\x10050-\\x1005d"
            "\\x10080-\\x100fa]";
    }

    static const char *IsLisu()
    {
        return "[\\xa4d0-\\xa4ff\\x11fb0]";
    }

    static const char *IsLycian()
    {
        return "[\\x10280-\\x1029c]";
    }

    static const char *IsLydian()
    {
        return "[\\x10920-\\x10939\\x1093f]";
    }

    static const char *IsMahajani()
    {
        return "[\\x11150-\\x11176]";
    }

    static const char *IsMakasar()
    {
        return "[\\x11ee0-\\x11ef8]";
    }

    static const char *IsMalayalam()
    {
        return "[\\xd00-\\xd0c\\xd0e-\\xd10\\xd12-\\xd44\\xd46-\\xd48"
            "\\xd4a-\\xd4f\\xd54-\\xd63\\xd66-\\xd7f]";
    }

    static const char *IsMandaic()
    {
        return "[\\x840-\\x85b\\x85e]";
    }

    static const char *IsManichaean()
    {
        return "[\\x10ac0-\\x10ae6\\x10aeb-\\x10af6]";
    }

    static const char *IsMarchen()
    {
        return "[\\x11c70-\\x11c8f\\x11c92-\\x11ca7\\x11ca9-\\x11cb6]";
    }

    static const char *IsMasaram_Gondi()
    {
        return "[\\x11d00-\\x11d06\\x11d08\\x11d09\\x11d0b-\\x11d36\\x11d3a"
            "\\x11d3c\\x11d3d\\x11d3f-\\x11d47\\x11d50-\\x11d59]";
    }

    static const char *IsMedefaidrin()
    {
        return "[\\x16e40-\\x16e9a]";
    }

    static const char *IsMeetei_Mayek()
    {
        return "[\\xaae0-\\xaaf6\\xabc0-\\xabed\\xabf0-\\xabf9]";
    }

    static const char *IsMende_Kikakui()
    {
        return "[\\x1e800-\\x1e8c4\\x1e8c7-\\x1e8d6]";
    }

    static const char *IsMeroitic_Cursive()
    {
        return "[\\x109a0-\\x109b7\\x109bc-\\x109cf\\x109d2-\\x109ff]";
    }

    static const char *IsMeroitic_Hieroglyphs()
    {
        return "[\\x10980-\\x1099f]";
    }

    static const char *IsMiao()
    {
        return "[\\x16f00-\\x16f4a\\x16f4f-\\x16f87\\x16f8f-\\x16f9f]";
    }

    static const char *IsModi()
    {
        return "[\\x11600-\\x11644\\x11650-\\x11659]";
    }

    static const char *IsMongolian()
    {
        return "[\\x1800\\x1801\\x1804\\x1806-\\x1819\\x1820-\\x1878"
            "\\x1880-\\x18aa\\x11660-\\x1166c]";
    }

    static const char *IsMro()
    {
        return "[\\x16a40-\\x16a5e\\x16a60-\\x16a69\\x16a6e\\x16a6f]";
    }

    static const char *IsMultani()
    {
        return "[\\x11280-\\x11286\\x11288\\x1128a-\\x1128d\\x1128f-\\x1129d"
            "\\x1129f-\\x112a9]";
    }

    static const char *IsMyanmar()
    {
        return "[\\x1000-\\x109f\\xa9e0-\\xa9fe\\xaa60-\\xaa7f]";
    }

    static const char *IsNabataean()
    {
        return "[\\x10880-\\x1089e\\x108a7-\\x108af]";
    }

    static const char *IsNandinagari()
    {
        return "[\\x119a0-\\x119a7\\x119aa-\\x119d7\\x119da-\\x119e4]";
    }

    static const char *IsNew_Tai_Lue()
    {
        return "[\\x1980-\\x19ab\\x19b0-\\x19c9\\x19d0-\\x19da\\x19de\\x19df]";
    }

    static const char *IsNewa()
    {
        return "[\\x11400-\\x1145b\\x1145d-\\x11461]";
    }

    static const char *IsNko()
    {
        return "[\\x7c0-\\x7fa\\x7fd-\\x7ff]";
    }

    static const char *IsNushu()
    {
        return "[\\x16fe1\\x1b170-\\x1b2fb]";
    }

    static const char *IsNyiakeng_Puachue_Hmong()
    {
        return "[\\x1e100-\\x1e12c\\x1e130-\\x1e13d\\x1e140-\\x1e149"
            "\\x1e14e\\x1e14f]";
    }

    static const char *IsOgham()
    {
        return "[\\x1680-\\x169c]";
    }

    static const char *IsOl_Chiki()
    {
        return "[\\x1c50-\\x1c7f]";
    }

    static const char *IsOld_Hungarian()
    {
        return "[\\x10c80-\\x10cb2\\x10cc0-\\x10cf2\\x10cfa-\\x10cff]";
    }

    static const char *IsOld_Italic()
    {
        return "[\\x10300-\\x10323\\x1032d-\\x1032f]";
    }

    static const char *IsOld_North_Arabian()
    {
        return "[\\x10a80-\\x10a9f]";
    }

    static const char *IsOld_Permic()
    {
        return "[\\x10350-\\x1037a]";
    }

    static const char *IsOld_Persian()
    {
        return "[\\x103a0-\\x103c3\\x103c8-\\x103d5]";
    }

    static const char *IsOld_Sogdian()
    {
        return "[\\x10f00-\\x10f27]";
    }

    static const char *IsOld_South_Arabian()
    {
        return "[\\x10a60-\\x10a7f]";
    }

    static const char *IsOld_Turkic()
    {
        return "[\\x10c00-\\x10c48]";
    }

    static const char *IsOld_Uyghur()
    {
        return "[\\x10f70-\\x10f89]";
    }

    static const char *IsOriya()
    {
        return "[\\xb01-\\xb03\\xb05-\\xb0c\\xb0f\\xb10\\xb13-\\xb28"
            "\\xb2a-\\xb30\\xb32\\xb33\\xb35-\\xb39\\xb3c-\\xb44\\xb47\\xb48"
            "\\xb4b-\\xb4d\\xb55-\\xb57\\xb5c\\xb5d\\xb5f-\\xb63"
            "\\xb66-\\xb77]";
    }

    static const char *IsOsage()
    {
        return "[\\x104b0-\\x104d3\\x104d8-\\x104fb]";
    }

    static const char *IsOsmanya()
    {
        return "[\\x10480-\\x1049d\\x104a0-\\x104a9]";
    }

    static const char *IsPahawh_Hmong()
    {
        return "[\\x16b00-\\x16b45\\x16b50-\\x16b59\\x16b5b-\\x16b61"
            "\\x16b63-\\x16b77\\x16b7d-\\x16b8f]";
    }

    static const char *IsPalmyrene()
    {
        return "[\\x10860-\\x1087f]";
    }

    static const char *IsPau_Cin_Hau()
    {
        return "[\\x11ac0-\\x11af8]";
    }

    static const char *IsPhags_Pa()
    {
        return "[\\xa840-\\xa877]";
    }

    static const char *IsPhoenician()
    {
        return "[\\x10900-\\x1091b\\x1091f]";
    }

    static const char *IsPsalter_Pahlavi()
    {
        return "[\\x10b80-\\x10b91\\x10b99-\\x10b9c\\x10ba9-\\x10baf]";
    }

    static const char *IsRejang()
    {
        return "[\\xa930-\\xa953\\xa95f]";
    }

    static const char *IsRunic()
    {
        return "[\\x16a0-\\x16ea\\x16ee-\\x16f8]";
    }

    static const char *IsSamaritan()
    {
        return "[\\x800-\\x82d\\x830-\\x83e]";
    }

    static const char *IsSaurashtra()
    {
        return "[\\xa880-\\xa8c5\\xa8ce-\\xa8d9]";
    }

    static const char *IsSharada()
    {
        return "[\\x11180-\\x111df]";
    }

    static const char *IsShavian()
    {
        return "[\\x10450-\\x1047f]";
    }

    static const char *IsSiddham()
    {
        return "[\\x11580-\\x115b5\\x115b8-\\x115dd]";
    }

    static const char *IsSignWriting()
    {
        return "[\\x1d800-\\x1da8b\\x1da9b-\\x1da9f\\x1daa1-\\x1daaf]";
    }

    static const char *IsSinhala()
    {
        return "[\\xd81-\\xd83\\xd85-\\xd96\\xd9a-\\xdb1\\xdb3-\\xdbb\\xdbd"
            "\\xdc0-\\xdc6\\xdca\\xdcf-\\xdd4\\xdd6\\xdd8-\\xddf\\xde6-\\xdef"
            "\\xdf2-\\xdf4\\x111e1-\\x111f4]";
    }

    static const char *IsSogdian()
    {
        return "[\\x10f30-\\x10f59]";
    }

    static const char *IsSora_Sompeng()
    {
        return "[\\x110d0-\\x110e8\\x110f0-\\x110f9]";
    }

    static const char *IsSoyombo()
    {
        return "[\\x11a50-\\x11aa2]";
    }

    static const char *IsSundanese()
    {
        return "[\\x1b80-\\x1bbf\\x1cc0-\\x1cc7]";
    }

    static const char *IsSyloti_Nagri()
    {
        return "[\\xa800-\\xa82c]";
    }

    static const char *IsSyriac()
    {
        return "[\\x700-\\x70d\\x70f-\\x74a\\x74d-\\x74f\\x860-\\x86a]";
    }

    static const char *IsTagalog()
    {
        return "[\\x1700-\\x1715\\x171f]";
    }

    static const char *IsTagbanwa()
    {
        return "[\\x1760-\\x176c\\x176e-\\x1770\\x1772\\x1773]";
    }

    static const char *IsTai_Le()
    {
        return "[\\x1950-\\x196d\\x1970-\\x1974]";
    }

    static const char *IsTai_Tham()
    {
        return "[\\x1a20-\\x1a5e\\x1a60-\\x1a7c\\x1a7f-\\x1a89\\x1a90-\\x1a99"
            "\\x1aa0-\\x1aad]";
    }

    static const char *IsTai_Viet()
    {
        return "[\\xaa80-\\xaac2\\xaadb-\\xaadf]";
    }

    static const char *IsTakri()
    {
        return "[\\x11680-\\x116b9\\x116c0-\\x116c9]";
    }

    static const char *IsTamil()
    {
        return "[\\xb82\\xb83\\xb85-\\xb8a\\xb8e-\\xb90\\xb92-\\xb95"
            "\\xb99\\xb9a\\xb9c\\xb9e\\xb9f\\xba3\\xba4\\xba8-\\xbaa"
            "\\xbae-\\xbb9\\xbbe-\\xbc2\\xbc6-\\xbc8\\xbca-\\xbcd\\xbd0\\xbd7"
            "\\xbe6-\\xbfa\\x11fc0-\\x11ff1\\x11fff]";
    }

    static const char *IsTangsa()
    {
        return "[\\x16a70-\\x16abe\\x16ac0-\\x16ac9]";
    }

    static const char *IsTangut()
    {
        return "[\\x16fe0\\x17000-\\x187f7\\x18800-\\x18aff"
            "\\x18d00-\\x18d08]";
    }

    static const char *IsTelugu()
    {
        return "[\\xc00-\\xc0c\\xc0e-\\xc10\\xc12-\\xc28\\xc2a-\\xc39"
            "\\xc3c-\\xc44\\xc46-\\xc48\\xc4a-\\xc4d\\xc55\\xc56\\xc58-\\xc5a"
            "\\xc5d\\xc60-\\xc63\\xc66-\\xc6f\\xc77-\\xc7f]";
    }

    static const char *IsThaana()
    {
        return "[\\x780-\\x7b1]";
    }

    static const char *IsThai()
    {
        return "[\\xe01-\\xe3a\\xe40-\\xe5b]";
    }

    static const char *IsTibetan()
    {
        return "[\\xf00-\\xf47\\xf49-\\xf6c\\xf71-\\xf97\\xf99-\\xfbc"
            "\\xfbe-\\xfcc\\xfce-\\xfd4\\xfd9\\xfda]";
    }

    static const char *IsTifinagh()
    {
        return "[\\x2d30-\\x2d67\\x2d6f\\x2d70\\x2d7f]";
    }

    static const char *IsTirhuta()
    {
        return "[\\x11480-\\x114c7\\x114d0-\\x114d9]";
    }

    static const char *IsToto()
    {
        return "[\\x1e290-\\x1e2ae]";
    }

    static const char *IsUgaritic()
    {
        return "[\\x10380-\\x1039d\\x1039f]";
    }

    static const char *IsVai()
    {
        return "[\\xa500-\\xa62b]";
    }

    static const char *IsVithkuqi()
    {
        return "[\\x10570-\\x1057a\\x1057c-\\x1058a\\x1058c-\\x10592"
            "\\x10594\\x10595\\x10597-\\x105a1\\x105a3-\\x105b1"
            "\\x105b3-\\x105b9\\x105bb\\x105bc]";
    }

    static const char *IsWancho()
    {
        return "[\\x1e2c0-\\x1e2f9\\x1e2ff]";
    }

    static const char *IsWarang_Citi()
    {
        return "[\\x118a0-\\x118f2\\x118ff]";
    }

    static const char *IsYezidi()
    {
        return "[\\x10e80-\\x10ea9\\x10eab-\\x10ead\\x10eb0\\x10eb1]";
    }

    static const char *IsYi()
    {
        return "[\\xa000-\\xa48c\\xa490-\\xa4c6]";
    }

    static const char *IsZanabazar_Square()
    {
        return "[\\x11a00-\\x11a47]";
    }
