/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// DeleteOptionsApplyConfiguration represents a declarative configuration of the DeleteOptions type for use
// with apply.
//
// DeleteOptions may be provided when deleting an API object.
type DeleteOptionsApplyConfiguration struct {
	TypeMetaApplyConfiguration `json:",inline"`
	// The duration in seconds before the object should be deleted. Value must be non-negative integer.
	// The value zero indicates delete immediately. If this value is nil, the default grace period for the
	// specified type will be used.
	// Defaults to a per object value if not specified. zero means delete immediately.
	GracePeriodSeconds *int64 `json:"gracePeriodSeconds,omitempty"`
	// Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be
	// returned.
	Preconditions *PreconditionsApplyConfiguration `json:"preconditions,omitempty"`
	// Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7.
	// Should the dependent objects be orphaned. If true/false, the "orphan"
	// finalizer will be added to/removed from the object's finalizers list.
	// Either this field or PropagationPolicy may be set, but not both.
	OrphanDependents *bool `json:"orphanDependents,omitempty"`
	// Whether and how garbage collection will be performed.
	// Either this field or OrphanDependents may be set, but not both.
	// The default policy is decided by the existing finalizer set in the
	// metadata.finalizers and the resource-specific default policy.
	// Acceptable values are: 'Orphan' - orphan the dependents; 'Background' -
	// allow the garbage collector to delete the dependents in the background;
	// 'Foreground' - a cascading policy that deletes all dependents in the
	// foreground.
	PropagationPolicy *metav1.DeletionPropagation `json:"propagationPolicy,omitempty"`
	// When present, indicates that modifications should not be
	// persisted. An invalid or unrecognized dryRun directive will
	// result in an error response and no further processing of the
	// request. Valid values are:
	// - All: all dry run stages will be processed
	DryRun []string `json:"dryRun,omitempty"`
	// if set to true, it will trigger an unsafe deletion of the resource in
	// case the normal deletion flow fails with a corrupt object error.
	// A resource is considered corrupt if it can not be retrieved from
	// the underlying storage successfully because of a) its data can
	// not be transformed e.g. decryption failure, or b) it fails
	// to decode into an object.
	// NOTE: unsafe deletion ignores finalizer constraints, skips
	// precondition checks, and removes the object from the storage.
	// WARNING: This may potentially break the cluster if the workload
	// associated with the resource being unsafe-deleted relies on normal
	// deletion flow. Use only if you REALLY know what you are doing.
	// The default value is false, and the user must opt in to enable it
	IgnoreStoreReadErrorWithClusterBreakingPotential *bool `json:"ignoreStoreReadErrorWithClusterBreakingPotential,omitempty"`
}

// DeleteOptionsApplyConfiguration constructs a declarative configuration of the DeleteOptions type for use with
// apply.
func DeleteOptions() *DeleteOptionsApplyConfiguration {
	b := &DeleteOptionsApplyConfiguration{}
	b.WithKind("DeleteOptions")
	b.WithAPIVersion("meta.k8s.io/v1")
	return b
}

func (b DeleteOptionsApplyConfiguration) IsApplyConfiguration() {}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *DeleteOptionsApplyConfiguration) WithKind(value string) *DeleteOptionsApplyConfiguration {
	b.TypeMetaApplyConfiguration.Kind = &value
	return b
}

// WithAPIVersion sets the APIVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIVersion field is set to the value of the last call.
func (b *DeleteOptionsApplyConfiguration) WithAPIVersion(value string) *DeleteOptionsApplyConfiguration {
	b.TypeMetaApplyConfiguration.APIVersion = &value
	return b
}

// WithGracePeriodSeconds sets the GracePeriodSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GracePeriodSeconds field is set to the value of the last call.
func (b *DeleteOptionsApplyConfiguration) WithGracePeriodSeconds(value int64) *DeleteOptionsApplyConfiguration {
	b.GracePeriodSeconds = &value
	return b
}

// WithPreconditions sets the Preconditions field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Preconditions field is set to the value of the last call.
func (b *DeleteOptionsApplyConfiguration) WithPreconditions(value *PreconditionsApplyConfiguration) *DeleteOptionsApplyConfiguration {
	b.Preconditions = value
	return b
}

// WithOrphanDependents sets the OrphanDependents field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the OrphanDependents field is set to the value of the last call.
func (b *DeleteOptionsApplyConfiguration) WithOrphanDependents(value bool) *DeleteOptionsApplyConfiguration {
	b.OrphanDependents = &value
	return b
}

// WithPropagationPolicy sets the PropagationPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PropagationPolicy field is set to the value of the last call.
func (b *DeleteOptionsApplyConfiguration) WithPropagationPolicy(value metav1.DeletionPropagation) *DeleteOptionsApplyConfiguration {
	b.PropagationPolicy = &value
	return b
}

// WithDryRun adds the given value to the DryRun field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the DryRun field.
func (b *DeleteOptionsApplyConfiguration) WithDryRun(values ...string) *DeleteOptionsApplyConfiguration {
	for i := range values {
		b.DryRun = append(b.DryRun, values[i])
	}
	return b
}

// WithIgnoreStoreReadErrorWithClusterBreakingPotential sets the IgnoreStoreReadErrorWithClusterBreakingPotential field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IgnoreStoreReadErrorWithClusterBreakingPotential field is set to the value of the last call.
func (b *DeleteOptionsApplyConfiguration) WithIgnoreStoreReadErrorWithClusterBreakingPotential(value bool) *DeleteOptionsApplyConfiguration {
	b.IgnoreStoreReadErrorWithClusterBreakingPotential = &value
	return b
}

// GetKind retrieves the value of the Kind field in the declarative configuration.
func (b *DeleteOptionsApplyConfiguration) GetKind() *string {
	return b.TypeMetaApplyConfiguration.Kind
}

// GetAPIVersion retrieves the value of the APIVersion field in the declarative configuration.
func (b *DeleteOptionsApplyConfiguration) GetAPIVersion() *string {
	return b.TypeMetaApplyConfiguration.APIVersion
}
