/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta3

// LimitedPriorityLevelConfigurationApplyConfiguration represents a declarative configuration of the LimitedPriorityLevelConfiguration type for use
// with apply.
//
// LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits.
// It addresses two issues:
// - How are requests for this priority level limited?
// - What should be done with requests that exceed the limit?
type LimitedPriorityLevelConfigurationApplyConfiguration struct {
	// `nominalConcurrencyShares` (NCS) contributes to the computation of the
	// NominalConcurrencyLimit (NominalCL) of this level.
	// This is the number of execution seats available at this priority level.
	// This is used both for requests dispatched from this priority level
	// as well as requests dispatched from other priority levels
	// borrowing seats from this level.
	// The server's concurrency limit (ServerCL) is divided among the
	// Limited priority levels in proportion to their NCS values:
	//
	// NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs )
	// sum_ncs = sum[priority level k] NCS(k)
	//
	// Bigger numbers mean a larger nominal concurrency limit,
	// at the expense of every other priority level.
	// This field has a default value of 30.
	NominalConcurrencyShares *int32 `json:"nominalConcurrencyShares,omitempty"`
	// `limitResponse` indicates what to do with requests that can not be executed right now
	LimitResponse *LimitResponseApplyConfiguration `json:"limitResponse,omitempty"`
	// `lendablePercent` prescribes the fraction of the level's NominalCL that
	// can be borrowed by other priority levels. The value of this
	// field must be between 0 and 100, inclusive, and it defaults to 0.
	// The number of seats that other levels can borrow from this level, known
	// as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.
	//
	// LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
	LendablePercent *int32 `json:"lendablePercent,omitempty"`
	// `borrowingLimitPercent`, if present, configures a limit on how many
	// seats this priority level can borrow from other priority levels.
	// The limit is known as this level's BorrowingConcurrencyLimit
	// (BorrowingCL) and is a limit on the total number of seats that this
	// level may borrow at any one time.
	// This field holds the ratio of that limit to the level's nominal
	// concurrency limit. When this field is non-nil, it must hold a
	// non-negative integer and the limit is calculated as follows.
	//
	// BorrowingCL(i) = round( NominalCL(i) * borrowingLimitPercent(i)/100.0 )
	//
	// The value of this field can be more than 100, implying that this
	// priority level can borrow a number of seats that is greater than
	// its own nominal concurrency limit (NominalCL).
	// When this field is left `nil`, the limit is effectively infinite.
	BorrowingLimitPercent *int32 `json:"borrowingLimitPercent,omitempty"`
}

// LimitedPriorityLevelConfigurationApplyConfiguration constructs a declarative configuration of the LimitedPriorityLevelConfiguration type for use with
// apply.
func LimitedPriorityLevelConfiguration() *LimitedPriorityLevelConfigurationApplyConfiguration {
	return &LimitedPriorityLevelConfigurationApplyConfiguration{}
}

// WithNominalConcurrencyShares sets the NominalConcurrencyShares field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NominalConcurrencyShares field is set to the value of the last call.
func (b *LimitedPriorityLevelConfigurationApplyConfiguration) WithNominalConcurrencyShares(value int32) *LimitedPriorityLevelConfigurationApplyConfiguration {
	b.NominalConcurrencyShares = &value
	return b
}

// WithLimitResponse sets the LimitResponse field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LimitResponse field is set to the value of the last call.
func (b *LimitedPriorityLevelConfigurationApplyConfiguration) WithLimitResponse(value *LimitResponseApplyConfiguration) *LimitedPriorityLevelConfigurationApplyConfiguration {
	b.LimitResponse = value
	return b
}

// WithLendablePercent sets the LendablePercent field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LendablePercent field is set to the value of the last call.
func (b *LimitedPriorityLevelConfigurationApplyConfiguration) WithLendablePercent(value int32) *LimitedPriorityLevelConfigurationApplyConfiguration {
	b.LendablePercent = &value
	return b
}

// WithBorrowingLimitPercent sets the BorrowingLimitPercent field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BorrowingLimitPercent field is set to the value of the last call.
func (b *LimitedPriorityLevelConfigurationApplyConfiguration) WithBorrowingLimitPercent(value int32) *LimitedPriorityLevelConfigurationApplyConfiguration {
	b.BorrowingLimitPercent = &value
	return b
}
