/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// ISCSIVolumeSourceApplyConfiguration represents a declarative configuration of the ISCSIVolumeSource type for use
// with apply.
//
// Represents an ISCSI disk.
// ISCSI volumes can only be mounted as read/write once.
// ISCSI volumes support ownership management and SELinux relabeling.
type ISCSIVolumeSourceApplyConfiguration struct {
	// targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port
	// is other than default (typically TCP ports 860 and 3260).
	TargetPortal *string `json:"targetPortal,omitempty"`
	// iqn is the target iSCSI Qualified Name.
	IQN *string `json:"iqn,omitempty"`
	// lun represents iSCSI Target Lun number.
	Lun *int32 `json:"lun,omitempty"`
	// iscsiInterface is the interface Name that uses an iSCSI transport.
	// Defaults to 'default' (tcp).
	ISCSIInterface *string `json:"iscsiInterface,omitempty"`
	// fsType is the filesystem type of the volume that you want to mount.
	// Tip: Ensure that the filesystem type is supported by the host operating system.
	// Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
	// TODO: how do we prevent errors in the filesystem from compromising the machine
	FSType *string `json:"fsType,omitempty"`
	// readOnly here will force the ReadOnly setting in VolumeMounts.
	// Defaults to false.
	ReadOnly *bool `json:"readOnly,omitempty"`
	// portals is the iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port
	// is other than default (typically TCP ports 860 and 3260).
	Portals []string `json:"portals,omitempty"`
	// chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
	DiscoveryCHAPAuth *bool `json:"chapAuthDiscovery,omitempty"`
	// chapAuthSession defines whether support iSCSI Session CHAP authentication
	SessionCHAPAuth *bool `json:"chapAuthSession,omitempty"`
	// secretRef is the CHAP Secret for iSCSI target and initiator authentication
	SecretRef *LocalObjectReferenceApplyConfiguration `json:"secretRef,omitempty"`
	// initiatorName is the custom iSCSI Initiator Name.
	// If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface
	// <target portal>:<volume name> will be created for the connection.
	InitiatorName *string `json:"initiatorName,omitempty"`
}

// ISCSIVolumeSourceApplyConfiguration constructs a declarative configuration of the ISCSIVolumeSource type for use with
// apply.
func ISCSIVolumeSource() *ISCSIVolumeSourceApplyConfiguration {
	return &ISCSIVolumeSourceApplyConfiguration{}
}

// WithTargetPortal sets the TargetPortal field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TargetPortal field is set to the value of the last call.
func (b *ISCSIVolumeSourceApplyConfiguration) WithTargetPortal(value string) *ISCSIVolumeSourceApplyConfiguration {
	b.TargetPortal = &value
	return b
}

// WithIQN sets the IQN field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IQN field is set to the value of the last call.
func (b *ISCSIVolumeSourceApplyConfiguration) WithIQN(value string) *ISCSIVolumeSourceApplyConfiguration {
	b.IQN = &value
	return b
}

// WithLun sets the Lun field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Lun field is set to the value of the last call.
func (b *ISCSIVolumeSourceApplyConfiguration) WithLun(value int32) *ISCSIVolumeSourceApplyConfiguration {
	b.Lun = &value
	return b
}

// WithISCSIInterface sets the ISCSIInterface field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ISCSIInterface field is set to the value of the last call.
func (b *ISCSIVolumeSourceApplyConfiguration) WithISCSIInterface(value string) *ISCSIVolumeSourceApplyConfiguration {
	b.ISCSIInterface = &value
	return b
}

// WithFSType sets the FSType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FSType field is set to the value of the last call.
func (b *ISCSIVolumeSourceApplyConfiguration) WithFSType(value string) *ISCSIVolumeSourceApplyConfiguration {
	b.FSType = &value
	return b
}

// WithReadOnly sets the ReadOnly field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ReadOnly field is set to the value of the last call.
func (b *ISCSIVolumeSourceApplyConfiguration) WithReadOnly(value bool) *ISCSIVolumeSourceApplyConfiguration {
	b.ReadOnly = &value
	return b
}

// WithPortals adds the given value to the Portals field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Portals field.
func (b *ISCSIVolumeSourceApplyConfiguration) WithPortals(values ...string) *ISCSIVolumeSourceApplyConfiguration {
	for i := range values {
		b.Portals = append(b.Portals, values[i])
	}
	return b
}

// WithDiscoveryCHAPAuth sets the DiscoveryCHAPAuth field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DiscoveryCHAPAuth field is set to the value of the last call.
func (b *ISCSIVolumeSourceApplyConfiguration) WithDiscoveryCHAPAuth(value bool) *ISCSIVolumeSourceApplyConfiguration {
	b.DiscoveryCHAPAuth = &value
	return b
}

// WithSessionCHAPAuth sets the SessionCHAPAuth field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SessionCHAPAuth field is set to the value of the last call.
func (b *ISCSIVolumeSourceApplyConfiguration) WithSessionCHAPAuth(value bool) *ISCSIVolumeSourceApplyConfiguration {
	b.SessionCHAPAuth = &value
	return b
}

// WithSecretRef sets the SecretRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecretRef field is set to the value of the last call.
func (b *ISCSIVolumeSourceApplyConfiguration) WithSecretRef(value *LocalObjectReferenceApplyConfiguration) *ISCSIVolumeSourceApplyConfiguration {
	b.SecretRef = value
	return b
}

// WithInitiatorName sets the InitiatorName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the InitiatorName field is set to the value of the last call.
func (b *ISCSIVolumeSourceApplyConfiguration) WithInitiatorName(value string) *ISCSIVolumeSourceApplyConfiguration {
	b.InitiatorName = &value
	return b
}
