/* This file is part of the Spring engine (GPL v2 or later), see LICENSE.html */

#include <glad/glad.h>
#include <type_traits>

int GLAD_GL_VERSION_1_0 = 0;
int GLAD_GL_VERSION_1_1 = 0;
int GLAD_GL_VERSION_1_2 = 0;
int GLAD_GL_VERSION_1_3 = 0;
int GLAD_GL_VERSION_1_4 = 0;
int GLAD_GL_VERSION_1_5 = 0;
int GLAD_GL_VERSION_2_0 = 0;
int GLAD_GL_VERSION_2_1 = 0;
int GLAD_GL_VERSION_3_0 = 0;
int GLAD_GL_VERSION_3_1 = 0;
int GLAD_GL_VERSION_3_2 = 0;
int GLAD_GL_VERSION_3_3 = 0;
int GLAD_GL_VERSION_4_0 = 0;
int GLAD_GL_VERSION_4_1 = 0;
int GLAD_GL_VERSION_4_2 = 0;
int GLAD_GL_VERSION_4_3 = 0;
int GLAD_GL_VERSION_4_4 = 0;
int GLAD_GL_VERSION_4_5 = 0;
int GLAD_GL_VERSION_4_6 = 0;

int GLAD_GL_NV_primitive_restart = 0;
int GLAD_GL_EXT_texture_filter_anisotropic = 0;
int GLAD_GL_EXT_texture_array = 0;
int GLAD_GL_EXT_stencil_two_side = 0;
int GLAD_GL_EXT_pixel_buffer_object = 0;
int GLAD_GL_EXT_framebuffer_object = 0;
int GLAD_GL_EXT_framebuffer_multisample = 0;
int GLAD_GL_EXT_framebuffer_blit = 0;
int GLAD_GL_EXT_blend_func_separate = 0;
int GLAD_GL_EXT_blend_equation_separate = 0;
int GLAD_GL_ARB_vertex_shader = 0;
int GLAD_GL_ARB_vertex_program = 0;
int GLAD_GL_ARB_vertex_buffer_object = 0;
int GLAD_GL_ARB_vertex_array_object = 0;
int GLAD_GL_ARB_uniform_buffer_object = 0;
int GLAD_GL_ARB_timer_query = 0;
int GLAD_GL_ARB_texture_storage = 0;
int GLAD_GL_ARB_texture_rectangle = 0;
int GLAD_GL_ARB_texture_query_lod = 0;
int GLAD_GL_ARB_texture_non_power_of_two = 1;
int GLAD_GL_ARB_texture_float = 1;
int GLAD_GL_ARB_texture_env_combine = 1;
int GLAD_GL_ARB_texture_compression = 1;
int GLAD_GL_ARB_sync = 0;
int GLAD_GL_ARB_shading_language_420pack = 0;
int GLAD_GL_ARB_shading_language_100 = 0;
int GLAD_GL_ARB_shader_storage_buffer_object = 0;
int GLAD_GL_ARB_seamless_cube_map = 0;
int GLAD_GL_ARB_occlusion_query = 0;
int GLAD_GL_ARB_multi_draw_indirect = 0;
int GLAD_GL_ARB_multitexture = 1;
int GLAD_GL_ARB_multisample = 0;
int GLAD_GL_ARB_map_buffer_range = 0;
int GLAD_GL_ARB_invalidate_subdata = 0;
int GLAD_GL_ARB_instanced_arrays = 0;
int GLAD_GL_ARB_imaging = 0;
int GLAD_GL_ARB_framebuffer_object = 1;
int GLAD_GL_ARB_fragment_shader = 0;
int GLAD_GL_ARB_fragment_program = 0;
int GLAD_GL_ARB_explicit_attrib_location = 0;
int GLAD_GL_ARB_draw_elements_base_vertex = 0;
int GLAD_GL_ARB_draw_buffers = 0;
int GLAD_GL_ARB_depth_clamp = 0;
int GLAD_GL_ARB_copy_image = 0;
int GLAD_GL_ARB_copy_buffer = 0;
int GLAD_GL_ARB_conservative_depth = 0;
int GLAD_GL_ARB_clip_control = 0;
int GLAD_GL_ARB_buffer_storage = 0;
int GLAD_GL_KHR_debug = 0;

GLenum APIENTRY impl_glCheckFramebufferStatus(GLenum target) {
    return GL_FRAMEBUFFER_COMPLETE;
}

void APIENTRY impl_glGetActiveUniformsiv(GLuint program, GLsizei uniformCount, const GLuint* uniformIndices, GLenum pname, GLint* params) {
    for (GLsizei i = 0; i < uniformCount; ++i)
        params[i] = 0;
}
GLint APIENTRY impl_glGetAttribLocation(GLuint program, const GLchar* name) { return -1; }

GLboolean APIENTRY impl_glIsBuffer(GLuint buffer) { return GL_TRUE; }
void APIENTRY impl_glGetBufferParameteriv(GLenum target, GLenum pname, GLint* params) { *params = 0; }

GLsync APIENTRY impl_glFenceSync(GLenum condition, GLbitfield flags) {
    static GLsync dummy;
    return dummy;
}
GLenum APIENTRY impl_glClientWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout) { return GL_ALREADY_SIGNALED; }
GLboolean APIENTRY impl_glIsSync(GLsync sync) { return GL_TRUE; }

void APIENTRY impl_glGetFloatv(GLenum pname, GLfloat* params) {
    *params = 0;
}

void APIENTRY impl_glGetBooleanv(GLenum pname, GLboolean* params) {
    *params = 0;
}

GLuint APIENTRY impl_glGenLists(GLsizei range) {
    return 0;
}

const GLubyte* APIENTRY impl_glGetString(GLenum name) {
    return (const GLubyte*)"";
}

decltype(glad_glActiveTexture) glad_glActiveTexture = nullptr;
decltype(glad_glAlphaFunc) glad_glAlphaFunc = nullptr;
decltype(glad_glAttachShader) glad_glAttachShader = nullptr;
decltype(glad_glBegin) glad_glBegin = nullptr;
decltype(glad_glBeginConditionalRender) glad_glBeginConditionalRender = nullptr;
decltype(glad_glBeginQuery) glad_glBeginQuery = nullptr;
decltype(glad_glBindAttribLocation) glad_glBindAttribLocation = nullptr;
decltype(glad_glBindFragDataLocation) glad_glBindFragDataLocation = nullptr;
decltype(glad_glBindBuffer) glad_glBindBuffer = nullptr;
decltype(glad_glBindBufferBase) glad_glBindBufferBase = nullptr;
decltype(glad_glBindBufferRange) glad_glBindBufferRange = nullptr;
decltype(glad_glBindFramebuffer) glad_glBindFramebuffer = nullptr;
decltype(glad_glBindImageTexture) glad_glBindImageTexture = nullptr;
decltype(glad_glBindRenderbuffer) glad_glBindRenderbuffer = nullptr;
decltype(glad_glBindTexture) glad_glBindTexture = nullptr;
decltype(glad_glBindVertexArray) glad_glBindVertexArray = nullptr;
decltype(glad_glBlendColor) glad_glBlendColor = nullptr;
decltype(glad_glBlendEquation) glad_glBlendEquation = nullptr;
decltype(glad_glBlendEquationSeparate) glad_glBlendEquationSeparate = nullptr;
decltype(glad_glBlendFunc) glad_glBlendFunc = nullptr;
decltype(glad_glBlendFuncSeparate) glad_glBlendFuncSeparate = nullptr;
decltype(glad_glBlendFuncSeparatei) glad_glBlendFuncSeparatei = nullptr;
decltype(glad_glBlitFramebuffer) glad_glBlitFramebuffer = nullptr;
decltype(glad_glBufferData) glad_glBufferData = nullptr;
decltype(glad_glBufferStorage) glad_glBufferStorage = nullptr;
decltype(glad_glBufferSubData) glad_glBufferSubData = nullptr;
decltype(glad_glCallList) glad_glCallList = nullptr;
decltype(glad_glCheckFramebufferStatus) glad_glCheckFramebufferStatus = nullptr;
decltype(glad_glClear) glad_glClear = nullptr;
decltype(glad_glClearAccum) glad_glClearAccum = nullptr;
decltype(glad_glClearBufferData) glad_glClearBufferData = nullptr;
decltype(glad_glClearColor) glad_glClearColor = nullptr;
decltype(glad_glClearDepth) glad_glClearDepth = nullptr;
decltype(glad_glClearStencil) glad_glClearStencil = nullptr;
decltype(glad_glClientActiveTexture) glad_glClientActiveTexture = nullptr;
decltype(glad_glClientWaitSync) glad_glClientWaitSync = nullptr;
decltype(glad_glClipPlane) glad_glClipPlane = nullptr;
decltype(glad_glColor3f) glad_glColor3f = nullptr;
decltype(glad_glColor3fv) glad_glColor3fv = nullptr;
decltype(glad_glColor3ub) glad_glColor3ub = nullptr;
decltype(glad_glColor3ubv) glad_glColor3ubv = nullptr;
decltype(glad_glColor4f) glad_glColor4f = nullptr;
decltype(glad_glColor4fv) glad_glColor4fv = nullptr;
decltype(glad_glColor4ub) glad_glColor4ub = nullptr;
decltype(glad_glColor4ubv) glad_glColor4ubv = nullptr;
decltype(glad_glColorMask) glad_glColorMask = nullptr;
decltype(glad_glColorPointer) glad_glColorPointer = nullptr;
decltype(glad_glCompileShader) glad_glCompileShader = nullptr;
decltype(glad_glCompressedTexImage2D) glad_glCompressedTexImage2D = nullptr;
decltype(glad_glCompressedTexSubImage1D) glad_glCompressedTexSubImage1D = nullptr;
decltype(glad_glCompressedTexSubImage2D) glad_glCompressedTexSubImage2D = nullptr;
decltype(glad_glCompressedTexSubImage3D) glad_glCompressedTexSubImage3D = nullptr;
decltype(glad_glCopyBufferSubData) glad_glCopyBufferSubData = nullptr;
decltype(glad_glCopyImageSubData) glad_glCopyImageSubData = nullptr;
decltype(glad_glCopyTexImage2D) glad_glCopyTexImage2D = nullptr;
decltype(glad_glCopyTexSubImage2D) glad_glCopyTexSubImage2D = nullptr;
decltype(glad_glCopyTexSubImage3D) glad_glCopyTexSubImage3D = nullptr;
decltype(glad_glCreateProgram) glad_glCreateProgram = nullptr;
decltype(glad_glCreateShader) glad_glCreateShader = nullptr;
decltype(glad_glCullFace) glad_glCullFace = nullptr;
decltype(glad_glDeleteBuffers) glad_glDeleteBuffers = nullptr;
decltype(glad_glDeleteFramebuffers) glad_glDeleteFramebuffers = nullptr;
decltype(glad_glDeleteLists) glad_glDeleteLists = nullptr;
decltype(glad_glDeleteProgram) glad_glDeleteProgram = nullptr;
decltype(glad_glDeleteQueries) glad_glDeleteQueries = nullptr;
decltype(glad_glDeleteRenderbuffers) glad_glDeleteRenderbuffers = nullptr;
decltype(glad_glDeleteShader) glad_glDeleteShader = nullptr;
decltype(glad_glDeleteSync) glad_glDeleteSync = nullptr;
decltype(glad_glDeleteTextures) glad_glDeleteTextures = nullptr;
decltype(glad_glDeleteVertexArrays) glad_glDeleteVertexArrays = nullptr;
decltype(glad_glDepthFunc) glad_glDepthFunc = nullptr;
decltype(glad_glDepthMask) glad_glDepthMask = nullptr;
decltype(glad_glDepthRange) glad_glDepthRange = nullptr;
decltype(glad_glDepthRangef) glad_glDepthRangef = nullptr;
decltype(glad_glDetachShader) glad_glDetachShader = nullptr;
decltype(glad_glDisable) glad_glDisable = nullptr;
decltype(glad_glDisableClientState) glad_glDisableClientState = nullptr;
decltype(glad_glDisableVertexAttribArray) glad_glDisableVertexAttribArray = nullptr;
decltype(glad_glDispatchCompute) glad_glDispatchCompute = nullptr;
decltype(glad_glDrawArrays) glad_glDrawArrays = nullptr;
decltype(glad_glDrawArraysInstanced) glad_glDrawArraysInstanced = nullptr;
decltype(glad_glDrawArraysInstancedBaseInstance) glad_glDrawArraysInstancedBaseInstance = nullptr;
decltype(glad_glDrawBuffer) glad_glDrawBuffer = nullptr;
decltype(glad_glDrawBuffers) glad_glDrawBuffers = nullptr;
decltype(glad_glDrawElements) glad_glDrawElements = nullptr;
decltype(glad_glDrawElementsBaseVertex) glad_glDrawElementsBaseVertex = nullptr;
decltype(glad_glDrawElementsIndirect) glad_glDrawElementsIndirect = nullptr;
decltype(glad_glDrawElementsInstanced) glad_glDrawElementsInstanced = nullptr;
decltype(glad_glDrawElementsInstancedBaseInstance) glad_glDrawElementsInstancedBaseInstance = nullptr;
decltype(glad_glDrawElementsInstancedBaseVertex) glad_glDrawElementsInstancedBaseVertex = nullptr;
decltype(glad_glDrawElementsInstancedBaseVertexBaseInstance) glad_glDrawElementsInstancedBaseVertexBaseInstance = nullptr;
decltype(glad_glDrawRangeElements) glad_glDrawRangeElements = nullptr;
decltype(glad_glEdgeFlag) glad_glEdgeFlag = nullptr;
decltype(glad_glEnable) glad_glEnable = nullptr;
decltype(glad_glEnableClientState) glad_glEnableClientState = nullptr;
decltype(glad_glEnableVertexAttribArray) glad_glEnableVertexAttribArray = nullptr;
decltype(glad_glEnd) glad_glEnd = nullptr;
decltype(glad_glEndConditionalRender) glad_glEndConditionalRender = nullptr;
decltype(glad_glEndList) glad_glEndList = nullptr;
decltype(glad_glEndQuery) glad_glEndQuery = nullptr;
decltype(glad_glEvalCoord1f) glad_glEvalCoord1f = nullptr;
decltype(glad_glEvalCoord2f) glad_glEvalCoord2f = nullptr;
decltype(glad_glEvalMesh1) glad_glEvalMesh1 = nullptr;
decltype(glad_glEvalMesh2) glad_glEvalMesh2 = nullptr;
decltype(glad_glEvalPoint1) glad_glEvalPoint1 = nullptr;
decltype(glad_glEvalPoint2) glad_glEvalPoint2 = nullptr;
decltype(glad_glFenceSync) glad_glFenceSync = nullptr;
decltype(glad_glFinish) glad_glFinish = nullptr;
decltype(glad_glFlush) glad_glFlush = nullptr;
decltype(glad_glFlushMappedBufferRange) glad_glFlushMappedBufferRange = nullptr;
decltype(glad_glFogCoordf) glad_glFogCoordf = nullptr;
decltype(glad_glFogf) glad_glFogf = nullptr;
decltype(glad_glFogfv) glad_glFogfv = nullptr;
decltype(glad_glFogi) glad_glFogi = nullptr;
decltype(glad_glFramebufferRenderbuffer) glad_glFramebufferRenderbuffer = nullptr;
decltype(glad_glFramebufferTexture) glad_glFramebufferTexture = nullptr;
decltype(glad_glFramebufferTexture1D) glad_glFramebufferTexture1D = nullptr;
decltype(glad_glFramebufferTexture2D) glad_glFramebufferTexture2D = nullptr;
decltype(glad_glFramebufferTexture3D) glad_glFramebufferTexture3D = nullptr;
decltype(glad_glFrontFace) glad_glFrontFace = nullptr;
decltype(glad_glFrustum) glad_glFrustum = nullptr;
decltype(glad_glGenBuffers) glad_glGenBuffers = nullptr;
decltype(glad_glGenFramebuffers) glad_glGenFramebuffers = nullptr;
decltype(glad_glGenLists) glad_glGenLists = nullptr;
decltype(glad_glGenQueries) glad_glGenQueries = nullptr;
decltype(glad_glGenRenderbuffers) glad_glGenRenderbuffers = nullptr;
decltype(glad_glGenTextures) glad_glGenTextures = nullptr;
decltype(glad_glGenVertexArrays) glad_glGenVertexArrays = nullptr;
decltype(glad_glGenerateMipmap) glad_glGenerateMipmap = nullptr;
decltype(glad_glGetActiveAttrib) glad_glGetActiveAttrib = nullptr;
decltype(glad_glGetActiveUniform) glad_glGetActiveUniform = nullptr;
decltype(glad_glGetActiveUniformsiv) glad_glGetActiveUniformsiv = nullptr;
decltype(glad_glGetAttribLocation) glad_glGetAttribLocation = nullptr;
decltype(glad_glGetBooleanv) glad_glGetBooleanv = nullptr;
decltype(glad_glGetBufferParameteriv) glad_glGetBufferParameteriv = nullptr;
decltype(glad_glGetCompressedTexImage) glad_glGetCompressedTexImage = nullptr;
decltype(glad_glGetError) glad_glGetError = nullptr;
decltype(glad_glGetFloatv) glad_glGetFloatv = nullptr;
decltype(glad_glGetFramebufferAttachmentParameteriv) glad_glGetFramebufferAttachmentParameteriv = nullptr;
decltype(glad_glGetFramebufferParameteriv) glad_glGetFramebufferParameteriv = nullptr;
decltype(glad_glGetIntegeri_v) glad_glGetIntegeri_v = nullptr;
decltype(glad_glGetIntegerv) glad_glGetIntegerv = nullptr;
decltype(glad_glGetProgramInfoLog) glad_glGetProgramInfoLog = nullptr;
decltype(glad_glGetProgramiv) glad_glGetProgramiv = nullptr;
decltype(glad_glGetQueryObjectiv) glad_glGetQueryObjectiv = nullptr;
decltype(glad_glGetQueryObjectui64v) glad_glGetQueryObjectui64v = nullptr;
decltype(glad_glGetQueryObjectuiv) glad_glGetQueryObjectuiv = nullptr;
decltype(glad_glGetQueryiv) glad_glGetQueryiv = nullptr;
decltype(glad_glGetRenderbufferParameteriv) glad_glGetRenderbufferParameteriv = nullptr;
decltype(glad_glGetShaderInfoLog) glad_glGetShaderInfoLog = nullptr;
decltype(glad_glGetShaderSource) glad_glGetShaderSource = nullptr;
decltype(glad_glGetShaderiv) glad_glGetShaderiv = nullptr;
decltype(glad_glGetString) glad_glGetString = nullptr;
decltype(glad_glGetSubroutineIndex) glad_glGetSubroutineIndex = nullptr;
decltype(glad_glGetTexImage) glad_glGetTexImage = nullptr;
decltype(glad_glGetTexLevelParameteriv) glad_glGetTexLevelParameteriv = nullptr;
decltype(glad_glGetUniformLocation) glad_glGetUniformLocation = nullptr;
decltype(glad_glGetUniformfv) glad_glGetUniformfv = nullptr;
decltype(glad_glGetUniformiv) glad_glGetUniformiv = nullptr;
decltype(glad_glGetUniformuiv) glad_glGetUniformuiv = nullptr;
decltype(glad_glHint) glad_glHint = nullptr;
decltype(glad_glInitNames) glad_glInitNames = nullptr;
decltype(glad_glIsBuffer) glad_glIsBuffer = nullptr;
decltype(glad_glIsEnabled) glad_glIsEnabled = nullptr;
decltype(glad_glIsProgram) glad_glIsProgram = nullptr;
decltype(glad_glIsRenderbuffer) glad_glIsRenderbuffer = nullptr;
decltype(glad_glIsShader) glad_glIsShader = nullptr;
decltype(glad_glIsSync) glad_glIsSync = nullptr;
decltype(glad_glIsTexture) glad_glIsTexture = nullptr;
decltype(glad_glLightModelfv) glad_glLightModelfv = nullptr;
decltype(glad_glLightModeli) glad_glLightModeli = nullptr;
decltype(glad_glLightf) glad_glLightf = nullptr;
decltype(glad_glLightfv) glad_glLightfv = nullptr;
decltype(glad_glLineStipple) glad_glLineStipple = nullptr;
decltype(glad_glLineWidth) glad_glLineWidth = nullptr;
decltype(glad_glLinkProgram) glad_glLinkProgram = nullptr;
decltype(glad_glLoadIdentity) glad_glLoadIdentity = nullptr;
decltype(glad_glLoadMatrixd) glad_glLoadMatrixd = nullptr;
decltype(glad_glLoadMatrixf) glad_glLoadMatrixf = nullptr;
decltype(glad_glLoadName) glad_glLoadName = nullptr;
decltype(glad_glLogicOp) glad_glLogicOp = nullptr;
decltype(glad_glMap1f) glad_glMap1f = nullptr;
decltype(glad_glMap2f) glad_glMap2f = nullptr;
decltype(glad_glMapBuffer) glad_glMapBuffer = nullptr;
decltype(glad_glMapBufferRange) glad_glMapBufferRange = nullptr;
decltype(glad_glMapGrid1f) glad_glMapGrid1f = nullptr;
decltype(glad_glMapGrid2f) glad_glMapGrid2f = nullptr;
decltype(glad_glMaterialf) glad_glMaterialf = nullptr;
decltype(glad_glMaterialfv) glad_glMaterialfv = nullptr;
decltype(glad_glMatrixMode) glad_glMatrixMode = nullptr;
decltype(glad_glMemoryBarrier) glad_glMemoryBarrier = nullptr;
decltype(glad_glMinSampleShading) glad_glMinSampleShading = nullptr;
decltype(glad_glMultMatrixd) glad_glMultMatrixd = nullptr;
decltype(glad_glMultMatrixf) glad_glMultMatrixf = nullptr;
decltype(glad_glMultiDrawElementsIndirect) glad_glMultiDrawElementsIndirect = nullptr;
decltype(glad_glMultiTexCoord1f) glad_glMultiTexCoord1f = nullptr;
decltype(glad_glMultiTexCoord2f) glad_glMultiTexCoord2f = nullptr;
decltype(glad_glMultiTexCoord2i) glad_glMultiTexCoord2i = nullptr;
decltype(glad_glMultiTexCoord2iv) glad_glMultiTexCoord2iv = nullptr;
decltype(glad_glMultiTexCoord3f) glad_glMultiTexCoord3f = nullptr;
decltype(glad_glMultiTexCoord4f) glad_glMultiTexCoord4f = nullptr;
decltype(glad_glNewList) glad_glNewList = nullptr;
decltype(glad_glNormal3f) glad_glNormal3f = nullptr;
decltype(glad_glNormal3fv) glad_glNormal3fv = nullptr;
decltype(glad_glNormalPointer) glad_glNormalPointer = nullptr;
decltype(glad_glOrtho) glad_glOrtho = nullptr;
decltype(glad_glPatchParameterfv) glad_glPatchParameterfv = nullptr;
decltype(glad_glPatchParameteri) glad_glPatchParameteri = nullptr;
decltype(glad_glPixelStorei) glad_glPixelStorei = nullptr;
decltype(glad_glPointParameterf) glad_glPointParameterf = nullptr;
decltype(glad_glPointParameterfv) glad_glPointParameterfv = nullptr;
decltype(glad_glPointSize) glad_glPointSize = nullptr;
decltype(glad_glPolygonMode) glad_glPolygonMode = nullptr;
decltype(glad_glPolygonOffset) glad_glPolygonOffset = nullptr;
decltype(glad_glPopAttrib) glad_glPopAttrib = nullptr;
decltype(glad_glPopMatrix) glad_glPopMatrix = nullptr;
decltype(glad_glPopName) glad_glPopName = nullptr;
decltype(glad_glPrimitiveRestartIndex) glad_glPrimitiveRestartIndex = nullptr;
decltype(glad_glProgramParameteri) glad_glProgramParameteri = nullptr;
decltype(glad_glPushAttrib) glad_glPushAttrib = nullptr;
decltype(glad_glPushMatrix) glad_glPushMatrix = nullptr;
decltype(glad_glPushName) glad_glPushName = nullptr;
decltype(glad_glQueryCounter) glad_glQueryCounter = nullptr;
decltype(glad_glReadBuffer) glad_glReadBuffer = nullptr;
decltype(glad_glReadPixels) glad_glReadPixels = nullptr;
decltype(glad_glRectf) glad_glRectf = nullptr;
decltype(glad_glRenderMode) glad_glRenderMode = nullptr;
decltype(glad_glRenderbufferStorage) glad_glRenderbufferStorage = nullptr;
decltype(glad_glRenderbufferStorageMultisample) glad_glRenderbufferStorageMultisample = nullptr;
decltype(glad_glRotatef) glad_glRotatef = nullptr;
decltype(glad_glScalef) glad_glScalef = nullptr;
decltype(glad_glScissor) glad_glScissor = nullptr;
decltype(glad_glSecondaryColor3f) glad_glSecondaryColor3f = nullptr;
decltype(glad_glSelectBuffer) glad_glSelectBuffer = nullptr;
decltype(glad_glShadeModel) glad_glShadeModel = nullptr;
decltype(glad_glShaderSource) glad_glShaderSource = nullptr;
decltype(glad_glStencilFunc) glad_glStencilFunc = nullptr;
decltype(glad_glStencilFuncSeparate) glad_glStencilFuncSeparate = nullptr;
decltype(glad_glStencilMask) glad_glStencilMask = nullptr;
decltype(glad_glStencilMaskSeparate) glad_glStencilMaskSeparate = nullptr;
decltype(glad_glStencilOp) glad_glStencilOp = nullptr;
decltype(glad_glStencilOpSeparate) glad_glStencilOpSeparate = nullptr;
decltype(glad_glTexCoord1f) glad_glTexCoord1f = nullptr;
decltype(glad_glTexCoord2f) glad_glTexCoord2f = nullptr;
decltype(glad_glTexCoord2fv) glad_glTexCoord2fv = nullptr;
decltype(glad_glTexCoord2i) glad_glTexCoord2i = nullptr;
decltype(glad_glTexCoord3f) glad_glTexCoord3f = nullptr;
decltype(glad_glTexCoord4f) glad_glTexCoord4f = nullptr;
decltype(glad_glTexCoordPointer) glad_glTexCoordPointer = nullptr;
decltype(glad_glTexEnvf) glad_glTexEnvf = nullptr;
decltype(glad_glTexEnvfv) glad_glTexEnvfv = nullptr;
decltype(glad_glTexEnvi) glad_glTexEnvi = nullptr;
decltype(glad_glTexGenf) glad_glTexGenf = nullptr;
decltype(glad_glTexGenfv) glad_glTexGenfv = nullptr;
decltype(glad_glTexGeni) glad_glTexGeni = nullptr;
decltype(glad_glTexImage1D) glad_glTexImage1D = nullptr;
decltype(glad_glTexImage2D) glad_glTexImage2D = nullptr;
decltype(glad_glTexImage2DMultisample) glad_glTexImage2DMultisample = nullptr;
decltype(glad_glTexImage3D) glad_glTexImage3D = nullptr;
decltype(glad_glTexParameterf) glad_glTexParameterf = nullptr;
decltype(glad_glTexParameterfv) glad_glTexParameterfv = nullptr;
decltype(glad_glTexParameteri) glad_glTexParameteri = nullptr;
decltype(glad_glTexParameteriv) glad_glTexParameteriv = nullptr;
decltype(glad_glTexStorage2D) glad_glTexStorage2D = nullptr;
decltype(glad_glTexStorage3D) glad_glTexStorage3D = nullptr;
decltype(glad_glTexSubImage2D) glad_glTexSubImage2D = nullptr;
decltype(glad_glTexSubImage3D) glad_glTexSubImage3D = nullptr;
decltype(glad_glTranslatef) glad_glTranslatef = nullptr;
decltype(glad_glUniform1f) glad_glUniform1f = nullptr;
decltype(glad_glUniform1fv) glad_glUniform1fv = nullptr;
decltype(glad_glUniform1i) glad_glUniform1i = nullptr;
decltype(glad_glUniform1iv) glad_glUniform1iv = nullptr;
decltype(glad_glUniform1uiv) glad_glUniform1uiv = nullptr;
decltype(glad_glUniform2f) glad_glUniform2f = nullptr;
decltype(glad_glUniform2fv) glad_glUniform2fv = nullptr;
decltype(glad_glUniform2i) glad_glUniform2i = nullptr;
decltype(glad_glUniform2iv) glad_glUniform2iv = nullptr;
decltype(glad_glUniform2uiv) glad_glUniform2uiv = nullptr;
decltype(glad_glUniform3f) glad_glUniform3f = nullptr;
decltype(glad_glUniform3fv) glad_glUniform3fv = nullptr;
decltype(glad_glUniform3i) glad_glUniform3i = nullptr;
decltype(glad_glUniform3iv) glad_glUniform3iv = nullptr;
decltype(glad_glUniform3uiv) glad_glUniform3uiv = nullptr;
decltype(glad_glUniform4f) glad_glUniform4f = nullptr;
decltype(glad_glUniform4fv) glad_glUniform4fv = nullptr;
decltype(glad_glUniform4i) glad_glUniform4i = nullptr;
decltype(glad_glUniform4iv) glad_glUniform4iv = nullptr;
decltype(glad_glUniform4uiv) glad_glUniform4uiv = nullptr;
decltype(glad_glUniformMatrix2fv) glad_glUniformMatrix2fv = nullptr;
decltype(glad_glUniformMatrix3fv) glad_glUniformMatrix3fv = nullptr;
decltype(glad_glUniformMatrix4fv) glad_glUniformMatrix4fv = nullptr;
decltype(glad_glUniformSubroutinesuiv) glad_glUniformSubroutinesuiv = nullptr;
decltype(glad_glUnmapBuffer) glad_glUnmapBuffer = nullptr;
decltype(glad_glUseProgram) glad_glUseProgram = nullptr;
decltype(glad_glValidateProgram) glad_glValidateProgram = nullptr;
decltype(glad_glVertex2f) glad_glVertex2f = nullptr;
decltype(glad_glVertex3f) glad_glVertex3f = nullptr;
decltype(glad_glVertex3fv) glad_glVertex3fv = nullptr;
decltype(glad_glVertex4f) glad_glVertex4f = nullptr;
decltype(glad_glVertexAttribDivisor) glad_glVertexAttribDivisor = nullptr;
decltype(glad_glVertexAttribIPointer) glad_glVertexAttribIPointer = nullptr;
decltype(glad_glVertexAttribPointer) glad_glVertexAttribPointer = nullptr;
decltype(glad_glVertexPointer) glad_glVertexPointer = nullptr;
decltype(glad_glViewport) glad_glViewport = nullptr;
decltype(glad_glDrawBuffersARB) glad_glDrawBuffersARB = nullptr;
decltype(glad_glProgramStringARB) glad_glProgramStringARB = nullptr;
decltype(glad_glBindProgramARB) glad_glBindProgramARB = nullptr;
decltype(glad_glDeleteProgramsARB) glad_glDeleteProgramsARB = nullptr;
decltype(glad_glGenProgramsARB) glad_glGenProgramsARB = nullptr;
decltype(glad_glProgramEnvParameter4dARB) glad_glProgramEnvParameter4dARB = nullptr;
decltype(glad_glProgramEnvParameter4dvARB) glad_glProgramEnvParameter4dvARB = nullptr;
decltype(glad_glProgramEnvParameter4fARB) glad_glProgramEnvParameter4fARB = nullptr;
decltype(glad_glProgramEnvParameter4fvARB) glad_glProgramEnvParameter4fvARB = nullptr;
decltype(glad_glProgramLocalParameter4dARB) glad_glProgramLocalParameter4dARB = nullptr;
decltype(glad_glProgramLocalParameter4dvARB) glad_glProgramLocalParameter4dvARB = nullptr;
decltype(glad_glProgramLocalParameter4fARB) glad_glProgramLocalParameter4fARB = nullptr;
decltype(glad_glProgramLocalParameter4fvARB) glad_glProgramLocalParameter4fvARB = nullptr;
decltype(glad_glGetProgramEnvParameterdvARB) glad_glGetProgramEnvParameterdvARB = nullptr;
decltype(glad_glGetProgramEnvParameterfvARB) glad_glGetProgramEnvParameterfvARB = nullptr;
decltype(glad_glGetProgramLocalParameterdvARB) glad_glGetProgramLocalParameterdvARB = nullptr;
decltype(glad_glGetProgramLocalParameterfvARB) glad_glGetProgramLocalParameterfvARB = nullptr;
decltype(glad_glGetProgramivARB) glad_glGetProgramivARB = nullptr;
decltype(glad_glActiveTextureARB) glad_glActiveTextureARB = nullptr;
decltype(glad_glClientActiveTextureARB) glad_glClientActiveTextureARB = nullptr;
decltype(glad_glMultiTexCoord2fARB) glad_glMultiTexCoord2fARB = nullptr;
decltype(glad_glMultiTexCoord2iARB) glad_glMultiTexCoord2iARB = nullptr;
decltype(glad_glMultiTexCoord2ivARB) glad_glMultiTexCoord2ivARB = nullptr;
decltype(glad_glDeleteObjectARB) glad_glDeleteObjectARB = nullptr;
decltype(glad_glGetHandleARB) glad_glGetHandleARB = nullptr;
decltype(glad_glDetachObjectARB) glad_glDetachObjectARB = nullptr;
decltype(glad_glCreateShaderObjectARB) glad_glCreateShaderObjectARB = nullptr;
decltype(glad_glShaderSourceARB) glad_glShaderSourceARB = nullptr;
decltype(glad_glCompileShaderARB) glad_glCompileShaderARB = nullptr;
decltype(glad_glCreateProgramObjectARB) glad_glCreateProgramObjectARB = nullptr;
decltype(glad_glAttachObjectARB) glad_glAttachObjectARB = nullptr;
decltype(glad_glLinkProgramARB) glad_glLinkProgramARB = nullptr;
decltype(glad_glUseProgramObjectARB) glad_glUseProgramObjectARB = nullptr;
decltype(glad_glValidateProgramARB) glad_glValidateProgramARB = nullptr;
decltype(glad_glUniform1fARB) glad_glUniform1fARB = nullptr;
decltype(glad_glUniform2fARB) glad_glUniform2fARB = nullptr;
decltype(glad_glUniform3fARB) glad_glUniform3fARB = nullptr;
decltype(glad_glUniform4fARB) glad_glUniform4fARB = nullptr;
decltype(glad_glUniform1iARB) glad_glUniform1iARB = nullptr;
decltype(glad_glUniform2iARB) glad_glUniform2iARB = nullptr;
decltype(glad_glUniform3iARB) glad_glUniform3iARB = nullptr;
decltype(glad_glUniform4iARB) glad_glUniform4iARB = nullptr;
decltype(glad_glUniform1fvARB) glad_glUniform1fvARB = nullptr;
decltype(glad_glUniform2fvARB) glad_glUniform2fvARB = nullptr;
decltype(glad_glUniform3fvARB) glad_glUniform3fvARB = nullptr;
decltype(glad_glUniform4fvARB) glad_glUniform4fvARB = nullptr;
decltype(glad_glUniform1ivARB) glad_glUniform1ivARB = nullptr;
decltype(glad_glUniform2ivARB) glad_glUniform2ivARB = nullptr;
decltype(glad_glUniform3ivARB) glad_glUniform3ivARB = nullptr;
decltype(glad_glUniform4ivARB) glad_glUniform4ivARB = nullptr;
decltype(glad_glUniformMatrix2fvARB) glad_glUniformMatrix2fvARB = nullptr;
decltype(glad_glUniformMatrix3fvARB) glad_glUniformMatrix3fvARB = nullptr;
decltype(glad_glUniformMatrix4fvARB) glad_glUniformMatrix4fvARB = nullptr;
decltype(glad_glGetObjectParameterfvARB) glad_glGetObjectParameterfvARB = nullptr;
decltype(glad_glGetObjectParameterivARB) glad_glGetObjectParameterivARB = nullptr;
decltype(glad_glGetInfoLogARB) glad_glGetInfoLogARB = nullptr;
decltype(glad_glGetAttachedObjectsARB) glad_glGetAttachedObjectsARB = nullptr;
decltype(glad_glGetUniformLocationARB) glad_glGetUniformLocationARB = nullptr;
decltype(glad_glCompressedTexImage3DARB) glad_glCompressedTexImage3DARB = nullptr;
decltype(glad_glCompressedTexImage2DARB) glad_glCompressedTexImage2DARB = nullptr;
decltype(glad_glCompressedTexImage1DARB) glad_glCompressedTexImage1DARB = nullptr;
decltype(glad_glCompressedTexSubImage3DARB) glad_glCompressedTexSubImage3DARB = nullptr;
decltype(glad_glCompressedTexSubImage2DARB) glad_glCompressedTexSubImage2DARB = nullptr;
decltype(glad_glCompressedTexSubImage1DARB) glad_glCompressedTexSubImage1DARB = nullptr;
decltype(glad_glGetCompressedTexImageARB) glad_glGetCompressedTexImageARB = nullptr;
decltype(glad_glBindBufferARB) glad_glBindBufferARB = nullptr;
decltype(glad_glDeleteBuffersARB) glad_glDeleteBuffersARB = nullptr;
decltype(glad_glGenBuffersARB) glad_glGenBuffersARB = nullptr;
decltype(glad_glBufferDataARB) glad_glBufferDataARB = nullptr;
decltype(glad_glVertexAttribPointerARB) glad_glVertexAttribPointerARB = nullptr;
decltype(glad_glEnableVertexAttribArrayARB) glad_glEnableVertexAttribArrayARB = nullptr;
decltype(glad_glDisableVertexAttribArrayARB) glad_glDisableVertexAttribArrayARB = nullptr;
decltype(glad_glBindAttribLocationARB) glad_glBindAttribLocationARB = nullptr;
decltype(glad_glGetActiveAttribARB) glad_glGetActiveAttribARB = nullptr;
decltype(glad_glGetAttribLocationARB) glad_glGetAttribLocationARB = nullptr;
decltype(glad_glBlitFramebufferEXT) glad_glBlitFramebufferEXT = nullptr;
decltype(glad_glRenderbufferStorageMultisampleEXT) glad_glRenderbufferStorageMultisampleEXT = nullptr;
decltype(glad_glIsRenderbufferEXT) glad_glIsRenderbufferEXT = nullptr;
decltype(glad_glBindRenderbufferEXT) glad_glBindRenderbufferEXT = nullptr;
decltype(glad_glDeleteRenderbuffersEXT) glad_glDeleteRenderbuffersEXT = nullptr;
decltype(glad_glGenRenderbuffersEXT) glad_glGenRenderbuffersEXT = nullptr;
decltype(glad_glRenderbufferStorageEXT) glad_glRenderbufferStorageEXT = nullptr;
decltype(glad_glGetRenderbufferParameterivEXT) glad_glGetRenderbufferParameterivEXT = nullptr;
decltype(glad_glIsFramebufferEXT) glad_glIsFramebufferEXT = nullptr;
decltype(glad_glBindFramebufferEXT) glad_glBindFramebufferEXT = nullptr;
decltype(glad_glDeleteFramebuffersEXT) glad_glDeleteFramebuffersEXT = nullptr;
decltype(glad_glGenFramebuffersEXT) glad_glGenFramebuffersEXT = nullptr;
decltype(glad_glFramebufferTexture1DEXT) glad_glFramebufferTexture1DEXT = nullptr;
decltype(glad_glFramebufferTexture2DEXT) glad_glFramebufferTexture2DEXT = nullptr;
decltype(glad_glFramebufferTexture3DEXT) glad_glFramebufferTexture3DEXT = nullptr;
decltype(glad_glFramebufferRenderbufferEXT) glad_glFramebufferRenderbufferEXT = nullptr;
decltype(glad_glGetFramebufferAttachmentParameterivEXT) glad_glGetFramebufferAttachmentParameterivEXT = nullptr;
decltype(glad_glGenerateMipmapEXT) glad_glGenerateMipmapEXT = nullptr;
decltype(glad_glProgramParameteriEXT) glad_glProgramParameteriEXT = nullptr;
decltype(glad_glFramebufferTextureLayerEXT) glad_glFramebufferTextureLayerEXT = nullptr;
decltype(glad_glDeleteFencesNV) glad_glDeleteFencesNV = nullptr;
decltype(glad_glGenFencesNV) glad_glGenFencesNV = nullptr;
decltype(glad_glIsFenceNV) glad_glIsFenceNV = nullptr;
decltype(glad_glTestFenceNV) glad_glTestFenceNV = nullptr;
decltype(glad_glGetFenceivNV) glad_glGetFenceivNV = nullptr;
decltype(glad_glFinishFenceNV) glad_glFinishFenceNV = nullptr;
decltype(glad_glSetFenceNV) glad_glSetFenceNV = nullptr;
decltype(glad_glFramebufferTextureEXT) glad_glFramebufferTextureEXT = nullptr;
decltype(glad_glPrimitiveRestartIndexNV) glad_glPrimitiveRestartIndexNV = nullptr;
decltype(glad_glInvalidateBufferData) glad_glInvalidateBufferData = nullptr;
decltype(glad_glClipControl) glad_glClipControl = nullptr;
decltype(glad_glPushDebugGroup) glad_glPushDebugGroup = nullptr;
decltype(glad_glPopDebugGroup) glad_glPopDebugGroup = nullptr;
decltype(glad_glObjectLabel) glad_glObjectLabel = nullptr;
decltype(glad_glClearBufferuiv) glad_glClearBufferuiv = nullptr;
decltype(glad_glClearBufferiv) glad_glClearBufferiv = nullptr;
decltype(glad_glClearBufferfv) glad_glClearBufferfv = nullptr;
decltype(glad_glGetTextureSubImage) glad_glGetTextureSubImage = nullptr;

namespace Impl {
    template<typename R, typename... Args>
    auto MakeDefaultLambdaHelper(R(*)(Args...)) {
        static auto defaultLambda = [](Args...) -> R {
            if constexpr (std::is_void_v<R>) {
                return;
            }
            else {
                return R{};
            }
        };
        return defaultLambda;
    }
}

template<typename Func>
auto MakeStubImpl(Func&& func) {
    return Impl::MakeDefaultLambdaHelper(func);
}

int gladLoadGL(void) {
    glad_glActiveTexture = MakeStubImpl(glad_glActiveTexture);
    glad_glAlphaFunc = MakeStubImpl(glad_glAlphaFunc);
    glad_glAttachShader = MakeStubImpl(glad_glAttachShader);
    glad_glBegin = MakeStubImpl(glad_glBegin);
    glad_glBeginConditionalRender = MakeStubImpl(glad_glBeginConditionalRender);
    glad_glBeginQuery = MakeStubImpl(glad_glBeginQuery);
    glad_glBindAttribLocation = MakeStubImpl(glad_glBindAttribLocation);
    glad_glBindFragDataLocation = MakeStubImpl(glad_glBindFragDataLocation);
    glad_glBindBuffer = MakeStubImpl(glad_glBindBuffer);
    glad_glBindBufferBase = MakeStubImpl(glad_glBindBufferBase);
    glad_glBindBufferRange = MakeStubImpl(glad_glBindBufferRange);
    glad_glBindFramebuffer = MakeStubImpl(glad_glBindFramebuffer);
    glad_glBindImageTexture = MakeStubImpl(glad_glBindImageTexture);
    glad_glBindRenderbuffer = MakeStubImpl(glad_glBindRenderbuffer);
    glad_glBindTexture = MakeStubImpl(glad_glBindTexture);
    glad_glBindVertexArray = MakeStubImpl(glad_glBindVertexArray);
    glad_glBlendColor = MakeStubImpl(glad_glBlendColor);
    glad_glBlendEquation = MakeStubImpl(glad_glBlendEquation);
    glad_glBlendEquationSeparate = MakeStubImpl(glad_glBlendEquationSeparate);
    glad_glBlendFunc = MakeStubImpl(glad_glBlendFunc);
    glad_glBlendFuncSeparate = MakeStubImpl(glad_glBlendFuncSeparate);
    glad_glBlendFuncSeparatei = MakeStubImpl(glad_glBlendFuncSeparatei);
    glad_glBlitFramebuffer = MakeStubImpl(glad_glBlitFramebuffer);
    glad_glBufferData = MakeStubImpl(glad_glBufferData);
    glad_glBufferStorage = MakeStubImpl(glad_glBufferStorage);
    glad_glBufferSubData = MakeStubImpl(glad_glBufferSubData);
    glad_glCallList = MakeStubImpl(glad_glCallList);
    glad_glCheckFramebufferStatus = impl_glCheckFramebufferStatus;
    glad_glClear = MakeStubImpl(glad_glClear);
    glad_glClearAccum = MakeStubImpl(glad_glClearAccum);
    glad_glClearBufferData = MakeStubImpl(glad_glClearBufferData);
    glad_glClearColor = MakeStubImpl(glad_glClearColor);
    glad_glClearDepth = MakeStubImpl(glad_glClearDepth);
    glad_glClearStencil = MakeStubImpl(glad_glClearStencil);
    glad_glClientActiveTexture = MakeStubImpl(glad_glClientActiveTexture);
    glad_glClientWaitSync = impl_glClientWaitSync;
    glad_glClipPlane = MakeStubImpl(glad_glClipPlane);
    glad_glColor3f = MakeStubImpl(glad_glColor3f);
    glad_glColor3fv = MakeStubImpl(glad_glColor3fv);
    glad_glColor3ub = MakeStubImpl(glad_glColor3ub);
    glad_glColor3ubv = MakeStubImpl(glad_glColor3ubv);
    glad_glColor4f = MakeStubImpl(glad_glColor4f);
    glad_glColor4fv = MakeStubImpl(glad_glColor4fv);
    glad_glColor4ub = MakeStubImpl(glad_glColor4ub);
    glad_glColor4ubv = MakeStubImpl(glad_glColor4ubv);
    glad_glColorMask = MakeStubImpl(glad_glColorMask);
    glad_glColorPointer = MakeStubImpl(glad_glColorPointer);
    glad_glCompileShader = MakeStubImpl(glad_glCompileShader);
    glad_glCompressedTexImage2D = MakeStubImpl(glad_glCompressedTexImage2D);
    glad_glCompressedTexSubImage1D = MakeStubImpl(glad_glCompressedTexSubImage1D);
    glad_glCompressedTexSubImage2D = MakeStubImpl(glad_glCompressedTexSubImage2D);
    glad_glCompressedTexSubImage3D = MakeStubImpl(glad_glCompressedTexSubImage3D);
    glad_glCopyBufferSubData = MakeStubImpl(glad_glCopyBufferSubData);
    glad_glCopyImageSubData = MakeStubImpl(glad_glCopyImageSubData);
    glad_glCopyTexImage2D = MakeStubImpl(glad_glCopyTexImage2D);
    glad_glCopyTexSubImage2D = MakeStubImpl(glad_glCopyTexSubImage2D);
    glad_glCopyTexSubImage3D = MakeStubImpl(glad_glCopyTexSubImage3D);
    glad_glCreateProgram = MakeStubImpl(glad_glCreateProgram);
    glad_glCreateShader = MakeStubImpl(glad_glCreateShader);
    glad_glCullFace = MakeStubImpl(glad_glCullFace);
    glad_glDeleteBuffers = MakeStubImpl(glad_glDeleteBuffers);
    glad_glDeleteFramebuffers = MakeStubImpl(glad_glDeleteFramebuffers);
    glad_glDeleteLists = MakeStubImpl(glad_glDeleteLists);
    glad_glDeleteProgram = MakeStubImpl(glad_glDeleteProgram);
    glad_glDeleteQueries = MakeStubImpl(glad_glDeleteQueries);
    glad_glDeleteRenderbuffers = MakeStubImpl(glad_glDeleteRenderbuffers);
    glad_glDeleteShader = MakeStubImpl(glad_glDeleteShader);
    glad_glDeleteSync = MakeStubImpl(glad_glDeleteSync);
    glad_glDeleteTextures = MakeStubImpl(glad_glDeleteTextures);
    glad_glDeleteVertexArrays = MakeStubImpl(glad_glDeleteVertexArrays);
    glad_glDepthFunc = MakeStubImpl(glad_glDepthFunc);
    glad_glDepthMask = MakeStubImpl(glad_glDepthMask);
    glad_glDepthRange = MakeStubImpl(glad_glDepthRange);
    glad_glDepthRangef = MakeStubImpl(glad_glDepthRangef);
    glad_glDetachShader = MakeStubImpl(glad_glDetachShader);
    glad_glDisable = MakeStubImpl(glad_glDisable);
    glad_glDisableClientState = MakeStubImpl(glad_glDisableClientState);
    glad_glDisableVertexAttribArray = MakeStubImpl(glad_glDisableVertexAttribArray);
    glad_glDispatchCompute = MakeStubImpl(glad_glDispatchCompute);
    glad_glDrawArrays = MakeStubImpl(glad_glDrawArrays);
    glad_glDrawArraysInstanced = MakeStubImpl(glad_glDrawArraysInstanced);
    glad_glDrawArraysInstancedBaseInstance = MakeStubImpl(glad_glDrawArraysInstancedBaseInstance);
    glad_glDrawBuffer = MakeStubImpl(glad_glDrawBuffer);
    glad_glDrawBuffers = MakeStubImpl(glad_glDrawBuffers);
    glad_glDrawElements = MakeStubImpl(glad_glDrawElements);
    glad_glDrawElementsBaseVertex = MakeStubImpl(glad_glDrawElementsBaseVertex);
    glad_glDrawElementsIndirect = MakeStubImpl(glad_glDrawElementsIndirect);
    glad_glDrawElementsInstanced = MakeStubImpl(glad_glDrawElementsInstanced);
    glad_glDrawElementsInstancedBaseInstance = MakeStubImpl(glad_glDrawElementsInstancedBaseInstance);
    glad_glDrawElementsInstancedBaseVertex = MakeStubImpl(glad_glDrawElementsInstancedBaseVertex);
    glad_glDrawElementsInstancedBaseVertexBaseInstance = MakeStubImpl(glad_glDrawElementsInstancedBaseVertexBaseInstance);
    glad_glDrawRangeElements = MakeStubImpl(glad_glDrawRangeElements);
    glad_glEdgeFlag = MakeStubImpl(glad_glEdgeFlag);
    glad_glEnable = MakeStubImpl(glad_glEnable);
    glad_glEnableClientState = MakeStubImpl(glad_glEnableClientState);
    glad_glEnableVertexAttribArray = MakeStubImpl(glad_glEnableVertexAttribArray);
    glad_glEnd = MakeStubImpl(glad_glEnd);
    glad_glEndConditionalRender = MakeStubImpl(glad_glEndConditionalRender);
    glad_glEndList = MakeStubImpl(glad_glEndList);
    glad_glEndQuery = MakeStubImpl(glad_glEndQuery);
    glad_glEvalCoord1f = MakeStubImpl(glad_glEvalCoord1f);
    glad_glEvalCoord2f = MakeStubImpl(glad_glEvalCoord2f);
    glad_glEvalMesh1 = MakeStubImpl(glad_glEvalMesh1);
    glad_glEvalMesh2 = MakeStubImpl(glad_glEvalMesh2);
    glad_glEvalPoint1 = MakeStubImpl(glad_glEvalPoint1);
    glad_glEvalPoint2 = MakeStubImpl(glad_glEvalPoint2);
    glad_glFenceSync = impl_glFenceSync;
    glad_glFinish = MakeStubImpl(glad_glFinish);
    glad_glFlush = MakeStubImpl(glad_glFlush);
    glad_glFlushMappedBufferRange = MakeStubImpl(glad_glFlushMappedBufferRange);
    glad_glFogCoordf = MakeStubImpl(glad_glFogCoordf);
    glad_glFogf = MakeStubImpl(glad_glFogf);
    glad_glFogfv = MakeStubImpl(glad_glFogfv);
    glad_glFogi = MakeStubImpl(glad_glFogi);
    glad_glFramebufferRenderbuffer = MakeStubImpl(glad_glFramebufferRenderbuffer);
    glad_glFramebufferTexture = MakeStubImpl(glad_glFramebufferTexture);
    glad_glFramebufferTexture1D = MakeStubImpl(glad_glFramebufferTexture1D);
    glad_glFramebufferTexture2D = MakeStubImpl(glad_glFramebufferTexture2D);
    glad_glFramebufferTexture3D = MakeStubImpl(glad_glFramebufferTexture3D);
    glad_glFrontFace = MakeStubImpl(glad_glFrontFace);
    glad_glFrustum = MakeStubImpl(glad_glFrustum);
    glad_glGenBuffers = MakeStubImpl(glad_glGenBuffers);
    glad_glGenFramebuffers = MakeStubImpl(glad_glGenFramebuffers);
    glad_glGenLists = impl_glGenLists;
    glad_glGenQueries = MakeStubImpl(glad_glGenQueries);
    glad_glGenRenderbuffers = MakeStubImpl(glad_glGenRenderbuffers);
    glad_glGenTextures = MakeStubImpl(glad_glGenTextures);
    glad_glGenVertexArrays = MakeStubImpl(glad_glGenVertexArrays);
    glad_glGenerateMipmap = MakeStubImpl(glad_glGenerateMipmap);
    glad_glGetActiveAttrib = MakeStubImpl(glad_glGetActiveAttrib);
    glad_glGetActiveUniform = MakeStubImpl(glad_glGetActiveUniform);
    glad_glGetActiveUniformsiv = impl_glGetActiveUniformsiv;
    glad_glGetAttribLocation = impl_glGetAttribLocation;
    glad_glGetBooleanv = impl_glGetBooleanv;
    glad_glGetBufferParameteriv = impl_glGetBufferParameteriv;
    glad_glGetCompressedTexImage = MakeStubImpl(glad_glGetCompressedTexImage);
    glad_glGetError = MakeStubImpl(glad_glGetError);
    glad_glGetFloatv = impl_glGetFloatv;
    glad_glGetFramebufferAttachmentParameteriv = MakeStubImpl(glad_glGetFramebufferAttachmentParameteriv);
    glad_glGetFramebufferParameteriv = MakeStubImpl(glad_glGetFramebufferParameteriv);
    glad_glGetIntegeri_v = MakeStubImpl(glad_glGetIntegeri_v);
    glad_glGetIntegerv = MakeStubImpl(glad_glGetIntegerv);
    glad_glGetProgramInfoLog = MakeStubImpl(glad_glGetProgramInfoLog);
    glad_glGetProgramiv = MakeStubImpl(glad_glGetProgramiv);
    glad_glGetQueryObjectiv = MakeStubImpl(glad_glGetQueryObjectiv);
    glad_glGetQueryObjectui64v = MakeStubImpl(glad_glGetQueryObjectui64v);
    glad_glGetQueryObjectuiv = MakeStubImpl(glad_glGetQueryObjectuiv);
    glad_glGetQueryiv = MakeStubImpl(glad_glGetQueryiv);
    glad_glGetRenderbufferParameteriv = MakeStubImpl(glad_glGetRenderbufferParameteriv);
    glad_glGetShaderInfoLog = MakeStubImpl(glad_glGetShaderInfoLog);
    glad_glGetShaderSource = MakeStubImpl(glad_glGetShaderSource);
    glad_glGetShaderiv = MakeStubImpl(glad_glGetShaderiv);
    glad_glGetString = impl_glGetString;
    glad_glGetSubroutineIndex = MakeStubImpl(glad_glGetSubroutineIndex);
    glad_glGetTexImage = MakeStubImpl(glad_glGetTexImage);
    glad_glGetTexLevelParameteriv = MakeStubImpl(glad_glGetTexLevelParameteriv);
    glad_glGetUniformLocation = MakeStubImpl(glad_glGetUniformLocation);
    glad_glGetUniformfv = MakeStubImpl(glad_glGetUniformfv);
    glad_glGetUniformiv = MakeStubImpl(glad_glGetUniformiv);
    glad_glGetUniformuiv = MakeStubImpl(glad_glGetUniformuiv);
    glad_glHint = MakeStubImpl(glad_glHint);
    glad_glInitNames = MakeStubImpl(glad_glInitNames);
    glad_glIsBuffer = impl_glIsBuffer;
    glad_glIsEnabled = MakeStubImpl(glad_glIsEnabled);
    glad_glIsProgram = MakeStubImpl(glad_glIsProgram);
    glad_glIsRenderbuffer = MakeStubImpl(glad_glIsRenderbuffer);
    glad_glIsShader = MakeStubImpl(glad_glIsShader);
    glad_glIsSync = impl_glIsSync;
    glad_glIsTexture = MakeStubImpl(glad_glIsTexture);
    glad_glLightModelfv = MakeStubImpl(glad_glLightModelfv);
    glad_glLightModeli = MakeStubImpl(glad_glLightModeli);
    glad_glLightf = MakeStubImpl(glad_glLightf);
    glad_glLightfv = MakeStubImpl(glad_glLightfv);
    glad_glLineStipple = MakeStubImpl(glad_glLineStipple);
    glad_glLineWidth = MakeStubImpl(glad_glLineWidth);
    glad_glLinkProgram = MakeStubImpl(glad_glLinkProgram);
    glad_glLoadIdentity = MakeStubImpl(glad_glLoadIdentity);
    glad_glLoadMatrixd = MakeStubImpl(glad_glLoadMatrixd);
    glad_glLoadMatrixf = MakeStubImpl(glad_glLoadMatrixf);
    glad_glLoadName = MakeStubImpl(glad_glLoadName);
    glad_glLogicOp = MakeStubImpl(glad_glLogicOp);
    glad_glMap1f = MakeStubImpl(glad_glMap1f);
    glad_glMap2f = MakeStubImpl(glad_glMap2f);
    glad_glMapBuffer = MakeStubImpl(glad_glMapBuffer);
    glad_glMapBufferRange = MakeStubImpl(glad_glMapBufferRange);
    glad_glMapGrid1f = MakeStubImpl(glad_glMapGrid1f);
    glad_glMapGrid2f = MakeStubImpl(glad_glMapGrid2f);
    glad_glMaterialf = MakeStubImpl(glad_glMaterialf);
    glad_glMaterialfv = MakeStubImpl(glad_glMaterialfv);
    glad_glMatrixMode = MakeStubImpl(glad_glMatrixMode);
    glad_glMemoryBarrier = MakeStubImpl(glad_glMemoryBarrier);
    glad_glMinSampleShading = MakeStubImpl(glad_glMinSampleShading);
    glad_glMultMatrixd = MakeStubImpl(glad_glMultMatrixd);
    glad_glMultMatrixf = MakeStubImpl(glad_glMultMatrixf);
    glad_glMultiDrawElementsIndirect = MakeStubImpl(glad_glMultiDrawElementsIndirect);
    glad_glMultiTexCoord1f = MakeStubImpl(glad_glMultiTexCoord1f);
    glad_glMultiTexCoord2f = MakeStubImpl(glad_glMultiTexCoord2f);
    glad_glMultiTexCoord2i = MakeStubImpl(glad_glMultiTexCoord2i);
    glad_glMultiTexCoord2iv = MakeStubImpl(glad_glMultiTexCoord2iv);
    glad_glMultiTexCoord3f = MakeStubImpl(glad_glMultiTexCoord3f);
    glad_glMultiTexCoord4f = MakeStubImpl(glad_glMultiTexCoord4f);
    glad_glNewList = MakeStubImpl(glad_glNewList);
    glad_glNormal3f = MakeStubImpl(glad_glNormal3f);
    glad_glNormal3fv = MakeStubImpl(glad_glNormal3fv);
    glad_glNormalPointer = MakeStubImpl(glad_glNormalPointer);
    glad_glOrtho = MakeStubImpl(glad_glOrtho);
    glad_glPatchParameterfv = MakeStubImpl(glad_glPatchParameterfv);
    glad_glPatchParameteri = MakeStubImpl(glad_glPatchParameteri);
    glad_glPixelStorei = MakeStubImpl(glad_glPixelStorei);
    glad_glPointParameterf = MakeStubImpl(glad_glPointParameterf);
    glad_glPointParameterfv = MakeStubImpl(glad_glPointParameterfv);
    glad_glPointSize = MakeStubImpl(glad_glPointSize);
    glad_glPolygonMode = MakeStubImpl(glad_glPolygonMode);
    glad_glPolygonOffset = MakeStubImpl(glad_glPolygonOffset);
    glad_glPopAttrib = MakeStubImpl(glad_glPopAttrib);
    glad_glPopMatrix = MakeStubImpl(glad_glPopMatrix);
    glad_glPopName = MakeStubImpl(glad_glPopName);
    glad_glPrimitiveRestartIndex = MakeStubImpl(glad_glPrimitiveRestartIndex);
    glad_glProgramParameteri = MakeStubImpl(glad_glProgramParameteri);
    glad_glPushAttrib = MakeStubImpl(glad_glPushAttrib);
    glad_glPushMatrix = MakeStubImpl(glad_glPushMatrix);
    glad_glPushName = MakeStubImpl(glad_glPushName);
    glad_glQueryCounter = MakeStubImpl(glad_glQueryCounter);
    glad_glReadBuffer = MakeStubImpl(glad_glReadBuffer);
    glad_glReadPixels = MakeStubImpl(glad_glReadPixels);
    glad_glRectf = MakeStubImpl(glad_glRectf);
    glad_glRenderMode = MakeStubImpl(glad_glRenderMode);
    glad_glRenderbufferStorage = MakeStubImpl(glad_glRenderbufferStorage);
    glad_glRenderbufferStorageMultisample = MakeStubImpl(glad_glRenderbufferStorageMultisample);
    glad_glRotatef = MakeStubImpl(glad_glRotatef);
    glad_glScalef = MakeStubImpl(glad_glScalef);
    glad_glScissor = MakeStubImpl(glad_glScissor);
    glad_glSecondaryColor3f = MakeStubImpl(glad_glSecondaryColor3f);
    glad_glSelectBuffer = MakeStubImpl(glad_glSelectBuffer);
    glad_glShadeModel = MakeStubImpl(glad_glShadeModel);
    glad_glShaderSource = MakeStubImpl(glad_glShaderSource);
    glad_glStencilFunc = MakeStubImpl(glad_glStencilFunc);
    glad_glStencilFuncSeparate = MakeStubImpl(glad_glStencilFuncSeparate);
    glad_glStencilMask = MakeStubImpl(glad_glStencilMask);
    glad_glStencilMaskSeparate = MakeStubImpl(glad_glStencilMaskSeparate);
    glad_glStencilOp = MakeStubImpl(glad_glStencilOp);
    glad_glStencilOpSeparate = MakeStubImpl(glad_glStencilOpSeparate);
    glad_glTexCoord1f = MakeStubImpl(glad_glTexCoord1f);
    glad_glTexCoord2f = MakeStubImpl(glad_glTexCoord2f);
    glad_glTexCoord2fv = MakeStubImpl(glad_glTexCoord2fv);
    glad_glTexCoord2i = MakeStubImpl(glad_glTexCoord2i);
    glad_glTexCoord3f = MakeStubImpl(glad_glTexCoord3f);
    glad_glTexCoord4f = MakeStubImpl(glad_glTexCoord4f);
    glad_glTexCoordPointer = MakeStubImpl(glad_glTexCoordPointer);
    glad_glTexEnvf = MakeStubImpl(glad_glTexEnvf);
    glad_glTexEnvfv = MakeStubImpl(glad_glTexEnvfv);
    glad_glTexEnvi = MakeStubImpl(glad_glTexEnvi);
    glad_glTexGenf = MakeStubImpl(glad_glTexGenf);
    glad_glTexGenfv = MakeStubImpl(glad_glTexGenfv);
    glad_glTexGeni = MakeStubImpl(glad_glTexGeni);
    glad_glTexImage1D = MakeStubImpl(glad_glTexImage1D);
    glad_glTexImage2D = MakeStubImpl(glad_glTexImage2D);
    glad_glTexImage2DMultisample = MakeStubImpl(glad_glTexImage2DMultisample);
    glad_glTexImage3D = MakeStubImpl(glad_glTexImage3D);
    glad_glTexParameterf = MakeStubImpl(glad_glTexParameterf);
    glad_glTexParameterfv = MakeStubImpl(glad_glTexParameterfv);
    glad_glTexParameteri = MakeStubImpl(glad_glTexParameteri);
    glad_glTexParameteriv = MakeStubImpl(glad_glTexParameteriv);
    glad_glTexStorage2D = MakeStubImpl(glad_glTexStorage2D);
    glad_glTexStorage3D = MakeStubImpl(glad_glTexStorage3D);
    glad_glTexSubImage2D = MakeStubImpl(glad_glTexSubImage2D);
    glad_glTexSubImage3D = MakeStubImpl(glad_glTexSubImage3D);
    glad_glTranslatef = MakeStubImpl(glad_glTranslatef);
    glad_glUniform1f = MakeStubImpl(glad_glUniform1f);
    glad_glUniform1fv = MakeStubImpl(glad_glUniform1fv);
    glad_glUniform1i = MakeStubImpl(glad_glUniform1i);
    glad_glUniform1iv = MakeStubImpl(glad_glUniform1iv);
    glad_glUniform1uiv = MakeStubImpl(glad_glUniform1uiv);
    glad_glUniform2f = MakeStubImpl(glad_glUniform2f);
    glad_glUniform2fv = MakeStubImpl(glad_glUniform2fv);
    glad_glUniform2i = MakeStubImpl(glad_glUniform2i);
    glad_glUniform2iv = MakeStubImpl(glad_glUniform2iv);
    glad_glUniform2uiv = MakeStubImpl(glad_glUniform2uiv);
    glad_glUniform3f = MakeStubImpl(glad_glUniform3f);
    glad_glUniform3fv = MakeStubImpl(glad_glUniform3fv);
    glad_glUniform3i = MakeStubImpl(glad_glUniform3i);
    glad_glUniform3iv = MakeStubImpl(glad_glUniform3iv);
    glad_glUniform3uiv = MakeStubImpl(glad_glUniform3uiv);
    glad_glUniform4f = MakeStubImpl(glad_glUniform4f);
    glad_glUniform4fv = MakeStubImpl(glad_glUniform4fv);
    glad_glUniform4i = MakeStubImpl(glad_glUniform4i);
    glad_glUniform4iv = MakeStubImpl(glad_glUniform4iv);
    glad_glUniform4uiv = MakeStubImpl(glad_glUniform4uiv);
    glad_glUniformMatrix2fv = MakeStubImpl(glad_glUniformMatrix2fv);
    glad_glUniformMatrix3fv = MakeStubImpl(glad_glUniformMatrix3fv);
    glad_glUniformMatrix4fv = MakeStubImpl(glad_glUniformMatrix4fv);
    glad_glUniformSubroutinesuiv = MakeStubImpl(glad_glUniformSubroutinesuiv);
    glad_glUnmapBuffer = MakeStubImpl(glad_glUnmapBuffer);
    glad_glUseProgram = MakeStubImpl(glad_glUseProgram);
    glad_glValidateProgram = MakeStubImpl(glad_glValidateProgram);
    glad_glVertex2f = MakeStubImpl(glad_glVertex2f);
    glad_glVertex3f = MakeStubImpl(glad_glVertex3f);
    glad_glVertex3fv = MakeStubImpl(glad_glVertex3fv);
    glad_glVertex4f = MakeStubImpl(glad_glVertex4f);
    glad_glVertexAttribDivisor = MakeStubImpl(glad_glVertexAttribDivisor);
    glad_glVertexAttribIPointer = MakeStubImpl(glad_glVertexAttribIPointer);
    glad_glVertexAttribPointer = MakeStubImpl(glad_glVertexAttribPointer);
    glad_glVertexPointer = MakeStubImpl(glad_glVertexPointer);
    glad_glViewport = MakeStubImpl(glad_glViewport);
    glad_glDrawBuffersARB = MakeStubImpl(glad_glDrawBuffersARB);
    glad_glProgramStringARB = MakeStubImpl(glad_glProgramStringARB);
    glad_glBindProgramARB = MakeStubImpl(glad_glBindProgramARB);
    glad_glDeleteProgramsARB = MakeStubImpl(glad_glDeleteProgramsARB);
    glad_glGenProgramsARB = MakeStubImpl(glad_glGenProgramsARB);
    glad_glProgramEnvParameter4dARB = MakeStubImpl(glad_glProgramEnvParameter4dARB);
    glad_glProgramEnvParameter4dvARB = MakeStubImpl(glad_glProgramEnvParameter4dvARB);
    glad_glProgramEnvParameter4fARB = MakeStubImpl(glad_glProgramEnvParameter4fARB);
    glad_glProgramEnvParameter4fvARB = MakeStubImpl(glad_glProgramEnvParameter4fvARB);
    glad_glProgramLocalParameter4dARB = MakeStubImpl(glad_glProgramLocalParameter4dARB);
    glad_glProgramLocalParameter4dvARB = MakeStubImpl(glad_glProgramLocalParameter4dvARB);
    glad_glProgramLocalParameter4fARB = MakeStubImpl(glad_glProgramLocalParameter4fARB);
    glad_glProgramLocalParameter4fvARB = MakeStubImpl(glad_glProgramLocalParameter4fvARB);
    glad_glGetProgramEnvParameterdvARB = MakeStubImpl(glad_glGetProgramEnvParameterdvARB);
    glad_glGetProgramEnvParameterfvARB = MakeStubImpl(glad_glGetProgramEnvParameterfvARB);
    glad_glGetProgramLocalParameterdvARB = MakeStubImpl(glad_glGetProgramLocalParameterdvARB);
    glad_glGetProgramLocalParameterfvARB = MakeStubImpl(glad_glGetProgramLocalParameterfvARB);
    glad_glGetProgramivARB = MakeStubImpl(glad_glGetProgramivARB);
    glad_glActiveTextureARB = MakeStubImpl(glad_glActiveTextureARB);
    glad_glClientActiveTextureARB = MakeStubImpl(glad_glClientActiveTextureARB);
    glad_glMultiTexCoord2fARB = MakeStubImpl(glad_glMultiTexCoord2fARB);
    glad_glMultiTexCoord2iARB = MakeStubImpl(glad_glMultiTexCoord2iARB);
    glad_glMultiTexCoord2ivARB = MakeStubImpl(glad_glMultiTexCoord2ivARB);
    glad_glDeleteObjectARB = MakeStubImpl(glad_glDeleteObjectARB);
    glad_glGetHandleARB = MakeStubImpl(glad_glGetHandleARB);
    glad_glDetachObjectARB = MakeStubImpl(glad_glDetachObjectARB);
    glad_glCreateShaderObjectARB = MakeStubImpl(glad_glCreateShaderObjectARB);
    glad_glShaderSourceARB = MakeStubImpl(glad_glShaderSourceARB);
    glad_glCompileShaderARB = MakeStubImpl(glad_glCompileShaderARB);
    glad_glCreateProgramObjectARB = MakeStubImpl(glad_glCreateProgramObjectARB);
    glad_glAttachObjectARB = MakeStubImpl(glad_glAttachObjectARB);
    glad_glLinkProgramARB = MakeStubImpl(glad_glLinkProgramARB);
    glad_glUseProgramObjectARB = MakeStubImpl(glad_glUseProgramObjectARB);
    glad_glValidateProgramARB = MakeStubImpl(glad_glValidateProgramARB);
    glad_glUniform1fARB = MakeStubImpl(glad_glUniform1fARB);
    glad_glUniform2fARB = MakeStubImpl(glad_glUniform2fARB);
    glad_glUniform3fARB = MakeStubImpl(glad_glUniform3fARB);
    glad_glUniform4fARB = MakeStubImpl(glad_glUniform4fARB);
    glad_glUniform1iARB = MakeStubImpl(glad_glUniform1iARB);
    glad_glUniform2iARB = MakeStubImpl(glad_glUniform2iARB);
    glad_glUniform3iARB = MakeStubImpl(glad_glUniform3iARB);
    glad_glUniform4iARB = MakeStubImpl(glad_glUniform4iARB);
    glad_glUniform1fvARB = MakeStubImpl(glad_glUniform1fvARB);
    glad_glUniform2fvARB = MakeStubImpl(glad_glUniform2fvARB);
    glad_glUniform3fvARB = MakeStubImpl(glad_glUniform3fvARB);
    glad_glUniform4fvARB = MakeStubImpl(glad_glUniform4fvARB);
    glad_glUniform1ivARB = MakeStubImpl(glad_glUniform1ivARB);
    glad_glUniform2ivARB = MakeStubImpl(glad_glUniform2ivARB);
    glad_glUniform3ivARB = MakeStubImpl(glad_glUniform3ivARB);
    glad_glUniform4ivARB = MakeStubImpl(glad_glUniform4ivARB);
    glad_glUniformMatrix2fvARB = MakeStubImpl(glad_glUniformMatrix2fvARB);
    glad_glUniformMatrix3fvARB = MakeStubImpl(glad_glUniformMatrix3fvARB);
    glad_glUniformMatrix4fvARB = MakeStubImpl(glad_glUniformMatrix4fvARB);
    glad_glGetObjectParameterfvARB = MakeStubImpl(glad_glGetObjectParameterfvARB);
    glad_glGetObjectParameterivARB = MakeStubImpl(glad_glGetObjectParameterivARB);
    glad_glGetInfoLogARB = MakeStubImpl(glad_glGetInfoLogARB);
    glad_glGetAttachedObjectsARB = MakeStubImpl(glad_glGetAttachedObjectsARB);
    glad_glGetUniformLocationARB = MakeStubImpl(glad_glGetUniformLocationARB);
    glad_glCompressedTexImage3DARB = MakeStubImpl(glad_glCompressedTexImage3DARB);
    glad_glCompressedTexImage2DARB = MakeStubImpl(glad_glCompressedTexImage2DARB);
    glad_glCompressedTexImage1DARB = MakeStubImpl(glad_glCompressedTexImage1DARB);
    glad_glCompressedTexSubImage3DARB = MakeStubImpl(glad_glCompressedTexSubImage3DARB);
    glad_glCompressedTexSubImage2DARB = MakeStubImpl(glad_glCompressedTexSubImage2DARB);
    glad_glCompressedTexSubImage1DARB = MakeStubImpl(glad_glCompressedTexSubImage1DARB);
    glad_glGetCompressedTexImageARB = MakeStubImpl(glad_glGetCompressedTexImageARB);
    glad_glBindBufferARB = MakeStubImpl(glad_glBindBufferARB);
    glad_glDeleteBuffersARB = MakeStubImpl(glad_glDeleteBuffersARB);
    glad_glGenBuffersARB = MakeStubImpl(glad_glGenBuffersARB);
    glad_glBufferDataARB = MakeStubImpl(glad_glBufferDataARB);
    glad_glVertexAttribPointerARB = MakeStubImpl(glad_glVertexAttribPointerARB);
    glad_glEnableVertexAttribArrayARB = MakeStubImpl(glad_glEnableVertexAttribArrayARB);
    glad_glDisableVertexAttribArrayARB = MakeStubImpl(glad_glDisableVertexAttribArrayARB);
    glad_glBindAttribLocationARB = MakeStubImpl(glad_glBindAttribLocationARB);
    glad_glGetActiveAttribARB = MakeStubImpl(glad_glGetActiveAttribARB);
    glad_glGetAttribLocationARB = MakeStubImpl(glad_glGetAttribLocationARB);
    glad_glBlitFramebufferEXT = MakeStubImpl(glad_glBlitFramebufferEXT);
    glad_glRenderbufferStorageMultisampleEXT = MakeStubImpl(glad_glRenderbufferStorageMultisampleEXT);
    glad_glIsRenderbufferEXT = MakeStubImpl(glad_glIsRenderbufferEXT);
    glad_glBindRenderbufferEXT = MakeStubImpl(glad_glBindRenderbufferEXT);
    glad_glDeleteRenderbuffersEXT = MakeStubImpl(glad_glDeleteRenderbuffersEXT);
    glad_glGenRenderbuffersEXT = MakeStubImpl(glad_glGenRenderbuffersEXT);
    glad_glRenderbufferStorageEXT = MakeStubImpl(glad_glRenderbufferStorageEXT);
    glad_glGetRenderbufferParameterivEXT = MakeStubImpl(glad_glGetRenderbufferParameterivEXT);
    glad_glIsFramebufferEXT = MakeStubImpl(glad_glIsFramebufferEXT);
    glad_glBindFramebufferEXT = MakeStubImpl(glad_glBindFramebufferEXT);
    glad_glDeleteFramebuffersEXT = MakeStubImpl(glad_glDeleteFramebuffersEXT);
    glad_glGenFramebuffersEXT = MakeStubImpl(glad_glGenFramebuffersEXT);
    glad_glFramebufferTexture1DEXT = MakeStubImpl(glad_glFramebufferTexture1DEXT);
    glad_glFramebufferTexture2DEXT = MakeStubImpl(glad_glFramebufferTexture2DEXT);
    glad_glFramebufferTexture3DEXT = MakeStubImpl(glad_glFramebufferTexture3DEXT);
    glad_glFramebufferRenderbufferEXT = MakeStubImpl(glad_glFramebufferRenderbufferEXT);
    glad_glGetFramebufferAttachmentParameterivEXT = MakeStubImpl(glad_glGetFramebufferAttachmentParameterivEXT);
    glad_glGenerateMipmapEXT = MakeStubImpl(glad_glGenerateMipmapEXT);
    glad_glProgramParameteriEXT = MakeStubImpl(glad_glProgramParameteriEXT);
    glad_glFramebufferTextureLayerEXT = MakeStubImpl(glad_glFramebufferTextureLayerEXT);
    glad_glDeleteFencesNV = MakeStubImpl(glad_glDeleteFencesNV);
    glad_glGenFencesNV = MakeStubImpl(glad_glGenFencesNV);
    glad_glIsFenceNV = MakeStubImpl(glad_glIsFenceNV);
    glad_glTestFenceNV = MakeStubImpl(glad_glTestFenceNV);
    glad_glGetFenceivNV = MakeStubImpl(glad_glGetFenceivNV);
    glad_glFinishFenceNV = MakeStubImpl(glad_glFinishFenceNV);
    glad_glSetFenceNV = MakeStubImpl(glad_glSetFenceNV);
    glad_glFramebufferTextureEXT = MakeStubImpl(glad_glFramebufferTextureEXT);
    glad_glPrimitiveRestartIndexNV = MakeStubImpl(glad_glPrimitiveRestartIndexNV);
    glad_glInvalidateBufferData = MakeStubImpl(glad_glInvalidateBufferData);
    glad_glClipControl = MakeStubImpl(glad_glClipControl);
    glad_glPushDebugGroup = MakeStubImpl(glad_glPushDebugGroup);
    glad_glPopDebugGroup = MakeStubImpl(glad_glPopDebugGroup);
    glad_glObjectLabel = MakeStubImpl(glad_glObjectLabel);
    glad_glClearBufferuiv = MakeStubImpl(glad_glClearBufferuiv);
    glad_glClearBufferiv = MakeStubImpl(glad_glClearBufferiv);
    glad_glClearBufferfv = MakeStubImpl(glad_glClearBufferfv);
    glad_glGetTextureSubImage = MakeStubImpl(glad_glGetTextureSubImage);

    return 0;
}