# Workflow

### Before you start
* To report a bug or make a suggestion/request, [create a github ticket](https://github.com/beyond-all-reason/RecoilEngine/issues/new/choose).
* If you want to contribute something **not covered by an existing ticket, make one or at least talk to responsible devs listed below** to make sure your work won't get rejected.
* Be aware that we're volunteers working in our free time, every interaction may take a while.
* Consider getting familiar with [the build process](https://recoilengine.org/development/) and [guides](https://recoilengine.org/docs/guides/)/[articles](https://recoilengine.org/articles/) relating to your contribution area.
* If an existing ticket provides a bill of materials it is strongly recommended to follow it.
* Keep in mind Recoil is not just for BAR. Don't put overt game design in the engine.

### Work in progress
* Don't be afraid to ask for feedback/help. This can be on a ticket, your PR, or e.g. on discord.
* If you have pure refactor commits that don't change logic, put them in front if possible. This makes things much easier to review and they can get merged immediately to get them out of the way. The smaller the better.
* There aren't really any proper tests. If making a change related to Lua you can write a test wupget, otherwise come up with some manual procedure and let us know what you did. Of course if you write proper automated tests that's even better, but often very difficult so don't worry about it too much.

[comment]: # (* Follow Recoil development philosophy. // FIXME would need an article and not everybody even agrees on details there)

### Finalizing
* Feel free to ping maintainers if you think the ball is now in our court. We may take a while to handle your patch otherwise.
* A positive review is not necessarily a sign that the patch is soon to be merged. Different maintainers may look at different aspects of the patch or disagree with each other. Reviewing and merging are often done by different people.
* Patches are usually merged in batches before and after a release (depending on how big/controversial they are). This doesn't happen on any specific schedule but we aim for a release about every 2-3 months.

## Responsibilities
* lead: **ivand** aka @lhog
* vice-lead: **Tarnished Knight** aka @lostsquirrel1, specialises in pathfinding and optimisation
* **Marek** aka @p2004a - infrastructure (tools, external protocols etc)
* **rhys-vdw** aka duke_of_gloat - documentation, tooling
* **saurtron** - fonts, perf, misc
* **sprunk** - gamedev capabilities (incl. API), misc

### Less active but knowledgeable people you could try reach if nobody above can deal with it
* **badosu** - gamedev UX (documentation etc.) and UI input
* **ChrisFloofyKitsune** - rmlUI
* **loveridge** - rmlUI, misc
