/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.model.ClientData;
import com.intellij.packageChecker.model.GeneralRepositoryServer;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.ResourceUrl;
import com.intellij.packageChecker.model.VulnerabilitiesRepository;
import com.intellij.packageChecker.model.VulnerabilitiesRepositoryServer;
import com.intellij.packageChecker.model.VulnerabilitiesRepositoryServerKt;
import com.intellij.packageChecker.model.Vulnerability;
import com.intellij.packageChecker.model.VulnerablePackage;
import com.intellij.packageChecker.model.dto.FalsePositiveReport;
import com.intellij.packageChecker.model.dto.VulnerablePackageDto;
import com.intellij.packageChecker.util.GzipUtils;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ*\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0096@\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/packageChecker/model/VulnerabilitiesRepositoryServer;", "Lcom/intellij/packageChecker/model/GeneralRepositoryServer;", "Lcom/intellij/packageChecker/model/VulnerabilitiesRepository;", "clientData", "Lcom/intellij/packageChecker/model/ClientData;", "dbBaseUrl", "Lcom/intellij/packageChecker/model/ResourceUrl;", "packagesUrlString", "", "falsePositiveUrl", "attemptsToCheck", "", "requestTimeout", "Ljava/time/Duration;", "<init>", "(Lcom/intellij/packageChecker/model/ClientData;Lcom/intellij/packageChecker/model/ResourceUrl;Ljava/lang/String;Ljava/lang/String;ILjava/time/Duration;)V", "getVulnerabilities", "", "Lcom/intellij/packageChecker/model/VulnerablePackage;", "project", "Lcom/intellij/openapi/project/Project;", "pkgs", "", "Lcom/intellij/packageChecker/model/Package;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Iterable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reportFalsePositive", "", "pkg", "vulnerability", "Lcom/intellij/packageChecker/model/Vulnerability;", "(Lcom/intellij/packageChecker/model/Package;Lcom/intellij/packageChecker/model/Vulnerability;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.packageChecker"})
public final class VulnerabilitiesRepositoryServer
extends GeneralRepositoryServer
implements VulnerabilitiesRepository {
    @NotNull
    private final ClientData clientData;
    @NotNull
    private final ResourceUrl dbBaseUrl;
    @NotNull
    private final String falsePositiveUrl;

    public VulnerabilitiesRepositoryServer(@NotNull ClientData clientData, @NotNull ResourceUrl dbBaseUrl, @NotNull String packagesUrlString, @NotNull String falsePositiveUrl, int attemptsToCheck, @NotNull Duration requestTimeout) {
        Intrinsics.checkNotNullParameter((Object)clientData, (String)"clientData");
        Intrinsics.checkNotNullParameter((Object)dbBaseUrl, (String)"dbBaseUrl");
        Intrinsics.checkNotNullParameter((Object)packagesUrlString, (String)"packagesUrlString");
        Intrinsics.checkNotNullParameter((Object)falsePositiveUrl, (String)"falsePositiveUrl");
        Intrinsics.checkNotNullParameter((Object)requestTimeout, (String)"requestTimeout");
        super(clientData, packagesUrlString, dbBaseUrl, attemptsToCheck, requestTimeout);
        this.clientData = clientData;
        this.dbBaseUrl = dbBaseUrl;
        this.falsePositiveUrl = falsePositiveUrl;
    }

    public /* synthetic */ VulnerabilitiesRepositoryServer(ClientData clientData, ResourceUrl resourceUrl, String string, String string2, int n, Duration duration, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            string2 = "/report";
        }
        if ((n2 & 0x10) != 0) {
            n = 3;
        }
        if ((n2 & 0x20) != 0) {
            Duration duration2 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
            duration = duration2;
        }
        this(clientData, resourceUrl, string, string2, n, duration);
    }

    @Override
    @Nullable
    public Object getVulnerabilities(@NotNull Project project, @NotNull Iterable<Package> pkgs2, @NotNull Continuation<? super List<VulnerablePackage>> $completion) {
        HttpResponse.BodyHandler bodyHandler2 = arg_0 -> VulnerabilitiesRepositoryServer.getVulnerabilities$lambda$2(this, arg_0);
        return this.getStatusForPackages(project, pkgs2, bodyHandler2, getVulnerabilities.2.INSTANCE, VulnerabilitiesRepositoryServer::getVulnerabilities$lambda$3, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object reportFalsePositive(@NotNull Package pkg, @NotNull Vulnerability vulnerability, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof reportFalsePositive.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ VulnerabilitiesRepositoryServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.reportFalsePositive(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                falsePositiveReport = new FalsePositiveReport(vulnerability.getCve(), pkg.getSearchKey(), this.clientData.getAnonymousToken());
                falsePositiveReportJson = this.getObjectMapper().writeValueAsString((Object)falsePositiveReport);
                v0 = this.getHttpClient();
                v1 = this.dbBaseUrl.url + this.falsePositiveUrl;
                v2 = HttpRequest.BodyPublishers.ofString(falsePositiveReportJson);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"ofString(...)");
                v3 = HttpResponse.BodyHandlers.ofString();
                Intrinsics.checkNotNullExpressionValue(v3, (String)"ofString(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)pkg);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)vulnerability);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)falsePositiveReport);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)falsePositiveReportJson);
                $continuation.label = 1;
                v4 = v0.post(v1, v2, v3, $continuation);
                ** if (v4 != var9_6) goto lbl30
lbl29:
                // 1 sources

                return var9_6;
lbl30:
                // 1 sources

                ** GOTO lbl40
            }
            case 1: {
                falsePositiveReportJson = (String)$continuation.L$3;
                falsePositiveReport = (FalsePositiveReport)$continuation.L$2;
                vulnerability = (Vulnerability)$continuation.L$1;
                pkg = (Package)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl40:
                    // 2 sources

                    if (!VulnerabilitiesRepositoryServerKt.access$isSuccess((response = (HttpResponse)v4).statusCode())) {
                        VulnerabilitiesRepositoryServerKt.access$getLogger$p().warn("Error during reporting FP, errorCode: " + response.statusCode());
                    }
                }
                catch (HttpTimeoutException <unused var>) {
                    VulnerabilitiesRepositoryServerKt.access$getLogger$p().warn("Error during reporting FP, timeout reached");
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final List getVulnerabilities$lambda$2$lambda$0(VulnerabilitiesRepositoryServer this$0, byte[] it) {
        Intrinsics.checkNotNull((Object)it);
        String originalContent = GzipUtils.INSTANCE.decompressFromGzipOrGetString(it);
        return (List)this$0.getObjectMapper().readValue(originalContent, (TypeReference)new TypeReference<List<? extends VulnerablePackageDto>>(){});
    }

    private static final List getVulnerabilities$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final HttpResponse.BodySubscriber getVulnerabilities$lambda$2(VulnerabilitiesRepositoryServer this$0, HttpResponse.ResponseInfo it) {
        return HttpResponse.BodySubscribers.mapping(HttpResponse.BodySubscribers.ofByteArray(), arg_0 -> VulnerabilitiesRepositoryServer.getVulnerabilities$lambda$2$lambda$1(arg_0 -> VulnerabilitiesRepositoryServer.getVulnerabilities$lambda$2$lambda$0(this$0, arg_0), arg_0));
    }

    private static final VulnerablePackage getVulnerabilities$lambda$3(Package pkg) {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        return new VulnerablePackage(pkg, CollectionsKt.emptyList(), null, "UNCHECKED", 4, null);
    }
}

