/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolverCore;
import com.intellij.database.csv.PersistentCsvFormat;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CsvFormatResolver
extends CsvFormatResolverCore {
    private static final Logger LOG = Logger.getInstance(CsvFormatResolver.class);
    private static final FileAttribute CSV_FORMAT_ATTRIBUTES = new FileAttribute("csv_format", 2, true);

    private CsvFormatResolver() {
    }

    @Nullable
    public static CsvFormat getFormatFromState(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditorProvider csvProvider;
        if (project == null) {
            CsvFormatResolver.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CsvFormatResolver.$$$reportNull$$$0(1);
        }
        return (csvProvider = FileEditorProviderManager.getInstance().getProvider("csv-data-editor")) == null ? null : CsvFormatResolver.getFormatFromState(project, file, csvProvider);
    }

    @Nullable
    public static CsvFormat getFormatFromState(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileEditorProvider provider) {
        if (project == null) {
            CsvFormatResolver.$$$reportNull$$$0(2);
        }
        if (file == null) {
            CsvFormatResolver.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            CsvFormatResolver.$$$reportNull$$$0(4);
        }
        if (project.isDisposed()) {
            return null;
        }
        EditorHistoryManager editorHistoryManager = EditorHistoryManager.getInstance((Project)project);
        FileEditorState state = editorHistoryManager.getState(file, provider);
        return state != null ? CsvFormatResolver.readCsvFormat(state) : null;
    }

    @Nullable
    public static CsvFormat getFormatFromFile(@NotNull VirtualFile file) {
        CsvFormat csvFormat;
        block10: {
            AttributeInputStream stream;
            if (file == null) {
                CsvFormatResolver.$$$reportNull$$$0(5);
            }
            AttributeInputStream attributeInputStream = stream = file instanceof VirtualFileWithId ? CSV_FORMAT_ATTRIBUTES.readFileAttribute(file) : null;
            if (stream == null) {
                return null;
            }
            AttributeInputStream resource = stream;
            try {
                String id = resource.readEnumeratedString();
                Element load = JDOMUtil.load((CharSequence)id);
                PersistentCsvFormat format = (PersistentCsvFormat)XmlSerializer.deserialize((Element)load, PersistentCsvFormat.class);
                csvFormat = format.immutable();
                if (resource == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | JDOMException e) {
                    LOG.warn(e);
                    return null;
                }
            }
            resource.close();
        }
        return csvFormat;
    }

    public static void saveCsvFormat(@NotNull CsvFormat format, @NotNull VirtualFile file) {
        if (format == null) {
            CsvFormatResolver.$$$reportNull$$$0(6);
        }
        if (file == null) {
            CsvFormatResolver.$$$reportNull$$$0(7);
        }
        PersistentCsvFormat persistentFormat = new PersistentCsvFormat(format);
        Element element = XmlSerializer.serialize((Object)persistentFormat);
        String string = JDOMUtil.write((Parent)element, (String)"");
        try (AttributeOutputStream resource = CSV_FORMAT_ATTRIBUTES.writeFileAttribute(file);){
            resource.writeEnumeratedString(string);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Nullable
    public static CsvFormat readCsvFormat(@Nullable FileEditorState state) {
        State csvState = (State)ObjectUtils.tryCast((Object)state, State.class);
        return csvState != null ? csvState.format.immutable() : null;
    }

    @Nullable
    public static CsvFormat getFormat(@NotNull Project project, @NotNull VirtualFile file, boolean tryDetectHeader, @Nullable Supplier<List<CsvFormat>> existingFormatsSupplier) {
        if (project == null) {
            CsvFormatResolver.$$$reportNull$$$0(8);
        }
        if (file == null) {
            CsvFormatResolver.$$$reportNull$$$0(9);
        }
        return CsvFormatResolver.getFormat(project, file, tryDetectHeader, existingFormatsSupplier, FormatGetter.FILE, FormatGetter.STATE, FormatGetter.CONTENT);
    }

    @Nullable
    public static CsvFormat getFormat(@NotNull Project project, @NotNull VirtualFile file, boolean tryDetectHeader, @Nullable Supplier<List<CsvFormat>> existingFormatsSupplier, FormatGetter ... getters) {
        if (project == null) {
            CsvFormatResolver.$$$reportNull$$$0(10);
        }
        if (file == null) {
            CsvFormatResolver.$$$reportNull$$$0(11);
        }
        if (getters == null) {
            CsvFormatResolver.$$$reportNull$$$0(12);
        }
        for (FormatGetter getter : getters) {
            CsvFormat format = getter.get(project, file, tryDetectHeader, existingFormatsSupplier);
            if (format == null) continue;
            return format;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getters";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/csv/CsvFormatResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFormatFromState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getFormatFromFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "saveCsvFormat";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getFormat";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class State
    implements FileEditorState {
        @Tag(value="format")
        public PersistentCsvFormat format;

        public State() {
        }

        public State(@NotNull CsvFormat format) {
            if (format == null) {
                State.$$$reportNull$$$0(0);
            }
            this.format = new PersistentCsvFormat(format);
        }

        public boolean canBeMergedWith(@NotNull FileEditorState otherState, @NotNull FileEditorStateLevel level) {
            if (otherState == null) {
                State.$$$reportNull$$$0(1);
            }
            if (level == null) {
                State.$$$reportNull$$$0(2);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/csv/CsvFormatResolver$State";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canBeMergedWith";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum FormatGetter {
        STATE{

            @Override
            @Nullable
            CsvFormat get(@NotNull Project project, @NotNull VirtualFile file, boolean tryDetectHeader, @Nullable Supplier<List<CsvFormat>> existingFormatsSupplier) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                return CsvFormatResolver.getFormatFromState(project, file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/csv/CsvFormatResolver$FormatGetter$1";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        FILE{

            @Override
            @Nullable
            CsvFormat get(@NotNull Project project, @NotNull VirtualFile file, boolean tryDetectHeader, @Nullable Supplier<List<CsvFormat>> existingFormatsSupplier) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(1);
                }
                return CsvFormatResolver.getFormatFromFile(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/csv/CsvFormatResolver$FormatGetter$2";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        CONTENT{

            @Override
            @Nullable
            CsvFormat get(@NotNull Project project, @NotNull VirtualFile file, boolean tryDetectHeader, @Nullable Supplier<List<CsvFormat>> existingFormatsSupplier) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    3.$$$reportNull$$$0(1);
                }
                return CsvFormatResolverCore.getMoreSuitableCsvFormat((VirtualFile)file, (boolean)tryDetectHeader, existingFormatsSupplier);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/csv/CsvFormatResolver$FormatGetter$3";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        @Nullable
        abstract CsvFormat get(@NotNull Project var1, @NotNull VirtualFile var2, boolean var3, @Nullable Supplier<List<CsvFormat>> var4);
    }
}

