/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.datagrid.CsvLexer;
import com.intellij.database.datagrid.CsvReader;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.dbimport.OffsetRecord;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamCsvFormatParser {
    private static final int ERROR_TEXT_SIZE = 15;
    private static final int NOT_IMPORTANT = -1;
    private final int myMaxCharsReadPerBatch;
    private final CsvFormat myDataFormat;
    private List<ErrorRecord> myErrors;
    private Token[] myHeader;
    private final CsvLexer myLexer;

    public StreamCsvFormatParser(@NotNull CsvFormat format, int maxCharsReadPerBatch, @NotNull CsvReader reader) {
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(1);
        }
        this.myDataFormat = format;
        this.myMaxCharsReadPerBatch = maxCharsReadPerBatch;
        this.myLexer = new CsvLexer(reader);
        this.myLexer.setCsvFormat((CsvRecordFormat)ObjectUtils.chooseNotNull((Object)this.myDataFormat.headerRecord, (Object)this.myDataFormat.dataRecord));
    }

    @Nullable
    public CsvParserResult parse() throws IOException {
        long startCharacters = this.myLexer.getCharacters();
        if (startCharacters != 0L && this.myHeader == null) {
            return null;
        }
        this.myErrors = new ArrayList<ErrorRecord>();
        ArrayList<Token[]> result = new ArrayList<Token[]>();
        if (!this.parseHeader(startCharacters)) {
            if (this.myErrors.isEmpty()) {
                this.myErrors.add(new MyRecord());
            }
            return new CsvParserResult(null, ContainerUtil.emptyList(), this.myErrors, this.myLexer.getCharacters() - startCharacters);
        }
        if (startCharacters == 0L && this.myDataFormat.headerRecord == null) {
            result.add(this.myHeader);
        }
        this.parseRecords(result, startCharacters);
        return !result.isEmpty() || !this.myErrors.isEmpty() ? new CsvParserResult(this.myDataFormat.headerRecord == null ? null : this.myHeader, result, this.myErrors, this.myLexer.getCharacters() - startCharacters) : null;
    }

    private void parseRecords(@NotNull List<Token[]> result, long startCharacters) throws IOException {
        Token[] e;
        int valuesPerRecordCount;
        if (result == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(2);
        }
        int n = valuesPerRecordCount = this.myDataFormat.rowNumbers ? this.myHeader.length + 1 : this.myHeader.length;
        while (this.myLexer.isReady() && (this.myLexer.getCharacters() - startCharacters < (long)this.myMaxCharsReadPerBatch || result.isEmpty()) && (e = this.getRecord(this.myDataFormat.dataRecord, true, valuesPerRecordCount)) != null) {
            result.add(e);
        }
    }

    private boolean parseHeader(long startCharacters) throws IOException {
        CsvRecordFormat headerFormat;
        if (this.myHeader != null) {
            return true;
        }
        CsvRecordFormat csvRecordFormat = headerFormat = this.myDataFormat.headerRecord == null ? this.myDataFormat.dataRecord : this.myDataFormat.headerRecord;
        while (this.myLexer.getCharacters() - startCharacters < (long)this.myMaxCharsReadPerBatch && this.myLexer.isReady() && this.myHeader == null) {
            this.myHeader = this.getRecord(headerFormat, this.myDataFormat.headerRecord == null, -1);
        }
        this.myLexer.setCsvFormat(this.myDataFormat.dataRecord);
        return this.myHeader != null;
    }

    private Token @Nullable [] getRecord(@NotNull CsvRecordFormat format, boolean allowNulls, int valuesPerRecordCount) throws IOException {
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(3);
        }
        List<Token> record = null;
        while (this.myLexer.isReady() && record == null) {
            try {
                record = this.parseRecord(format, allowNulls, valuesPerRecordCount);
            }
            catch (CsvParserException e) {
                this.myErrors.add((ErrorRecord)new OffsetRecord((Exception)e, e.getLine(), e.getOffset()));
            }
        }
        return record == null ? null : (Token[])ContainerUtil.toArray(record, Token[]::new);
    }

    @NotNull
    private List<Token> parseRecord(@NotNull CsvRecordFormat format, boolean allowNulls, int valuesPerRecordCount) throws IOException, CsvParserException {
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(4);
        }
        ArrayList<Token> result = new ArrayList<Token>();
        this.parseRecordChain(format, allowNulls, valuesPerRecordCount, result);
        List<Token> list = result.isEmpty() || !this.myDataFormat.rowNumbers ? result : ContainerUtil.subList(result, (int)1);
        if (list == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(5);
        }
        return list;
    }

    private void parseRecordChain(@NotNull CsvRecordFormat format, boolean allowNulls, int valuesPerRecordCount, List<Token> result) throws IOException, CsvParserException {
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(6);
        }
        this.myLexer.advance();
        this.maybe(CsvLexer.TokenType.PREFIX);
        if (this.myLexer.getType() == null) {
            return;
        }
        if (!this.valuesChain(format, result, allowNulls, valuesPerRecordCount)) {
            return;
        }
        this.checkUnexpectedCount(format, result, valuesPerRecordCount);
        this.maybe(CsvLexer.TokenType.SUFFIX);
        this.assertTypesOrNull(format, CsvLexer.TokenType.RECORD_SEPARATOR);
    }

    private boolean valuesChain(@NotNull CsvRecordFormat format, @NotNull List<Token> result, boolean allowNulls, int valuesPerRecordCount) throws CsvParserException, IOException {
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(7);
        }
        if (result == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(8);
        }
        while (this.shouldReadValue()) {
            this.value(format, result, allowNulls, valuesPerRecordCount);
        }
        return true;
    }

    private void value(@NotNull CsvRecordFormat format, @NotNull List<Token> result, boolean allowNulls, int valuesPerRecordCount) throws CsvParserException, IOException {
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(9);
        }
        if (result == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(10);
        }
        this.assertTokenType(format, CsvLexer.TokenType.VALUE, CsvLexer.TokenType.QUOTED_VALUE);
        result.add(this.createValueToken(allowNulls ? format : null));
        this.myLexer.advance();
        if (valuesPerRecordCount != -1 && valuesPerRecordCount == result.size() && this.myLexer.getType() != null) {
            this.countChain(format);
        }
        if (this.checkIfTypesOrNull(CsvLexer.TokenType.RECORD_SEPARATOR, CsvLexer.TokenType.SUFFIX)) {
            return;
        }
        this.assertTokenType(format, CsvLexer.TokenType.VALUE_SEPARATOR);
        this.myLexer.advance();
    }

    private void countChain(@NotNull CsvRecordFormat format) throws CsvParserException, IOException {
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(11);
        }
        this.maybe(CsvLexer.TokenType.SUFFIX);
        this.assertTypesOrNull(format, CsvLexer.TokenType.RECORD_SEPARATOR);
    }

    @Nullable
    private Token createValueToken(@Nullable CsvRecordFormat format) {
        String text = this.myLexer.getText();
        if (text == null) {
            return null;
        }
        if (text.length() >= 0x500000) {
            this.myErrors.add((ErrorRecord)new OffsetRecord((Exception)new MaxCharactersReachedException(StreamCsvFormatParser.cut(text)), this.myLexer.getTokenLine(), this.myLexer.getOffset()));
        }
        return this.createToken(format);
    }

    private void checkUnexpectedCount(@NotNull CsvRecordFormat format, @NotNull List<Token> result, int count) throws CsvParserException, IOException {
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(12);
        }
        if (result == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(13);
        }
        if (count != -1 && result.size() < count) {
            throw this.newParserException(format, CsvLexer.TokenType.VALUE);
        }
    }

    private boolean shouldReadValue() {
        CsvLexer.TokenType type = this.myLexer.getType();
        return type != null && type != CsvLexer.TokenType.SUFFIX && type != CsvLexer.TokenType.RECORD_SEPARATOR;
    }

    @NotNull
    private CsvParserException newParserException(@NotNull CsvRecordFormat format, CsvLexer.TokenType ... types) throws IOException {
        CsvLexer.TokenType type;
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(14);
        }
        if (types == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(15);
        }
        boolean hasToken = (type = this.myLexer.getType()) == null;
        String text = hasToken ? StreamCsvFormatParser.cut(this.myLexer.readAhead(15)) : this.myLexer.getText();
        long character = hasToken ? this.myLexer.getLineCharacters() : this.myLexer.getOffset();
        long line = hasToken ? this.myLexer.getLine() : this.myLexer.getTokenLine();
        return new CsvParserException(text == null ? null : StringUtil.wrapWithDoubleQuote((String)text), this.createToken(null), format, character, line, types);
    }

    @Contract(value="null -> null; !null -> !null")
    private static String cut(@Nullable String text) {
        return text == null ? null : text.substring(0, Math.min(text.length(), 15)) + "...";
    }

    @Nullable
    private Token createToken(@Nullable CsvRecordFormat format) {
        boolean isNull;
        if (!this.myLexer.hasToken()) {
            return null;
        }
        String text = Objects.requireNonNull(this.myLexer.getText());
        CsvLexer.TokenType type = Objects.requireNonNull(this.myLexer.getType());
        boolean bl = isNull = type != CsvLexer.TokenType.QUOTED_VALUE && format != null && StringUtil.equals((CharSequence)text, (CharSequence)format.nullText);
        if (type == CsvLexer.TokenType.QUOTED_VALUE) {
            CsvRecordFormat fmt = this.myLexer.getCsvFormat();
            for (CsvRecordFormat.Quotes quote : fmt.quotes) {
                if (!quote.isQuoted(text)) continue;
                text = StreamCsvFormatParser.unquote(text, quote, fmt.trimWhitespace);
                break;
            }
        }
        if (type == CsvLexer.TokenType.VALUE && this.myLexer.getCsvFormat().trimWhitespace) {
            text = text.strip();
        }
        return new Token(text, isNull, type, this.myLexer.getTokenLine(), this.myLexer.getOffset());
    }

    private static String unquote(String text, CsvRecordFormat.Quotes quote, boolean trim) {
        int from;
        int to = text.length() - quote.rightQuote.length();
        if (trim) {
            for (from = quote.leftQuote.length(); from < to && Character.isWhitespace(text.charAt(from)); ++from) {
            }
            while (from < to && Character.isWhitespace(text.charAt(to - 1))) {
                --to;
            }
        }
        if (to <= from) {
            return "";
        }
        int idx = StringUtil.indexOf((CharSequence)text, (CharSequence)quote.rightQuoteEscaped, (int)from, (int)to);
        if (idx == -1) {
            return text.substring(from, to);
        }
        StringBuilder res = new StringBuilder(text.length() * 2);
        while (idx != -1) {
            res.append(text, from, idx);
            res.append(quote.rightQuote);
            from = idx + quote.rightQuoteEscaped.length();
            idx = StringUtil.indexOf((CharSequence)text, (CharSequence)quote.rightQuoteEscaped, (int)from, (int)to);
        }
        res.append(text, from, to);
        return res.toString();
    }

    private static void restore(@NotNull CsvLexer lexer) throws IOException {
        if (lexer == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(16);
        }
        while (lexer.isReady() && lexer.getType() != CsvLexer.TokenType.RECORD_SEPARATOR) {
            lexer.advance();
        }
    }

    private void assertTokenType(@NotNull CsvRecordFormat format, CsvLexer.TokenType ... types) throws IOException, CsvParserException {
        CsvLexer.TokenType type;
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(17);
        }
        if (types == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(18);
        }
        if ((type = this.myLexer.getType()) != null && ArrayUtil.contains((Object)type, (Object[])types)) {
            return;
        }
        CsvParserException e = this.newParserException(format, types);
        if (type == CsvLexer.TokenType.RECORD_SEPARATOR) {
            throw e;
        }
        StreamCsvFormatParser.restore(this.myLexer);
        throw e;
    }

    private boolean checkIfTypesOrNull(CsvLexer.TokenType ... types) {
        if (types == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(19);
        }
        return this.myLexer.getType() == null || ArrayUtil.contains((Object)this.myLexer.getType(), (Object[])types);
    }

    private void assertTypesOrNull(CsvRecordFormat format, CsvLexer.TokenType ... types) throws IOException, CsvParserException {
        if (types == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(20);
        }
        if (this.myLexer.getType() == null) {
            return;
        }
        this.assertTokenType(format, types);
    }

    private void maybe(@NotNull CsvLexer.TokenType type) throws IOException {
        CsvLexer.TokenType tokenType;
        if (type == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(21);
        }
        if ((tokenType = this.myLexer.getType()) == type) {
            this.myLexer.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/StreamCsvFormatParser";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/StreamCsvFormatParser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRecord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseRecords";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRecord";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseRecord";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseRecordChain";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "valuesChain";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "value";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "countChain";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkUnexpectedCount";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "newParserException";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "assertTokenType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkIfTypesOrNull";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "assertTypesOrNull";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "maybe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static class Token {
        private final String myText;
        private final boolean myIsNull;
        private final CsvLexer.TokenType myType;
        private final long myLine;
        private final long myOffset;

        /*
         * WARNING - void declaration
         */
        public Token(@NotNull String text, boolean isNull, @NotNull CsvLexer.TokenType type, long line, long l) {
            void offset;
            if (text == null) {
                Token.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Token.$$$reportNull$$$0(1);
            }
            this.myText = text;
            this.myIsNull = isNull;
            this.myType = type;
            this.myLine = line;
            this.myOffset = offset;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                Token.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public String getValue() {
            return this.myIsNull ? null : this.myText;
        }

        @NotNull
        public CsvLexer.TokenType getType() {
            CsvLexer.TokenType tokenType = this.myType;
            if (tokenType == null) {
                Token.$$$reportNull$$$0(3);
            }
            return tokenType;
        }

        public long getLine() {
            return this.myLine;
        }

        public long getOffset() {
            return this.myOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/StreamCsvFormatParser$Token";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/StreamCsvFormatParser$Token";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyRecord
    extends ErrorRecord {
        protected MyRecord() {
            super(0L);
        }

        @NotNull
        public String getMessage() {
            return "couldn't parse header";
        }
    }

    public static class CsvParserResult {
        private final Token[] myHeader;
        private final List<Token[]> myRecords;
        private final List<ErrorRecord> myErrors;
        private final long myCharacters;

        public CsvParserResult(Token @Nullable [] header, @NotNull List<Token[]> records, @NotNull List<ErrorRecord> errors, long characters) {
            if (records == null) {
                CsvParserResult.$$$reportNull$$$0(0);
            }
            if (errors == null) {
                CsvParserResult.$$$reportNull$$$0(1);
            }
            this.myHeader = header;
            this.myRecords = records;
            this.myErrors = errors;
            this.myCharacters = characters;
        }

        public Token @Nullable [] getHeader() {
            return this.myHeader;
        }

        @NotNull
        public List<Token[]> getRecords() {
            List<Token[]> list = this.myRecords;
            if (list == null) {
                CsvParserResult.$$$reportNull$$$0(2);
            }
            return list;
        }

        public long getCharacters() {
            return this.myCharacters;
        }

        @NotNull
        public List<ErrorRecord> getErrors() {
            List<ErrorRecord> list = this.myErrors;
            if (list == null) {
                CsvParserResult.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        public String getErrorText() {
            String string = StringUtil.join(this.myErrors, ErrorRecord::getMessage, (String)"\n");
            if (string == null) {
                CsvParserResult.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "records";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errors";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecords";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrors";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class CsvParserException
    extends Exception {
        public static final String END_OF_FILE = "end of file";
        private static final String MASK = "actual: %s, expected: %s";
        private final long myCharacter;
        private final long myLine;

        /*
         * WARNING - void declaration
         */
        CsvParserException(@Nullable String text, @Nullable Token actual, @NotNull CsvRecordFormat format, long character, long line, CsvLexer.TokenType ... tokenTypeArray) {
            void expected;
            if (format == null) {
                CsvParserException.$$$reportNull$$$0(0);
            }
            if (tokenTypeArray == null) {
                CsvParserException.$$$reportNull$$$0(1);
            }
            super(CsvParserException.getMessageText(format, actual, text, (CsvLexer.TokenType[])expected));
            this.myCharacter = character;
            this.myLine = line;
        }

        public long getOffset() {
            return this.myCharacter;
        }

        public long getLine() {
            return this.myLine;
        }

        @NotNull
        private static String getMessageText(@NotNull CsvRecordFormat format, @Nullable Token token, @Nullable String text, CsvLexer.TokenType ... types) {
            if (format == null) {
                CsvParserException.$$$reportNull$$$0(2);
            }
            if (types == null) {
                CsvParserException.$$$reportNull$$$0(3);
            }
            String string = String.format(MASK, CsvParserException.getActualText(token, text), CsvParserException.getExpected(format, types));
            if (string == null) {
                CsvParserException.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        private static String getExpected(@NotNull CsvRecordFormat format, CsvLexer.TokenType ... types) {
            if (format == null) {
                CsvParserException.$$$reportNull$$$0(5);
            }
            if (types == null) {
                CsvParserException.$$$reportNull$$$0(6);
            }
            String string = StringUtil.escapeStringCharacters((String)StringUtil.join((Object[])types, type -> type.getDebugName(format), (String)", "));
            if (string == null) {
                CsvParserException.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        private static String getActualText(@Nullable Token token, @Nullable String text) {
            String string = token != null ? token.getType().getTokenRepresentation(token.getText()) : (text == null ? END_OF_FILE : StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeStringCharacters((String)text)));
            if (string == null) {
                CsvParserException.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expected";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserException";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessageText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpected";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActualText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessageText";
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    public static class MaxCharactersReachedException
    extends Exception {
        public MaxCharactersReachedException(@NotNull String text) {
            if (text == null) {
                MaxCharactersReachedException.$$$reportNull$$$0(0);
            }
            super(String.format("too long value: \"%s\"", StringUtil.escapeStringCharacters((String)text)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/datagrid/StreamCsvFormatParser$MaxCharactersReachedException", "<init>"));
        }
    }
}

