/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.indexing.shared.generate.HashBasedIndexGenerator;
import com.intellij.indexing.shared.platform.api.layout.SharedIndexLocation;
import com.intellij.indexing.shared.platform.impl.SharedIndexExtension;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.ValueContainerInputRemapping;
import com.intellij.util.indexing.impl.ValueContainerProcessor;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.MapForwardIndexAccessor;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.function.LongSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class HashBasedMapReduceIndex<Key, Value>
extends VfsAwareMapReduceIndex<Key, Value, VfsAwareMapReduceIndex.IndexerIdHolder> {
    @NotNull
    private final SharedIndexExtension<Key, Value> mySharedExtension;
    @NotNull
    private final LongSupplier myHashIndexStampSupplier;
    private volatile long myLastFileContentIndexStamp;

    @VisibleForTesting
    public HashBasedMapReduceIndex(@NotNull SharedIndexLocation<Key, Value> indexLocation, @NotNull SharedIndexExtension<Key, Value> sharedExtension, @NotNull ValueContainerInputRemapping hashIdRemapping, @NotNull LongSupplier hashIndexStampSupplier) throws IOException {
        if (indexLocation == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(0);
        }
        if (sharedExtension == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(1);
        }
        if (hashIdRemapping == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(2);
        }
        if (hashIndexStampSupplier == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(3);
        }
        super(HashBasedMapReduceIndex.assertIndexerNotUsed(sharedExtension.getFileBasedIndexExtension()), HashBasedMapReduceIndex.createIndexLayout(indexLocation, sharedExtension, hashIdRemapping));
        this.myLastFileContentIndexStamp = -1L;
        this.mySharedExtension = sharedExtension;
        this.myHashIndexStampSupplier = hashIndexStampSupplier;
    }

    @NotNull
    private static <Key, Value> VfsAwareIndexStorageLayout<Key, Value> createIndexLayout(final @NotNull SharedIndexLocation<Key, Value> indexLocation, final @NotNull SharedIndexExtension<Key, Value> sharedExtension, final @NotNull ValueContainerInputRemapping hashIdRemapping) {
        if (indexLocation == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(4);
        }
        if (sharedExtension == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(5);
        }
        if (hashIdRemapping == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(6);
        }
        if (HashBasedIndexGenerator.shouldCreateForwardIndex(sharedExtension)) {
            return new VfsAwareIndexStorageLayout<Key, Value>(){

                public void clearIndexData() {
                    throw new UnsupportedOperationException();
                }

                @NotNull
                public IndexStorage<Key, Value> openIndexStorage() throws IOException {
                    IndexStorage indexStorage = indexLocation.createStorage(sharedExtension, hashIdRemapping);
                    if (indexStorage == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return indexStorage;
                }

                @NotNull
                public ForwardIndex openForwardIndex() throws IOException {
                    ForwardIndex forwardIndex = indexLocation.createForwardIndex(sharedExtension, true);
                    if (forwardIndex == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return forwardIndex;
                }

                @NotNull
                public ForwardIndexAccessor<Key, Value> getForwardIndexAccessor() {
                    MapForwardIndexAccessor mapForwardIndexAccessor = HashBasedIndexGenerator.createForwardIndexAccessor(sharedExtension, hashId -> {
                        throw new AssertionError();
                    });
                    if (mapForwardIndexAccessor == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return mapForwardIndexAccessor;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "openIndexStorage";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "openForwardIndex";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getForwardIndexAccessor";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }
        return new VfsAwareIndexStorageLayout<Key, Value>(){

            public void clearIndexData() {
                throw new UnsupportedOperationException();
            }

            @NotNull
            public IndexStorage<Key, Value> openIndexStorage() throws IOException {
                IndexStorage indexStorage = indexLocation.createStorage(sharedExtension, hashIdRemapping);
                if (indexStorage == null) {
                    2.$$$reportNull$$$0(0);
                }
                return indexStorage;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex$2", "openIndexStorage"));
            }
        };
    }

    public boolean acceptsFile(@NotNull IndexedFile file) {
        if (file == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(7);
        }
        return this.mySharedExtension.acceptsInputFile(file);
    }

    @NotNull
    public Map<Key, Value> getIndexedFileData(int hashId) throws StorageException {
        this.ensureCachesUpToDate();
        if (this.getExtension() instanceof SingleEntryFileBasedIndexExtension || this.hasForwardIndex()) {
            Map map = super.getIndexedFileData(hashId);
            if (map == null) {
                HashBasedMapReduceIndex.$$$reportNull$$$0(8);
            }
            return map;
        }
        throw new AssertionError();
    }

    public <E extends Exception> boolean withData(@NotNull Key key, @NotNull ValueContainerProcessor<Value, E> processor) throws StorageException, E {
        if (key == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            HashBasedMapReduceIndex.$$$reportNull$$$0(10);
        }
        this.ensureCachesUpToDate();
        return super.withData(key, processor);
    }

    protected void doDispose() throws StorageException {
        try {
            super.doDispose();
        }
        finally {
            this.mySharedExtension.closeResources();
        }
    }

    boolean hasForwardIndex() {
        return this.getForwardIndex() != null;
    }

    private void ensureCachesUpToDate() {
        long currentStamp = this.myHashIndexStampSupplier.getAsLong();
        if (this.myLastFileContentIndexStamp != currentStamp) {
            this.getStorage().invalidateCachedMappings();
            this.myLastFileContentIndexStamp = currentStamp;
        }
    }

    @NotNull
    private static <K, V> FileBasedIndexExtension<K, V> assertIndexerNotUsed(final FileBasedIndexExtension<K, V> extension) {
        if (extension instanceof SingleEntryFileBasedIndexExtension) {
            return new SingleEntryFileBasedIndexExtension<V>(){

                @NotNull
                public ID<Integer, V> getName() {
                    ID iD = extension.getName();
                    if (iD == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return iD;
                }

                public // Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull FileBasedIndex.InputFilter getInputFilter() {
                    throw HashBasedMapReduceIndex.error();
                }

                @NotNull
                public SingleEntryIndexer<V> getIndexer() {
                    return new SingleEntryIndexer<V>(false){

                        @Nullable
                        protected V computeValue(@NotNull FileContent inputData) {
                            if (inputData == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            throw HashBasedMapReduceIndex.error();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex$3$1", "computeValue"));
                        }
                    };
                }

                @NotNull
                public DataExternalizer<V> getValueExternalizer() {
                    return new MyKeyDescriptor();
                }

                public int getVersion() {
                    throw HashBasedMapReduceIndex.error();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex$3", "getName"));
                }
            };
        }
        return new FileBasedIndexExtension<K, V>(){

            @NotNull
            public ID<K, V> getName() {
                ID iD = extension.getName();
                if (iD == null) {
                    4.$$$reportNull$$$0(0);
                }
                return iD;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
             @NotNull FileBasedIndex.InputFilter getInputFilter() {
                throw HashBasedMapReduceIndex.error();
            }

            public boolean dependsOnFileContent() {
                return extension.dependsOnFileContent();
            }

            @NotNull
            public DataIndexer<K, V, FileContent> getIndexer() {
                DataIndexer dataIndexer = fc -> {
                    throw HashBasedMapReduceIndex.error();
                };
                if (dataIndexer == null) {
                    4.$$$reportNull$$$0(1);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<K> getKeyDescriptor() {
                return new MyKeyDescriptor();
            }

            @NotNull
            public DataExternalizer<V> getValueExternalizer() {
                return new MyKeyDescriptor();
            }

            public int getVersion() {
                throw HashBasedMapReduceIndex.error();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    private static AssertionError error() {
        return new AssertionError((Object)"Should not be called for shared index");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexLocation";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedExtension";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashIdRemapping";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashIndexStampSupplier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedFileData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createIndexLayout";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private static class MyKeyDescriptor<K>
    implements KeyDescriptor<K> {
        private MyKeyDescriptor() {
        }

        public int getHashCode(K value) {
            throw HashBasedMapReduceIndex.error();
        }

        public boolean isEqual(K val1, K val2) {
            throw HashBasedMapReduceIndex.error();
        }

        public void save(@NotNull DataOutput out, K value) {
            if (out == null) {
                MyKeyDescriptor.$$$reportNull$$$0(0);
            }
            throw HashBasedMapReduceIndex.error();
        }

        public K read(@NotNull DataInput in) {
            if (in == null) {
                MyKeyDescriptor.$$$reportNull$$$0(1);
            }
            throw HashBasedMapReduceIndex.error();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex$MyKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

