//
//  Controller.m
//  HiawathaWebserver
//
//  Created by Hugo Leisink on 6/9/08.
//  Copyright 2008 Hugo Leisink. All rights reserved.
//

#include <Security/Authorization.h>
#include <Security/AuthorizationTags.h>
#include <sys/stat.h>
#import "Controller.h"


@implementation Controller

- (bool) file_exists:(char*) filename {
	struct stat buf;

	return stat(filename, &buf) != -1;
}

- (void) awakeFromNib {
	if ([self file_exists:"/usr/local/var/run/hiawatha.pid"] == false) {
		// Hiawatha not running
		[button setTitle:@"Start Hiawatha"];
	} else {
		// Hiawatha is running
		[button setTitle:@"Stop Hiawatha"];
	}
}

- (IBAction) controlHiawathaWebserver:(id)sender {
	FILE *fp;
	char input[16], *c, *hiawatha_binary = "/usr/local/sbin/hiawatha";
	pid_t hiawatha_pid;

	// Authentication
	AuthorizationRef gAuthorizationRef = 0;
	char *kill_args[3] = {"-c", NULL, NULL};
	char *rm_pid_args[2] = {"/usr/local/var/run/hiawatha.pid", NULL};
//	AuthorizationItem myItems[] = {{kAuthorizationRightExecute, strlen(hiawatha_binary), hiawatha_binary, 0}};
//	AuthorizationRights myRights = {sizeof(myItems)/sizeof(AuthorizationItem), myItems};

	AuthorizationFlags myFlags =
		kAuthorizationFlagDefaults |
		kAuthorizationFlagInteractionAllowed |
		kAuthorizationFlagPreAuthorize |
		kAuthorizationFlagExtendRights;

	if (AuthorizationCreate(NULL, kAuthorizationEmptyEnvironment, kAuthorizationFlagDefaults, &gAuthorizationRef) != errAuthorizationSuccess) {
		NSLog(@"AuthCreate");
		return;
	}

//	if (AuthorizationCopyRights(gAuthorizationRef, &myRights, NULL, myFlags, NULL ) != errAuthorizationSuccess) {
	if (AuthorizationCopyRights(gAuthorizationRef, NULL, NULL, myFlags, NULL ) != errAuthorizationSuccess) {
		NSLog(@"AuthCopyRights");
		return;
	}

	if ((fp = fopen("/usr/local/var/run/hiawatha.pid", "r")) == NULL) {
		// Start Hiawatha

		if (AuthorizationExecuteWithPrivileges(gAuthorizationRef, hiawatha_binary, kAuthorizationFlagDefaults, NULL, NULL) != errAuthorizationSuccess) {
			NSLog(@"AuthExecWithPriv");
		}

		AuthorizationFree(gAuthorizationRef, kAuthorizationFlagDefaults);

		[button setTitle:@"Stop Hiawatha"];
	} else {
		// Stop Hiawatha 
		if (fgets(input, 15, fp) != NULL) {
			c = input;
			while (*c != '\0') {
				if ((*c == 10) || (*c == 13)) {
					*c = '\0';
					break;
				}
				c++;
			}

			if ((hiawatha_pid = atoi(input)) > 100) {
				if ((kill_args[1] = (char*)malloc(20)) == NULL) {
					NSLog(@"Malloc error");
					return;
				}
				sprintf(kill_args[1], "kill -15 %d", hiawatha_pid);
				if (AuthorizationExecuteWithPrivileges(gAuthorizationRef, "/bin/sh", kAuthorizationFlagDefaults, kill_args, NULL) != errAuthorizationSuccess) {
					NSLog(@"Kill hiawatha");
					return;
				}
			}
		}
		fclose(fp);

		if (AuthorizationExecuteWithPrivileges(gAuthorizationRef, "/bin/rm", kAuthorizationFlagDefaults, rm_pid_args, NULL) != errAuthorizationSuccess) {
			NSLog(@"rm PID");
			return;
		}

		[button setTitle:@"Start Hiawatha"];
	}

	// Drop privileges
}

@end
