// generated by diplomat-tool
import type { CodePointSetBuilder } from "./CodePointSetBuilder"
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { Locale } from "./Locale"
import type { TitlecaseOptions } from "./TitlecaseOptions"
import type { TitlecaseOptions_obj } from "./TitlecaseOptions"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * See the [Rust documentation for `CaseMapper`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapper.html) for more information.
 */


export class CaseMapper {
    get ffiValue(): pointer;


    /**
     * Construct a new CaseMapper instance using a particular data source.
     *
     * See the [Rust documentation for `new`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapper.html#method.new) for more information.
     */
    static createWithProvider(provider: DataProvider): CaseMapper;

    /**
     * Returns the full lowercase mapping of the given string
     *
     * See the [Rust documentation for `lowercase`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapperBorrowed.html#method.lowercase) for more information.
     */
    lowercase(s: string, locale: Locale): string;

    /**
     * Returns the full uppercase mapping of the given string
     *
     * See the [Rust documentation for `uppercase`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapperBorrowed.html#method.uppercase) for more information.
     */
    uppercase(s: string, locale: Locale): string;

    /**
     * Returns the full lowercase mapping of the given string, using compiled data (avoids having to allocate a CaseMapper object)
     *
     * See the [Rust documentation for `lowercase`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapperBorrowed.html#method.lowercase) for more information.
     */
    static lowercaseWithCompiledData(s: string, locale: Locale): string;

    /**
     * Returns the full uppercase mapping of the given string, using compiled data (avoids having to allocate a CaseMapper object)
     *
     * See the [Rust documentation for `uppercase`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapperBorrowed.html#method.uppercase) for more information.
     */
    static uppercaseWithCompiledData(s: string, locale: Locale): string;

    /**
     * Returns the full titlecase mapping of the given string, performing head adjustment without
     * loading additional data.
     * (if head adjustment is enabled in the options)
     *
     * The `v1` refers to the version of the options struct, which may change as we add more options
     *
     * See the [Rust documentation for `titlecase_segment_with_only_case_data`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapperBorrowed.html#method.titlecase_segment_with_only_case_data) for more information.
     */
    titlecaseSegmentWithOnlyCaseData(s: string, locale: Locale, options: TitlecaseOptions_obj): string;

    /**
     * Case-folds the characters in the given string
     *
     * See the [Rust documentation for `fold`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapperBorrowed.html#method.fold) for more information.
     */
    fold(s: string): string;

    /**
     * Case-folds the characters in the given string
     * using Turkic (T) mappings for dotted/dotless I.
     *
     * See the [Rust documentation for `fold_turkic`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapperBorrowed.html#method.fold_turkic) for more information.
     */
    foldTurkic(s: string): string;

    /**
     * Adds all simple case mappings and the full case folding for `c` to `builder`.
     * Also adds special case closure mappings.
     *
     * In other words, this adds all characters that this casemaps to, as
     * well as all characters that may casemap to this one.
     *
     * Note that since CodePointSetBuilder does not contain strings, this will
     * ignore string mappings.
     *
     * Identical to the similarly named method on `CaseMapCloser`, use that if you
     * plan on using string case closure mappings too.
     *
     * See the [Rust documentation for `add_case_closure_to`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapperBorrowed.html#method.add_case_closure_to) for more information.
     */
    addCaseClosureTo(c: codepoint, builder: CodePointSetBuilder): void;

    /**
     * Returns the simple lowercase mapping of the given character.
     *
     * This function only implements simple and common mappings.
     * Full mappings, which can map one char to a string, are not included.
     * For full mappings, use `CaseMapperBorrowed::lowercase`.
     *
     * See the [Rust documentation for `simple_lowercase`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapperBorrowed.html#method.simple_lowercase) for more information.
     */
    simpleLowercase(ch: codepoint): codepoint;

    /**
     * Returns the simple uppercase mapping of the given character.
     *
     * This function only implements simple and common mappings.
     * Full mappings, which can map one char to a string, are not included.
     * For full mappings, use `CaseMapperBorrowed::uppercase`.
     *
     * See the [Rust documentation for `simple_uppercase`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapperBorrowed.html#method.simple_uppercase) for more information.
     */
    simpleUppercase(ch: codepoint): codepoint;

    /**
     * Returns the simple titlecase mapping of the given character.
     *
     * This function only implements simple and common mappings.
     * Full mappings, which can map one char to a string, are not included.
     * For full mappings, use `CaseMapperBorrowed::titlecase_segment`.
     *
     * See the [Rust documentation for `simple_titlecase`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapperBorrowed.html#method.simple_titlecase) for more information.
     */
    simpleTitlecase(ch: codepoint): codepoint;

    /**
     * Returns the simple casefolding of the given character.
     *
     * This function only implements simple folding.
     * For full folding, use `CaseMapperBorrowed::fold`.
     *
     * See the [Rust documentation for `simple_fold`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapperBorrowed.html#method.simple_fold) for more information.
     */
    simpleFold(ch: codepoint): codepoint;

    /**
     * Returns the simple casefolding of the given character in the Turkic locale
     *
     * This function only implements simple folding.
     * For full folding, use `CaseMapperBorrowed::fold_turkic`.
     *
     * See the [Rust documentation for `simple_fold_turkic`](https://docs.rs/icu/latest/icu/casemap/struct.CaseMapperBorrowed.html#method.simple_fold_turkic) for more information.
     */
    simpleFoldTurkic(ch: codepoint): codepoint;

    constructor();
}