/*
Copyright (C) 2024 Signal Messenger, LLC.
SPDX-License-Identifier: AGPL-3.0-only
*/


#ifndef SIGNAL_FFI_TESTING_H_
#define SIGNAL_FFI_TESTING_H_

/* This file was automatically generated by cbindgen */

#include <stdarg.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include "signal_ffi.h"

typedef struct SignalComparableBackup SignalComparableBackup;

typedef struct SignalFakeChatConnection SignalFakeChatConnection;

typedef struct SignalFakeChatRemoteEnd SignalFakeChatRemoteEnd;

typedef struct SignalFakeChatResponse SignalFakeChatResponse;

typedef struct SignalFakeChatSentRequest SignalFakeChatSentRequest;

typedef struct SignalFakeChatServer SignalFakeChatServer;

typedef struct SignalNonSuspendingBackgroundThreadRuntime SignalNonSuspendingBackgroundThreadRuntime;

typedef struct SignalOtherTestingHandleType SignalOtherTestingHandleType;

/**
 * The top-level error type (opaquely) returned to C clients when something goes wrong.
 *
 * Ideally this would use [ThinBox][], and then we wouldn't need an extra level of indirection when
 * returning it to C, but unfortunately that isn't stable yet.
 *
 * [ThinBox]: https://doc.rust-lang.org/std/boxed/struct.ThinBox.html
 */
typedef struct SignalFfiError SignalFfiError;

/**
 * Counter for future cancellations
 */
typedef struct SignalTestingFutureCancellationCounter SignalTestingFutureCancellationCounter;

typedef struct SignalTestingHandleType SignalTestingHandleType;

typedef struct SignalTestingSemaphore SignalTestingSemaphore;

typedef struct SignalTestingValueHolder SignalTestingValueHolder;

typedef struct {
  SignalComparableBackup *raw;
} SignalMutPointerComparableBackup;

typedef struct {
  const SignalComparableBackup *raw;
} SignalConstPointerComparableBackup;

typedef SignalBytestringArray SignalStringArray;

typedef struct {
  SignalFakeChatConnection *raw;
} SignalMutPointerFakeChatConnection;

typedef struct {
  SignalFakeChatRemoteEnd *raw;
} SignalMutPointerFakeChatRemoteEnd;

typedef struct {
  SignalFakeChatResponse *raw;
} SignalMutPointerFakeChatResponse;

typedef struct {
  SignalFakeChatSentRequest *raw;
} SignalMutPointerFakeChatSentRequest;

typedef struct {
  SignalFakeChatServer *raw;
} SignalMutPointerFakeChatServer;

typedef struct {
  SignalOtherTestingHandleType *raw;
} SignalMutPointerOtherTestingHandleType;

typedef struct {
  const SignalOtherTestingHandleType *raw;
} SignalConstPointerOtherTestingHandleType;

typedef struct {
  SignalNonSuspendingBackgroundThreadRuntime *raw;
} SignalMutPointerNonSuspendingBackgroundThreadRuntime;

typedef uint8_t SignalOptionalUuid[17];

typedef struct {
  const SignalNonSuspendingBackgroundThreadRuntime *raw;
} SignalConstPointerNonSuspendingBackgroundThreadRuntime;

typedef uint64_t SignalRawCancellationId;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const void *const *result, const void *context);
  const void *context;
  SignalRawCancellationId cancellation_id;
} SignalCPromiseRawPointer;

typedef struct {
  const SignalFakeChatConnection *raw;
} SignalConstPointerFakeChatConnection;

typedef struct {
  const SignalFakeChatRemoteEnd *raw;
} SignalConstPointerFakeChatRemoteEnd;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalMutPointerFakeChatSentRequest *result, const void *context);
  const void *context;
  SignalRawCancellationId cancellation_id;
} SignalCPromiseMutPointerFakeChatSentRequest;

typedef struct {
  const SignalFakeChatResponse *raw;
} SignalConstPointerFakeChatResponse;

typedef struct {
  const SignalFakeChatSentRequest *raw;
} SignalConstPointerFakeChatSentRequest;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalMutPointerFakeChatRemoteEnd *result, const void *context);
  const void *context;
  SignalRawCancellationId cancellation_id;
} SignalCPromiseMutPointerFakeChatRemoteEnd;

typedef struct {
  const SignalFakeChatServer *raw;
} SignalConstPointerFakeChatServer;

typedef struct {
  SignalTestingFutureCancellationCounter *raw;
} SignalMutPointerTestingFutureCancellationCounter;

typedef struct {
  const SignalTestingFutureCancellationCounter *raw;
} SignalConstPointerTestingFutureCancellationCounter;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const int32_t *result, const void *context);
  const void *context;
  SignalRawCancellationId cancellation_id;
} SignalCPromisei32;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalMutPointerOtherTestingHandleType *result, const void *context);
  const void *context;
  SignalRawCancellationId cancellation_id;
} SignalCPromiseMutPointerOtherTestingHandleType;

typedef struct {
  SignalTestingHandleType *raw;
} SignalMutPointerTestingHandleType;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalMutPointerTestingHandleType *result, const void *context);
  const void *context;
  SignalRawCancellationId cancellation_id;
} SignalCPromiseMutPointerTestingHandleType;

typedef struct {
  const SignalTestingHandleType *raw;
} SignalConstPointerTestingHandleType;

typedef struct {
  const SignalTestingSemaphore *raw;
} SignalConstPointerTestingSemaphore;

typedef struct {
  SignalTestingSemaphore *raw;
} SignalMutPointerTestingSemaphore;

typedef struct {
  SignalTestingValueHolder *raw;
} SignalMutPointerTestingValueHolder;

typedef struct {
  const SignalTestingValueHolder *raw;
} SignalConstPointerTestingValueHolder;

SignalFfiError *signal_comparable_backup_destroy(SignalMutPointerComparableBackup p);

SignalFfiError *signal_comparable_backup_get_comparable_string(const char **out, SignalConstPointerComparableBackup backup);

SignalFfiError *signal_comparable_backup_get_unknown_fields(SignalStringArray *out, SignalConstPointerComparableBackup backup);

SignalFfiError *signal_comparable_backup_read_unencrypted(SignalMutPointerComparableBackup *out, SignalConstPointerFfiInputStreamStruct stream, uint64_t len, uint8_t purpose);

SignalFfiError *signal_fake_chat_connection_destroy(SignalMutPointerFakeChatConnection p);

SignalFfiError *signal_fake_chat_remote_end_destroy(SignalMutPointerFakeChatRemoteEnd p);

SignalFfiError *signal_fake_chat_response_destroy(SignalMutPointerFakeChatResponse p);

SignalFfiError *signal_fake_chat_sent_request_destroy(SignalMutPointerFakeChatSentRequest p);

SignalFfiError *signal_fake_chat_server_destroy(SignalMutPointerFakeChatServer p);

SignalFfiError *signal_other_testing_handle_type_clone(SignalMutPointerOtherTestingHandleType *new_obj, SignalConstPointerOtherTestingHandleType obj);

SignalFfiError *signal_other_testing_handle_type_destroy(SignalMutPointerOtherTestingHandleType p);

SignalFfiError *signal_test_only_fn_returns_123(uint32_t *out);

SignalFfiError *signal_testing_NonSuspendingBackgroundThreadRuntime_destroy(SignalMutPointerNonSuspendingBackgroundThreadRuntime p);

SignalFfiError *signal_testing_bridged_string_map_dump_to_json(const char **out, SignalConstPointerBridgedStringMap map);

SignalFfiError *signal_testing_cdsi_lookup_error_convert(const char *error_description);

SignalFfiError *signal_testing_cdsi_lookup_response_convert(SignalCPromiseFfiCdsiLookupResponse *promise, SignalConstPointerTokioAsyncContext async_runtime);

SignalFfiError *signal_testing_chat_connect_error_convert(const char *error_description);

SignalFfiError *signal_testing_chat_request_get_body(SignalOwnedBuffer *out, SignalConstPointerHttpRequest request);

SignalFfiError *signal_testing_chat_request_get_header_names(SignalStringArray *out, SignalConstPointerHttpRequest request);

SignalFfiError *signal_testing_chat_request_get_header_value(const char **out, SignalConstPointerHttpRequest request, const char *header_name);

SignalFfiError *signal_testing_chat_request_get_method(const char **out, SignalConstPointerHttpRequest request);

SignalFfiError *signal_testing_chat_request_get_path(const char **out, SignalConstPointerHttpRequest request);

SignalFfiError *signal_testing_chat_response_convert(SignalFfiChatResponse *out, bool body_present);

SignalFfiError *signal_testing_chat_send_error_convert(const char *error_description);

SignalFfiError *signal_testing_connection_manager_is_using_proxy(int32_t *out, SignalConstPointerConnectionManager manager);

SignalFfiError *signal_testing_convert_optional_uuid(SignalOptionalUuid *out, bool present);

SignalFfiError *signal_testing_create_otp(const char **out, const char *username, SignalBorrowedBuffer secret);

SignalFfiError *signal_testing_create_otp_from_base64(const char **out, const char *username, const char *secret);

SignalFfiError *signal_testing_error_on_borrow_async(const void *_input);

SignalFfiError *signal_testing_error_on_borrow_io(SignalCPromisebool *promise, SignalConstPointerNonSuspendingBackgroundThreadRuntime async_runtime, const void *_input);

SignalFfiError *signal_testing_error_on_borrow_sync(const void *_input);

SignalFfiError *signal_testing_error_on_return_async(const void **out, const void *_needs_cleanup);

SignalFfiError *signal_testing_error_on_return_io(SignalCPromiseRawPointer *promise, SignalConstPointerNonSuspendingBackgroundThreadRuntime async_runtime, const void *_needs_cleanup);

SignalFfiError *signal_testing_error_on_return_sync(const void **out, const void *_needs_cleanup);

SignalFfiError *signal_testing_fake_chat_connection_create(SignalMutPointerFakeChatConnection *out, SignalConstPointerTokioAsyncContext tokio, SignalConstPointerFfiChatListenerStruct listener, const char *alerts_joined_by_newlines);

SignalFfiError *signal_testing_fake_chat_connection_take_authenticated_chat(SignalMutPointerAuthenticatedChatConnection *out, SignalConstPointerFakeChatConnection chat);

SignalFfiError *signal_testing_fake_chat_connection_take_remote(SignalMutPointerFakeChatRemoteEnd *out, SignalConstPointerFakeChatConnection chat);

SignalFfiError *signal_testing_fake_chat_connection_take_unauthenticated_chat(SignalMutPointerUnauthenticatedChatConnection *out, SignalConstPointerFakeChatConnection chat);

SignalFfiError *signal_testing_fake_chat_remote_end_inject_connection_interrupted(SignalConstPointerFakeChatRemoteEnd chat);

SignalFfiError *signal_testing_fake_chat_remote_end_receive_incoming_request(SignalCPromiseMutPointerFakeChatSentRequest *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerFakeChatRemoteEnd chat);

SignalFfiError *signal_testing_fake_chat_remote_end_send_raw_server_request(SignalConstPointerFakeChatRemoteEnd chat, SignalBorrowedBuffer bytes);

SignalFfiError *signal_testing_fake_chat_remote_end_send_raw_server_response(SignalConstPointerFakeChatRemoteEnd chat, SignalBorrowedBuffer bytes);

SignalFfiError *signal_testing_fake_chat_remote_end_send_server_response(SignalConstPointerFakeChatRemoteEnd chat, SignalConstPointerFakeChatResponse response);

SignalFfiError *signal_testing_fake_chat_response_create(SignalMutPointerFakeChatResponse *out, uint64_t id, uint16_t status, const char *message, SignalBorrowedBytestringArray headers, SignalOptionalBorrowedSliceOfc_uchar body);

SignalFfiError *signal_testing_fake_chat_sent_request_request_id(uint64_t *out, SignalConstPointerFakeChatSentRequest request);

SignalFfiError *signal_testing_fake_chat_sent_request_take_http_request(SignalMutPointerHttpRequest *out, SignalMutPointerFakeChatSentRequest request);

SignalFfiError *signal_testing_fake_chat_server_create(SignalMutPointerFakeChatServer *out);

SignalFfiError *signal_testing_fake_chat_server_get_next_remote(SignalCPromiseMutPointerFakeChatRemoteEnd *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerFakeChatServer server);

SignalFfiError *signal_testing_fake_registration_session_create_session(SignalCPromiseMutPointerRegistrationService *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalFfiRegistrationCreateSessionRequest create_session, SignalConstPointerFakeChatServer chat);

SignalFfiError *signal_testing_fingerprint_version_mismatch_error(uint32_t theirs, uint32_t ours);

SignalFfiError *signal_testing_future_cancellation_counter_create(SignalMutPointerTestingFutureCancellationCounter *out, uint8_t initial_value);

SignalFfiError *signal_testing_future_cancellation_counter_destroy(SignalMutPointerTestingFutureCancellationCounter p);

SignalFfiError *signal_testing_future_cancellation_counter_wait_for_count(SignalCPromisebool *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerTestingFutureCancellationCounter count, uint8_t target);

SignalFfiError *signal_testing_future_failure(SignalCPromisei32 *promise, SignalConstPointerNonSuspendingBackgroundThreadRuntime async_runtime, uint8_t _input);

SignalFfiError *signal_testing_future_increment_on_cancel(SignalCPromisebool *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerTestingFutureCancellationCounter _guard);

SignalFfiError *signal_testing_future_produces_other_pointer_type(SignalCPromiseMutPointerOtherTestingHandleType *promise, SignalConstPointerNonSuspendingBackgroundThreadRuntime async_runtime, const char *input);

SignalFfiError *signal_testing_future_produces_pointer_type(SignalCPromiseMutPointerTestingHandleType *promise, SignalConstPointerNonSuspendingBackgroundThreadRuntime async_runtime, uint8_t input);

SignalFfiError *signal_testing_future_success(SignalCPromisei32 *promise, SignalConstPointerNonSuspendingBackgroundThreadRuntime async_runtime, uint8_t input);

SignalFfiError *signal_testing_handle_type_clone(SignalMutPointerTestingHandleType *new_obj, SignalConstPointerTestingHandleType obj);

SignalFfiError *signal_testing_handle_type_destroy(SignalMutPointerTestingHandleType p);

SignalFfiError *signal_testing_input_stream_read_into_zero_length_slice(SignalOwnedBuffer *out, SignalConstPointerFfiInputStreamStruct caps_alphabet_input);

SignalFfiError *signal_testing_key_trans_chat_send_error(void);

SignalFfiError *signal_testing_key_trans_fatal_verification_failure(void);

SignalFfiError *signal_testing_key_trans_non_fatal_verification_failure(void);

SignalFfiError *signal_testing_other_testing_handle_type_get_value(const char **out, SignalConstPointerOtherTestingHandleType handle);

SignalFfiError *signal_testing_panic_in_body_async(const void *_input);

SignalFfiError *signal_testing_panic_in_body_io(SignalCPromisebool *promise, SignalConstPointerNonSuspendingBackgroundThreadRuntime async_runtime, const void *_input);

SignalFfiError *signal_testing_panic_in_body_sync(const void *_input);

SignalFfiError *signal_testing_panic_on_borrow_async(const void *_input);

SignalFfiError *signal_testing_panic_on_borrow_io(SignalCPromisebool *promise, SignalConstPointerNonSuspendingBackgroundThreadRuntime async_runtime, const void *_input);

SignalFfiError *signal_testing_panic_on_borrow_sync(const void *_input);

SignalFfiError *signal_testing_panic_on_load_async(const void *_needs_cleanup, const void *_input);

SignalFfiError *signal_testing_panic_on_load_io(SignalCPromisebool *promise, SignalConstPointerNonSuspendingBackgroundThreadRuntime async_runtime, const void *_needs_cleanup, const void *_input);

SignalFfiError *signal_testing_panic_on_load_sync(const void *_needs_cleanup, const void *_input);

SignalFfiError *signal_testing_panic_on_return_async(const void **out, const void *_needs_cleanup);

SignalFfiError *signal_testing_panic_on_return_io(SignalCPromiseRawPointer *promise, SignalConstPointerNonSuspendingBackgroundThreadRuntime async_runtime, const void *_needs_cleanup);

SignalFfiError *signal_testing_panic_on_return_sync(const void **out, const void *_needs_cleanup);

SignalFfiError *signal_testing_process_bytestring_array(SignalBytestringArray *out, SignalBorrowedSliceOfBuffers input);

SignalFfiError *signal_testing_register_account_response_create_test_value(SignalMutPointerRegisterAccountResponse *out);

SignalFfiError *signal_testing_registration_service_check_svr2_credentials_error_convert(const char *error_description);

SignalFfiError *signal_testing_registration_service_check_svr2_credentials_response_convert(SignalFfiCheckSvr2CredentialsResponse *out);

SignalFfiError *signal_testing_registration_service_create_session_error_convert(const char *error_description);

SignalFfiError *signal_testing_registration_service_register_account_error_convert(const char *error_description);

SignalFfiError *signal_testing_registration_service_request_verification_code_error_convert(const char *error_description);

SignalFfiError *signal_testing_registration_service_resume_session_error_convert(const char *error_description);

SignalFfiError *signal_testing_registration_service_submit_verification_error_convert(const char *error_description);

SignalFfiError *signal_testing_registration_service_update_session_error_convert(const char *error_description);

SignalFfiError *signal_testing_registration_session_info_convert(SignalMutPointerRegistrationSession *out);

SignalFfiError *signal_testing_return_string_array(SignalStringArray *out);

SignalFfiError *signal_testing_semaphore_add_permits(SignalConstPointerTestingSemaphore semaphore, uint32_t permits);

SignalFfiError *signal_testing_semaphore_destroy(SignalMutPointerTestingSemaphore p);

SignalFfiError *signal_testing_semaphore_new(SignalMutPointerTestingSemaphore *out, uint32_t initial);

SignalFfiError *signal_testing_signed_public_pre_key_check_bridges_correctly(SignalConstPointerPublicKey source_public_key, SignalFfiSignedPublicPreKey signed_pre_key);

SignalFfiError *signal_testing_testing_handle_type_get_value(uint8_t *out, SignalConstPointerTestingHandleType handle);

SignalFfiError *signal_testing_tokio_async_context_future_success_bytes(SignalCPromiseOwnedBufferOfc_uchar *promise, SignalConstPointerTokioAsyncContext async_runtime, int32_t count);

SignalFfiError *signal_testing_tokio_async_context_new_single_threaded(SignalMutPointerTokioAsyncContext *out);

SignalFfiError *signal_testing_tokio_async_future(SignalCPromisei32 *promise, SignalConstPointerTokioAsyncContext async_runtime, uint8_t input);

SignalFfiError *signal_testing_value_holder_destroy(SignalMutPointerTestingValueHolder p);

SignalFfiError *signal_testing_value_holder_get(int32_t *out, SignalConstPointerTestingValueHolder holder);

SignalFfiError *signal_testing_value_holder_new(SignalMutPointerTestingValueHolder *out, int32_t value);

#endif  /* SIGNAL_FFI_TESTING_H_ */
