//
// Copyright 2020-2021 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//

import ByteArray from '../internal/ByteArray.js';

export default class GroupMasterKey extends ByteArray {
  private readonly __type?: never;
  static SIZE = 32;

  constructor(contents: Uint8Array) {
    super(contents, GroupMasterKey.checkLength(GroupMasterKey.SIZE));
  }
}
